<?php
/**
 * Widget: Social Icons
 *
 * @package thelandscaper-toolkit
 */

if ( ! class_exists( 'QT_Social_Icons' ) ) {
	class QT_Social_Icons extends WP_Widget {

		/**
		 * Register widget with WordPress.
		 */
		public function __construct() {
			parent::__construct(
				false,
				esc_html__( 'QT: Social Icons', 'the-landscaper-wp' ),
				array(
					'description' => esc_html__( 'Icons to link to your social media profiles', 'the-landscaper-wp' ),
					'classname'   => 'widget-social-icons',
				)
			);
		}
		
		/**
		 * Front-end display of widget.
		 *
		 * @see WP_Widget::widget()
		 *
		 * @param array $args     Widget arguments.
		 * @param array $instance Saved values from database.
		 */
		public function widget( $args, $instance ) {

			// Define Font Awesome 4 social icon classes
			$icon_classes = array(
				'fa fa-facebook',
				'fa fa-twitter',
				'fa fa-linkedin',
				'fa fa-youtube-play',
				'fa fa-instagram',
				'fa fa-tumblr',
				'fa fa-pinterest',
				'fa fa-yelp',
				'fa fa-houzz'
			);

			// Overwrite if Font Awesome version 5 is selected
			if ( '5' === get_theme_mod( 'qt_fontawesome_version' ) ) {
				$icon_classes = array(
					'fab fa-facebook-f',
					'fab fa-twitter',
					'fab fa-linkedin',
					'fab fa-youtube',
					'fab fa-instagram',
					'fab fa-tumblr',
					'fab fa-pinterest',
					'fab fa-yelp',
					'fab fa-houzz'
				);
			}

			// Added in version 2.0.0
			$instance['yelp_profile']  = empty( $instance['yelp_profile'] ) ? '' : $instance['yelp_profile'];
			$instance['houzz_profile'] = empty( $instance['houzz_profile'] ) ? '' : $instance['houzz_profile'];

			echo $args['before_widget'];
		 	?>

		 	<div class="social-icons">
				<?php if( $instance['fb_profile'] ) : ?>
					<a href="<?php echo esc_url( $instance['fb_profile'] ); ?>" aria-label="<?php esc_attr_e( 'Facebook', 'the-landscaper-wp' ); ?>" <?php echo empty ( $instance['new_tab'] ) ? '' : 'target="_blank" rel="noopener noreferrer"'; ?>>
						<i class="<?php echo esc_attr( $icon_classes[0] ); ?>"></i>
					</a>
				<?php endif; ?>

				<?php if( $instance['twttr_profile'] ) : ?>
					<a href="<?php echo esc_url( $instance['twttr_profile'] ); ?>" aria-label="<?php esc_attr_e( 'Twitter', 'the-landscaper-wp' ); ?>" <?php echo empty ( $instance['new_tab'] ) ? '' : 'target="_blank" rel="noopener noreferrer"'; ?>>
						<i class="<?php echo esc_attr( $icon_classes[1] ); ?>"></i>
					</a>
				<?php endif; ?>

				<?php if( $instance['lnkin_profile'] ) : ?>
					<a href="<?php echo esc_url( $instance['lnkin_profile'] ); ?>" aria-label="<?php esc_attr_e( 'LinkedIn', 'the-landscaper-wp' ); ?>" <?php echo empty ( $instance['new_tab'] ) ? '' : 'target="_blank" rel="noopener noreferrer"'; ?>>
						<i class="<?php echo esc_attr( $icon_classes[2] ); ?>"></i>
					</a>
				<?php endif; ?>
				
				<?php if( $instance['youtube_profile'] ) : ?>
					<a href="<?php echo esc_url( $instance['youtube_profile'] ); ?>" aria-label="<?php esc_attr_e( 'YouTube', 'the-landscaper-wp' ); ?>" <?php echo empty ( $instance['new_tab'] ) ? '' : 'target="_blank" rel="noopener noreferrer"'; ?>>
						<i class="<?php echo esc_attr( $icon_classes[3] ); ?>"></i>
					</a>
				<?php endif; ?>
				
				<?php if( $instance['insta_profile'] ) : ?>
					<a href="<?php echo esc_url( $instance['insta_profile'] ); ?>" aria-label="<?php esc_attr_e( 'Instagram', 'the-landscaper-wp' ); ?>" <?php echo empty ( $instance['new_tab'] ) ? '' : 'target="_blank" rel="noopener noreferrer"'; ?>>
						<i class="<?php echo esc_attr( $icon_classes[4] ); ?>"></i>
					</a>
				<?php endif; ?>
				
				<?php if( $instance['tumblr_profile'] ) : ?>
					<a href="<?php echo esc_url( $instance['tumblr_profile'] ); ?>" aria-label="<?php esc_attr_e( 'Tumblr', 'the-landscaper-wp' ); ?>" <?php echo empty ( $instance['new_tab'] ) ? '' : 'target="_blank" rel="noopener noreferrer"'; ?>>
						<i class="<?php echo esc_attr( $icon_classes[5] ); ?>"></i>
					</a>
				<?php endif; ?>

				<?php if( $instance['pintrst_profile'] ) : ?>
					<a href="<?php echo esc_url( $instance['pintrst_profile'] ); ?>" aria-label="<?php esc_attr_e( 'Pinterest', 'the-landscaper-wp' ); ?>" <?php echo empty ( $instance['new_tab'] ) ? '' : 'target="_blank" rel="noopener noreferrer"'; ?>>
						<i class="<?php echo esc_attr( $icon_classes[6] ); ?>"></i>
					</a>
				<?php endif; ?>

				<?php if( $instance['yelp_profile'] ) : ?>
					<a href="<?php echo esc_url( $instance['yelp_profile'] ); ?>" aria-label="<?php esc_attr_e( 'Yelp', 'the-landscaper-wp' ); ?>" <?php echo empty ( $instance['new_tab'] ) ? '' : 'target="_blank" rel="noopener noreferrer"'; ?>>
						<i class="<?php echo esc_attr( $icon_classes[7] ); ?>"></i>
					</a>
				<?php endif; ?>

				<?php if( $instance['houzz_profile'] ) : ?>
					<a href="<?php echo esc_url( $instance['houzz_profile'] ); ?>" aria-label="<?php esc_attr_e( 'Houzz', 'the-landscaper-wp' ); ?>" <?php echo empty ( $instance['new_tab'] ) ? '' : 'target="_blank" rel="noopener noreferrer"'; ?>>
						<i class="<?php echo esc_attr( $icon_classes[8] ); ?>"></i>
					</a>
				<?php endif; ?>
			</div>

			<?php
			echo $args['after_widget'];
		}
		
		/**
		 * Sanitize widget form values as they are saved.
		 *
		 * @see WP_Widget::update()
		 *
		 * @param array $new_instance Values just sent to be saved.
		 * @param array $old_instance Previously saved values from database.
		 *
		 * @return array Updated safe values to be saved.
		 */
		public function update( $new_instance, $old_instance ) {
			$instance = array();

			$instance['fb_profile']		 = sanitize_text_field( $new_instance['fb_profile'] );
			$instance['twttr_profile']	 = sanitize_text_field( $new_instance['twttr_profile'] );
			$instance['lnkin_profile']	 = sanitize_text_field( $new_instance['lnkin_profile'] );
			$instance['youtube_profile'] = sanitize_text_field( $new_instance['youtube_profile'] );
			$instance['insta_profile']	 = sanitize_text_field( $new_instance['insta_profile'] );
			$instance['tumblr_profile']  = sanitize_text_field( $new_instance['tumblr_profile'] );
			$instance['pintrst_profile'] = sanitize_text_field( $new_instance['pintrst_profile'] );
			$instance['yelp_profile']    = sanitize_text_field( $new_instance['yelp_profile'] );
			$instance['houzz_profile']   = sanitize_text_field( $new_instance['houzz_profile'] );
			$instance['new_tab'] 		 = ! empty( $new_instance['new_tab'] ) ? sanitize_key( $new_instance['new_tab'] ) : '';
			
			return $instance;
		}

		/**
		 * Back-end widget form.
		 *
		 * @see WP_Widget::form()
		 *
		 * @param array $instance Previously saved values from database.
		 */
		public function form( $instance ) {
			$new_tab         = empty( $instance['new_tab'] ) ? '' : $instance['new_tab'];
			$fb_profile      = empty( $instance['fb_profile'] ) ? '' : $instance['fb_profile'];
			$twttr_profile   = empty( $instance['twttr_profile'] ) ? '' : $instance['twttr_profile'];
			$lnkin_profile   = empty( $instance['lnkin_profile'] ) ? '' : $instance['lnkin_profile'];
			$insta_profile   = empty( $instance['insta_profile'] ) ? '' : $instance['insta_profile'];
			$tumblr_profile  = empty( $instance['tumblr_profile'] ) ? '' : $instance['tumblr_profile'];
			$pintrst_profile = empty( $instance['pintrst_profile'] ) ? '' : $instance['pintrst_profile'];
			$youtube_profile = empty( $instance['youtube_profile'] ) ? '' : $instance['youtube_profile'];
			$yelp_profile    = empty( $instance['yelp_profile'] ) ? '' : $instance['yelp_profile'];
			$houzz_profile   = empty( $instance['houzz_profile'] ) ? '' : $instance['houzz_profile'];
			?>
			
			<p>
				<label for="<?php echo esc_attr( $this->get_field_id('fb_profile' ) ); ?>">Facebook <?php esc_html_e( 'Link', 'the-landscaper-wp' ); ?>:</label><br>
				<input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'fb_profile' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'fb_profile' ) ); ?>" type="text" value="<?php echo esc_attr( $fb_profile ); ?>" />
			</p>
			
			<p>
				<label for="<?php echo esc_attr( $this->get_field_id('twttr_profile' ) ); ?>">Twitter <?php esc_html_e( 'Link', 'the-landscaper-wp' ); ?>:</label><br>
				<input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'twttr_profile' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'twttr_profile' ) ); ?>" type="text" value="<?php echo esc_attr( $twttr_profile ); ?>" />
			</p>
			
			<p>
				<label for="<?php echo esc_attr( $this->get_field_id('lnkin_profile' ) ); ?>">LinkedIn <?php esc_html_e( 'Link', 'the-landscaper-wp' ); ?>:</label><br>
				<input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'lnkin_profile' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'lnkin_profile' ) ); ?>" type="text" value="<?php echo esc_attr( $lnkin_profile ); ?>" />
			</p>
			
			<p>
				<label for="<?php echo esc_attr( $this->get_field_id('youtube_profile' ) ); ?>">YouTube <?php esc_html_e( 'Link', 'the-landscaper-wp' ); ?>:</label><br>
				<input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'youtube_profile ' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'youtube_profile' ) ); ?>" type="text" value="<?php echo esc_attr( $youtube_profile ); ?>" />
			</p>
			
			<p>
				<label for="<?php echo esc_attr( $this->get_field_id('insta_profile' ) ); ?>">Instagram <?php esc_html_e( 'Link', 'the-landscaper-wp' ); ?>:</label><br>
				<input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'insta_profile' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'insta_profile' ) ); ?>" type="text" value="<?php echo esc_attr( $insta_profile ); ?>" />
			</p>
			
			<p>
				<label for="<?php echo esc_attr( $this->get_field_id('tumblr_profile' ) ); ?>">Tumblr <?php esc_html_e( 'Link', 'the-landscaper-wp' ); ?>:</label><br>
				<input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'tumblr_profile') ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'tumblr_profile' ) ); ?>" type="text" value="<?php echo esc_attr( $tumblr_profile ); ?>" />
			</p>
			
			<p>
				<label for="<?php echo esc_attr( $this->get_field_id('pintrst_profile' ) ); ?>">Pinterest <?php esc_html_e( 'Link', 'the-landscaper-wp' ); ?>:</label><br>
				<input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'pintrst_profile' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'pintrst_profile' ) ); ?>" type="text" value="<?php echo esc_attr( $pintrst_profile ); ?>" />
			</p>

			<p>
				<label for="<?php echo esc_attr( $this->get_field_id('yelp_profile' ) ); ?>">Yelp <?php esc_html_e( 'Link', 'the-landscaper-wp' ); ?>:</label><br>
				<input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'yelp_profile' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'yelp_profile' ) ); ?>" type="text" value="<?php echo esc_attr( $yelp_profile ); ?>" />
			</p>

			<p>
				<label for="<?php echo esc_attr( $this->get_field_id('houzz_profile' ) ); ?>">Houzz <?php esc_html_e( 'Link', 'the-landscaper-wp' ); ?>:</label><br>
				<input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'houzz_profile' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'houzz_profile' ) ); ?>" type="text" value="<?php echo esc_attr( $houzz_profile ); ?>" />
			</p>

			<p>
				<input class="checkbox" type="checkbox" <?php checked( $new_tab, 'on'); ?> id="<?php echo esc_attr( $this->get_field_id( 'new_tab' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'new_tab' ) ); ?>" value="on" />
				<label for="<?php echo esc_attr( $this->get_field_id( 'new_tab' ) ); ?>"><?php esc_html_e( 'Open link in new browser tab?', 'the-landscaper-wp'   ); ?></label>
			</p>
			
			<?php 
		}
	}
}