/* DUPLICATOR-LITE (PHP BUILD MODE) MYSQL SCRIPT CREATED ON : 2021-08-01 18:32:38 */

/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;

SET FOREIGN_KEY_CHECKS = 0;

CREATE TABLE `rtl_lnd_actionscheduler_actions` (
  `action_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `hook` varchar(191) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `scheduled_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `scheduled_date_local` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `args` varchar(191) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `schedule` longtext COLLATE utf8mb4_unicode_520_ci,
  `group_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `attempts` int(11) NOT NULL DEFAULT '0',
  `last_attempt_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `last_attempt_local` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `claim_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `extended_args` varchar(8000) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`action_id`),
  KEY `hook` (`hook`),
  KEY `status` (`status`),
  KEY `scheduled_date_gmt` (`scheduled_date_gmt`),
  KEY `args` (`args`),
  KEY `group_id` (`group_id`),
  KEY `last_attempt_gmt` (`last_attempt_gmt`),
  KEY `claim_id` (`claim_id`),
  KEY `claim_id_status_scheduled_date_gmt` (`claim_id`,`status`,`scheduled_date_gmt`)
) ENGINE=MyISAM AUTO_INCREMENT=7143 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `rtl_lnd_actionscheduler_claims` (
  `claim_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`claim_id`),
  KEY `date_created_gmt` (`date_created_gmt`)
) ENGINE=MyISAM AUTO_INCREMENT=421 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `rtl_lnd_actionscheduler_groups` (
  `group_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `slug` (`slug`(191))
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `rtl_lnd_actionscheduler_logs` (
  `log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `action_id` bigint(20) unsigned NOT NULL,
  `message` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `log_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `log_date_local` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`log_id`),
  KEY `action_id` (`action_id`),
  KEY `log_date_gmt` (`log_date_gmt`)
) ENGINE=MyISAM AUTO_INCREMENT=133 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `rtl_lnd_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=41 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `rtl_lnd_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT '0',
  `comment_author` tinytext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_author_email` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT '0',
  `comment_approved` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'comment',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10)),
  KEY `woo_idx_comment_type` (`comment_type`)
) ENGINE=InnoDB AUTO_INCREMENT=35 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `rtl_lnd_duplicator_packages` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) COLLATE utf8_persian_ci NOT NULL,
  `hash` varchar(50) COLLATE utf8_persian_ci NOT NULL,
  `status` int(11) NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) COLLATE utf8_persian_ci NOT NULL,
  `package` longtext COLLATE utf8_persian_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=MyISAM AUTO_INCREMENT=16 DEFAULT CHARSET=utf8 COLLATE=utf8_persian_ci;

CREATE TABLE `rtl_lnd_eg_grids` (
  `id` mediumint(6) NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `handle` varchar(191) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `postparams` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `params` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `layers` mediumtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `settings` text COLLATE utf8mb4_unicode_520_ci,
  `last_modified` datetime DEFAULT NULL,
  UNIQUE KEY `id` (`id`),
  UNIQUE KEY `handle` (`handle`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `rtl_lnd_eg_item_elements` (
  `id` mediumint(6) NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `handle` varchar(191) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `settings` mediumtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  UNIQUE KEY `id` (`id`),
  UNIQUE KEY `handle` (`handle`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `rtl_lnd_eg_item_skins` (
  `id` mediumint(6) NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `handle` varchar(191) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `params` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `layers` mediumtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `settings` text COLLATE utf8mb4_unicode_520_ci,
  UNIQUE KEY `id` (`id`),
  UNIQUE KEY `name` (`name`),
  UNIQUE KEY `handle` (`handle`)
) ENGINE=InnoDB AUTO_INCREMENT=55 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `rtl_lnd_eg_navigation_skins` (
  `id` mediumint(6) NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `handle` varchar(191) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `css` mediumtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  UNIQUE KEY `id` (`id`),
  UNIQUE KEY `handle` (`handle`)
) ENGINE=InnoDB AUTO_INCREMENT=18 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `rtl_lnd_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_image` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_target` varchar(25) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_description` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_visible` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT '1',
  `link_rating` int(11) NOT NULL DEFAULT '0',
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_notes` mediumtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `link_rss` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `rtl_lnd_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `option_value` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `autoload` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=InnoDB AUTO_INCREMENT=3183 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `rtl_lnd_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=11119 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `rtl_lnd_posts` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint(20) unsigned NOT NULL DEFAULT '0',
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_title` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_excerpt` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `post_password` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `post_name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `to_ping` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `pinged` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `guid` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `menu_order` int(11) NOT NULL DEFAULT '0',
  `post_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_count` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`)
) ENGINE=InnoDB AUTO_INCREMENT=7179 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `rtl_lnd_term_relationships` (
  `object_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `term_taxonomy_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `term_order` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `rtl_lnd_term_taxonomy` (
  `term_taxonomy_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `taxonomy` varchar(32) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `description` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `count` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=InnoDB AUTO_INCREMENT=53 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `rtl_lnd_termmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `rtl_lnd_terms` (
  `term_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `slug` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `term_group` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=InnoDB AUTO_INCREMENT=53 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `rtl_lnd_usermeta` (
  `umeta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=93 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `rtl_lnd_users` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_pass` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_nicename` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_email` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_url` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_status` int(11) NOT NULL DEFAULT '0',
  `display_name` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `rtl_lnd_wc_admin_note_actions` (
  `action_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `note_id` bigint(20) unsigned NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `label` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `query` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `status` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `is_primary` tinyint(1) NOT NULL DEFAULT '0',
  `actioned_text` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `nonce_action` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `nonce_name` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`action_id`),
  KEY `note_id` (`note_id`)
) ENGINE=MyISAM AUTO_INCREMENT=551 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `rtl_lnd_wc_admin_notes` (
  `note_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `locale` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `title` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `content` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `content_data` longtext COLLATE utf8mb4_unicode_520_ci,
  `status` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `source` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_reminder` datetime DEFAULT NULL,
  `is_snoozable` tinyint(1) NOT NULL DEFAULT '0',
  `layout` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `image` varchar(200) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `is_deleted` tinyint(1) NOT NULL DEFAULT '0',
  `icon` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'info',
  PRIMARY KEY (`note_id`)
) ENGINE=MyISAM AUTO_INCREMENT=52 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `rtl_lnd_wc_category_lookup` (
  `category_tree_id` bigint(20) unsigned NOT NULL,
  `category_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`category_tree_id`,`category_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `rtl_lnd_wc_customer_lookup` (
  `customer_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `username` varchar(60) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `first_name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `last_name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `email` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `date_last_active` timestamp NULL DEFAULT NULL,
  `date_registered` timestamp NULL DEFAULT NULL,
  `country` char(2) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `postcode` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `city` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `state` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`customer_id`),
  UNIQUE KEY `user_id` (`user_id`),
  KEY `email` (`email`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `rtl_lnd_wc_download_log` (
  `download_log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `timestamp` datetime NOT NULL,
  `permission_id` bigint(20) unsigned NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `user_ip_address` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  PRIMARY KEY (`download_log_id`),
  KEY `permission_id` (`permission_id`),
  KEY `timestamp` (`timestamp`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `rtl_lnd_wc_order_coupon_lookup` (
  `order_id` bigint(20) unsigned NOT NULL,
  `coupon_id` bigint(20) NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `discount_amount` double NOT NULL DEFAULT '0',
  PRIMARY KEY (`order_id`,`coupon_id`),
  KEY `coupon_id` (`coupon_id`),
  KEY `date_created` (`date_created`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `rtl_lnd_wc_order_product_lookup` (
  `order_item_id` bigint(20) unsigned NOT NULL,
  `order_id` bigint(20) unsigned NOT NULL,
  `product_id` bigint(20) unsigned NOT NULL,
  `variation_id` bigint(20) unsigned NOT NULL,
  `customer_id` bigint(20) unsigned DEFAULT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `product_qty` int(11) NOT NULL,
  `product_net_revenue` double NOT NULL DEFAULT '0',
  `product_gross_revenue` double NOT NULL DEFAULT '0',
  `coupon_amount` double NOT NULL DEFAULT '0',
  `tax_amount` double NOT NULL DEFAULT '0',
  `shipping_amount` double NOT NULL DEFAULT '0',
  `shipping_tax_amount` double NOT NULL DEFAULT '0',
  PRIMARY KEY (`order_item_id`),
  KEY `order_id` (`order_id`),
  KEY `product_id` (`product_id`),
  KEY `customer_id` (`customer_id`),
  KEY `date_created` (`date_created`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `rtl_lnd_wc_order_stats` (
  `order_id` bigint(20) unsigned NOT NULL,
  `parent_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `num_items_sold` int(11) NOT NULL DEFAULT '0',
  `total_sales` double NOT NULL DEFAULT '0',
  `tax_total` double NOT NULL DEFAULT '0',
  `shipping_total` double NOT NULL DEFAULT '0',
  `net_total` double NOT NULL DEFAULT '0',
  `returning_customer` tinyint(1) DEFAULT NULL,
  `status` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `customer_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`order_id`),
  KEY `date_created` (`date_created`),
  KEY `customer_id` (`customer_id`),
  KEY `status` (`status`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `rtl_lnd_wc_order_tax_lookup` (
  `order_id` bigint(20) unsigned NOT NULL,
  `tax_rate_id` bigint(20) unsigned NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `shipping_tax` double NOT NULL DEFAULT '0',
  `order_tax` double NOT NULL DEFAULT '0',
  `total_tax` double NOT NULL DEFAULT '0',
  PRIMARY KEY (`order_id`,`tax_rate_id`),
  KEY `tax_rate_id` (`tax_rate_id`),
  KEY `date_created` (`date_created`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `rtl_lnd_wc_product_meta_lookup` (
  `product_id` bigint(20) NOT NULL,
  `sku` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  `virtual` tinyint(1) DEFAULT '0',
  `downloadable` tinyint(1) DEFAULT '0',
  `min_price` decimal(19,4) DEFAULT NULL,
  `max_price` decimal(19,4) DEFAULT NULL,
  `onsale` tinyint(1) DEFAULT '0',
  `stock_quantity` double DEFAULT NULL,
  `stock_status` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT 'instock',
  `rating_count` bigint(20) DEFAULT '0',
  `average_rating` decimal(3,2) DEFAULT '0.00',
  `total_sales` bigint(20) DEFAULT '0',
  `tax_status` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT 'taxable',
  `tax_class` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  PRIMARY KEY (`product_id`),
  KEY `virtual` (`virtual`),
  KEY `downloadable` (`downloadable`),
  KEY `stock_status` (`stock_status`),
  KEY `stock_quantity` (`stock_quantity`),
  KEY `onsale` (`onsale`),
  KEY `min_max_price` (`min_price`,`max_price`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `rtl_lnd_wc_reserved_stock` (
  `order_id` bigint(20) NOT NULL,
  `product_id` bigint(20) NOT NULL,
  `stock_quantity` double NOT NULL DEFAULT '0',
  `timestamp` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `expires` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`order_id`,`product_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `rtl_lnd_wc_tax_rate_classes` (
  `tax_rate_class_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `slug` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`tax_rate_class_id`),
  UNIQUE KEY `slug` (`slug`(191))
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `rtl_lnd_wc_webhooks` (
  `webhook_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `status` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `name` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL,
  `delivery_url` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `secret` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `topic` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `api_version` smallint(4) NOT NULL,
  `failure_count` smallint(10) NOT NULL DEFAULT '0',
  `pending_delivery` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`webhook_id`),
  KEY `user_id` (`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `rtl_lnd_woocommerce_api_keys` (
  `key_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL,
  `description` varchar(200) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `permissions` varchar(10) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `consumer_key` char(64) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `consumer_secret` char(43) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `nonces` longtext COLLATE utf8mb4_unicode_520_ci,
  `truncated_key` char(7) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `last_access` datetime DEFAULT NULL,
  PRIMARY KEY (`key_id`),
  KEY `consumer_key` (`consumer_key`),
  KEY `consumer_secret` (`consumer_secret`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `rtl_lnd_woocommerce_attribute_taxonomies` (
  `attribute_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `attribute_name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `attribute_label` varchar(200) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `attribute_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `attribute_orderby` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `attribute_public` int(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`attribute_id`),
  KEY `attribute_name` (`attribute_name`(20))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `rtl_lnd_woocommerce_downloadable_product_permissions` (
  `permission_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `download_id` varchar(36) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `product_id` bigint(20) unsigned NOT NULL,
  `order_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `order_key` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `user_email` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `downloads_remaining` varchar(9) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `access_granted` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `access_expires` datetime DEFAULT NULL,
  `download_count` bigint(20) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`permission_id`),
  KEY `download_order_key_product` (`product_id`,`order_id`,`order_key`(16),`download_id`),
  KEY `download_order_product` (`download_id`,`order_id`,`product_id`),
  KEY `order_id` (`order_id`),
  KEY `user_order_remaining_expires` (`user_id`,`order_id`,`downloads_remaining`,`access_expires`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `rtl_lnd_woocommerce_ir` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `text1` text CHARACTER SET utf8 COLLATE utf8_persian_ci NOT NULL,
  `text2` text CHARACTER SET utf8 COLLATE utf8_persian_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `rtl_lnd_woocommerce_log` (
  `log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `timestamp` datetime NOT NULL,
  `level` smallint(4) NOT NULL,
  `source` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `message` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `context` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`log_id`),
  KEY `level` (`level`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `rtl_lnd_woocommerce_order_itemmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_item_id` bigint(20) unsigned NOT NULL,
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `order_item_id` (`order_item_id`),
  KEY `meta_key` (`meta_key`(32))
) ENGINE=InnoDB AUTO_INCREMENT=37 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `rtl_lnd_woocommerce_order_items` (
  `order_item_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_item_name` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `order_item_type` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `order_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`order_item_id`),
  KEY `order_id` (`order_id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `rtl_lnd_woocommerce_payment_tokenmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `payment_token_id` bigint(20) unsigned NOT NULL,
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `payment_token_id` (`payment_token_id`),
  KEY `meta_key` (`meta_key`(32))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `rtl_lnd_woocommerce_payment_tokens` (
  `token_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `gateway_id` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `token` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `type` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `is_default` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`token_id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `rtl_lnd_woocommerce_sessions` (
  `session_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `session_key` char(32) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `session_value` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `session_expiry` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`session_id`),
  UNIQUE KEY `session_key` (`session_key`)
) ENGINE=InnoDB AUTO_INCREMENT=71 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `rtl_lnd_woocommerce_shipping_zone_locations` (
  `location_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `zone_id` bigint(20) unsigned NOT NULL,
  `location_code` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `location_type` varchar(40) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `location_id` (`location_id`),
  KEY `location_type_code` (`location_type`(10),`location_code`(20))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `rtl_lnd_woocommerce_shipping_zone_methods` (
  `zone_id` bigint(20) unsigned NOT NULL,
  `instance_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `method_id` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `method_order` bigint(20) unsigned NOT NULL,
  `is_enabled` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`instance_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `rtl_lnd_woocommerce_shipping_zones` (
  `zone_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `zone_name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `zone_order` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`zone_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `rtl_lnd_woocommerce_tax_rate_locations` (
  `location_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `location_code` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `tax_rate_id` bigint(20) unsigned NOT NULL,
  `location_type` varchar(40) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `tax_rate_id` (`tax_rate_id`),
  KEY `location_type_code` (`location_type`(10),`location_code`(20))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `rtl_lnd_woocommerce_tax_rates` (
  `tax_rate_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `tax_rate_country` varchar(2) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `tax_rate_state` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `tax_rate` varchar(8) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `tax_rate_name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `tax_rate_priority` bigint(20) unsigned NOT NULL,
  `tax_rate_compound` int(1) NOT NULL DEFAULT '0',
  `tax_rate_shipping` int(1) NOT NULL DEFAULT '1',
  `tax_rate_order` bigint(20) unsigned NOT NULL,
  `tax_rate_class` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`tax_rate_id`),
  KEY `tax_rate_country` (`tax_rate_country`),
  KEY `tax_rate_state` (`tax_rate_state`(2)),
  KEY `tax_rate_class` (`tax_rate_class`(10)),
  KEY `tax_rate_priority` (`tax_rate_priority`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;


/* INSERT TABLE DATA: rtl_lnd_actionscheduler_actions */
INSERT INTO `rtl_lnd_actionscheduler_actions` VALUES("7142", "wc-admin_import_customers", "complete", "2021-08-01 18:14:44", "2021-08-01 22:44:44", "[1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1627841684;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1627841684;}", "4", "1", "2021-08-01 18:14:54", "2021-08-01 22:44:54", "0", NULL);

/* INSERT TABLE DATA: rtl_lnd_actionscheduler_groups */
INSERT INTO `rtl_lnd_actionscheduler_groups` VALUES("1", "action-scheduler-migration");
INSERT INTO `rtl_lnd_actionscheduler_groups` VALUES("2", "woocommerce-db-updates");
INSERT INTO `rtl_lnd_actionscheduler_groups` VALUES("3", "wc_update_product_lookup_tables");
INSERT INTO `rtl_lnd_actionscheduler_groups` VALUES("4", "wc-admin-data");

/* INSERT TABLE DATA: rtl_lnd_actionscheduler_logs */
INSERT INTO `rtl_lnd_actionscheduler_logs` VALUES("130", "7142", "عملیات ایجاد شد", "2021-08-01 18:14:39", "2021-08-01 22:44:39");
INSERT INTO `rtl_lnd_actionscheduler_logs` VALUES("131", "7142", "عملیات با Async Request شروع شد", "2021-08-01 18:14:54", "2021-08-01 22:44:54");
INSERT INTO `rtl_lnd_actionscheduler_logs` VALUES("132", "7142", "عملیات با Async Request تکمیل شد", "2021-08-01 18:14:54", "2021-08-01 22:44:54");

/* INSERT TABLE DATA: rtl_lnd_commentmeta */
INSERT INTO `rtl_lnd_commentmeta` VALUES("1", "2", "rating", "4");
INSERT INTO `rtl_lnd_commentmeta` VALUES("2", "2", "verified", "0");
INSERT INTO `rtl_lnd_commentmeta` VALUES("3", "3", "rating", "5");
INSERT INTO `rtl_lnd_commentmeta` VALUES("4", "3", "verified", "0");
INSERT INTO `rtl_lnd_commentmeta` VALUES("7", "5", "rating", "4");
INSERT INTO `rtl_lnd_commentmeta` VALUES("8", "5", "verified", "0");
INSERT INTO `rtl_lnd_commentmeta` VALUES("21", "14", "rating", "4");
INSERT INTO `rtl_lnd_commentmeta` VALUES("22", "14", "verified", "0");
INSERT INTO `rtl_lnd_commentmeta` VALUES("39", "23", "rating", "4");
INSERT INTO `rtl_lnd_commentmeta` VALUES("40", "23", "verified", "0");

/* INSERT TABLE DATA: rtl_lnd_comments */
INSERT INTO `rtl_lnd_comments` VALUES("2", "50", "محسن", "james@jameskoster.co.uk", "", "86.146.141.82", "2013-06-07 11:46:52", "2013-06-07 08:16:52", "سلام, این یک دیدگاه است.", "0", "1", "", "review", "0", "0");
INSERT INTO `rtl_lnd_comments` VALUES("3", "50", "محمد", "bester.c@gmail.com", "", "196.215.9.147", "2013-06-07 11:53:13", "2013-06-07 08:23:13", "سلام, این یک دیدگاه است.", "0", "1", "", "review", "0", "0");
INSERT INTO `rtl_lnd_comments` VALUES("5", "87", "میلاد", "bester.c@gmail.com", "", "196.215.9.147", "2013-06-07 11:56:32", "2013-06-07 08:26:32", "سلام, این یک دیدگاه است.", "0", "1", "", "review", "0", "0");
INSERT INTO `rtl_lnd_comments` VALUES("14", "552", "محمد", "bester.c@gmail.com", "", "196.215.9.147", "2013-06-07 11:52:25", "2013-06-07 08:22:25", "سلام, این یک دیدگاه است.", "0", "1", "", "review", "0", "0");
INSERT INTO `rtl_lnd_comments` VALUES("23", "563", "محسن", "bester.c@gmail.com", "", "196.215.9.147", "2013-06-07 11:58:43", "2013-06-07 08:28:43", "سلام, این یک دیدگاه است.", "0", "1", "", "review", "0", "0");
INSERT INTO `rtl_lnd_comments` VALUES("31", "1066", "مدیریت", "info@demo.ir", "", "::1", "2017-11-10 18:46:50", "2017-11-10 19:46:50", "دیدگاه تست!", "0", "1", "Mozilla/5.0 (Windows NT 10.0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/62.0.3202.89 Safari/537.36", "comment", "0", "1");
INSERT INTO `rtl_lnd_comments` VALUES("32", "7071", "ووکامرس", "", "", "", "2017-11-11 14:32:05", "2017-11-11 15:32:05", "در حال انتظار بررسی پرداخت وضعیت سفارش از در انتظار پرداخت به در انتظار بررسی تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `rtl_lnd_comments` VALUES("33", "7079", "ووکامرس", "", "", "", "2017-12-07 13:39:51", "2017-12-07 14:39:51", "پرداخت پس از تحویل وضعیت سفارش از در انتظار پرداخت به در حال انجام تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `rtl_lnd_comments` VALUES("34", "7096", "ووکامرس", "", "", "", "2019-03-08 12:28:09", "2019-03-08 08:58:09", "پرداخت پس از تحویل وضعیت سفارش از در انتظار پرداخت به در حال انجام تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");

/* INSERT TABLE DATA: rtl_lnd_duplicator_packages */
INSERT INTO `rtl_lnd_duplicator_packages` VALUES("15", "Landscaper", "0e6e70f5ef40d4f03815_20210801183218", "21", "2021-08-01 18:32:37", "unknown", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2021-08-01 18:32:18\";s:7:\"Version\";s:5:\"1.4.2\";s:9:\"VersionWP\";s:3:\"5.8\";s:9:\"VersionDB\";s:6:\"5.7.24\";s:10:\"VersionPHP\";s:5:\"7.3.1\";s:9:\"VersionOS\";s:5:\"WINNT\";s:2:\"ID\";i:15;s:4:\"Name\";s:10:\"Landscaper\";s:4:\"Hash\";s:35:\"0e6e70f5ef40d4f03815_20210801183218\";s:8:\"NameHash\";s:46:\"Landscaper_0e6e70f5ef40d4f03815_20210801183218\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:56:\"Landscaper_0e6e70f5ef40d4f03815_20210801183218_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";s:4:\"21.2\";s:6:\"WPUser\";s:7:\"unknown\";s:7:\"Archive\";O:11:\"DUP_Archive\":21:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:58:\"Landscaper_0e6e70f5ef40d4f03815_20210801183218_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:29:\"C:/wamp64/www/mgh7/Landscaper\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:5:\"Files\";a:0:{}s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":6:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":7:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:-1;s:10:\"\0*\0Package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2021-08-01 18:32:18\";s:7:\"Version\";s:5:\"1.4.2\";s:9:\"VersionWP\";s:3:\"5.8\";s:9:\"VersionDB\";s:6:\"5.7.24\";s:10:\"VersionPHP\";s:5:\"7.3.1\";s:9:\"VersionOS\";s:5:\"WINNT\";s:2:\"ID\";N;s:4:\"Name\";s:10:\"Landscaper\";s:4:\"Hash\";s:35:\"0e6e70f5ef40d4f03815_20210801183218\";s:8:\"NameHash\";s:46:\"Landscaper_0e6e70f5ef40d4f03815_20210801183218\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";O:13:\"DUP_Installer\":13:{s:4:\"File\";s:60:\"Landscaper_0e6e70f5ef40d4f03815_20210801183218_installer.php\";s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:63;}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";s:59:\"Landscaper_0e6e70f5ef40d4f03815_20210801183218_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:28:\"MySQL Community Server (GPL)\";s:4:\"info\";O:16:\"DUP_DatabaseInfo\":16:{s:9:\"buildMode\";N;s:13:\"collationList\";a:0:{}s:17:\"isTablesUpperCase\";N;s:15:\"isNameUpperCase\";N;s:4:\"name\";N;s:15:\"tablesBaseCount\";N;s:16:\"tablesFinalCount\";N;s:14:\"tablesRowCount\";N;s:16:\"tablesSizeOnDisk\";N;s:18:\"varLowerCaseTables\";i:1;s:7:\"version\";N;s:14:\"versionComment\";N;s:18:\"tableWiseRowCounts\";a:5:{s:31:\"rtl_lnd_actionscheduler_actions\";s:1:\"1\";s:30:\"rtl_lnd_actionscheduler_claims\";s:1:\"0\";s:30:\"rtl_lnd_actionscheduler_groups\";s:1:\"4\";s:28:\"rtl_lnd_actionscheduler_logs\";s:1:\"3\";s:19:\"rtl_lnd_commentmeta\";s:2:\"10\";}s:11:\"triggerList\";a:0:{}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:1;s:24:\"\0DUP_Database\0tempDbPath\";s:106:\"C:/wamp64/www/mgh7/Landscaper/wp-snapshots/tmp/Landscaper_0e6e70f5ef40d4f03815_20210801183218_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;s:19:\"sameNameTableExists\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:0;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";r:63;}}s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:5:{i:0;s:38:\"C:/wamp64/www/mgh7/Landscaper/wp-admin\";i:1;s:48:\"C:/wamp64/www/mgh7/Landscaper/wp-content/uploads\";i:2;s:50:\"C:/wamp64/www/mgh7/Landscaper/wp-content/languages\";i:3;s:47:\"C:/wamp64/www/mgh7/Landscaper/wp-content/themes\";i:4;s:41:\"C:/wamp64/www/mgh7/Landscaper/wp-includes\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:2:{i:0;s:29:\"C:/wamp64/www/mgh7/Landscaper\";i:1;s:40:\"C:/wamp64/www/mgh7/Landscaper/wp-content\";}}s:9:\"Installer\";r:84;s:8:\"Database\";r:98;s:13:\"BuildProgress\";r:135;}");

/* INSERT TABLE DATA: rtl_lnd_eg_grids */
INSERT INTO `rtl_lnd_eg_grids` VALUES("1", "Gallery Classic", "classic", "{\"source-type\":\"post\",\"post_types\":\"portfolio\",\"post_category\":\"portfolio_category_31,portfolio_category_46,portfolio_category_45\",\"category-relation\":\"OR\",\"additional-query\":\"\",\"selected_pages\":\"\",\"max_entries\":\"-1\",\"stream-source-type\":\"instagram\",\"youtube-api\":\"\",\"youtube-channel-id\":\"\",\"youtube-type-source\":\"channel\",\"youtube-playlist\":\"\",\"youtube-playlist-select\":\"\",\"youtube-thumb-size\":\"default\",\"youtube-full-size\":\"default\",\"youtube-count\":\"12\",\"youtube-transient-sec\":\"86400\",\"vimeo-type-source\":\"user\",\"vimeo-username\":\"\",\"vimeo-groupname\":\"\",\"vimeo-albumid\":\"\",\"vimeo-channelname\":\"\",\"vimeo-thumb-size\":\"thumbnail_small\",\"vimeo-count\":\"12\",\"vimeo-transient-sec\":\"86400\",\"instagram-user-id\":\"\",\"instagram-thumb-size\":\"Low Resolution\",\"instagram-full-size\":\"Standard Resolution\",\"instagram-count\":\"12\",\"instagram-transient-sec\":\"86400\",\"flickr-api-key\":\"\",\"flickr-type\":\"publicphotos\",\"flickr-user-url\":\"\",\"flickr-photoset\":\"\",\"flickr-photoset-select\":\"\",\"flickr-gallery-url\":\"\",\"flickr-group-url\":\"\",\"flickr-thumb-size\":\"Small 320\",\"flickr-full-size\":\"Medium 800\",\"flickr-count\":\"12\",\"flickr-transient-sec\":\"86400\",\"facebook-app-id\":\"\",\"facebook-app-secret\":\"\",\"facebook-page-url\":\"\",\"facebook-type-source\":\"timeline\",\"facebook-album\":\"\",\"facebook-album-select\":\"\",\"facebook-count\":\"12\",\"facebook-transient-sec\":\"86400\",\"twitter-consumer-key\":\"\",\"twitter-consumer-secret\":\"\",\"twitter-access-token\":\"\",\"twitter-access-secret\":\"\",\"twitter-user-id\":\"\",\"twitter-image-only\":\"true\",\"twitter-include-retweets\":\"on\",\"twitter-exclude-replies\":\"on\",\"twitter-count\":\"12\",\"twitter-transient-sec\":\"86400\",\"media-source-order\":[\"featured-image\",\"youtube\"],\"poster-source-order\":[\"featured-image\"],\"image-source-type\":\"full\",\"media-filter-type\":\"none\",\"default-image\":\"0\",\"youtube-default-image\":\"0\",\"vimeo-default-image\":\"0\",\"html-default-image\":\"0\"}", "{\"layout-sizing\":\"boxed\",\"fullscreen-offset-container\":\"\",\"layout\":\"even\",\"content-push\":\"off\",\"x-ratio\":\"4\",\"y-ratio\":\"3\",\"auto-ratio\":\"true\",\"rtl\":\"off\",\"use-cobbles-pattern\":\"off\",\"columns-advanced\":\"off\",\"columns-height\":[\"0\",\"0\",\"0\",\"0\",\"0\",\"0\",\"0\"],\"columns-width\":[\"1400\",\"1170\",\"1024\",\"960\",\"778\",\"640\",\"480\"],\"mascontent-height\":[\"0\",\"0\",\"0\",\"0\",\"0\",\"0\",\"0\"],\"columns\":[\"4\",\"4\",\"3\",\"3\",\"3\",\"3\",\"1\"],\"rows-unlimited\":\"on\",\"rows\":\"2\",\"load-more\":\"button\",\"load-more-hide\":\"off\",\"load-more-text\":\"\\u0628\\u0627\\u0631\\u06af\\u0630\\u0627\\u0631\\u06cc \\u0628\\u06cc\\u0634\\u062a\\u0631\",\"load-more-show-number\":\"off\",\"load-more-start\":\"8\",\"load-more-amount\":\"4\",\"lazy-loading\":\"off\",\"lazy-loading-blur\":\"on\",\"lazy-load-color\":\"#FFFFFF\",\"0\":\"\",\"spacings\":\"30\",\"grid-padding\":[\"0\",\"\",\"\",\"\"],\"main-background-color\":\"transparent\",\"navigation-skin\":\"the-landscaper\",\"entry-skin\":\"51\",\"grid-animation\":\"fade\",\"grid-animation-speed\":\"100\",\"grid-animation-delay\":\"1\",\"hover-animation-delay\":\"1\",\"top-1-align\":\"center\",\"top-1-margin-bottom\":\"0\",\"top-2-align\":\"center\",\"top-2-margin-bottom\":\"50\",\"bottom-1-align\":\"center\",\"bottom-1-margin-top\":\"0\",\"bottom-2-align\":\"center\",\"bottom-2-margin-top\":\"0\",\"left-margin-left\":\"0\",\"right-margin-right\":\"0\",\"module-spacings\":\"0\",\"pagination-numbers\":\"smart\",\"pagination-scroll\":\"off\",\"pagination-scroll-offset\":\"0\",\"filter-arrows\":\"single\",\"filter-logic\":\"or\",\"filter-start\":\"\",\"filter-show-on\":\"hover\",\"filter-all-text\":\"\\u062a\\u0645\\u0627\\u0645 \\u062f\\u0633\\u062a\\u0647 \\u0628\\u0646\\u062f\\u06cc \\u0647\\u0627\",\"filter-listing\":\"list\",\"filter-dropdown-text\":\"\\u0641\\u06cc\\u0644\\u062a\\u0631 \\u0628\\u0631\\u0627\\u0633\\u0627\\u0633 \\u062f\\u0633\\u062a\\u0647 \\u0647\\u0627\",\"filter-counter\":\"off\",\"filter-selected\":[\"portfolio_category_46\",\"portfolio_category_31\",\"portfolio_category_45\"],\"sort-by-text\":\"\\u0645\\u0631\\u062a\\u0628 \\u0633\\u0627\\u0632\\u06cc\",\"sorting-order-by\":\"date,title\",\"sorting-order-by-start\":\"none\",\"sorting-order-by-start-meta\":\"\",\"sorting-order-type\":\"ASC\",\"search-text\":\"\\u062c\\u0633\\u062a\\u062c\\u0648...\",\"lb-source-order\":[\"featured-image\"],\"lightbox-mode\":\"single\",\"lightbox-exclude-media\":\"off\",\"lightbox-type\":\"null\",\"lightbox-position\":\"bottom\",\"lightbox-twitter\":\"off\",\"lightbox-facebook\":\"off\",\"lbox-inpadding\":[\"0\",\"0\",\"0\",\"0\"],\"lbox-padding\":[\"0\",\"0\",\"0\",\"0\"],\"lightbox-effect-open-close\":\"fade\",\"lightbox-effect-open-close-speed\":\"normal\",\"lightbox-effect-next-prev\":\"fade\",\"lightbox-effect-next-prev-speed\":\"normal\",\"lbox-width\":\"800\",\"lbox-height\":\"600\",\"lbox-minwidth\":\"100\",\"lbox-minheight\":\"100\",\"lbox-maxwidth\":\"9999\",\"lbox-maxheight\":\"9999\",\"lightbox-autoplay\":\"off\",\"lbox-playspeed\":\"3000\",\"lbox-preload\":\"3\",\"lightbox-arrows\":\"on\",\"lightbox-thumbs\":\"off\",\"lbox-thumb-w\":\"50\",\"lbox-thumb-h\":\"50\",\"aj-source-order\":[\"post-content\"],\"ajax-container-id\":\"ess-grid-ajax-container-\",\"ajax-container-position\":\"top\",\"ajax-scroll-onload\":\"on\",\"ajax-scrollto-offset\":\"0\",\"ajax-close-button\":\"off\",\"ajax-button-text\":\"Close\",\"ajax-nav-button\":\"off\",\"ajax-button-skin\":\"light\",\"ajax-button-type\":\"type1\",\"ajax-button-inner\":\"false\",\"ajax-button-h-pos\":\"r\",\"ajax-button-v-pos\":\"t\",\"ajax-container-pre\":\"\",\"ajax-container-post\":\"\",\"ajax-container-css\":\"\",\"ajax-callback\":\"\",\"ajax-callback-arg\":\"false\",\"ajax-css-url\":\"\",\"ajax-js-url\":\"\",\"use-spinner\":\"0\",\"spinner-color\":\"#FFFFFF\",\"hide-markup-before-load\":\"off\",\"custom-javascript\":\"\",\"cookie-save-time\":\"30\",\"cookie-save-search\":\"off\",\"cookie-save-filter\":\"off\",\"cookie-save-pagination\":\"off\",\"css-id\":\"\",\"navigation-layout\":{\"filter\":{\"top-2\":\"0\"}}}", "[]", NULL, "2017-11-11 14:18:55");
INSERT INTO `rtl_lnd_eg_grids` VALUES("2", "Gallery Fullwidth", "fullwidth", "{\"source-type\":\"post\",\"post_types\":\"portfolio\",\"post_category\":\"portfolio_category_31,portfolio_category_46,portfolio_category_45\",\"category-relation\":\"OR\",\"additional-query\":\"\",\"selected_pages\":\"\",\"max_entries\":\"-1\",\"stream-source-type\":\"instagram\",\"youtube-api\":\"\",\"youtube-channel-id\":\"\",\"youtube-type-source\":\"channel\",\"youtube-playlist\":\"\",\"youtube-playlist-select\":\"\",\"youtube-thumb-size\":\"default\",\"youtube-full-size\":\"default\",\"youtube-count\":\"12\",\"youtube-transient-sec\":\"86400\",\"vimeo-type-source\":\"user\",\"vimeo-username\":\"\",\"vimeo-groupname\":\"\",\"vimeo-albumid\":\"\",\"vimeo-channelname\":\"\",\"vimeo-thumb-size\":\"thumbnail_small\",\"vimeo-count\":\"12\",\"vimeo-transient-sec\":\"86400\",\"instagram-user-id\":\"\",\"instagram-thumb-size\":\"Low Resolution\",\"instagram-full-size\":\"Standard Resolution\",\"instagram-count\":\"12\",\"instagram-transient-sec\":\"86400\",\"flickr-api-key\":\"\",\"flickr-type\":\"publicphotos\",\"flickr-user-url\":\"\",\"flickr-photoset\":\"\",\"flickr-photoset-select\":\"\",\"flickr-gallery-url\":\"\",\"flickr-group-url\":\"\",\"flickr-thumb-size\":\"Small 320\",\"flickr-full-size\":\"Medium 800\",\"flickr-count\":\"12\",\"flickr-transient-sec\":\"86400\",\"facebook-app-id\":\"\",\"facebook-app-secret\":\"\",\"facebook-page-url\":\"\",\"facebook-type-source\":\"timeline\",\"facebook-album\":\"\",\"facebook-album-select\":\"\",\"facebook-count\":\"12\",\"facebook-transient-sec\":\"86400\",\"twitter-consumer-key\":\"\",\"twitter-consumer-secret\":\"\",\"twitter-access-token\":\"\",\"twitter-access-secret\":\"\",\"twitter-user-id\":\"\",\"twitter-image-only\":\"true\",\"twitter-include-retweets\":\"on\",\"twitter-exclude-replies\":\"on\",\"twitter-count\":\"12\",\"twitter-transient-sec\":\"86400\",\"media-source-order\":[\"featured-image\"],\"poster-source-order\":[\"featured-image\"],\"image-source-type\":\"full\",\"media-filter-type\":\"none\",\"default-image\":\"0\",\"youtube-default-image\":\"0\",\"vimeo-default-image\":\"0\",\"html-default-image\":\"0\"}", "{\"layout-sizing\":\"fullwidth\",\"fullscreen-offset-container\":\"\",\"layout\":\"even\",\"content-push\":\"off\",\"x-ratio\":\"4\",\"y-ratio\":\"3\",\"auto-ratio\":\"true\",\"rtl\":\"off\",\"use-cobbles-pattern\":\"off\",\"columns-advanced\":\"off\",\"columns-height\":[\"0\",\"0\",\"0\",\"0\",\"0\",\"0\",\"0\"],\"columns-width\":[\"1400\",\"1170\",\"1024\",\"960\",\"778\",\"640\",\"480\"],\"mascontent-height\":[\"0\",\"0\",\"0\",\"0\",\"0\",\"0\",\"0\"],\"columns\":[\"4\",\"4\",\"4\",\"3\",\"3\",\"3\",\"1\"],\"rows-unlimited\":\"on\",\"rows\":\"3\",\"load-more\":\"button\",\"load-more-hide\":\"off\",\"load-more-text\":\"\\u0628\\u0627\\u0631\\u06af\\u0630\\u0627\\u0631\\u06cc \\u0628\\u06cc\\u0634\\u062a\\u0631\",\"load-more-show-number\":\"on\",\"load-more-start\":\"8\",\"load-more-amount\":\"4\",\"lazy-loading\":\"off\",\"lazy-loading-blur\":\"on\",\"lazy-load-color\":\"#FFFFFF\",\"0\":\"\",\"spacings\":\"0\",\"grid-padding\":[\"0\",\"0\",\"0\",\"0\"],\"main-background-color\":\"transparent\",\"navigation-skin\":\"the-landscaper\",\"entry-skin\":\"51\",\"grid-animation\":\"fade\",\"grid-animation-speed\":\"400\",\"grid-animation-delay\":\"1\",\"hover-animation-delay\":\"1\",\"top-1-align\":\"center\",\"top-1-margin-bottom\":\"0\",\"top-2-align\":\"center\",\"top-2-margin-bottom\":\"50\",\"bottom-1-align\":\"center\",\"bottom-1-margin-top\":\"0\",\"bottom-2-align\":\"center\",\"bottom-2-margin-top\":\"0\",\"left-margin-left\":\"0\",\"right-margin-right\":\"0\",\"module-spacings\":\"0\",\"pagination-numbers\":\"smart\",\"pagination-scroll\":\"off\",\"pagination-scroll-offset\":\"0\",\"filter-arrows\":\"single\",\"filter-logic\":\"or\",\"filter-start\":\"\",\"filter-show-on\":\"hover\",\"filter-all-text\":\"\\u062a\\u0645\\u0627\\u0645 \\u062f\\u0633\\u062a\\u0647 \\u0628\\u0646\\u062f\\u06cc \\u0647\\u0627\",\"filter-listing\":\"list\",\"filter-dropdown-text\":\"\\u0641\\u06cc\\u0644\\u062a\\u0631 \\u0628\\u0631\\u0627\\u0633\\u0627\\u0633 \\u062f\\u0633\\u062a\\u0647 \\u0647\\u0627\",\"filter-counter\":\"off\",\"filter-selected\":[\"portfolio_category_45\",\"portfolio_category_46\",\"portfolio_category_31\"],\"sort-by-text\":\"\\u0645\\u0631\\u062a\\u0628 \\u0633\\u0627\\u0632\\u06cc\",\"sorting-order-by\":\"date\",\"sorting-order-by-start\":\"none\",\"sorting-order-by-start-meta\":\"\",\"sorting-order-type\":\"ASC\",\"search-text\":\"\\u062c\\u0633\\u062a\\u062c\\u0648...\",\"lb-source-order\":[\"featured-image\"],\"lightbox-mode\":\"single\",\"lightbox-exclude-media\":\"off\",\"lightbox-type\":\"null\",\"lightbox-position\":\"bottom\",\"lightbox-twitter\":\"off\",\"lightbox-facebook\":\"off\",\"lbox-inpadding\":[\"0\",\"0\",\"0\",\"0\"],\"lbox-padding\":[\"0\",\"0\",\"0\",\"0\"],\"lightbox-effect-open-close\":\"fade\",\"lightbox-effect-open-close-speed\":\"normal\",\"lightbox-effect-next-prev\":\"fade\",\"lightbox-effect-next-prev-speed\":\"normal\",\"lbox-width\":\"800\",\"lbox-height\":\"600\",\"lbox-minwidth\":\"100\",\"lbox-minheight\":\"100\",\"lbox-maxwidth\":\"9999\",\"lbox-maxheight\":\"9999\",\"lightbox-autoplay\":\"off\",\"lbox-playspeed\":\"3000\",\"lbox-preload\":\"3\",\"lightbox-arrows\":\"on\",\"lightbox-thumbs\":\"off\",\"lbox-thumb-w\":\"50\",\"lbox-thumb-h\":\"50\",\"aj-source-order\":[\"post-content\"],\"ajax-container-id\":\"ess-grid-ajax-container-\",\"ajax-container-position\":\"top\",\"ajax-scroll-onload\":\"on\",\"ajax-scrollto-offset\":\"0\",\"ajax-close-button\":\"off\",\"ajax-button-text\":\"Close\",\"ajax-nav-button\":\"off\",\"ajax-button-skin\":\"light\",\"ajax-button-type\":\"type1\",\"ajax-button-inner\":\"false\",\"ajax-button-h-pos\":\"r\",\"ajax-button-v-pos\":\"t\",\"ajax-container-pre\":\"\",\"ajax-container-post\":\"\",\"ajax-container-css\":\"\",\"ajax-callback\":\"\",\"ajax-callback-arg\":\"false\",\"ajax-css-url\":\"\",\"ajax-js-url\":\"\",\"use-spinner\":\"0\",\"spinner-color\":\"#FFFFFF\",\"hide-markup-before-load\":\"off\",\"custom-javascript\":\"\",\"cookie-save-time\":\"30\",\"cookie-save-search\":\"off\",\"cookie-save-filter\":\"off\",\"cookie-save-pagination\":\"off\",\"css-id\":\"\",\"navigation-layout\":{\"filter\":{\"top-2\":\"0\"}}}", "[]", NULL, "2017-11-11 14:14:21");
INSERT INTO `rtl_lnd_eg_grids` VALUES("3", "Gallery No Filter", "nofilter", "{\"source-type\":\"post\",\"post_types\":\"portfolio\",\"post_category\":\"portfolio_category_31,portfolio_category_46,portfolio_category_45\",\"category-relation\":\"OR\",\"additional-query\":\"\",\"selected_pages\":\"\",\"max_entries\":\"-1\",\"stream-source-type\":\"instagram\",\"youtube-api\":\"\",\"youtube-channel-id\":\"\",\"youtube-type-source\":\"channel\",\"youtube-playlist\":\"\",\"youtube-playlist-select\":\"\",\"youtube-thumb-size\":\"default\",\"youtube-full-size\":\"default\",\"youtube-count\":\"12\",\"youtube-transient-sec\":\"86400\",\"vimeo-type-source\":\"user\",\"vimeo-username\":\"\",\"vimeo-groupname\":\"\",\"vimeo-albumid\":\"\",\"vimeo-channelname\":\"\",\"vimeo-thumb-size\":\"thumbnail_small\",\"vimeo-count\":\"12\",\"vimeo-transient-sec\":\"86400\",\"instagram-user-id\":\"\",\"instagram-thumb-size\":\"Low Resolution\",\"instagram-full-size\":\"Standard Resolution\",\"instagram-count\":\"12\",\"instagram-transient-sec\":\"86400\",\"flickr-api-key\":\"\",\"flickr-type\":\"publicphotos\",\"flickr-user-url\":\"\",\"flickr-photoset\":\"\",\"flickr-photoset-select\":\"\",\"flickr-gallery-url\":\"\",\"flickr-group-url\":\"\",\"flickr-thumb-size\":\"Small 320\",\"flickr-full-size\":\"Medium 800\",\"flickr-count\":\"12\",\"flickr-transient-sec\":\"86400\",\"facebook-app-id\":\"\",\"facebook-app-secret\":\"\",\"facebook-page-url\":\"\",\"facebook-type-source\":\"timeline\",\"facebook-album\":\"\",\"facebook-album-select\":\"\",\"facebook-count\":\"12\",\"facebook-transient-sec\":\"86400\",\"twitter-consumer-key\":\"\",\"twitter-consumer-secret\":\"\",\"twitter-access-token\":\"\",\"twitter-access-secret\":\"\",\"twitter-user-id\":\"\",\"twitter-image-only\":\"true\",\"twitter-include-retweets\":\"on\",\"twitter-exclude-replies\":\"on\",\"twitter-count\":\"12\",\"twitter-transient-sec\":\"86400\",\"media-source-order\":[\"featured-image\"],\"poster-source-order\":[\"featured-image\"],\"image-source-type\":\"full\",\"media-filter-type\":\"none\",\"default-image\":\"0\",\"youtube-default-image\":\"0\",\"vimeo-default-image\":\"0\",\"html-default-image\":\"0\"}", "{\"layout-sizing\":\"boxed\",\"fullscreen-offset-container\":\"\",\"layout\":\"even\",\"content-push\":\"off\",\"x-ratio\":\"4\",\"y-ratio\":\"3\",\"auto-ratio\":\"true\",\"rtl\":\"off\",\"use-cobbles-pattern\":\"off\",\"columns-advanced\":\"off\",\"columns-height\":[\"0\",\"0\",\"0\",\"0\",\"0\",\"0\",\"0\"],\"columns-width\":[\"1400\",\"1170\",\"1024\",\"960\",\"778\",\"640\",\"480\"],\"mascontent-height\":[\"0\",\"0\",\"0\",\"0\",\"0\",\"0\",\"0\"],\"columns\":[\"3\",\"3\",\"3\",\"3\",\"3\",\"3\",\"1\"],\"rows-unlimited\":\"on\",\"rows\":\"3\",\"load-more\":\"button\",\"load-more-hide\":\"off\",\"load-more-text\":\"\\u0628\\u0627\\u0631\\u06af\\u0630\\u0627\\u0631\\u06cc \\u0628\\u06cc\\u0634\\u062a\\u0631\",\"load-more-show-number\":\"on\",\"load-more-start\":\"6\",\"load-more-amount\":\"3\",\"lazy-loading\":\"off\",\"lazy-loading-blur\":\"on\",\"lazy-load-color\":\"#FFFFFF\",\"0\":\"\",\"spacings\":\"30\",\"grid-padding\":[\"0\",\"0\",\"0\",\"0\"],\"main-background-color\":\"transparent\",\"navigation-skin\":\"the-landscaper\",\"entry-skin\":\"51\",\"grid-animation\":\"fade\",\"grid-animation-speed\":\"1000\",\"grid-animation-delay\":\"1\",\"hover-animation-delay\":\"1\",\"top-1-align\":\"center\",\"top-1-margin-bottom\":\"0\",\"top-2-align\":\"center\",\"top-2-margin-bottom\":\"0\",\"bottom-1-align\":\"center\",\"bottom-1-margin-top\":\"0\",\"bottom-2-align\":\"center\",\"bottom-2-margin-top\":\"0\",\"left-margin-left\":\"0\",\"right-margin-right\":\"0\",\"module-spacings\":\"5\",\"pagination-numbers\":\"smart\",\"pagination-scroll\":\"off\",\"pagination-scroll-offset\":\"0\",\"filter-arrows\":\"single\",\"filter-logic\":\"or\",\"filter-start\":\"\",\"filter-show-on\":\"hover\",\"filter-all-text\":\"\\u0641\\u06cc\\u0644\\u062a\\u0631 \\u0647\\u0645\\u0647\",\"filter-listing\":\"list\",\"filter-dropdown-text\":\"\\u0641\\u06cc\\u0644\\u062a\\u0631 \\u062f\\u0633\\u062a\\u0647 \\u0647\\u0627\",\"filter-counter\":\"off\",\"filter-selected\":[\"portfolio_category_31\",\"portfolio_category_46\",\"portfolio_category_45\"],\"sort-by-text\":\"\\u0645\\u0631\\u062a\\u0628 \\u0633\\u0627\\u0632\\u06cc\",\"sorting-order-by\":\"date\",\"sorting-order-by-start\":\"none\",\"sorting-order-by-start-meta\":\"\",\"sorting-order-type\":\"ASC\",\"search-text\":\"\\u062c\\u0633\\u062a\\u062c\\u0648...\",\"lb-source-order\":[\"featured-image\"],\"lightbox-mode\":\"single\",\"lightbox-exclude-media\":\"off\",\"lightbox-type\":\"null\",\"lightbox-position\":\"bottom\",\"lightbox-twitter\":\"off\",\"lightbox-facebook\":\"off\",\"lbox-inpadding\":[\"0\",\"0\",\"0\",\"0\"],\"lbox-padding\":[\"0\",\"0\",\"0\",\"0\"],\"lightbox-effect-open-close\":\"fade\",\"lightbox-effect-open-close-speed\":\"normal\",\"lightbox-effect-next-prev\":\"fade\",\"lightbox-effect-next-prev-speed\":\"normal\",\"lbox-width\":\"800\",\"lbox-height\":\"600\",\"lbox-minwidth\":\"100\",\"lbox-minheight\":\"100\",\"lbox-maxwidth\":\"9999\",\"lbox-maxheight\":\"9999\",\"lightbox-autoplay\":\"off\",\"lbox-playspeed\":\"3000\",\"lbox-preload\":\"3\",\"lightbox-arrows\":\"on\",\"lightbox-thumbs\":\"off\",\"lbox-thumb-w\":\"50\",\"lbox-thumb-h\":\"50\",\"aj-source-order\":[\"post-content\"],\"ajax-container-id\":\"ess-grid-ajax-container-\",\"ajax-container-position\":\"top\",\"ajax-scroll-onload\":\"on\",\"ajax-scrollto-offset\":\"0\",\"ajax-close-button\":\"off\",\"ajax-button-text\":\"Close\",\"ajax-nav-button\":\"off\",\"ajax-button-skin\":\"light\",\"ajax-button-type\":\"type1\",\"ajax-button-inner\":\"false\",\"ajax-button-h-pos\":\"r\",\"ajax-button-v-pos\":\"t\",\"ajax-container-pre\":\"\",\"ajax-container-post\":\"\",\"ajax-container-css\":\"\",\"ajax-callback\":\"\",\"ajax-callback-arg\":\"false\",\"ajax-css-url\":\"\",\"ajax-js-url\":\"\",\"use-spinner\":\"0\",\"spinner-color\":\"#FFFFFF\",\"hide-markup-before-load\":\"off\",\"custom-javascript\":\"\",\"cookie-save-time\":\"30\",\"cookie-save-search\":\"off\",\"cookie-save-filter\":\"off\",\"cookie-save-pagination\":\"off\",\"css-id\":\"\"}", "[]", NULL, "2017-11-11 14:20:19");
INSERT INTO `rtl_lnd_eg_grids` VALUES("4", "Gallery Homepage", "gallery_homepage", "{\"source-type\":\"post\",\"post_types\":\"portfolio\",\"post_category\":\"portfolio_category_31,portfolio_category_46,portfolio_category_45\",\"category-relation\":\"OR\",\"additional-query\":\"\",\"selected_pages\":\"\",\"max_entries\":\"-1\",\"stream-source-type\":\"instagram\",\"youtube-api\":\"\",\"youtube-channel-id\":\"\",\"youtube-type-source\":\"channel\",\"youtube-playlist\":\"\",\"youtube-playlist-select\":\"\",\"youtube-thumb-size\":\"default\",\"youtube-full-size\":\"default\",\"youtube-count\":\"12\",\"youtube-transient-sec\":\"86400\",\"vimeo-type-source\":\"user\",\"vimeo-username\":\"\",\"vimeo-groupname\":\"\",\"vimeo-albumid\":\"\",\"vimeo-channelname\":\"\",\"vimeo-thumb-size\":\"thumbnail_small\",\"vimeo-count\":\"12\",\"vimeo-transient-sec\":\"86400\",\"instagram-user-id\":\"\",\"instagram-thumb-size\":\"Low Resolution\",\"instagram-full-size\":\"Standard Resolution\",\"instagram-count\":\"12\",\"instagram-transient-sec\":\"86400\",\"flickr-api-key\":\"\",\"flickr-type\":\"publicphotos\",\"flickr-user-url\":\"\",\"flickr-photoset\":\"\",\"flickr-photoset-select\":\"\",\"flickr-gallery-url\":\"\",\"flickr-group-url\":\"\",\"flickr-thumb-size\":\"Small 320\",\"flickr-full-size\":\"Medium 800\",\"flickr-count\":\"12\",\"flickr-transient-sec\":\"86400\",\"facebook-app-id\":\"\",\"facebook-app-secret\":\"\",\"facebook-page-url\":\"\",\"facebook-type-source\":\"timeline\",\"facebook-album\":\"\",\"facebook-album-select\":\"\",\"facebook-count\":\"12\",\"facebook-transient-sec\":\"86400\",\"twitter-consumer-key\":\"\",\"twitter-consumer-secret\":\"\",\"twitter-access-token\":\"\",\"twitter-access-secret\":\"\",\"twitter-user-id\":\"\",\"twitter-image-only\":\"true\",\"twitter-include-retweets\":\"on\",\"twitter-exclude-replies\":\"on\",\"twitter-count\":\"12\",\"twitter-transient-sec\":\"86400\",\"media-source-order\":[\"featured-image\"],\"poster-source-order\":[\"featured-image\"],\"image-source-type\":\"thelandscaper-featured-thumb\",\"media-filter-type\":\"none\",\"default-image\":\"0\",\"youtube-default-image\":\"0\",\"vimeo-default-image\":\"0\",\"html-default-image\":\"0\"}", "{\"layout-sizing\":\"boxed\",\"fullscreen-offset-container\":\"\",\"layout\":\"masonry\",\"content-push\":\"off\",\"x-ratio\":\"4\",\"y-ratio\":\"3\",\"auto-ratio\":\"true\",\"rtl\":\"off\",\"use-cobbles-pattern\":\"off\",\"columns-advanced\":\"off\",\"columns-height\":[\"0\",\"0\",\"0\",\"0\",\"0\",\"0\",\"0\"],\"columns-width\":[\"1400\",\"1170\",\"1024\",\"960\",\"778\",\"640\",\"480\"],\"mascontent-height\":[\"0\",\"0\",\"0\",\"0\",\"0\",\"0\",\"0\"],\"columns\":[\"4\",\"4\",\"4\",\"4\",\"2\",\"2\",\"1\"],\"rows-unlimited\":\"off\",\"rows\":\"1\",\"load-more\":\"none\",\"load-more-hide\":\"off\",\"load-more-text\":\"Load More\",\"load-more-show-number\":\"off\",\"load-more-start\":\"4\",\"load-more-amount\":\"4\",\"lazy-loading\":\"off\",\"lazy-loading-blur\":\"on\",\"lazy-load-color\":\"#FFFFFF\",\"0\":\"\",\"spacings\":\"25\",\"grid-padding\":[\"0\",\"0\",\"0\",\"0\"],\"main-background-color\":\"transparent\",\"navigation-skin\":\"the-landscaper-home\",\"entry-skin\":\"52\",\"grid-animation\":\"fade\",\"grid-animation-speed\":\"100\",\"grid-animation-delay\":\"1\",\"hover-animation-delay\":\"1\",\"top-1-align\":\"center\",\"top-1-margin-bottom\":\"0\",\"top-2-align\":\"center\",\"top-2-margin-bottom\":\"0\",\"bottom-1-align\":\"center\",\"bottom-1-margin-top\":\"30\",\"bottom-2-align\":\"center\",\"bottom-2-margin-top\":\"0\",\"left-margin-left\":\"0\",\"right-margin-right\":\"0\",\"module-spacings\":\"0\",\"pagination-numbers\":\"smart\",\"pagination-scroll\":\"off\",\"pagination-scroll-offset\":\"0\",\"filter-arrows\":\"single\",\"filter-logic\":\"or\",\"filter-start\":\"\",\"filter-show-on\":\"hover\",\"filter-all-text\":\"\\u062a\\u0645\\u0627\\u0645 \\u062f\\u0633\\u062a\\u0647 \\u0628\\u0646\\u062f\\u06cc \\u0647\\u0627\",\"filter-listing\":\"list\",\"filter-dropdown-text\":\"\\u0641\\u06cc\\u0644\\u062a\\u0631 \\u062f\\u0633\\u062a\\u0647 \\u0647\\u0627\",\"filter-counter\":\"off\",\"filter-selected\":[\"portfolio_category_45\",\"portfolio_category_46\",\"portfolio_category_31\"],\"sort-by-text\":\"\\u0645\\u0631\\u062a\\u0628 \\u0633\\u0627\\u0632\\u06cc\",\"sorting-order-by\":\"date,title\",\"sorting-order-by-start\":\"none\",\"sorting-order-by-start-meta\":\"\",\"sorting-order-type\":\"ASC\",\"search-text\":\"\\u062c\\u0633\\u062a\\u062c\\u0648...\",\"lb-source-order\":[\"featured-image\"],\"lightbox-mode\":\"single\",\"lightbox-exclude-media\":\"off\",\"lightbox-type\":\"null\",\"lightbox-position\":\"bottom\",\"lightbox-twitter\":\"off\",\"lightbox-facebook\":\"off\",\"lbox-inpadding\":[\"0\",\"0\",\"0\",\"0\"],\"lbox-padding\":[\"0\",\"0\",\"0\",\"0\"],\"lightbox-effect-open-close\":\"fade\",\"lightbox-effect-open-close-speed\":\"normal\",\"lightbox-effect-next-prev\":\"fade\",\"lightbox-effect-next-prev-speed\":\"normal\",\"lbox-width\":\"800\",\"lbox-height\":\"600\",\"lbox-minwidth\":\"100\",\"lbox-minheight\":\"100\",\"lbox-maxwidth\":\"9999\",\"lbox-maxheight\":\"9999\",\"lightbox-autoplay\":\"off\",\"lbox-playspeed\":\"3000\",\"lbox-preload\":\"3\",\"lightbox-arrows\":\"on\",\"lightbox-thumbs\":\"off\",\"lbox-thumb-w\":\"50\",\"lbox-thumb-h\":\"50\",\"aj-source-order\":[\"post-content\"],\"ajax-container-id\":\"ess-grid-ajax-container-\",\"ajax-container-position\":\"top\",\"ajax-scroll-onload\":\"on\",\"ajax-scrollto-offset\":\"0\",\"ajax-close-button\":\"off\",\"ajax-button-text\":\"Close\",\"ajax-nav-button\":\"off\",\"ajax-button-skin\":\"light\",\"ajax-button-type\":\"type1\",\"ajax-button-inner\":\"false\",\"ajax-button-h-pos\":\"r\",\"ajax-button-v-pos\":\"t\",\"ajax-container-pre\":\"<p><br data-mce-bogus=\\\"1\\\"><\\/p>\\n\",\"ajax-container-post\":\"<p><br data-mce-bogus=\\\"1\\\"><\\/p>\\n\",\"ajax-container-css\":\"\",\"ajax-callback\":\"\",\"ajax-callback-arg\":\"false\",\"ajax-css-url\":\"\",\"ajax-js-url\":\"\",\"use-spinner\":\"0\",\"spinner-color\":\"#FFFFFF\",\"hide-markup-before-load\":\"off\",\"custom-javascript\":\"\",\"cookie-save-time\":\"30\",\"cookie-save-search\":\"off\",\"cookie-save-filter\":\"off\",\"cookie-save-pagination\":\"off\",\"css-id\":\"\",\"navigation-layout\":{\"left\":{\"bottom-1\":\"0\"},\"right\":{\"bottom-1\":\"1\"}}}", "[]", NULL, "2017-11-11 14:21:09");
INSERT INTO `rtl_lnd_eg_grids` VALUES("5", "Gallery Lightbox", "gallery_lightbox", "{\"source-type\":\"post\",\"post_types\":\"portfolio\",\"post_category\":\"portfolio_category_31,portfolio_category_46,portfolio_category_45\",\"category-relation\":\"OR\",\"additional-query\":\"\",\"selected_pages\":\"\",\"max_entries\":\"-1\",\"stream-source-type\":\"instagram\",\"youtube-api\":\"\",\"youtube-channel-id\":\"\",\"youtube-type-source\":\"channel\",\"youtube-playlist\":\"\",\"youtube-playlist-select\":\"\",\"youtube-thumb-size\":\"default\",\"youtube-full-size\":\"default\",\"youtube-count\":\"12\",\"youtube-transient-sec\":\"86400\",\"vimeo-type-source\":\"user\",\"vimeo-username\":\"\",\"vimeo-groupname\":\"\",\"vimeo-albumid\":\"\",\"vimeo-channelname\":\"\",\"vimeo-thumb-size\":\"thumbnail_small\",\"vimeo-count\":\"12\",\"vimeo-transient-sec\":\"86400\",\"instagram-user-id\":\"\",\"instagram-thumb-size\":\"Low Resolution\",\"instagram-full-size\":\"Standard Resolution\",\"instagram-count\":\"12\",\"instagram-transient-sec\":\"86400\",\"flickr-api-key\":\"\",\"flickr-type\":\"publicphotos\",\"flickr-user-url\":\"\",\"flickr-photoset\":\"\",\"flickr-photoset-select\":\"\",\"flickr-gallery-url\":\"\",\"flickr-group-url\":\"\",\"flickr-thumb-size\":\"Small 320\",\"flickr-full-size\":\"Medium 800\",\"flickr-count\":\"12\",\"flickr-transient-sec\":\"86400\",\"facebook-app-id\":\"\",\"facebook-app-secret\":\"\",\"facebook-page-url\":\"\",\"facebook-type-source\":\"timeline\",\"facebook-album\":\"\",\"facebook-album-select\":\"\",\"facebook-count\":\"12\",\"facebook-transient-sec\":\"86400\",\"twitter-consumer-key\":\"\",\"twitter-consumer-secret\":\"\",\"twitter-access-token\":\"\",\"twitter-access-secret\":\"\",\"twitter-user-id\":\"\",\"twitter-image-only\":\"true\",\"twitter-include-retweets\":\"on\",\"twitter-exclude-replies\":\"on\",\"twitter-count\":\"12\",\"twitter-transient-sec\":\"86400\",\"media-source-order\":[\"featured-image\"],\"poster-source-order\":[\"featured-image\"],\"image-source-type\":\"full\",\"media-filter-type\":\"none\",\"default-image\":\"0\",\"youtube-default-image\":\"0\",\"vimeo-default-image\":\"0\",\"html-default-image\":\"0\"}", "{\"layout-sizing\":\"boxed\",\"fullscreen-offset-container\":\"\",\"layout\":\"even\",\"content-push\":\"off\",\"x-ratio\":\"4\",\"y-ratio\":\"3\",\"auto-ratio\":\"true\",\"rtl\":\"off\",\"use-cobbles-pattern\":\"off\",\"columns-advanced\":\"off\",\"columns-height\":[\"0\",\"0\",\"0\",\"0\",\"0\",\"0\",\"0\"],\"columns-width\":[\"1400\",\"1170\",\"1024\",\"960\",\"778\",\"640\",\"480\"],\"mascontent-height\":[\"0\",\"0\",\"0\",\"0\",\"0\",\"0\",\"0\"],\"columns\":[\"4\",\"4\",\"4\",\"3\",\"3\",\"3\",\"1\"],\"rows-unlimited\":\"on\",\"rows\":\"3\",\"load-more\":\"button\",\"load-more-hide\":\"off\",\"load-more-text\":\"\\u0628\\u0627\\u0631\\u06af\\u0630\\u0627\\u0631\\u06cc \\u0628\\u06cc\\u0634\\u062a\\u0631\",\"load-more-show-number\":\"off\",\"load-more-start\":\"12\",\"load-more-amount\":\"4\",\"lazy-loading\":\"off\",\"lazy-loading-blur\":\"on\",\"lazy-load-color\":\"#FFFFFF\",\"0\":\"\",\"spacings\":\"30\",\"grid-padding\":[\"0\",\"0\",\"0\",\"0\"],\"main-background-color\":\"transparent\",\"navigation-skin\":\"the-landscaper\",\"entry-skin\":\"53\",\"grid-animation\":\"fade\",\"grid-animation-speed\":\"1000\",\"grid-animation-delay\":\"1\",\"hover-animation-delay\":\"1\",\"top-1-align\":\"center\",\"top-1-margin-bottom\":\"0\",\"top-2-align\":\"center\",\"top-2-margin-bottom\":\"30\",\"bottom-1-align\":\"center\",\"bottom-1-margin-top\":\"0\",\"bottom-2-align\":\"center\",\"bottom-2-margin-top\":\"0\",\"left-margin-left\":\"0\",\"right-margin-right\":\"0\",\"module-spacings\":\"5\",\"pagination-numbers\":\"smart\",\"pagination-scroll\":\"off\",\"pagination-scroll-offset\":\"0\",\"filter-arrows\":\"single\",\"filter-logic\":\"or\",\"filter-start\":\"\",\"filter-show-on\":\"hover\",\"filter-all-text\":\"\\u062a\\u0645\\u0627\\u0645 \\u062f\\u0633\\u062a\\u0647 \\u0628\\u0646\\u062f\\u06cc \\u0647\\u0627\",\"filter-listing\":\"list\",\"filter-dropdown-text\":\"\\u0641\\u06cc\\u0644\\u062a\\u0631 \\u062f\\u0633\\u062a\\u0647 \\u0647\\u0627\",\"filter-counter\":\"off\",\"filter-selected\":[\"portfolio_category_45\",\"portfolio_category_46\",\"portfolio_category_31\"],\"sort-by-text\":\"\\u0645\\u0631\\u062a\\u0628 \\u0633\\u0627\\u0632\\u06cc\",\"sorting-order-by\":\"date\",\"sorting-order-by-start\":\"none\",\"sorting-order-by-start-meta\":\"\",\"sorting-order-type\":\"ASC\",\"search-text\":\"\\u062c\\u0633\\u062a\\u062c\\u0648...\",\"lb-source-order\":[\"featured-image\"],\"lightbox-mode\":\"single\",\"lightbox-exclude-media\":\"off\",\"lightbox-type\":\"null\",\"lightbox-position\":\"bottom\",\"lightbox-twitter\":\"off\",\"lightbox-facebook\":\"off\",\"lbox-inpadding\":[\"0\",\"0\",\"0\",\"0\"],\"lbox-padding\":[\"0\",\"0\",\"0\",\"0\"],\"lightbox-effect-open-close\":\"fade\",\"lightbox-effect-open-close-speed\":\"normal\",\"lightbox-effect-next-prev\":\"fade\",\"lightbox-effect-next-prev-speed\":\"normal\",\"lbox-width\":\"800\",\"lbox-height\":\"600\",\"lbox-minwidth\":\"100\",\"lbox-minheight\":\"100\",\"lbox-maxwidth\":\"9999\",\"lbox-maxheight\":\"9999\",\"lightbox-autoplay\":\"off\",\"lbox-playspeed\":\"3000\",\"lbox-preload\":\"3\",\"lightbox-arrows\":\"on\",\"lightbox-thumbs\":\"off\",\"lbox-thumb-w\":\"50\",\"lbox-thumb-h\":\"50\",\"aj-source-order\":[\"post-content\"],\"ajax-container-id\":\"ess-grid-ajax-container-\",\"ajax-container-position\":\"top\",\"ajax-scroll-onload\":\"on\",\"ajax-scrollto-offset\":\"0\",\"ajax-close-button\":\"off\",\"ajax-button-text\":\"Close\",\"ajax-nav-button\":\"off\",\"ajax-button-skin\":\"light\",\"ajax-button-type\":\"type1\",\"ajax-button-inner\":\"false\",\"ajax-button-h-pos\":\"r\",\"ajax-button-v-pos\":\"t\",\"ajax-container-pre\":\"\",\"ajax-container-post\":\"\",\"ajax-container-css\":\"\",\"ajax-callback\":\"\",\"ajax-callback-arg\":\"false\",\"ajax-css-url\":\"\",\"ajax-js-url\":\"\",\"use-spinner\":\"0\",\"spinner-color\":\"#FFFFFF\",\"hide-markup-before-load\":\"off\",\"custom-javascript\":\"\",\"cookie-save-time\":\"30\",\"cookie-save-search\":\"off\",\"cookie-save-filter\":\"off\",\"cookie-save-pagination\":\"off\",\"css-id\":\"\",\"navigation-layout\":{\"filter\":{\"top-2\":\"0\"}}}", "[]", NULL, "2017-11-11 14:21:45");

/* INSERT TABLE DATA: rtl_lnd_eg_item_elements */
INSERT INTO `rtl_lnd_eg_item_elements` VALUES("1", "Craftsman", "craftsman", "{\"source\":\"post\",\"source-post\":\"title\",\"source-woocommerce\":\"wc_full_price\",\"source-separate\":\",\",\"source-function\":\"link\",\"source-meta\":\"\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"source-icon\":\"\",\"source-text\":\"READ MORE\",\"enable-hover\":\"false\",\"font-size\":\"17\",\"line-height\":\"20\",\"color\":\"#ffffff\",\"0\":\"Default\",\"font-family\":\"\",\"font-weight\":\"800\",\"text-decoration\":\"none\",\"font-style\":\"false\",\"text-transform\":\"uppercase\",\"position\":\"relative\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"10\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"#ffffff\",\"bg-alpha\":\"0\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"17\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"false\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"15\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"hideunderheight\":\"0\",\"hidetype\":\"visibility\",\"hide-on-video\":\"false\",\"show-on-sale\":\"false\",\"show-if-featured\":\"false\",\"transition\":\"fade\",\"transition-type\":\"\",\"delay\":\"60\",\"link-type\":\"none\",\"url-link\":\"\",\"meta-link\":\"\",\"javascript-link\":\"\",\"link-target\":\"_self\",\"tag-type\":\"div\",\"force-important\":\"false\"}");

/* INSERT TABLE DATA: rtl_lnd_eg_item_skins */
INSERT INTO `rtl_lnd_eg_item_skins` VALUES("1", "Washington", "washington", "{\"eg-item-skin-element-last-id\":\"9\",\"choose-layout\":\"even\",\"show-content\":\"bottom\",\"content-align\":\"left\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"rgba(0,0,0,0.65)\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"100\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#3f424a\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"transparent\",\"full-border-style\":\"none\",\"full-overflow-hidden\":\"false\",\"content-bg-color\":\"#ffffff\",\"content-padding\":[\"0\",\"0\",\"0\",\"0\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"double\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"#000000\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"fade\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"fade\",\"media-animation\":\"none\",\"media-animation-delay\":\"0\"}", "[{\"id\":\"0\",\"order\":\"0\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\\\"Open Sans\\\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"10\",\"0\",\"0\"],\"padding\":[\"17\",\"17\",\"17\",\"17\"],\"background-color\":\"rgba(255,255,255,0.15)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(0,0,0,0.50)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"falldown\",\"delay\":\"10\",\"link-type\":\"lightbox\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"css\":\"\",\"css-hover\":\"\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-icon\":\"eg-icon-search\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"1\",\"order\":\"1\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"10\",\"0\",\"0\"],\"padding\":[\"17\",\"17\",\"17\",\"17\"],\"background-color\":\"rgba(255,255,255,0.15)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(0,0,0,0.50)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"falldown\",\"delay\":\"20\",\"link-type\":\"post\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"css\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"css-hover\":\"\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-icon\":\"eg-icon-link\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},\"\",{\"id\":\"3\",\"order\":\"4\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"13\",\"line-height\":\"20\",\"color\":\"#ffffff\",\"font-family\":\"\\\"Open Sans\\\"\",\"font-weight\":\"700\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"15\",\"0\",\"0\",\"0\"],\"padding\":[\"5\",\"10\",\"5\",\"10\"],\"background-color\":\"rgba(255,255,255,0.15)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"flipup\",\"delay\":\"10\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"hide-on-video\":\"\",\"source-post\":\"title\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},\"\",{\"id\":\"8\",\"order\":\"2\",\"container\":\"c\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"solid\",\"shadow-color\":\"#000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"solid\",\"background-color-hover\":\"#FFF\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"#000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"9\",\"order\":\"5\",\"container\":\"c\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"solid\",\"shadow-color\":\"#000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"solid\",\"background-color-hover\":\"#FFF\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"#000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}}]", NULL);
INSERT INTO `rtl_lnd_eg_item_skins` VALUES("2", "Adams", "adams", "{\"eg-item-skin-element-last-id\":\"8\",\"choose-layout\":\"even\",\"show-content\":\"bottom\",\"content-align\":\"left\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"#89af72\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"100\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"transparent\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"transparent\",\"full-border-style\":\"none\",\"full-overflow-hidden\":\"false\",\"content-bg-color\":\"#ffffff\",\"content-padding\":[\"0\",\"0\",\"0\",\"0\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"double\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"#000000\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"10\",\"cover-animation-center\":\"flipleft\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"none\",\"media-animation\":\"turnout\",\"media-animation-delay\":\"0\"}", "[{\"id\":\"0\",\"order\":\"0\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"10\",\"0\",\"0\"],\"padding\":[\"17\",\"17\",\"17\",\"17\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"2\",\"2\",\"2\",\"2\"],\"border-radius\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#000000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"2\",\"2\",\"2\",\"2\"],\"border-radius-hover\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"slideright\",\"delay\":\"10\",\"link-type\":\"lightbox\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"css\":\".eg-adams-element-0{}\",\"css-hover\":\".eg-adams-element-0{}\",\"transition-type\":\"\",\"position\":\"relative\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"tag-type\":\"div\",\"align\":\"t_l\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"force-important\":\"true\",\"absolute-unit\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-icon\":\"eg-icon-search\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"1\",\"order\":\"1\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"10\",\"0\",\"0\"],\"padding\":[\"17\",\"17\",\"17\",\"17\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"2\",\"2\",\"2\",\"2\"],\"border-radius\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#000000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"2\",\"2\",\"2\",\"2\"],\"border-radius-hover\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"slideleft\",\"delay\":\"20\",\"link-type\":\"post\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-icon\":\"eg-icon-link\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},\"\",{\"id\":\"3\",\"order\":\"4\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"13\",\"line-height\":\"20\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"700\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"15\",\"0\",\"0\",\"0\"],\"padding\":[\"5\",\"10\",\"5\",\"10\"],\"background-color\":\"rgba(255,255,255,0.15)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"zoomfront\",\"delay\":\"20\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"transition-type\":\"\",\"css\":\".eg-adams-element-3{}\",\"position\":\"relative\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"align\":\"t_l\",\"css-hover\":\".eg-adams-element-3{}\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"force-important\":\"\",\"absolute-unit\":\"px\",\"source-post\":\"title\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},\"\",{\"id\":\"5\",\"order\":\"7\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"13\",\"line-height\":\"20\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"5\",\"10\",\"5\",\"10\"],\"background-color\":\"rgba(255,255,255,0.15)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"zoomfront\",\"delay\":\"20\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"transition-type\":\"\",\"css\":\".eg-adams-element-5{}\",\"position\":\"relative\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"tag-type\":\"div\",\"align\":\"t_l\",\"css-hover\":\".eg-adams-element-5{}\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"words\",\"limit-num\":\"6\",\"force-important\":\"\",\"absolute-unit\":\"px\",\"source-post\":\"excerpt\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"7\",\"order\":\"2\",\"container\":\"c\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"solid\",\"shadow-color\":\"#000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"solid\",\"background-color-hover\":\"#FFF\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"#000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\"}},{\"id\":\"8\",\"order\":\"5\",\"container\":\"c\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"solid\",\"shadow-color\":\"#000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"solid\",\"background-color-hover\":\"#FFF\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"#000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\"}}]", NULL);
INSERT INTO `rtl_lnd_eg_item_skins` VALUES("3", "Jefferson", "jefferson", "{\"eg-item-skin-element-last-id\":\"8\",\"choose-layout\":\"even\",\"show-content\":\"bottom\",\"content-align\":\"left\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"#e33a0c\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"100\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#ffffff\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"transparent\",\"full-border-style\":\"none\",\"full-overflow-hidden\":\"false\",\"content-bg-color\":\"#ffffff\",\"content-padding\":[\"0\",\"0\",\"0\",\"0\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"none\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"#000000\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"fliphorizontal\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"fade\",\"media-animation\":\"fliphorizontalout\",\"media-animation-delay\":\"0\"}", "[{\"id\":\"0\",\"order\":\"0\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"10\",\"0\",\"0\"],\"padding\":[\"17\",\"17\",\"17\",\"17\"],\"background-color\":\"rgba(255,255,255,0.15)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#e33a0c\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"slideup\",\"delay\":\"46\",\"link-type\":\"post\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"transition-type\":\"\",\"css\":\"\",\"position\":\"relative\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"tag-type\":\"div\",\"align\":\"t_l\",\"css-hover\":\"\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"force-important\":\"\",\"absolute-unit\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-icon\":\"eg-icon-link\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"1\",\"order\":\"1\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"17\",\"17\",\"17\",\"17\"],\"background-color\":\"rgba(255,255,255,0.15)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#e33a0c\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"slidedown\",\"delay\":\"50\",\"link-type\":\"lightbox\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-icon\":\"eg-icon-search\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},\"\",{\"id\":\"3\",\"order\":\"3\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"17\",\"line-height\":\"20\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"800\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"10\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"17\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"zoomfront\",\"delay\":\"60\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"transition-type\":\"\",\"css\":\"\",\"position\":\"relative\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"align\":\"t_l\",\"css-hover\":\"\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"force-important\":\"\",\"absolute-unit\":\"px\",\"source-post\":\"title\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},\"\",{\"id\":\"5\",\"order\":\"6\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"enable-hover\":\"on\",\"font-size\":\"12\",\"line-height\":\"20\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"1\",\"5\",\"1\",\"5\"],\"background-color\":\"rgba(255,255,255,0.15)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"3\",\"3\",\"3\",\"3\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"12\",\"line-height-hover\":\"20\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(0,0,0,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"3\",\"3\",\"3\",\"3\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"zoomfront\",\"delay\":\"70\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"transition-type\":\"\",\"css\":\"\",\"position\":\"relative\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"tag-type\":\"div\",\"align\":\"t_l\",\"css-hover\":\"\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\"&nbsp; &nbsp;\",\"limit-type\":\"words\",\"limit-num\":\"10\",\"force-important\":\"\",\"absolute-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"source-post\":\"cat_list\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"7\",\"order\":\"2\",\"container\":\"c\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"solid\",\"shadow-color\":\"#000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"solid\",\"background-color-hover\":\"#FFF\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"#000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"8\",\"order\":\"4\",\"container\":\"c\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"solid\",\"shadow-color\":\"#000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"solid\",\"background-color-hover\":\"#FFF\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"#000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}}]", NULL);
INSERT INTO `rtl_lnd_eg_item_skins` VALUES("4", "Madison", "madison", "{\"eg-item-skin-element-last-id\":\"7\",\"choose-layout\":\"even\",\"show-content\":\"bottom\",\"content-align\":\"left\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"#585c67\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"100\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#585c67\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"transparent\",\"full-border-style\":\"none\",\"full-overflow-hidden\":\"false\",\"content-bg-color\":\"#ffffff\",\"content-padding\":[\"0\",\"0\",\"0\",\"0\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"double\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"#000000\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"flipvertical\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"fade\",\"media-animation\":\"flipverticalout\",\"media-animation-delay\":\"0\"}", "[{\"id\":\"0\",\"order\":\"0\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"10\",\"0\",\"0\"],\"padding\":[\"19\",\"19\",\"19\",\"19\"],\"background-color\":\"rgba(255,255,255,0.15)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(0,0,0,0.25)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"zoomfront\",\"delay\":\"50\",\"link-type\":\"lightbox\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"transition-type\":\"\",\"css\":\"\",\"position\":\"relative\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"tag-type\":\"div\",\"align\":\"t_l\",\"css-hover\":\"\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"force-important\":\"\",\"absolute-unit\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-icon\":\"eg-icon-search\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"1\",\"order\":\"1\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"19\",\"19\",\"19\",\"19\"],\"background-color\":\"rgba(255,255,255,0.15)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(0,0,0,0.25)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"zoomfront\",\"delay\":\"35\",\"link-type\":\"post\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"transition-type\":\"\",\"css\":\"\",\"position\":\"relative\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"align\":\"t_l\",\"css-hover\":\"\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"force-important\":\"true\",\"absolute-unit\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-icon\":\"eg-icon-link\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},\"\",{\"id\":\"3\",\"order\":\"4\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"13\",\"line-height\":\"20\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"700\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"15\",\"0\",\"0\",\"0\"],\"padding\":[\"5\",\"10\",\"5\",\"10\"],\"background-color\":\"rgba(255,255,255,0.15)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"slideup\",\"delay\":\"35\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"source-post\":\"title\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},\"\",{\"id\":\"5\",\"order\":\"7\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"12\",\"line-height\":\"20\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"5\",\"10\",\"5\",\"10\"],\"background-color\":\"rgba(255,255,255,0.15)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"slidedown\",\"delay\":\"45\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"words\",\"limit-num\":\"6\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"source-post\":\"excerpt\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"6\",\"order\":\"2\",\"container\":\"c\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"solid\",\"shadow-color\":\"#000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"solid\",\"background-color-hover\":\"#FFF\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"#000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"7\",\"order\":\"5\",\"container\":\"c\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"solid\",\"shadow-color\":\"#000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"solid\",\"background-color-hover\":\"#FFF\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"#000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}}]", NULL);
INSERT INTO `rtl_lnd_eg_item_skins` VALUES("5", "Monroe", "monroe", "{\"eg-item-skin-element-last-id\":\"8\",\"choose-layout\":\"even\",\"show-content\":\"none\",\"content-align\":\"center\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"rgba(10,10,10,0.50)\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"100\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#ffffff\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"transparent\",\"full-border-style\":\"none\",\"full-overflow-hidden\":\"false\",\"content-bg-color\":\"#ffffff\",\"content-padding\":[\"0\",\"0\",\"0\",\"0\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"none\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"#000000\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"cover-animation-top-type\":\"out\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"none\",\"cover-animation-center-type\":\"out\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"fade\",\"cover-animation-bottom-type\":\"out\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"none\",\"cover-group-animation\":\"none\",\"media-animation\":\"none\",\"media-animation-delay\":\"0\"}", "[{\"id\":\"0\",\"order\":\"0\",\"container\":\"br\",\"settings\":{\"0\":\"Default\",\"source\":\"text\",\"enable-hover\":\"on\",\"font-size\":\"13\",\"line-height\":\"30\",\"color\":\"#ffffff\",\"font-family\":\"\\\"Raleway\\\"\",\"font-weight\":\"800\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"30\",\"0\"],\"padding\":[\"3\",\"15\",\"2\",\"15\"],\"background-color\":\"#89af72\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"transparent\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"3\",\"0\"],\"border-radius\":[\"3\",\"3\",\"3\",\"3\"],\"border-radius-unit\":\"px\",\"border-color\":\"#617f52\",\"border-style\":\"solid\",\"font-size-hover\":\"13\",\"line-height-hover\":\"30\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\\\"Raleway\\\"\",\"font-weight-hover\":\"800\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"#9bc184\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"transparent\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"3\",\"0\"],\"border-radius-hover\":[\"3\",\"3\",\"3\",\"3\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#617f52\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"flipup\",\"delay\":\"0\",\"link-type\":\"post\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-text\":\"Read More\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"1\",\"order\":\"0\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"16\",\"line-height\":\"24\",\"color\":\"#ffffff\",\"font-family\":\"\\\"Raleway\\\"\",\"font-weight\":\"900\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"4\",\"12\",\"3\",\"12\"],\"background-color\":\"rgba(255,255,255,0.15)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"transparent\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.20)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"flipdown\",\"delay\":\"0\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"transition-type\":\"out\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-post\":\"title\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"8\",\"order\":\"0\",\"container\":\"tl\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"enable-hover\":\"\",\"font-size\":\"17\",\"line-height\":\"24\",\"color\":\"#000000\",\"font-family\":\"\\\"Raleway\\\"\",\"font-weight\":\"800\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"position\":\"relative\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"30\",\"0\",\"0\",\"0\"],\"padding\":[\"3\",\"12\",\"4\",\"12\"],\"background-color\":\"#ffffff\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"transparent\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.20)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"slidedown\",\"transition-type\":\"\",\"delay\":\"0\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"margin-unit\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-post\":\"date\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}}]", NULL);
INSERT INTO `rtl_lnd_eg_item_skins` VALUES("6", "Quincy", "quincy", "{\"eg-item-skin-element-last-id\":\"6\",\"choose-layout\":\"even\",\"show-content\":\"bottom\",\"content-align\":\"left\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"rgba(45,48,57,0.75)\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"100\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#2d3039\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"transparent\",\"full-border-style\":\"none\",\"full-overflow-hidden\":\"false\",\"content-bg-color\":\"#ffffff\",\"content-padding\":[\"0\",\"0\",\"0\",\"0\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"double\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"#000000\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"fade\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"fade\",\"media-animation\":\"pressback\",\"media-animation-delay\":\"0\"}", "[{\"id\":\"0\",\"order\":\"0\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"24\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"10\",\"0\",\"10\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"24\",\"line-height-hover\":\"22\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"transparent\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"zoomfront\",\"delay\":\"30\",\"link-type\":\"lightbox\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"transition-type\":\"\",\"css\":\"\",\"position\":\"relative\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"tag-type\":\"div\",\"align\":\"t_l\",\"css-hover\":\"\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"force-important\":\"\",\"absolute-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-icon\":\"eg-icon-search\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"1\",\"order\":\"1\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"24\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"10\",\"0\",\"10\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"24\",\"line-height-hover\":\"22\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"transparent\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"zoomfront\",\"delay\":\"10\",\"link-type\":\"post\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"transition-type\":\"\",\"css\":\"\",\"position\":\"relative\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"align\":\"t_l\",\"css-hover\":\"\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"force-important\":\"\",\"absolute-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-icon\":\"eg-icon-link\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},\"\",{\"id\":\"3\",\"order\":\"4\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"13\",\"line-height\":\"20\",\"color\":\"#ffffff\",\"font-family\":\"\\\"Raleway\\\"\",\"font-weight\":\"800\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"15\",\"0\",\"0\",\"0\"],\"padding\":[\"5\",\"10\",\"5\",\"10\"],\"background-color\":\"rgba(255,255,255,0.15)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"slideup\",\"delay\":\"10\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"source-post\":\"title\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},\"\",{\"id\":\"5\",\"order\":\"2\",\"container\":\"c\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"solid\",\"shadow-color\":\"#000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"solid\",\"background-color-hover\":\"#FFF\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"#000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"6\",\"order\":\"5\",\"container\":\"c\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"solid\",\"shadow-color\":\"#000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"solid\",\"background-color-hover\":\"#FFF\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"#000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}}]", NULL);
INSERT INTO `rtl_lnd_eg_item_skins` VALUES("7", "Jackson", "jackson", "{\"eg-item-skin-element-last-id\":\"7\",\"choose-layout\":\"even\",\"show-content\":\"none\",\"content-align\":\"center\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"#ffffff\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"100\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#eeeeee\",\"full-padding\":[\"5\",\"5\",\"5\",\"5\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"transparent\",\"full-border-style\":\"none\",\"full-overflow-hidden\":\"false\",\"content-bg-color\":\"#ffffff\",\"content-padding\":[\"0\",\"0\",\"0\",\"0\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"none\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"#000000\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"zoomback\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"none\",\"media-animation\":\"none\",\"media-animation-delay\":\"0\"}", "[{\"id\":\"0\",\"order\":\"0\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#000000\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"10\",\"0\",\"0\"],\"padding\":[\"17\",\"17\",\"17\",\"17\"],\"background-color\":\"#f5f5f5\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#000000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"#eeeeee\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"zoomback\",\"delay\":\"5\",\"link-type\":\"lightbox\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"transition-type\":\"\",\"css\":\".eg-jackson-element-0{}\",\"position\":\"relative\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"tag-type\":\"div\",\"align\":\"t_l\",\"css-hover\":\".eg-jackson-element-0{}\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"force-important\":\"\",\"absolute-unit\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-icon\":\"eg-icon-search\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"1\",\"order\":\"1\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#000000\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"17\",\"17\",\"17\",\"17\"],\"background-color\":\"#f5f5f5\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#000000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"#eeeeee\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"zoomback\",\"delay\":\"10\",\"link-type\":\"post\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"transition-type\":\"\",\"css\":\"\",\"position\":\"relative\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"tag-type\":\"div\",\"align\":\"t_l\",\"css-hover\":\"\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"force-important\":\"\",\"absolute-unit\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-icon\":\"eg-icon-link\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},\"\",{\"id\":\"3\",\"order\":\"4\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"18\",\"line-height\":\"20\",\"color\":\"#000000\",\"font-family\":\"\\\"Raleway\\\"\",\"font-weight\":\"800\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"15\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"rgba(255,255,255,0.15)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"18\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"skewright\",\"delay\":\"15\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"source-post\":\"title\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},\"\",{\"id\":\"5\",\"order\":\"7\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"enable-hover\":\"on\",\"font-size\":\"12\",\"line-height\":\"20\",\"color\":\"#888888\",\"font-family\":\"\\\"Raleway\\\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"12\",\"line-height-hover\":\"20\",\"color-hover\":\"#000000\",\"font-family-hover\":\"\\\"Raleway\\\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"transparent\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"skewleft\",\"delay\":\"10\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\", \",\"limit-type\":\"none\",\"limit-num\":\"10\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"source-post\":\"cat_list\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"6\",\"order\":\"2\",\"container\":\"c\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"solid\",\"shadow-color\":\"#000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"solid\",\"background-color-hover\":\"#FFF\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"#000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\"}},{\"id\":\"7\",\"order\":\"5\",\"container\":\"c\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"solid\",\"shadow-color\":\"#000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"solid\",\"background-color-hover\":\"#FFF\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"#000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\"}}]", NULL);
INSERT INTO `rtl_lnd_eg_item_skins` VALUES("8", "VanBuren", "vanburen", "{\"eg-item-skin-element-last-id\":\"3\",\"choose-layout\":\"even\",\"show-content\":\"bottom\",\"content-align\":\"left\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"rgba(10,6,6,0.85)\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"100\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#363839\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"transparent\",\"full-border-style\":\"none\",\"full-overflow-hidden\":\"false\",\"content-bg-color\":\"#ffffff\",\"content-padding\":[\"0\",\"0\",\"0\",\"0\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"none\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"#000000\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"flipup\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"fade\",\"media-animation\":\"none\",\"media-animation-delay\":\"0\"}", "[{\"id\":\"0\",\"order\":\"0\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"17\",\"line-height\":\"20\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"800\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"15\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"20\",\"0\",\"20\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"flyleft\",\"delay\":\"5\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"transition-type\":\"\",\"css\":\"\",\"position\":\"relative\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"tag-type\":\"div\",\"align\":\"t_l\",\"css-hover\":\"\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"force-important\":\"\",\"absolute-unit\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-post\":\"title\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},\"\",{\"id\":\"2\",\"order\":\"3\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"13\",\"line-height\":\"20\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"flyright\",\"delay\":\"0\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"transition-type\":\"\",\"css\":\"\",\"position\":\"relative\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"tag-type\":\"div\",\"align\":\"t_l\",\"css-hover\":\"\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"force-important\":\"\",\"absolute-unit\":\"px\",\"source-post\":\"date\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"3\",\"order\":\"1\",\"container\":\"c\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"solid\",\"shadow-color\":\"#000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"solid\",\"background-color-hover\":\"#FFF\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"#000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}}]", NULL);
INSERT INTO `rtl_lnd_eg_item_skins` VALUES("9", "HenryHarrison", "henryharrison", "{\"eg-item-skin-element-last-id\":\"5\",\"choose-layout\":\"even\",\"show-content\":\"bottom\",\"content-align\":\"left\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"rgba(49,165,203,0.85)\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"100\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#ffffff\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"transparent\",\"full-border-style\":\"none\",\"full-overflow-hidden\":\"false\",\"content-bg-color\":\"#ffffff\",\"content-padding\":[\"0\",\"0\",\"0\",\"0\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"double\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"#000000\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"fade\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"fade\",\"media-animation\":\"none\",\"media-animation-delay\":\"0\"}", "[{\"id\":\"1\",\"order\":\"0\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"16\",\"line-height\":\"30\",\"color\":\"#ffffff\",\"font-family\":\"\\\"Raleway\\\"\",\"font-weight\":\"900\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"10\",\"0\"],\"padding\":[\"0\",\"20\",\"0\",\"20\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"transparent\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"transparent\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"flipup\",\"delay\":\"5\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"transition-type\":\"\",\"css\":\"\",\"position\":\"relative\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"tag-type\":\"div\",\"align\":\"t_l\",\"css-hover\":\"\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"force-important\":\"\",\"absolute-unit\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-post\":\"title\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},\"\",{\"id\":\"2\",\"order\":\"3\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"20\",\"line-height\":\"27\",\"color\":\"#ffffff\",\"font-family\":\"\\\"Raleway\\\"\",\"font-weight\":\"800\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"17\",\"17\",\"17\",\"17\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"2\",\"2\",\"2\",\"2\"],\"border-radius\":[\"0\",\"60\",\"60\",\"60\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"20\",\"line-height-hover\":\"27\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(0,0,0,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"normal\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"2\",\"2\",\"2\",\"2\"],\"border-radius-hover\":[\"60\",\"60\",\"0\",\"60\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"rotatescale\",\"delay\":\"5\",\"link-type\":\"post\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"transition-type\":\"\",\"css\":\"\",\"position\":\"relative\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"tag-type\":\"div\",\"align\":\"t_l\",\"css-hover\":\"\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"force-important\":\"\",\"absolute-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-icon\":\"eg-icon-plus\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},\"\",{\"id\":\"5\",\"order\":\"1\",\"container\":\"c\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"solid\",\"shadow-color\":\"#000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"solid\",\"background-color-hover\":\"#FFF\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"#000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}}]", NULL);
INSERT INTO `rtl_lnd_eg_item_skins` VALUES("10", "Tyler", "tyler", "{\"eg-item-skin-element-last-id\":\"8\",\"choose-layout\":\"even\",\"show-content\":\"bottom\",\"content-align\":\"left\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"rgba(54,56,57,0.85)\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"100\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#ffffff\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"transparent\",\"full-border-style\":\"none\",\"full-overflow-hidden\":\"false\",\"content-bg-color\":\"#ffffff\",\"content-padding\":[\"0\",\"0\",\"0\",\"0\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"double\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"#000000\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"fade\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"fade\",\"media-animation\":\"none\",\"media-animation-delay\":\"0\"}", "[{\"id\":\"0\",\"order\":\"0\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"10\",\"0\",\"0\"],\"padding\":[\"17\",\"17\",\"17\",\"17\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"2\",\"2\",\"2\",\"2\"],\"border-radius\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#000000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"2\",\"2\",\"2\",\"2\"],\"border-radius-hover\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"falldown\",\"delay\":\"20\",\"link-type\":\"lightbox\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-icon\":\"eg-icon-search\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"1\",\"order\":\"1\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"17\",\"17\",\"17\",\"17\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"2\",\"2\",\"2\",\"2\"],\"border-radius\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#000000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"2\",\"2\",\"2\",\"2\"],\"border-radius-hover\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"falldown\",\"delay\":\"30\",\"link-type\":\"post\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-icon\":\"eg-icon-unlink\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},\"\",{\"id\":\"3\",\"order\":\"4\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"13\",\"line-height\":\"20\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"700\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"10\",\"0\",\"0\",\"0\"],\"padding\":[\"5\",\"10\",\"5\",\"10\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"slideleft\",\"delay\":\"30\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"source-post\":\"title\",\"transition-type\":\"\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},\"\",{\"id\":\"5\",\"order\":\"7\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"13\",\"line-height\":\"20\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"300\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"5\",\"10\",\"5\",\"10\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"slideright\",\"delay\":\"34\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"source-post\":\"excerpt\",\"transition-type\":\"\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"7\",\"order\":\"2\",\"container\":\"c\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"solid\",\"shadow-color\":\"#000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"solid\",\"background-color-hover\":\"#FFF\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"#000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"8\",\"order\":\"5\",\"container\":\"c\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"solid\",\"shadow-color\":\"#000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"solid\",\"background-color-hover\":\"#FFF\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"#000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}}]", NULL);
INSERT INTO `rtl_lnd_eg_item_skins` VALUES("11", "Polk", "polk", "{\"eg-item-skin-element-last-id\":\"6\",\"choose-layout\":\"even\",\"show-content\":\"bottom\",\"content-align\":\"left\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"rgba(54,56,57,0.85)\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"100\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#ffffff\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"transparent\",\"full-border-style\":\"none\",\"content-bg-color\":\"#ffffff\",\"content-padding\":[\"0\",\"0\",\"0\",\"0\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"double\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"#000000\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"fade\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"fade\",\"media-animation\":\"none\",\"media-animation-delay\":\"0\"}", "[{\"id\":\"0\",\"order\":\"0\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"10\",\"0\",\"0\"],\"padding\":[\"17\",\"17\",\"17\",\"17\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"2\",\"2\",\"2\",\"2\"],\"border-radius\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#000000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.95)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"2\",\"2\",\"2\",\"2\"],\"border-radius-hover\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"rotatescale\",\"delay\":\"20\",\"link-type\":\"lightbox\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"source-icon\":\"eg-icon-search\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"1\",\"order\":\"1\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"17\",\"17\",\"17\",\"17\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"2\",\"2\",\"2\",\"2\"],\"border-radius\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#000000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"2\",\"2\",\"2\",\"2\"],\"border-radius-hover\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"rotatescale\",\"delay\":\"30\",\"link-type\":\"post\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"source-icon\":\"eg-icon-unlink\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"2\",\"order\":\"3\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"13\",\"line-height\":\"19\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"700\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"10\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"flipdown\",\"delay\":\"46\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"source-post\":\"title\",\"transition-type\":\"\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"3\",\"order\":\"5\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"13\",\"line-height\":\"20\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"300\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"flipdown\",\"delay\":\"57\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"source-post\":\"excerpt\",\"transition-type\":\"\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}}]", NULL);
INSERT INTO `rtl_lnd_eg_item_skins` VALUES("12", "Taylor", "taylor", "{\"eg-item-skin-element-last-id\":\"6\",\"choose-layout\":\"even\",\"show-content\":\"bottom\",\"content-align\":\"left\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"rgba(54,56,57,0.85)\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"100\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#ffffff\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"transparent\",\"full-border-style\":\"none\",\"content-bg-color\":\"#ffffff\",\"content-padding\":[\"0\",\"0\",\"0\",\"0\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"double\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"#000000\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"fade\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"flipdown\",\"media-animation\":\"none\",\"media-animation-delay\":\"0\"}", "[{\"id\":\"0\",\"order\":\"0\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"10\",\"0\",\"0\"],\"padding\":[\"17\",\"17\",\"17\",\"17\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"2\",\"2\",\"2\",\"2\"],\"border-radius\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#000000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"2\",\"2\",\"2\",\"2\"],\"border-radius-hover\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"0\",\"link-type\":\"lightbox\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"source-icon\":\"eg-icon-search\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"1\",\"order\":\"1\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"17\",\"17\",\"17\",\"17\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"2\",\"2\",\"2\",\"2\"],\"border-radius\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#000000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"2\",\"2\",\"2\",\"2\"],\"border-radius-hover\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"0\",\"link-type\":\"post\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"source-icon\":\"eg-icon-unlink\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"2\",\"order\":\"2\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"13\",\"line-height\":\"19\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"700\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"20\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"0\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"source-post\":\"title\",\"transition-type\":\"\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"3\",\"order\":\"3\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"13\",\"line-height\":\"20\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"300\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"5\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"0\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"source-post\":\"excerpt\",\"transition-type\":\"\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}}]", NULL);
INSERT INTO `rtl_lnd_eg_item_skins` VALUES("13", "Fillmore", "fillmore", "{\"eg-item-skin-element-last-id\":\"7\",\"choose-layout\":\"even\",\"show-content\":\"bottom\",\"content-align\":\"left\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"rgba(54,56,57,0.85)\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"100\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#ffffff\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"transparent\",\"full-border-style\":\"none\",\"content-bg-color\":\"#ffffff\",\"content-padding\":[\"0\",\"0\",\"0\",\"0\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"double\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"#000000\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"fade\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"none\",\"media-animation\":\"none\",\"media-animation-delay\":\"0\"}", "[{\"id\":\"0\",\"order\":\"0\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"10\",\"0\",\"0\"],\"padding\":[\"17\",\"17\",\"17\",\"17\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"2\",\"2\",\"2\",\"2\"],\"border-radius\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#363839\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"2\",\"2\",\"2\",\"2\"],\"border-radius-hover\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"fade\",\"delay\":\"0\",\"link-type\":\"lightbox\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"transition-type\":\"\",\"css\":\".eg-fillmore-element-0{cursor:pointer}\",\"position\":\"relative\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"tag-type\":\"div\",\"align\":\"t_l\",\"css-hover\":\".eg-fillmore-element-0{cursor:pointer}\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"force-important\":\"\",\"absolute-unit\":\"px\",\"source-icon\":\"eg-icon-search\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"1\",\"order\":\"0\",\"container\":\"br\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"13\",\"line-height\":\"20\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"700\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"5\",\"10\",\"5\",\"10\"],\"background-color\":\"rgba(255,255,255,0.15)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"slidedown\",\"delay\":\"13\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"transition-type\":\"out\",\"tag-type\":\"div\",\"align\":\"c_c\",\"margin-unit\":\"px\",\"source-post\":\"date\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"2\",\"order\":\"1\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"17\",\"17\",\"17\",\"17\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"2\",\"2\",\"2\",\"2\"],\"border-radius\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#363839\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"2\",\"2\",\"2\",\"2\"],\"border-radius-hover\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"fade\",\"delay\":\"0\",\"link-type\":\"post\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"transition-type\":\"\",\"css\":\".eg-fillmore-element-1{ cursor:pointer}\",\"position\":\"relative\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"tag-type\":\"div\",\"align\":\"t_l\",\"css-hover\":\".eg-fillmore-element-1{cursor:pointer}\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"force-important\":\"\",\"absolute-unit\":\"px\",\"source-icon\":\"eg-icon-unlink\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"3\",\"order\":\"2\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"13\",\"line-height\":\"19\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"700\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"20\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"fade\",\"delay\":\"0\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"source-post\":\"title\",\"transition-type\":\"\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"4\",\"order\":\"3\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"13\",\"line-height\":\"20\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"300\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"5\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"fade\",\"delay\":\"0\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"source-post\":\"excerpt\",\"transition-type\":\"\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}}]", NULL);
INSERT INTO `rtl_lnd_eg_item_skins` VALUES("14", "Pierce", "pierce", "{\"eg-item-skin-element-last-id\":\"6\",\"choose-layout\":\"even\",\"show-content\":\"bottom\",\"content-align\":\"left\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"rgba(54,56,57,0.85)\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"100\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#ffffff\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"transparent\",\"full-border-style\":\"none\",\"content-bg-color\":\"#ffffff\",\"content-padding\":[\"0\",\"0\",\"0\",\"0\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"double\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"#000000\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"none\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"fade\",\"media-animation\":\"none\",\"media-animation-delay\":\"0\"}", "[{\"id\":\"0\",\"order\":\"0\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"10\",\"0\",\"0\"],\"padding\":[\"17\",\"17\",\"17\",\"17\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"2\",\"2\",\"2\",\"2\"],\"border-radius\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#000000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"2\",\"2\",\"2\",\"2\"],\"border-radius-hover\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"zoomback\",\"delay\":\"20\",\"link-type\":\"lightbox\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"transition-type\":\"\",\"css\":\".eg-pierce-element-0{}\",\"position\":\"relative\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"tag-type\":\"div\",\"align\":\"t_l\",\"css-hover\":\".eg-pierce-element-0{}\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"force-important\":\"\",\"absolute-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"source-icon\":\"eg-icon-search\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"1\",\"order\":\"1\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"17\",\"17\",\"17\",\"17\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"2\",\"2\",\"2\",\"2\"],\"border-radius\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#000000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"2\",\"2\",\"2\",\"2\"],\"border-radius-hover\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"zoomfront\",\"delay\":\"30\",\"link-type\":\"post\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"transition-type\":\"\",\"css\":\".eg-pierce-element-1{}\",\"position\":\"relative\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"tag-type\":\"div\",\"align\":\"t_l\",\"css-hover\":\".eg-pierce-element-1{}\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"force-important\":\"\",\"absolute-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"source-icon\":\"eg-icon-unlink\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"2\",\"order\":\"2\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"13\",\"line-height\":\"19\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"700\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"20\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"falldown\",\"delay\":\"30\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"source-post\":\"title\",\"transition-type\":\"\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"3\",\"order\":\"3\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"13\",\"line-height\":\"20\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"300\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"5\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"slideup\",\"delay\":\"20\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"transition-type\":\"\",\"css\":\"\",\"position\":\"relative\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"source-post\":\"excerpt\",\"tag-type\":\"div\",\"align\":\"c_c\",\"css-hover\":\"\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}}]", NULL);
INSERT INTO `rtl_lnd_eg_item_skins` VALUES("15", "Buchanan", "buchanan", "{\"eg-item-skin-element-last-id\":\"6\",\"choose-layout\":\"even\",\"show-content\":\"bottom\",\"content-align\":\"left\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"rgba(54,56,57,0.85)\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"100\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#ffffff\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"transparent\",\"full-border-style\":\"none\",\"content-bg-color\":\"#ffffff\",\"content-padding\":[\"0\",\"0\",\"0\",\"0\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"double\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"#000000\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"slidedown\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"fade\",\"media-animation\":\"none\",\"media-animation-delay\":\"0\"}", "[{\"id\":\"0\",\"order\":\"0\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"10\",\"0\",\"0\"],\"padding\":[\"17\",\"17\",\"17\",\"17\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"2\",\"2\",\"2\",\"2\"],\"border-radius\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#000000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"2\",\"2\",\"2\",\"2\"],\"border-radius-hover\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"rollright\",\"delay\":\"20\",\"link-type\":\"lightbox\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"source-icon\":\"eg-icon-search\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"1\",\"order\":\"1\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"17\",\"17\",\"17\",\"17\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"2\",\"2\",\"2\",\"2\"],\"border-radius\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#000000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"2\",\"2\",\"2\",\"2\"],\"border-radius-hover\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"rollleft\",\"delay\":\"30\",\"link-type\":\"post\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"source-icon\":\"eg-icon-link\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"2\",\"order\":\"2\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"13\",\"line-height\":\"19\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"700\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"20\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"slidedown\",\"delay\":\"21\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"source-post\":\"title\",\"transition-type\":\"\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"3\",\"order\":\"3\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"13\",\"line-height\":\"20\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"300\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"5\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"slideup\",\"delay\":\"40\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"source-post\":\"excerpt\",\"transition-type\":\"\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}}]", NULL);
INSERT INTO `rtl_lnd_eg_item_skins` VALUES("16", "Lincoln", "lincoln", "{\"eg-item-skin-element-last-id\":\"14\",\"choose-layout\":\"even\",\"show-content\":\"bottom\",\"content-align\":\"left\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"rgba(54,56,57,0.85)\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"100\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#ffffff\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"transparent\",\"full-border-style\":\"none\",\"content-bg-color\":\"#ffffff\",\"content-padding\":[\"0\",\"0\",\"0\",\"0\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"double\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"#000000\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"10\",\"cover-animation-center\":\"fade\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"fade\",\"media-animation\":\"turnout\",\"media-animation-delay\":\"0\"}", "[{\"id\":\"0\",\"order\":\"0\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"13\",\"line-height\":\"20\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"700\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"5\",\"10\",\"5\",\"10\"],\"background-color\":\"rgba(255,255,255,0.15)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"flipup\",\"delay\":\"10\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"source-post\":\"title\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"1\",\"order\":\"0\",\"container\":\"br\",\"settings\":{\"0\":\"\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"left\",\"clear\":\"none\",\"margin\":[\"0\",\"1\",\"0\",\"0\"],\"padding\":[\"13\",\"13\",\"13\",\"13\"],\"background-color\":\"rgba(255,255,255,0.15)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"css\":\"\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(0,0,0,0.25)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"rollleft\",\"delay\":\"30\",\"link-type\":\"post\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"margin-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"source-icon\":\"eg-icon-link\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"2\",\"order\":\"1\",\"container\":\"br\",\"settings\":{\"0\":\"\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"left\",\"clear\":\"none\",\"margin\":[\"0\",\"1\",\"0\",\"0\"],\"padding\":[\"13\",\"13\",\"13\",\"13\"],\"background-color\":\"rgba(255,255,255,0.15)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"css\":\"\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(0,0,0,0.25)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"rollleft\",\"delay\":\"30\",\"link-type\":\"lightbox\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"margin-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"source-icon\":\"eg-icon-link-ext\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"3\",\"order\":\"2\",\"container\":\"br\",\"settings\":{\"0\":\"\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"left\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"13\",\"13\",\"13\",\"13\"],\"background-color\":\"rgba(255,255,255,0.15)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"css\":\"\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(0,0,0,0.25)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"rollleft\",\"delay\":\"30\",\"link-type\":\"url\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"margin-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"source-icon\":\"eg-icon-mail\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}}]", NULL);
INSERT INTO `rtl_lnd_eg_item_skins` VALUES("17", "Johnson", "johnson", "{\"eg-item-skin-element-last-id\":\"12\",\"choose-layout\":\"even\",\"show-content\":\"bottom\",\"content-align\":\"left\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"rgba(0,142,133,0.85)\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"100\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#ffffff\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"transparent\",\"full-border-style\":\"none\",\"full-overflow-hidden\":\"false\",\"content-bg-color\":\"#ffffff\",\"content-padding\":[\"0\",\"0\",\"0\",\"0\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"double\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"#000000\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"10\",\"cover-animation-center\":\"covergrowup\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"none\",\"media-animation\":\"none\",\"media-animation-delay\":\"0\"}", "[{\"id\":\"0\",\"order\":\"0\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"16\",\"line-height\":\"20\",\"color\":\"#ffffff\",\"font-family\":\"\\\"Raleway\\\"\",\"font-weight\":\"800\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"40\",\"0\",\"40\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"flipup\",\"delay\":\"10\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"css\":\".eg-johnson-element-0{}\",\"css-hover\":\".eg-johnson-element-0{}\",\"tag-type\":\"div\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-post\":\"title\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"1\",\"order\":\"0\",\"container\":\"br\",\"settings\":{\"0\":\"\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"1\",\"0\"],\"padding\":[\"13\",\"13\",\"13\",\"13\"],\"background-color\":\"rgba(255,255,255,0.15)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(0,0,0,0.25)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"slideup\",\"delay\":\"30\",\"link-type\":\"lightbox\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"css\":\".eg-johnson-element-1{}\",\"css-hover\":\".eg-johnson-element-1{}\",\"tag-type\":\"div\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-icon\":\"eg-icon-search\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},\"\",{\"id\":\"3\",\"order\":\"1\",\"container\":\"br\",\"settings\":{\"0\":\"\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"1\",\"0\"],\"padding\":[\"13\",\"13\",\"13\",\"13\"],\"background-color\":\"rgba(255,255,255,0.15)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(0,0,0,0.25)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"slideup\",\"delay\":\"20\",\"link-type\":\"embedded_video\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"css\":\".eg-johnson-element-3{}\",\"css-hover\":\".eg-johnson-element-3{}\",\"tag-type\":\"div\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-icon\":\"eg-icon-videocam\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"4\",\"order\":\"2\",\"container\":\"br\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"1\",\"0\"],\"padding\":[\"13\",\"13\",\"13\",\"13\"],\"background-color\":\"rgba(255,255,255,0.15)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(0,0,0,0.25)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"slideup\",\"delay\":\"10\",\"link-type\":\"post\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"css\":\"\",\"css-hover\":\"\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-icon\":\"eg-icon-link\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"5\",\"order\":\"2\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"13\",\"line-height\":\"20\",\"color\":\"#ffffff\",\"font-family\":\"\\\"Raleway\\\"\",\"font-weight\":\"700\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"flipup\",\"delay\":\"34\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\", \",\"limit-type\":\"none\",\"limit-num\":\"10\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"source-post\":\"cat_list\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"12\",\"order\":\"1\",\"container\":\"c\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"solid\",\"shadow-color\":\"#000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"solid\",\"background-color-hover\":\"#FFF\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"#000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\"}}]", NULL);
INSERT INTO `rtl_lnd_eg_item_skins` VALUES("18", "Grant", "grant", "{\"eg-item-skin-element-last-id\":\"22\",\"choose-layout\":\"masonry\",\"show-content\":\"bottom\",\"content-align\":\"left\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"rgba(54,56,57,0.85)\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"100\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#ffffff\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"transparent\",\"full-border-style\":\"none\",\"full-overflow-hidden\":\"false\",\"content-bg-color\":\"#ffffff\",\"content-padding\":[\"30\",\"30\",\"30\",\"30\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"double\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"rgba(0,0,0,0.20)\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"1\",\"2\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"fade\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"fade\",\"media-animation\":\"none\",\"media-animation-delay\":\"0\"}", "[{\"id\":\"0\",\"order\":\"0\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"20\",\"line-height\":\"25\",\"color\":\"#363839\",\"font-family\":\"\",\"font-weight\":\"600\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"display\":\"block\",\"text-align\":\"left\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"20\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"#ffffff\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\".eg-grant-element-0{}\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\".eg-grant-element-0{}\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"30\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"tag-type\":\"div\",\"align\":\"t_l\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"force-important\":\"\",\"absolute-unit\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-post\":\"title\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"1\",\"order\":\"0\",\"container\":\"br\",\"settings\":{\"0\":\"\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"left\",\"clear\":\"right\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"13\",\"13\",\"13\",\"13\"],\"background-color\":\"rgba(0,0,0,0.15)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"css\":\"\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(0,0,0,0.40)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"rollleft\",\"delay\":\"30\",\"link-type\":\"post\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-icon\":\"eg-icon-link-ext\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"2\",\"order\":\"0\",\"container\":\"c\",\"settings\":{\"0\":\"\",\"source\":\"text\",\"enable-hover\":\"\",\"font-size\":\"13\",\"line-height\":\"20\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"600\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"5\",\"10\",\"5\",\"10\"],\"background-color\":\"rgba(0,0,0,0.15)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"flipup\",\"delay\":\"10\",\"link-type\":\"post\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"source-text\":\"READ MORE\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"3\",\"order\":\"1\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"12\",\"line-height\":\"14\",\"color\":\"#aaaaaa\",\"font-family\":\"\",\"font-weight\":\"300\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"left\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"10\",\"0\",\"0\"],\"background-color\":\"#ffffff\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"css\":\"\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"34\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"hide-on-video\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-post\":\"date\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},\"\",\"\",{\"id\":\"6\",\"order\":\"3\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"13\",\"line-height\":\"22\",\"color\":\"#777777\",\"font-family\":\"\",\"font-weight\":\"300\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"display\":\"block\",\"text-align\":\"left\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"15\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"#ffffff\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"34\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-post\":\"excerpt\",\"transition-type\":\"\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"22\",\"order\":\"2\",\"container\":\"m\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"solid\",\"shadow-color\":\"#000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"solid\",\"background-color-hover\":\"#FFF\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"#000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}}]", NULL);
INSERT INTO `rtl_lnd_eg_item_skins` VALUES("19", "Hayes", "hayes", "{\"eg-item-skin-element-last-id\":\"23\",\"choose-layout\":\"masonry\",\"show-content\":\"bottom\",\"content-align\":\"left\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"rgba(54,56,57,0.85)\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"100\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#ffffff\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"transparent\",\"full-border-style\":\"none\",\"full-overflow-hidden\":\"false\",\"content-bg-color\":\"#ffffff\",\"content-padding\":[\"30\",\"30\",\"30\",\"30\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"double\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"rgba(0,0,0,0.20)\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"1\",\"2\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"fade\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"fade\",\"media-animation\":\"none\",\"media-animation-delay\":\"0\"}", "[{\"id\":\"0\",\"order\":\"0\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"20\",\"line-height\":\"25\",\"color\":\"#363839\",\"font-family\":\"\",\"font-weight\":\"600\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"display\":\"block\",\"text-align\":\"left\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"20\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"#ffffff\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"30\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"hide-on-video\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-post\":\"title\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"1\",\"order\":\"1\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"12\",\"line-height\":\"14\",\"color\":\"#aaaaaa\",\"font-family\":\"\",\"font-weight\":\"300\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"left\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"10\",\"0\",\"0\"],\"background-color\":\"#ffffff\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"1\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#aaaaaa\",\"border-style\":\"solid\",\"css\":\"\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"34\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"hide-on-video\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-post\":\"date\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"2\",\"order\":\"2\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"12\",\"line-height\":\"14\",\"color\":\"#aaaaaa\",\"font-family\":\"\",\"font-weight\":\"300\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"left\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"10\"],\"padding\":[\"0\",\"10\",\"0\",\"0\"],\"background-color\":\"#ffffff\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#aaaaaa\",\"border-style\":\"solid\",\"css\":\"\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"34\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"hide-on-video\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-post\":\"cat_list\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}}]", NULL);
INSERT INTO `rtl_lnd_eg_item_skins` VALUES("20", "Garfield", "garfield", "{\"eg-item-skin-element-last-id\":\"22\",\"choose-layout\":\"masonry\",\"show-content\":\"top\",\"content-align\":\"left\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"rgba(0,0,0,0.75)\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"100\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"transparent\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"transparent\",\"full-border-style\":\"none\",\"full-overflow-hidden\":\"false\",\"content-bg-color\":\"#ffffff\",\"content-padding\":[\"30\",\"30\",\"30\",\"30\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"double\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"rgba(0,0,0,0.20)\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"-1\",\"2\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"fade\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"fade\",\"media-animation\":\"none\",\"media-animation-delay\":\"0\"}", "[{\"id\":\"0\",\"order\":\"0\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"20\",\"line-height\":\"25\",\"color\":\"#363839\",\"font-family\":\"\\\"Raleway\\\"\",\"font-weight\":\"700\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"display\":\"block\",\"text-align\":\"left\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"20\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"#ffffff\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"30\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-post\":\"title\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"1\",\"order\":\"0\",\"container\":\"br\",\"settings\":{\"0\":\"\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"left\",\"clear\":\"right\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"13\",\"13\",\"13\",\"13\"],\"background-color\":\"rgba(0,0,0,0.25)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"css\":\"\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"#000000\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"rollleft\",\"delay\":\"30\",\"link-type\":\"post\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-icon\":\"eg-icon-link-ext\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"2\",\"order\":\"0\",\"container\":\"c\",\"settings\":{\"0\":\"\",\"source\":\"text\",\"enable-hover\":\"on\",\"font-size\":\"12\",\"line-height\":\"20\",\"color\":\"#ffffff\",\"font-family\":\"\\\"Raleway\\\"\",\"font-weight\":\"800\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"5\",\"10\",\"5\",\"10\"],\"background-color\":\"rgba(0,0,0,0.25)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"20\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\\\"Raleway\\\"\",\"font-weight-hover\":\"800\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"#000000\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"flipup\",\"delay\":\"10\",\"link-type\":\"post\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-text\":\"READ MORE\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"3\",\"order\":\"1\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"12\",\"line-height\":\"16\",\"color\":\"#777777\",\"font-family\":\"\\\"Raleway\\\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"left\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"10\",\"0\",\"0\"],\"background-color\":\"#ffffff\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"1\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#e5e5e5\",\"border-style\":\"solid\",\"css\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"16\",\"color-hover\":\"#000000\",\"font-family-hover\":\"\\\"Raleway\\\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"capitalize\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"1\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#e5e5e5\",\"border-style-hover\":\"solid\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"34\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"source-post\":\"date\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"4\",\"order\":\"2\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"on\",\"font-size\":\"12\",\"line-height\":\"16\",\"color\":\"#777\",\"font-family\":\"\\\"Raleway\\\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"left\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"10\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"#ffffff\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"16\",\"color-hover\":\"#000000\",\"font-family-hover\":\"\\\"Raleway\\\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"capitalize\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"34\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\", \",\"limit-type\":\"none\",\"limit-num\":\"10\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"source-post\":\"cat_list\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"22\",\"order\":\"4\",\"container\":\"m\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"solid\",\"shadow-color\":\"#000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"solid\",\"background-color-hover\":\"#FFF\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"#000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"6\",\"order\":\"5\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"13\",\"line-height\":\"22\",\"color\":\"#333333\",\"font-family\":\"\\\"Raleway\\\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"display\":\"block\",\"text-align\":\"left\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"15\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"#ffffff\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"34\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"words\",\"limit-num\":\"15\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"source-post\":\"excerpt\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}}]", NULL);
INSERT INTO `rtl_lnd_eg_item_skins` VALUES("21", "Arthur", "arthur", "{\"eg-item-skin-element-last-id\":\"31\",\"choose-layout\":\"masonry\",\"show-content\":\"top\",\"content-align\":\"center\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"rgba(137,175,114,0.75)\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"100\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#ffffff\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"1\",\"1\",\"1\",\"1\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"#e5e5e5\",\"full-border-style\":\"solid\",\"full-overflow-hidden\":\"false\",\"content-bg-color\":\"#f5f5f5\",\"content-padding\":[\"30\",\"30\",\"25\",\"30\"],\"content-border\":[\"0\",\"0\",\"1\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"#e5e5e5\",\"content-border-style\":\"solid\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"rgba(0,0,0,0.20)\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"-1\",\"2\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"fade\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"fade\",\"media-animation\":\"none\",\"media-animation-delay\":\"0\"}", "[{\"id\":\"0\",\"order\":\"0\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"17\",\"line-height\":\"22\",\"color\":\"#000000\",\"font-family\":\"\\\"Raleway\\\"\",\"font-weight\":\"700\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"30\",\"link-type\":\"post\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"20\",\"hide-on-video\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-post\":\"title\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"28\",\"order\":\"0\",\"container\":\"c\",\"settings\":{\"0\":\"\",\"source\":\"woocommerce\",\"enable-hover\":\"on\",\"font-size\":\"13\",\"line-height\":\"20\",\"color\":\"#ffffff\",\"font-family\":\"\\\"Raleway\\\"\",\"font-weight\":\"800\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"5\",\"10\",\"4\",\"10\"],\"background-color\":\"rgba(0,0,0,0.15)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-size-x\":\"100\",\"background-size-y\":\"100\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"13\",\"line-height-hover\":\"20\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\\\"Raleway\\\"\",\"font-weight-hover\":\"800\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"flipup\",\"delay\":\"10\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"hide-on-video\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"margin-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"source-woocommerce\":\"wc_add_to_cart_button\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"25\",\"order\":\"1\",\"container\":\"m\",\"settings\":{\"0\":\"Default\",\"source\":\"woocommerce\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"enable-hover\":\"\",\"font-size\":\"17\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\\\"Open Sans\\\"\",\"font-weight\":\"700\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"position\":\"relative\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"10\",\"0\",\"0\",\"0\"],\"padding\":[\"2\",\"7\",\"1\",\"7\"],\"background-color\":\"#e33a0c\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"slideleft\",\"transition-type\":\"\",\"split\":\"full\",\"delay\":\"30\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-separate\":\",\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"margin-unit\":\"px\",\"source-woocommerce\":\"wc_full_price\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"26\",\"order\":\"2\",\"container\":\"m\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"solid\",\"shadow-color\":\"#000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"solid\",\"background-color-hover\":\"#FFF\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"#000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"1\",\"order\":\"3\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"woocommerce\",\"enable-hover\":\"on\",\"font-size\":\"12\",\"line-height\":\"14\",\"color\":\"#777777\",\"font-family\":\"\\\"Open Sans\\\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"10\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#aaaaaa\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000000\",\"font-family-hover\":\"\\\"Open Sans\\\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"capitalize\",\"background-color-hover\":\"transparent\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#aaaaaa\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"34\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\", \",\"limit-type\":\"none\",\"limit-num\":\"10\",\"hide-on-video\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"source-woocommerce\":\"wc_categories\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"31\",\"order\":\"4\",\"container\":\"m\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"solid\",\"shadow-color\":\"#000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"solid\",\"background-color-hover\":\"#FFF\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"#000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"30\",\"order\":\"5\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"woocommerce\",\"enable-hover\":\"\",\"font-size\":\"13\",\"line-height\":\"20\",\"color\":\"#000000\",\"font-family\":\"\",\"font-weight\":\"700\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"5\",\"10\",\"5\",\"10\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-size-x\":\"100\",\"background-size-y\":\"100\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"slideleft\",\"delay\":\"30\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"hide-on-video\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"margin-unit\":\"px\",\"source-woocommerce\":\"wc_star_rating\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}}]", NULL);
INSERT INTO `rtl_lnd_eg_item_skins` VALUES("22", "Cleveland", "cleveland", "{\"eg-item-skin-element-last-id\":\"22\",\"choose-layout\":\"masonry\",\"show-content\":\"bottom\",\"content-align\":\"left\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"rgba(0,0,0,0.75)\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"100\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#333333\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"transparent\",\"full-border-style\":\"none\",\"full-overflow-hidden\":\"false\",\"content-bg-color\":\"#333333\",\"content-padding\":[\"30\",\"30\",\"30\",\"30\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"double\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"rgba(0,0,0,0.20)\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"1\",\"2\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"fade\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"fade\",\"media-animation\":\"none\",\"media-animation-delay\":\"0\"}", "[{\"id\":\"0\",\"order\":\"0\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"20\",\"line-height\":\"25\",\"color\":\"#ffffff\",\"font-family\":\"\\\"Raleway\\\"\",\"font-weight\":\"700\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"display\":\"block\",\"text-align\":\"left\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"20\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\".eg-cleveland-element-0{}\",\"font-size-hover\":\"20\",\"line-height-hover\":\"25\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\\\"Raleway\\\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"capitalize\",\"background-color-hover\":\"transparent\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\".eg-cleveland-element-0{}\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"30\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"tag-type\":\"div\",\"align\":\"t_l\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"force-important\":\"\",\"absolute-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-post\":\"title\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"1\",\"order\":\"0\",\"container\":\"br\",\"settings\":{\"0\":\"\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"left\",\"clear\":\"right\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"13\",\"13\",\"13\",\"13\"],\"background-color\":\"rgba(0,0,0,0.25)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"css\":\"\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"#000000\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"rollleft\",\"delay\":\"30\",\"link-type\":\"lightbox\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-icon\":\"eg-icon-link-ext\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"2\",\"order\":\"0\",\"container\":\"c\",\"settings\":{\"0\":\"\",\"source\":\"text\",\"enable-hover\":\"on\",\"font-size\":\"12\",\"line-height\":\"20\",\"color\":\"#ffffff\",\"font-family\":\"\\\"Raleway\\\"\",\"font-weight\":\"800\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"5\",\"10\",\"5\",\"10\"],\"background-color\":\"rgba(0,0,0,0.25)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"20\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\\\"Raleway\\\"\",\"font-weight-hover\":\"800\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"#000000\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"flipup\",\"delay\":\"10\",\"link-type\":\"post\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-text\":\"READ MORE\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"3\",\"order\":\"1\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"12\",\"line-height\":\"16\",\"color\":\"#aaaaaa\",\"font-family\":\"\\\"Raleway\\\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"left\",\"clear\":\"none\",\"margin\":[\"0\",\"10\",\"0\",\"0\"],\"padding\":[\"0\",\"10\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"1\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#555555\",\"border-style\":\"solid\",\"css\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"16\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\\\"Raleway\\\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"capitalize\",\"background-color-hover\":\"transparent\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"1\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#555555\",\"border-style-hover\":\"solid\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"34\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"source-post\":\"date\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"4\",\"order\":\"2\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"on\",\"font-size\":\"12\",\"line-height\":\"16\",\"color\":\"#aaaaaa\",\"font-family\":\"\\\"Raleway\\\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"left\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"16\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\\\"Raleway\\\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"capitalize\",\"background-color-hover\":\"transparent\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"34\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\", \",\"limit-type\":\"none\",\"limit-num\":\"10\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"source-post\":\"cat_list\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},\"\",{\"id\":\"6\",\"order\":\"5\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"13\",\"line-height\":\"22\",\"color\":\"#eeeeee\",\"font-family\":\"\\\"Raleway\\\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"display\":\"block\",\"text-align\":\"left\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"15\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"34\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"words\",\"limit-num\":\"15\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"source-post\":\"excerpt\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"22\",\"order\":\"4\",\"container\":\"m\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"solid\",\"shadow-color\":\"#000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"solid\",\"background-color-hover\":\"#FFF\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"#000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}}]", NULL);
INSERT INTO `rtl_lnd_eg_item_skins` VALUES("23", "Harrison", "harrison", "{\"eg-item-skin-element-last-id\":\"24\",\"choose-layout\":\"masonry\",\"show-content\":\"top\",\"content-align\":\"left\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"rgba(54,56,57,0.85)\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"100\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#ffffff\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"transparent\",\"full-border-style\":\"none\",\"full-overflow-hidden\":\"false\",\"content-bg-color\":\"#363839\",\"content-padding\":[\"30\",\"30\",\"30\",\"30\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"double\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"rgba(0,0,0,0.20)\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"-1\",\"2\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"fade\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"fade\",\"media-animation\":\"none\",\"media-animation-delay\":\"0\"}", "[{\"id\":\"0\",\"order\":\"0\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"20\",\"line-height\":\"25\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"500\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"display\":\"block\",\"text-align\":\"left\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"20\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"30\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"hide-on-video\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-post\":\"title\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"1\",\"order\":\"1\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"12\",\"line-height\":\"14\",\"color\":\"#aaaaaa\",\"font-family\":\"\",\"font-weight\":\"300\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"left\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"10\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"1\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#aaaaaa\",\"border-style\":\"solid\",\"css\":\"\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"34\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-post\":\"date\",\"transition-type\":\"\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"2\",\"order\":\"2\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"12\",\"line-height\":\"14\",\"color\":\"#aaaaaa\",\"font-family\":\"\",\"font-weight\":\"300\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"left\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"10\"],\"padding\":[\"0\",\"10\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#aaaaaa\",\"border-style\":\"solid\",\"css\":\"\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"34\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"hide-on-video\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-post\":\"cat_list\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}}]", NULL);
INSERT INTO `rtl_lnd_eg_item_skins` VALUES("24", "McKinley", "mckinley", "{\"eg-item-skin-element-last-id\":\"30\",\"choose-layout\":\"masonry\",\"show-content\":\"bottom\",\"content-align\":\"left\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"rgba(19,192,223,0.65)\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"100\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#ffffff\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"#e5e5e5\",\"full-border-style\":\"none\",\"full-overflow-hidden\":\"false\",\"content-bg-color\":\"#ffffff\",\"content-padding\":[\"30\",\"30\",\"30\",\"30\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"double\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"#000000\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"1\",\"10\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"slide\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"none\",\"media-animation\":\"none\",\"media-animation-delay\":\"0\"}", "[{\"id\":\"0\",\"order\":\"0\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"on\",\"font-size\":\"20\",\"line-height\":\"25\",\"color\":\"#363839\",\"font-family\":\"\\\"Raleway\\\"\",\"font-weight\":\"800\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"10\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"#ffffff\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"20\",\"line-height-hover\":\"25\",\"color-hover\":\"#13c0df\",\"font-family-hover\":\"\\\"Raleway\\\"\",\"font-weight-hover\":\"800\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"capitalize\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"30\",\"link-type\":\"post\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"hide-on-video\":\"\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-post\":\"title\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\"}},{\"id\":\"25\",\"order\":\"0\",\"container\":\"c\",\"settings\":{\"0\":\"\",\"source\":\"text\",\"enable-hover\":\"on\",\"font-size\":\"13\",\"line-height\":\"20\",\"color\":\"#ffffff\",\"font-family\":\"\\\"Raleway\\\"\",\"font-weight\":\"900\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"5\",\"10\",\"3\",\"10\"],\"background-color\":\"rgba(0,0,0,0.15)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-size-x\":\"100\",\"background-size-y\":\"100\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"13\",\"line-height-hover\":\"20\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\\\"Raleway\\\"\",\"font-weight-hover\":\"900\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(0,0,0,0.50)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"slide\",\"delay\":\"20\",\"link-type\":\"lightbox\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"hide-on-video\":\"true\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"margin-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-text\":\"SHOW IMAGE\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"28\",\"order\":\"1\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"text\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"enable-hover\":\"on\",\"font-size\":\"13\",\"line-height\":\"20\",\"color\":\"#ffffff\",\"font-family\":\"\\\"Raleway\\\"\",\"font-weight\":\"900\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"position\":\"relative\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"5\"],\"padding\":[\"5\",\"10\",\"3\",\"10\"],\"background-color\":\"rgba(0,0,0,0.15)\",\"bg-alpha\":\"100\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"20\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\\\"Raleway\\\"\",\"font-weight-hover\":\"900\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(0,0,0,0.50)\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"\",\"transition\":\"slide\",\"transition-type\":\"\",\"delay\":\"20\",\"link-type\":\"embedded_video\",\"url-link\":\"\",\"meta-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"margin-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-text\":\"PLAY VIDEO\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"3\",\"order\":\"1\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"on\",\"font-size\":\"12\",\"line-height\":\"14\",\"color\":\"#aaaaaa\",\"font-family\":\"\\\"Open Sans\\\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"#ffffff\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#e5e5e5\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000000\",\"font-family-hover\":\"\\\"Open Sans\\\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"capitalize\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#e5e5e5\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"34\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\", \",\"limit-type\":\"none\",\"limit-num\":\"10\",\"hide-on-video\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"source-post\":\"cat_list\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\"}},\"\",{\"id\":\"6\",\"order\":\"3\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"13\",\"line-height\":\"22\",\"color\":\"#777777\",\"font-family\":\"\\\"Open Sans\\\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"15\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"#ffffff\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"34\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"words\",\"limit-num\":\"15\",\"hide-on-video\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"source-post\":\"excerpt\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\"}},\"\",{\"id\":\"29\",\"order\":\"2\",\"container\":\"m\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"solid\",\"shadow-color\":\"#000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"solid\",\"background-color-hover\":\"#FFF\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"#000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\"}},{\"id\":\"30\",\"order\":\"4\",\"container\":\"m\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"solid\",\"shadow-color\":\"#000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"solid\",\"background-color-hover\":\"#FFF\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"#000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\"}}]", NULL);
INSERT INTO `rtl_lnd_eg_item_skins` VALUES("25", "Roosevelt", "roosevelt", "{\"eg-item-skin-element-last-id\":\"3\",\"choose-layout\":\"even\",\"show-content\":\"bottom\",\"content-align\":\"left\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"rgba(34,34,34,0.50)\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"100\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#333333\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"transparent\",\"full-border-style\":\"none\",\"full-overflow-hidden\":\"false\",\"content-bg-color\":\"#333333\",\"content-padding\":[\"0\",\"0\",\"0\",\"0\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"double\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"#000000\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"fade\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"zoomback\",\"cover-group-animation\":\"none\",\"media-animation\":\"shifttotop\",\"media-animation-delay\":\"0\"}", "[{\"id\":\"0\",\"order\":\"0\",\"container\":\"br\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"15\",\"line-height\":\"20\",\"color\":\"#ffffff\",\"font-family\":\"\\\"Raleway\\\"\",\"font-weight\":\"800\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"20\",\"20\",\"20\",\"20\"],\"background-color\":\"#333333\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\".eg-roosevelt-element-0{}\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\".eg-roosevelt-element-0{}\",\"hideunder\":\"0\",\"transition\":\"flipup\",\"delay\":\"9\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"transition-type\":\"\",\"tag-type\":\"div\",\"align\":\"t_l\",\"margin-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"force-important\":\"\",\"absolute-unit\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-post\":\"title\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"2\",\"order\":\"0\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"10\",\"60\",\"0\"],\"padding\":[\"17\",\"17\",\"17\",\"17\"],\"background-color\":\"rgba(0,0,0,0.50)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(0,0,0,0.75)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"slideup\",\"delay\":\"20\",\"link-type\":\"lightbox\",\"url-link\":\"\",\"javascript-link\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"css\":\".eg-roosevelt-element-2{}\",\"position\":\"relative\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"transition-type\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"align\":\"t_l\",\"css-hover\":\".eg-roosevelt-element-2{}\",\"margin-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"force-important\":\"true\",\"absolute-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-icon\":\"eg-icon-search\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"1\",\"order\":\"1\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"17\",\"17\",\"17\",\"17\"],\"background-color\":\"rgba(0,0,0,0.50)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(0,0,0,0.75)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"slideup\",\"delay\":\"30\",\"link-type\":\"post\",\"url-link\":\"\",\"javascript-link\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"css\":\"\",\"position\":\"relative\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"transition-type\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"align\":\"t_l\",\"css-hover\":\"\",\"margin-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"force-important\":\"true\",\"absolute-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-icon\":\"eg-icon-link\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}}]", NULL);
INSERT INTO `rtl_lnd_eg_item_skins` VALUES("26", "HowardTaft", "howardtaft", "{\"eg-item-skin-element-last-id\":\"14\",\"choose-layout\":\"even\",\"show-content\":\"none\",\"content-align\":\"left\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"rgba(111,33,44,0.75)\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"100\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#000000\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"transparent\",\"full-border-style\":\"none\",\"full-overflow-hidden\":\"false\",\"content-bg-color\":\"#000000\",\"content-padding\":[\"0\",\"0\",\"0\",\"0\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"none\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"#000000\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"slide\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"none\",\"media-animation\":\"none\",\"media-animation-delay\":\"0\"}", "[{\"id\":\"0\",\"order\":\"0\",\"container\":\"c\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"15\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\\\"Raleway\\\"\",\"font-weight\":\"900\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\".eg-howardtaft-element-0{letter-spacing:1px;}\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\".eg-howardtaft-element-0{}\",\"hideunder\":\"0\",\"transition\":\"slide\",\"delay\":\"15\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top\":\"0\",\"top-unit\":\"px\",\"right\":\"0\",\"right-unit\":\"px\",\"bottom\":\"0\",\"bottom-unit\":\"px\",\"left\":\"0\",\"left-unit\":\"px\",\"split\":\"full\",\"transition-type\":\"\",\"tag-type\":\"div\",\"align\":\"t_l\",\"margin-unit\":\"px\",\"top-left-right\":\"0\",\"bottom-left-right\":\"0\",\"force-important\":\"true\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"absolute-unit\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-post\":\"title\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"1\",\"order\":\"1\",\"container\":\"c\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"css\":\"\",\"position\":\"relative\",\"top\":\"0\",\"top-unit\":\"px\",\"right\":\"0\",\"right-unit\":\"px\",\"bottom\":\"0\",\"bottom-unit\":\"px\",\"left\":\"0\",\"left-unit\":\"px\",\"split\":\"full\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"align\":\"t_l\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"background-color-hover\":\"#FFF\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"css-hover\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\"}},{\"id\":\"2\",\"order\":\"2\",\"container\":\"c\",\"settings\":{\"0\":\"\",\"source\":\"text\",\"enable-hover\":\"\",\"font-size\":\"6\",\"line-height\":\"7\",\"color\":\"transparent\",\"font-family\":\"\",\"font-weight\":\"300\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"2\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"css\":\".eg-howardtaft-element-2{ min-width:50px}\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\".eg-howardtaft-element-2{}\",\"hideunder\":\"0\",\"transition\":\"zoomback\",\"delay\":\"25\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-left-right\":\"0\",\"bottom-left-right\":\"0\",\"split\":\"full\",\"transition-type\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"margin-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"hide-on-video\":\"\",\"absolute-unit\":\"px\",\"source-text\":\"anemptytextlline\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"3\",\"order\":\"3\",\"container\":\"c\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"css\":\"\",\"position\":\"relative\",\"top-left-right\":\"0\",\"bottom-left-right\":\"0\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"background-color-hover\":\"#FFF\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"css-hover\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\"}},{\"id\":\"6\",\"order\":\"6\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"enable-hover\":\"\",\"font-size\":\"17\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"200\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"7\",\"color-hover\":\"#e33a0c\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"2\",\"2\",\"2\",\"2\"],\"border-radius-hover\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"slide\",\"delay\":\"35\",\"link-type\":\"lightbox\",\"url-link\":\"\",\"javascript-link\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-left-right\":\"0\",\"bottom-left-right\":\"0\",\"transition-type\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"margin-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"absolute-unit\":\"px\",\"hide-on-video\":\"true\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-icon\":\"eg-icon-search\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"7\",\"order\":\"7\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"enable-hover\":\"\",\"font-size\":\"17\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"7\",\"color-hover\":\"#e33a0c\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"2\",\"2\",\"2\",\"2\"],\"border-radius-hover\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"slide\",\"delay\":\"35\",\"link-type\":\"embedded_video\",\"url-link\":\"\",\"javascript-link\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-left-right\":\"0\",\"bottom-left-right\":\"0\",\"transition-type\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"margin-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"absolute-unit\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-icon\":\"eg-icon-play\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}}]", NULL);
INSERT INTO `rtl_lnd_eg_item_skins` VALUES("27", "WoodrowWilson", "woodrowwilson", "{\"eg-item-skin-element-last-id\":\"14\",\"choose-layout\":\"even\",\"show-content\":\"none\",\"content-align\":\"left\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"#ffffff\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"100\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#ffffff\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"transparent\",\"full-border-style\":\"none\",\"full-overflow-hidden\":\"false\",\"content-bg-color\":\"#ffffff\",\"content-padding\":[\"0\",\"0\",\"0\",\"0\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"none\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"#000000\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"fade\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"none\",\"media-animation\":\"none\",\"media-animation-delay\":\"0\"}", "[{\"id\":\"0\",\"order\":\"0\",\"container\":\"c\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"15\",\"line-height\":\"18\",\"color\":\"#000000\",\"font-family\":\"\\\"Raleway\\\"\",\"font-weight\":\"800\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"20\",\"0\",\"20\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"slideleft\",\"delay\":\"15\",\"link-type\":\"post\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top\":\"0\",\"top-unit\":\"px\",\"right\":\"0\",\"right-unit\":\"px\",\"bottom\":\"0\",\"bottom-unit\":\"px\",\"left\":\"0\",\"left-unit\":\"px\",\"split\":\"full\",\"transition-type\":\"\",\"tag-type\":\"div\",\"align\":\"t_l\",\"margin-unit\":\"px\",\"top-left-right\":\"0\",\"bottom-left-right\":\"0\",\"force-important\":\"true\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"absolute-unit\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-post\":\"title\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"1\",\"order\":\"1\",\"container\":\"c\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"css\":\"\",\"position\":\"relative\",\"top\":\"0\",\"top-unit\":\"px\",\"right\":\"0\",\"right-unit\":\"px\",\"bottom\":\"0\",\"bottom-unit\":\"px\",\"left\":\"0\",\"left-unit\":\"px\",\"split\":\"full\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"align\":\"t_l\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"background-color-hover\":\"#FFF\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"css-hover\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\"}},{\"id\":\"2\",\"order\":\"2\",\"container\":\"c\",\"settings\":{\"0\":\"\",\"source\":\"text\",\"enable-hover\":\"\",\"font-size\":\"6\",\"line-height\":\"7\",\"color\":\"transparent\",\"font-family\":\"\",\"font-weight\":\"300\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"3\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#89af72\",\"border-style\":\"solid\",\"css\":\".eg-howardtaft-element-2{ min-width:50px}\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\".eg-howardtaft-element-2{}\",\"hideunder\":\"0\",\"transition\":\"zoomfront\",\"delay\":\"25\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-left-right\":\"0\",\"bottom-left-right\":\"0\",\"split\":\"full\",\"transition-type\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"margin-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"hide-on-video\":\"\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-text\":\"anemptytextlline\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"3\",\"order\":\"3\",\"container\":\"c\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"css\":\"\",\"position\":\"relative\",\"top-left-right\":\"0\",\"bottom-left-right\":\"0\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"background-color-hover\":\"#FFF\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"css-hover\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"hide-on-video\":\"\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-text\":\"LINE-BREAK\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\"}},{\"id\":\"4\",\"order\":\"4\",\"container\":\"c\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"13\",\"line-height\":\"22\",\"color\":\"#555555\",\"font-family\":\"\\\"Open Sans\\\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"slideright\",\"delay\":\"20\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-left-right\":\"0\",\"bottom-left-right\":\"0\",\"transition-type\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"margin-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\", \",\"limit-type\":\"none\",\"limit-num\":\"10\",\"hide-on-video\":\"\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-post\":\"cat_list\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}}]", NULL);
INSERT INTO `rtl_lnd_eg_item_skins` VALUES("28", "Harding", "harding", "{\"eg-item-skin-element-last-id\":\"17\",\"choose-layout\":\"masonry\",\"show-content\":\"bottom\",\"content-align\":\"center\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"transparent\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"100\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#ffffff\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"transparent\",\"full-border-style\":\"none\",\"content-bg-color\":\"#ffffff\",\"content-padding\":[\"0\",\"0\",\"0\",\"0\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"none\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"transparent\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"fade\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"none\",\"media-animation\":\"none\",\"media-animation-delay\":\"0\",\"google-fonts\":[\"Droid+Serif:400,700\",\"Open+Sans:400,600,700,800\"]}", "[{\"id\":\"0\",\"order\":\"0\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"15\",\"line-height\":\"25\",\"color\":\"#000000\",\"font-family\":\"\",\"font-weight\":\"800\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"40\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"15\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top\":\"0\",\"top-unit\":\"px\",\"right\":\"0\",\"right-unit\":\"px\",\"bottom\":\"0\",\"bottom-unit\":\"px\",\"left\":\"0\",\"left-unit\":\"px\",\"split\":\"full\",\"transition-type\":\"\",\"tag-type\":\"div\",\"align\":\"t_l\",\"margin-unit\":\"px\",\"top-left-right\":\"0\",\"bottom-left-right\":\"0\",\"force-important\":\"true\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"limit-type\":\"words\",\"limit-num\":\"10\",\"source-post\":\"title\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\"}},{\"id\":\"1\",\"order\":\"2\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"text\",\"enable-hover\":\"\",\"font-size\":\"12\",\"line-height\":\"14\",\"color\":\"#444444\",\"font-family\":\"\\\"Open Sans\\\"\",\"font-weight\":\"500\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"#ffffff\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#363839\",\"font-family-hover\":\"\",\"font-weight-hover\":\"600\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"capitalize\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"slideright\",\"delay\":\"34\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"limit-type\":\"words\",\"limit-num\":\"10\",\"transition-type\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"margin-unit\":\"px\",\"source-text\":\"Frontend Developer\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"2\",\"order\":\"3\",\"container\":\"m\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top\":\"0\",\"top-unit\":\"px\",\"right\":\"0\",\"right-unit\":\"px\",\"bottom\":\"0\",\"bottom-unit\":\"px\",\"left\":\"0\",\"left-unit\":\"px\",\"split\":\"full\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"align\":\"t_l\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"background-color-hover\":\"#FFF\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"top-left-right\":\"0\",\"bottom-left-right\":\"0\",\"force-important\":\"\",\"source-text\":\"LINE-BREAK\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\"}},{\"id\":\"3\",\"order\":\"4\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"text\",\"enable-hover\":\"\",\"font-size\":\"6\",\"line-height\":\"7\",\"color\":\"transparent\",\"font-family\":\"\",\"font-weight\":\"300\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"2\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#000000\",\"border-style\":\"solid\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"25\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-left-right\":\"0\",\"bottom-left-right\":\"0\",\"split\":\"full\",\"transition-type\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"margin-unit\":\"px\",\"source-text\":\"anemptytextlline\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\"}},{\"id\":\"4\",\"order\":\"5\",\"container\":\"m\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-left-right\":\"0\",\"bottom-left-right\":\"0\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"background-color-hover\":\"#FFF\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\"}},{\"id\":\"5\",\"order\":\"6\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"15\",\"line-height\":\"22\",\"color\":\"#555555\",\"font-family\":\"\\\"Droid Serif\\\"\",\"font-weight\":\"300\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"5\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"20\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-left-right\":\"0\",\"bottom-left-right\":\"0\",\"transition-type\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"margin-unit\":\"px\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"limit-type\":\"words\",\"limit-num\":\"50\",\"source-post\":\"excerpt\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\"}},{\"id\":\"6\",\"order\":\"7\",\"container\":\"m\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-left-right\":\"0\",\"bottom-left-right\":\"0\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"background-color-hover\":\"#FFF\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\"}}]", NULL);
INSERT INTO `rtl_lnd_eg_item_skins` VALUES("29", "Coolidge", "coolidge", "{\"eg-item-skin-element-last-id\":\"19\",\"choose-layout\":\"masonry\",\"show-content\":\"bottom\",\"content-align\":\"center\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"transparent\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"100\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#ffffff\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"transparent\",\"full-border-style\":\"none\",\"content-bg-color\":\"#ffffff\",\"content-padding\":[\"30\",\"30\",\"30\",\"30\"],\"content-border\":[\"1\",\"1\",\"1\",\"1\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"#e5e5e5\",\"content-border-style\":\"solid\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"rgba(0,0,0,0.15)\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"0\",\"0\",\"\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"fade\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"none\",\"media-animation\":\"none\",\"media-animation-delay\":\"0\",\"google-fonts\":[\"Droid+Serif:400,700\",\"Open+Sans:400,600,700,800\"]}", "[{\"id\":\"0\",\"order\":\"0\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"text\",\"enable-hover\":\"\",\"font-size\":\"33\",\"line-height\":\"25\",\"color\":\"#363839\",\"font-family\":\"\",\"font-weight\":\"600\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"#ffffff\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"slideleft\",\"delay\":\"30\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"margin-unit\":\"px\",\"source-text\":\"<i class=\\\"eg-icon-tools\\\"><\\/i>\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"1\",\"order\":\"1\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"15\",\"line-height\":\"19\",\"color\":\"#000000\",\"font-family\":\"\",\"font-weight\":\"800\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"15\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"15\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top\":\"0\",\"top-unit\":\"px\",\"right\":\"0\",\"right-unit\":\"px\",\"bottom\":\"0\",\"bottom-unit\":\"px\",\"left\":\"0\",\"left-unit\":\"px\",\"split\":\"full\",\"transition-type\":\"\",\"tag-type\":\"div\",\"align\":\"t_l\",\"margin-unit\":\"px\",\"top-left-right\":\"0\",\"bottom-left-right\":\"0\",\"force-important\":\"true\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"limit-type\":\"words\",\"limit-num\":\"10\",\"source-post\":\"title\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\"}},{\"id\":\"2\",\"order\":\"2\",\"container\":\"m\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top\":\"0\",\"top-unit\":\"px\",\"right\":\"0\",\"right-unit\":\"px\",\"bottom\":\"0\",\"bottom-unit\":\"px\",\"left\":\"0\",\"left-unit\":\"px\",\"split\":\"full\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"align\":\"t_l\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"background-color-hover\":\"#FFF\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"top-left-right\":\"0\",\"bottom-left-right\":\"0\",\"force-important\":\"\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-text\":\"LINE-BREAK\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"absolute-unit\":\"px\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\"}},{\"id\":\"3\",\"order\":\"3\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"text\",\"enable-hover\":\"\",\"font-size\":\"6\",\"line-height\":\"7\",\"color\":\"transparent\",\"font-family\":\"\",\"font-weight\":\"300\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"2\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#000000\",\"border-style\":\"solid\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"25\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-left-right\":\"0\",\"bottom-left-right\":\"0\",\"split\":\"full\",\"transition-type\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"margin-unit\":\"px\",\"source-text\":\"anemptytextlline\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\"}},{\"id\":\"4\",\"order\":\"4\",\"container\":\"m\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-left-right\":\"0\",\"bottom-left-right\":\"0\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"background-color-hover\":\"#FFF\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\"}},{\"id\":\"5\",\"order\":\"5\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"15\",\"line-height\":\"22\",\"color\":\"#555555\",\"font-family\":\"\\\"Droid Serif\\\"\",\"font-weight\":\"300\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"5\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"20\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-left-right\":\"0\",\"bottom-left-right\":\"0\",\"transition-type\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"margin-unit\":\"px\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"limit-type\":\"words\",\"limit-num\":\"40\",\"source-post\":\"excerpt\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\"}},{\"id\":\"6\",\"order\":\"6\",\"container\":\"m\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-left-right\":\"0\",\"bottom-left-right\":\"0\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"background-color-hover\":\"#FFF\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\"}},{\"id\":\"7\",\"order\":\"7\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"text\",\"enable-hover\":\"\",\"font-size\":\"15\",\"line-height\":\"14\",\"color\":\"#40dc8d\",\"font-family\":\"\\\"Droid Serif\\\"\",\"font-weight\":\"300\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"20\",\"0\",\"0\",\"-15\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"#ffffff\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#363839\",\"font-family-hover\":\"\",\"font-weight-hover\":\"600\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"capitalize\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"34\",\"link-type\":\"post\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"margin-unit\":\"px\",\"source-text\":\"<i class=\\\"eg-icon-angle-right\\\"><\\/i> Learn More\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\"}}]", NULL);
INSERT INTO `rtl_lnd_eg_item_skins` VALUES("30", "Herbert Hoover", "herbert-hoover", "{\"eg-item-skin-element-last-id\":\"25\",\"choose-layout\":\"masonry\",\"show-content\":\"bottom\",\"content-align\":\"center\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"transparent\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"100\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#ffffff\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"transparent\",\"full-border-style\":\"none\",\"full-overflow-hidden\":\"false\",\"content-bg-color\":\"#ffffff\",\"content-padding\":[\"30\",\"30\",\"30\",\"30\"],\"content-border\":[\"0\",\"1\",\"1\",\"1\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"#e5e5e5\",\"content-border-style\":\"solid\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"transparent\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"fade\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"none\",\"media-animation\":\"none\",\"media-animation-delay\":\"0\"}", "[{\"id\":\"0\",\"order\":\"0\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"15\",\"line-height\":\"25\",\"color\":\"#000000\",\"font-family\":\"\\\"Raleway\\\"\",\"font-weight\":\"800\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"15\",\"link-type\":\"post\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top\":\"0\",\"top-unit\":\"px\",\"right\":\"0\",\"right-unit\":\"px\",\"bottom\":\"0\",\"bottom-unit\":\"px\",\"left\":\"0\",\"left-unit\":\"px\",\"split\":\"full\",\"transition-type\":\"\",\"tag-type\":\"div\",\"align\":\"t_l\",\"margin-unit\":\"px\",\"top-left-right\":\"0\",\"bottom-left-right\":\"0\",\"force-important\":\"true\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"limit-type\":\"words\",\"limit-num\":\"10\",\"source-separate\":\",\",\"hide-on-video\":\"\",\"source-post\":\"title\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\"}},{\"id\":\"24\",\"order\":\"0\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"position\":\"relative\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"17\",\"17\",\"17\",\"17\"],\"background-color\":\"rgba(0,0,0,0.50)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"50\",\"50\",\"50\",\"50\"],\"border-radius-unit\":\"%\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(0,0,0,0.75)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"50\",\"50\",\"50\",\"50\"],\"border-radius-unit-hover\":\"%\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"fade\",\"transition-type\":\"\",\"split\":\"full\",\"delay\":\"10\",\"link-type\":\"lightbox\",\"url-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-separate\":\",\",\"margin-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"hide-on-video\":\"true\",\"source-icon\":\"eg-icon-search\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"1\",\"order\":\"1\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"on\",\"font-size\":\"12\",\"line-height\":\"14\",\"color\":\"#444444\",\"font-family\":\"\\\"Open Sans\\\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"#ffffff\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#aaaaaa\",\"font-family-hover\":\"\\\"Open Sans\\\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"slideright\",\"delay\":\"34\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"limit-type\":\"words\",\"limit-num\":\"10\",\"transition-type\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"margin-unit\":\"px\",\"source-separate\":\", \",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"source-post\":\"cat_list\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"25\",\"order\":\"1\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"position\":\"relative\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"5\"],\"padding\":[\"17\",\"17\",\"17\",\"17\"],\"background-color\":\"rgba(0,0,0,0.50)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"50\",\"50\",\"50\",\"50\"],\"border-radius-unit\":\"%\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(0,0,0,0.75)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"50\",\"50\",\"50\",\"50\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"fade\",\"transition-type\":\"\",\"split\":\"full\",\"delay\":\"10\",\"link-type\":\"embedded_video\",\"url-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-separate\":\",\",\"margin-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"source-icon\":\"eg-icon-play\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"10\",\"order\":\"10\",\"container\":\"m\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"limit-num\":\"10\",\"limit-type\":\"none\",\"enable-hover\":\"on\",\"font-size\":\"22\",\"line-height\":\"7\",\"color\":\"#000000\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"position\":\"relative\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"25\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"2\",\"2\",\"2\",\"2\"],\"border-radius\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"22\",\"line-height-hover\":\"7\",\"color-hover\":\"#c32524\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"transparent\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"2\",\"2\",\"2\",\"2\"],\"border-radius-hover\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"falldown\",\"transition-type\":\"\",\"split\":\"full\",\"delay\":\"10\",\"link-type\":\"url\",\"url-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"margin-unit\":\"px\",\"source-separate\":\",\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"source-icon\":\"eg-icon-pinterest\",\"link-type-url\":\"#\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"3\",\"order\":\"2\",\"container\":\"m\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top\":\"0\",\"top-unit\":\"px\",\"right\":\"0\",\"right-unit\":\"px\",\"bottom\":\"0\",\"bottom-unit\":\"px\",\"left\":\"0\",\"left-unit\":\"px\",\"split\":\"full\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"align\":\"t_l\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"background-color-hover\":\"#FFF\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"top-left-right\":\"0\",\"bottom-left-right\":\"0\",\"force-important\":\"\",\"source-text\":\"LINE-BREAK\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\"}},{\"id\":\"4\",\"order\":\"3\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"text\",\"enable-hover\":\"\",\"font-size\":\"6\",\"line-height\":\"7\",\"color\":\"transparent\",\"font-family\":\"\",\"font-weight\":\"300\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"2\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#000000\",\"border-style\":\"solid\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"25\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-left-right\":\"0\",\"bottom-left-right\":\"0\",\"split\":\"full\",\"transition-type\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"margin-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"absolute-unit\":\"px\",\"source-text\":\"anemptytextlline\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\"}},{\"id\":\"5\",\"order\":\"4\",\"container\":\"m\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-left-right\":\"0\",\"bottom-left-right\":\"0\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"background-color-hover\":\"#FFF\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\"}},{\"id\":\"6\",\"order\":\"5\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"15\",\"line-height\":\"22\",\"color\":\"#555555\",\"font-family\":\"\\\"Open Sans\\\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"5\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"20\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-left-right\":\"0\",\"bottom-left-right\":\"0\",\"transition-type\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"margin-unit\":\"px\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"limit-type\":\"words\",\"limit-num\":\"15\",\"source-separate\":\",\",\"source-post\":\"excerpt\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\"}},{\"id\":\"7\",\"order\":\"6\",\"container\":\"m\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-left-right\":\"0\",\"bottom-left-right\":\"0\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"background-color-hover\":\"#FFF\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\"}},{\"id\":\"8\",\"order\":\"7\",\"container\":\"m\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"limit-num\":\"10\",\"limit-type\":\"none\",\"enable-hover\":\"on\",\"font-size\":\"22\",\"line-height\":\"7\",\"color\":\"#000000\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"position\":\"relative\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"25\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"2\",\"2\",\"2\",\"2\"],\"border-radius\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"22\",\"line-height-hover\":\"7\",\"color-hover\":\"#4672b3\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"transparent\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"2\",\"2\",\"2\",\"2\"],\"border-radius-hover\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"falldown\",\"transition-type\":\"\",\"split\":\"full\",\"delay\":\"10\",\"link-type\":\"url\",\"url-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"margin-unit\":\"px\",\"source-separate\":\",\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"source-icon\":\"eg-icon-facebook-1\",\"link-type-url\":\"#\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"9\",\"order\":\"8\",\"container\":\"m\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"limit-num\":\"10\",\"limit-type\":\"none\",\"enable-hover\":\"on\",\"font-size\":\"22\",\"line-height\":\"7\",\"color\":\"#000000\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"position\":\"relative\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"25\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"2\",\"2\",\"2\",\"2\"],\"border-radius\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"22\",\"line-height-hover\":\"7\",\"color-hover\":\"#099bcc\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"transparent\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"2\",\"2\",\"2\",\"2\"],\"border-radius-hover\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"falldown\",\"transition-type\":\"\",\"split\":\"full\",\"delay\":\"10\",\"link-type\":\"url\",\"url-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"margin-unit\":\"px\",\"source-separate\":\",\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"source-icon\":\"eg-icon-twitter-1\",\"link-type-url\":\"#\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"2\",\"order\":\"9\",\"container\":\"m\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"limit-num\":\"10\",\"limit-type\":\"none\",\"enable-hover\":\"on\",\"font-size\":\"22\",\"line-height\":\"7\",\"color\":\"#000000\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"position\":\"relative\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"25\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"2\",\"2\",\"2\",\"2\"],\"border-radius\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"22\",\"line-height-hover\":\"7\",\"color-hover\":\"#da4a38\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"transparent\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"2\",\"2\",\"2\",\"2\"],\"border-radius-hover\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"falldown\",\"transition-type\":\"\",\"split\":\"full\",\"delay\":\"10\",\"link-type\":\"url\",\"url-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"margin-unit\":\"px\",\"source-separate\":\",\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"source-icon\":\"eg-icon-gplus-1\",\"link-type-url\":\"#\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}}]", NULL);
INSERT INTO `rtl_lnd_eg_item_skins` VALUES("31", "Eisenhower", "eisenhower", "{\"eg-item-skin-element-last-id\":\"24\",\"choose-layout\":\"masonry\",\"show-content\":\"bottom\",\"content-align\":\"center\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"transparent\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"100\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#ffffff\",\"full-padding\":[\"20\",\"20\",\"20\",\"20\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"5\",\"5\",\"5\",\"5\"],\"full-border-color\":\"#606060\",\"full-border-style\":\"solid\",\"content-bg-color\":\"#ffffff\",\"content-padding\":[\"30\",\"30\",\"0\",\"30\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"#e5e5e5\",\"content-border-style\":\"none\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"rgba(0,0,0,0.15)\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"0\",\"0\",\"\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"fade\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"none\",\"media-animation\":\"none\",\"media-animation-delay\":\"0\",\"google-fonts\":[\"Droid+Serif:400,700\",\"Open+Sans:400,600,700,800\"]}", "[{\"id\":\"0\",\"order\":\"0\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"15\",\"line-height\":\"19\",\"color\":\"#000000\",\"font-family\":\"\",\"font-weight\":\"800\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"15\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top\":\"0\",\"top-unit\":\"px\",\"right\":\"0\",\"right-unit\":\"px\",\"bottom\":\"0\",\"bottom-unit\":\"px\",\"left\":\"0\",\"left-unit\":\"px\",\"split\":\"full\",\"transition-type\":\"\",\"tag-type\":\"div\",\"align\":\"t_l\",\"margin-unit\":\"px\",\"top-left-right\":\"0\",\"bottom-left-right\":\"0\",\"force-important\":\"true\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"limit-type\":\"words\",\"limit-num\":\"10\",\"source-separate\":\",\",\"source-post\":\"title\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\"}},{\"id\":\"1\",\"order\":\"0\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"position\":\"relative\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"15\",\"0\",\"0\"],\"padding\":[\"17\",\"17\",\"17\",\"17\"],\"background-color\":\"rgba(0,0,0,0.85)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"50\",\"50\",\"50\",\"50\"],\"border-radius-unit\":\"%\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#000000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"50\",\"50\",\"50\",\"50\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"rollright\",\"transition-type\":\"\",\"split\":\"full\",\"delay\":\"10\",\"link-type\":\"lightbox\",\"url-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"margin-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"source-separate\":\",\",\"source-icon\":\"eg-icon-search\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"2\",\"order\":\"1\",\"container\":\"m\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top\":\"0\",\"top-unit\":\"px\",\"right\":\"0\",\"right-unit\":\"px\",\"bottom\":\"0\",\"bottom-unit\":\"px\",\"left\":\"0\",\"left-unit\":\"px\",\"split\":\"full\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"align\":\"t_l\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"background-color-hover\":\"#FFF\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"top-left-right\":\"0\",\"bottom-left-right\":\"0\",\"force-important\":\"\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-text\":\"LINE-BREAK\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"absolute-unit\":\"px\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\"}},{\"id\":\"3\",\"order\":\"1\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"17\",\"17\",\"17\",\"17\"],\"background-color\":\"rgba(0,0,0,0.85)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"50\",\"50\",\"50\",\"50\"],\"border-radius-unit\":\"%\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#000000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"50\",\"50\",\"50\",\"50\"],\"border-radius-unit-hover\":\"%\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"rollleft\",\"delay\":\"18\",\"link-type\":\"post\",\"url-link\":\"\",\"javascript-link\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"margin-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"source-separate\":\",\",\"source-icon\":\"eg-icon-forward\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"4\",\"order\":\"2\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"text\",\"enable-hover\":\"\",\"font-size\":\"6\",\"line-height\":\"7\",\"color\":\"transparent\",\"font-family\":\"\",\"font-weight\":\"300\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"2\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#40dc8d\",\"border-style\":\"solid\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"25\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-left-right\":\"0\",\"bottom-left-right\":\"0\",\"split\":\"full\",\"transition-type\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"margin-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"absolute-unit\":\"px\",\"source-text\":\"anemptytextlline\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\"}},{\"id\":\"5\",\"order\":\"3\",\"container\":\"m\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-left-right\":\"0\",\"bottom-left-right\":\"0\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"background-color-hover\":\"#FFF\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\"}},{\"id\":\"6\",\"order\":\"4\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"15\",\"line-height\":\"22\",\"color\":\"#555555\",\"font-family\":\"\\\"Droid Serif\\\"\",\"font-weight\":\"300\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"5\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"20\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-left-right\":\"0\",\"bottom-left-right\":\"0\",\"transition-type\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"margin-unit\":\"px\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"limit-type\":\"words\",\"limit-num\":\"5\",\"source-post\":\"cat_list\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\"}}]", NULL);
INSERT INTO `rtl_lnd_eg_item_skins` VALUES("32", "J.F.Kennedy", "j-f-kennedy", "{\"eg-item-skin-element-last-id\":\"24\",\"choose-layout\":\"masonry\",\"show-content\":\"bottom\",\"content-align\":\"center\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"transparent\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"100\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#111111\",\"full-padding\":[\"20\",\"20\",\"20\",\"20\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"5\",\"5\",\"5\",\"5\"],\"full-border-color\":\"#606060\",\"full-border-style\":\"solid\",\"content-bg-color\":\"#111111\",\"content-padding\":[\"30\",\"30\",\"0\",\"30\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"#e5e5e5\",\"content-border-style\":\"none\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"rgba(0,0,0,0.15)\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"0\",\"0\",\"\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"fade\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"none\",\"media-animation\":\"none\",\"media-animation-delay\":\"0\",\"google-fonts\":[\"Droid+Serif:400,700\",\"Open+Sans:400,600,700,800\"]}", "[{\"id\":\"0\",\"order\":\"0\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"15\",\"line-height\":\"19\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"800\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"15\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top\":\"0\",\"top-unit\":\"px\",\"right\":\"0\",\"right-unit\":\"px\",\"bottom\":\"0\",\"bottom-unit\":\"px\",\"left\":\"0\",\"left-unit\":\"px\",\"split\":\"full\",\"transition-type\":\"\",\"tag-type\":\"div\",\"align\":\"t_l\",\"margin-unit\":\"px\",\"top-left-right\":\"0\",\"bottom-left-right\":\"0\",\"force-important\":\"true\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"limit-type\":\"words\",\"limit-num\":\"10\",\"source-separate\":\",\",\"source-post\":\"title\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\"}},{\"id\":\"1\",\"order\":\"0\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"position\":\"relative\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"15\",\"0\",\"0\"],\"padding\":[\"19\",\"19\",\"19\",\"19\"],\"background-color\":\"rgba(0,0,0,0.85)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"50\",\"50\",\"50\",\"50\"],\"border-radius-unit\":\"%\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#000000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"50\",\"50\",\"50\",\"50\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"rollright\",\"transition-type\":\"\",\"split\":\"full\",\"delay\":\"10\",\"link-type\":\"lightbox\",\"url-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"margin-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"source-separate\":\",\",\"source-icon\":\"eg-icon-search\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"2\",\"order\":\"1\",\"container\":\"m\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top\":\"0\",\"top-unit\":\"px\",\"right\":\"0\",\"right-unit\":\"px\",\"bottom\":\"0\",\"bottom-unit\":\"px\",\"left\":\"0\",\"left-unit\":\"px\",\"split\":\"full\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"align\":\"t_l\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"background-color-hover\":\"#FFF\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"top-left-right\":\"0\",\"bottom-left-right\":\"0\",\"force-important\":\"\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-text\":\"LINE-BREAK\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"absolute-unit\":\"px\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\"}},{\"id\":\"3\",\"order\":\"1\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"19\",\"19\",\"19\",\"19\"],\"background-color\":\"rgba(0,0,0,0.85)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"50\",\"50\",\"50\",\"50\"],\"border-radius-unit\":\"%\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"19\",\"color-hover\":\"#000000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"50\",\"50\",\"50\",\"50\"],\"border-radius-unit-hover\":\"%\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"rollleft\",\"delay\":\"18\",\"link-type\":\"post\",\"url-link\":\"\",\"javascript-link\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"margin-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"source-separate\":\",\",\"source-icon\":\"eg-icon-forward\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"4\",\"order\":\"2\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"text\",\"enable-hover\":\"\",\"font-size\":\"6\",\"line-height\":\"7\",\"color\":\"transparent\",\"font-family\":\"\",\"font-weight\":\"300\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"2\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#40dc8d\",\"border-style\":\"solid\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"25\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-left-right\":\"0\",\"bottom-left-right\":\"0\",\"split\":\"full\",\"transition-type\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"margin-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"absolute-unit\":\"px\",\"source-text\":\"anemptytextlline\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\"}},{\"id\":\"5\",\"order\":\"3\",\"container\":\"m\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-left-right\":\"0\",\"bottom-left-right\":\"0\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"background-color-hover\":\"#FFF\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\"}},{\"id\":\"6\",\"order\":\"4\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"15\",\"line-height\":\"22\",\"color\":\"#888888\",\"font-family\":\"\\\"Droid Serif\\\"\",\"font-weight\":\"300\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"5\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"20\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-left-right\":\"0\",\"bottom-left-right\":\"0\",\"transition-type\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"margin-unit\":\"px\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"limit-type\":\"words\",\"limit-num\":\"5\",\"source-post\":\"cat_list\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\"}}]", NULL);
INSERT INTO `rtl_lnd_eg_item_skins` VALUES("33", "Lyndon Johnson", "lyndon-johnson", "{\"eg-item-skin-element-last-id\":\"2\",\"choose-layout\":\"even\",\"show-content\":\"none\",\"content-align\":\"left\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"rgba(0,0,0,0.75)\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"100\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#ffffff\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"transparent\",\"full-border-style\":\"none\",\"full-overflow-hidden\":\"false\",\"content-bg-color\":\"#ffffff\",\"content-padding\":[\"0\",\"0\",\"0\",\"0\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"none\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"#000000\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"covergrowup\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"none\",\"media-animation\":\"none\",\"media-animation-delay\":\"0\"}", "[{\"id\":\"0\",\"order\":\"0\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"text\",\"enable-hover\":\"\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"none\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"transparent\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"0\",\"link-type\":\"lightbox\",\"url-link\":\"\",\"javascript-link\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"out\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"margin-unit\":\"px\",\"source-separate\":\",\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"source-text\":\"<img src=\\\"%eg-clients-icon%\\\" \\/>\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\"}}]", NULL);
INSERT INTO `rtl_lnd_eg_item_skins` VALUES("34", "Ulysses S. Grant", "ulysses-s-grant", "{\"eg-item-skin-element-last-id\":\"11\",\"choose-layout\":\"masonry\",\"show-content\":\"bottom\",\"content-align\":\"center\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"transparent\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"100\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#f5f5f5\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"1\",\"1\",\"1\",\"1\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"#e5e5e5\",\"full-border-style\":\"solid\",\"full-overflow-hidden\":\"false\",\"content-bg-color\":\"#f5f5f5\",\"content-padding\":[\"0\",\"0\",\"0\",\"0\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"none\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"#000000\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"none\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"none\",\"media-animation\":\"none\",\"media-animation-delay\":\"0\",\"google-fonts\":[\"Open+Sans:400\",\"Raleway:700,800,900\"]}", "[{\"id\":\"0\",\"order\":\"0\",\"container\":\"c\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"50\",\"line-height\":\"50\",\"color\":\"#ffffff\",\"font-family\":\"\\\"Raleway\\\"\",\"font-weight\":\"800\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"80\",\"0\",\"-6\",\"0\"],\"padding\":[\"1\",\"10\",\"5\",\"10\"],\"background-color\":\"#000000\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"flipdown\",\"delay\":\"0\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"out\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"margin-unit\":\"px\",\"source-separate\":\",\",\"source-post\":\"meta\",\"source-meta\":\"eg-pricetable-price\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"1\",\"order\":\"0\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"20\",\"line-height\":\"25\",\"color\":\"#363839\",\"font-family\":\"\\\"Raleway\\\"\",\"font-weight\":\"800\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"30\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"slideleft\",\"delay\":\"30\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"margin-unit\":\"px\",\"source-separate\":\",\",\"source-post\":\"title\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"2\",\"order\":\"1\",\"container\":\"c\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"solid\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"solid\",\"background-color-hover\":\"#FFF\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-separate\":\",\",\"source-text\":\"LINE-BREAK\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\"}},{\"id\":\"3\",\"order\":\"1\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"12\",\"line-height\":\"22\",\"color\":\"#999999\",\"font-family\":\"\\\"Open Sans\\\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"20\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"slideright\",\"delay\":\"34\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"limit-type\":\"words\",\"limit-num\":\"5\",\"transition-type\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"margin-unit\":\"px\",\"source-separate\":\",\",\"source-post\":\"excerpt\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"4\",\"order\":\"2\",\"container\":\"c\",\"settings\":{\"0\":\"\",\"source\":\"text\",\"enable-hover\":\"\",\"font-size\":\"13\",\"line-height\":\"20\",\"color\":\"#ffffff\",\"font-family\":\"\\\"Raleway\\\"\",\"font-weight\":\"700\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"position\":\"relative\",\"align\":\"t_l\",\"top\":\"0\",\"top-unit-hover\":\"px\",\"right\":\"0\",\"right-unit-hover\":\"px\",\"bottom\":\"0\",\"bottom-unit-hover\":\"px\",\"left\":\"0\",\"left-unit-hover\":\"px\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"5\",\"0\",\"5\"],\"background-color\":\"#e33a0c\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\".eg-kriki-element-2{.eg-kriki-element-4{}\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\".eg-kriki-element-2{.eg-kriki-element-4{}\",\"hideunder\":\"0\",\"transition\":\"flipdown\",\"transition-type\":\"out\",\"delay\":\"0\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"force-important\":\"\",\"absolute-unit\":\"px\",\"margin-unit\":\"px\",\"source-separate\":\",\",\"source-text\":\"SHIPPING INCL.\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"5\",\"order\":\"2\",\"container\":\"m\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"enable-hover\":\"\",\"font-size\":\"15\",\"line-height\":\"18\",\"color\":\"#777777\",\"font-family\":\"\\\"Open Sans\\\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"position\":\"relative\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"17\",\"20\",\"17\",\"20\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"1\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#e5e5e5\",\"border-style\":\"solid\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"slideright\",\"transition-type\":\"\",\"split\":\"full\",\"delay\":\"34\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"margin-unit\":\"px\",\"source-separate\":\",\",\"source-post\":\"meta\",\"source-meta\":\"eg-pricetable-line1\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"6\",\"order\":\"3\",\"container\":\"m\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"enable-hover\":\"\",\"font-size\":\"15\",\"line-height\":\"18\",\"color\":\"#777777\",\"font-family\":\"\\\"Open Sans\\\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"position\":\"relative\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"17\",\"20\",\"17\",\"20\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"1\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#e5e5e5\",\"border-style\":\"solid\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"slideright\",\"transition-type\":\"\",\"split\":\"full\",\"delay\":\"34\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"margin-unit\":\"px\",\"source-separate\":\",\",\"source-post\":\"meta\",\"source-meta\":\"eg-pricetable-line2\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"7\",\"order\":\"4\",\"container\":\"m\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"enable-hover\":\"\",\"font-size\":\"15\",\"line-height\":\"18\",\"color\":\"#777777\",\"font-family\":\"\\\"Open Sans\\\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"position\":\"relative\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"17\",\"20\",\"17\",\"20\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"1\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#e5e5e5\",\"border-style\":\"solid\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"slideright\",\"transition-type\":\"\",\"split\":\"full\",\"delay\":\"34\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"margin-unit\":\"px\",\"source-separate\":\",\",\"source-post\":\"meta\",\"source-meta\":\"eg-pricetable-line3\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"8\",\"order\":\"5\",\"container\":\"m\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"enable-hover\":\"\",\"font-size\":\"15\",\"line-height\":\"18\",\"color\":\"#777777\",\"font-family\":\"\\\"Open Sans\\\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"position\":\"relative\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"17\",\"20\",\"17\",\"20\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"1\",\"0\",\"1\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#e5e5e5\",\"border-style\":\"solid\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"slideright\",\"transition-type\":\"\",\"split\":\"full\",\"delay\":\"34\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"margin-unit\":\"px\",\"source-separate\":\",\",\"source-post\":\"meta\",\"source-meta\":\"eg-pricetable-line4\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"9\",\"order\":\"6\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"text\",\"enable-hover\":\"on\",\"font-size\":\"13\",\"line-height\":\"20\",\"color\":\"#ffffff\",\"font-family\":\"\\\"Raleway\\\"\",\"font-weight\":\"800\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"position\":\"relative\",\"align\":\"t_l\",\"top\":\"0\",\"top-unit-hover\":\"px\",\"right\":\"0\",\"right-unit-hover\":\"px\",\"bottom\":\"0\",\"bottom-unit-hover\":\"px\",\"left\":\"0\",\"left-unit-hover\":\"px\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"20\",\"0\",\"15\",\"0\"],\"padding\":[\"8\",\"25\",\"8\",\"25\"],\"background-color\":\"#e33a0c\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\".eg-kriki-element-2{.eg-kriki-element-4{}\",\"font-size-hover\":\"13\",\"line-height-hover\":\"20\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\\\"Raleway\\\"\",\"font-weight-hover\":\"800\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"#000000\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\".eg-kriki-element-2{.eg-kriki-element-4{}\",\"hideunder\":\"0\",\"transition\":\"skewright\",\"transition-type\":\"\",\"delay\":\"34\",\"link-type\":\"url\",\"url-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"force-important\":\"true\",\"absolute-unit\":\"px\",\"margin-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"source-separate\":\",\",\"source-text\":\"BUY NOW\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"11\",\"order\":\"7\",\"container\":\"m\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"solid\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"solid\",\"background-color-hover\":\"#FFF\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\"}}]", NULL);
INSERT INTO `rtl_lnd_eg_item_skins` VALUES("35", "Richard Nixon", "richard-nixon", "{\"eg-item-skin-element-last-id\":\"12\",\"choose-layout\":\"masonry\",\"show-content\":\"bottom\",\"content-align\":\"center\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"transparent\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"100\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#252525\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"1\",\"1\",\"1\",\"1\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"#444444\",\"full-border-style\":\"solid\",\"full-overflow-hidden\":\"false\",\"content-bg-color\":\"#252525\",\"content-padding\":[\"0\",\"0\",\"0\",\"0\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"none\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"#000000\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"none\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"none\",\"media-animation\":\"none\",\"media-animation-delay\":\"0\"}", "[{\"id\":\"0\",\"order\":\"0\",\"container\":\"c\",\"settings\":{\"0\":\"\",\"source\":\"text\",\"enable-hover\":\"\",\"font-size\":\"50\",\"line-height\":\"50\",\"color\":\"#ffffff\",\"font-family\":\"\\\"Raleway\\\"\",\"font-weight\":\"800\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"80\",\"0\",\"-6\",\"0\"],\"padding\":[\"1\",\"10\",\"5\",\"10\"],\"background-color\":\"#000000\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"flipdown\",\"delay\":\"0\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"out\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"margin-unit\":\"px\",\"source-separate\":\",\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-text\":\"<span style=\\\"font-size:30px; font-weight:300;\\\">$<\\/span> 24.99\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"1\",\"order\":\"0\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"20\",\"line-height\":\"25\",\"color\":\"#ffffff\",\"font-family\":\"\\\"Raleway\\\"\",\"font-weight\":\"800\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"30\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"slideleft\",\"delay\":\"30\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"margin-unit\":\"px\",\"source-separate\":\",\",\"source-post\":\"title\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},\"\",{\"id\":\"3\",\"order\":\"1\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"12\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\\\"Open Sans\\\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"20\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"slideright\",\"delay\":\"34\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"limit-type\":\"words\",\"limit-num\":\"5\",\"transition-type\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"margin-unit\":\"px\",\"source-separate\":\",\",\"source-post\":\"excerpt\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"4\",\"order\":\"3\",\"container\":\"c\",\"settings\":{\"0\":\"\",\"source\":\"text\",\"enable-hover\":\"\",\"font-size\":\"13\",\"line-height\":\"20\",\"color\":\"#ffffff\",\"font-family\":\"\\\"Raleway\\\"\",\"font-weight\":\"700\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"position\":\"relative\",\"align\":\"t_l\",\"top\":\"0\",\"top-unit-hover\":\"px\",\"right\":\"0\",\"right-unit-hover\":\"px\",\"bottom\":\"0\",\"bottom-unit-hover\":\"px\",\"left\":\"0\",\"left-unit-hover\":\"px\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"5\",\"0\",\"5\"],\"background-color\":\"#e33a0c\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\".eg-kriki-element-2{.eg-kriki-element-4{}\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\".eg-kriki-element-2{.eg-kriki-element-4{}\",\"hideunder\":\"0\",\"transition\":\"flipdown\",\"transition-type\":\"out\",\"delay\":\"0\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"force-important\":\"\",\"absolute-unit\":\"px\",\"margin-unit\":\"px\",\"source-separate\":\",\",\"source-text\":\"SHIPPING INCL.\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"5\",\"order\":\"2\",\"container\":\"m\",\"settings\":{\"0\":\"Default\",\"source\":\"text\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"enable-hover\":\"\",\"font-size\":\"15\",\"line-height\":\"18\",\"color\":\"#888888\",\"font-family\":\"\\\"Open Sans\\\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"position\":\"relative\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"17\",\"20\",\"17\",\"20\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"1\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#444444\",\"border-style\":\"solid\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"slideright\",\"transition-type\":\"\",\"split\":\"full\",\"delay\":\"34\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"margin-unit\":\"px\",\"source-separate\":\",\",\"source-text\":\"4gb Webspace Included\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"6\",\"order\":\"3\",\"container\":\"m\",\"settings\":{\"0\":\"Default\",\"source\":\"text\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"enable-hover\":\"\",\"font-size\":\"15\",\"line-height\":\"18\",\"color\":\"#888888\",\"font-family\":\"\\\"Open Sans\\\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"position\":\"relative\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"17\",\"20\",\"17\",\"20\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"1\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#444444\",\"border-style\":\"solid\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"slideright\",\"transition-type\":\"\",\"split\":\"full\",\"delay\":\"34\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"margin-unit\":\"px\",\"source-separate\":\",\",\"source-text\":\"2 Domains\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"7\",\"order\":\"4\",\"container\":\"m\",\"settings\":{\"0\":\"Default\",\"source\":\"text\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"enable-hover\":\"\",\"font-size\":\"15\",\"line-height\":\"18\",\"color\":\"#888888\",\"font-family\":\"\\\"Open Sans\\\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"position\":\"relative\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"17\",\"20\",\"17\",\"20\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"1\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#444444\",\"border-style\":\"solid\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"slideright\",\"transition-type\":\"\",\"split\":\"full\",\"delay\":\"34\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"margin-unit\":\"px\",\"source-separate\":\",\",\"source-text\":\"PHP5 Enabled\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"8\",\"order\":\"5\",\"container\":\"m\",\"settings\":{\"0\":\"Default\",\"source\":\"text\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"enable-hover\":\"\",\"font-size\":\"15\",\"line-height\":\"18\",\"color\":\"#888888\",\"font-family\":\"\\\"Open Sans\\\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"position\":\"relative\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"17\",\"20\",\"17\",\"20\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"1\",\"0\",\"1\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#444444\",\"border-style\":\"solid\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"slideright\",\"transition-type\":\"\",\"split\":\"full\",\"delay\":\"34\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"margin-unit\":\"px\",\"source-separate\":\",\",\"source-text\":\"24h Support\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"9\",\"order\":\"6\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"text\",\"enable-hover\":\"on\",\"font-size\":\"13\",\"line-height\":\"20\",\"color\":\"#ffffff\",\"font-family\":\"\\\"Raleway\\\"\",\"font-weight\":\"800\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"position\":\"relative\",\"align\":\"t_l\",\"top\":\"0\",\"top-unit-hover\":\"px\",\"right\":\"0\",\"right-unit-hover\":\"px\",\"bottom\":\"0\",\"bottom-unit-hover\":\"px\",\"left\":\"0\",\"left-unit-hover\":\"px\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"20\",\"0\",\"15\",\"0\"],\"padding\":[\"8\",\"25\",\"8\",\"25\"],\"background-color\":\"#e33a0c\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\".eg-kriki-element-2{.eg-kriki-element-4{}\",\"font-size-hover\":\"13\",\"line-height-hover\":\"20\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\\\"Raleway\\\"\",\"font-weight-hover\":\"800\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"#000000\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\".eg-kriki-element-2{.eg-kriki-element-4{}\",\"hideunder\":\"0\",\"transition\":\"skewright\",\"transition-type\":\"\",\"delay\":\"34\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"force-important\":\"\",\"absolute-unit\":\"px\",\"margin-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"source-separate\":\",\",\"source-text\":\"BUY NOW\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"11\",\"order\":\"7\",\"container\":\"m\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"solid\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"solid\",\"background-color-hover\":\"#FFF\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\"}},{\"id\":\"12\",\"order\":\"1\",\"container\":\"c\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"solid\",\"shadow-color\":\"#000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"solid\",\"background-color-hover\":\"#FFF\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"#000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\"}}]", NULL);
INSERT INTO `rtl_lnd_eg_item_skins` VALUES("36", "Gerald Ford", "gerald-ford", "{\"eg-item-skin-element-last-id\":\"15\",\"choose-layout\":\"masonry\",\"show-content\":\"bottom\",\"content-align\":\"center\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"rgba(255,255,255,0.25)\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"100\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#f5f5f5\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"1\",\"1\",\"1\",\"1\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"#e5e5e5\",\"full-border-style\":\"solid\",\"full-overflow-hidden\":\"false\",\"content-bg-color\":\"#f5f5f5\",\"content-padding\":[\"0\",\"0\",\"0\",\"0\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"none\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"#000000\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"fade\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"none\",\"media-animation\":\"none\",\"media-animation-delay\":\"0\"}", "[{\"id\":\"1\",\"order\":\"0\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"text\",\"enable-hover\":\"\",\"font-size\":\"20\",\"line-height\":\"25\",\"color\":\"#000000\",\"font-family\":\"\\\"Raleway\\\"\",\"font-weight\":\"700\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"30\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"slideleft\",\"delay\":\"30\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"margin-unit\":\"px\",\"source-separate\":\",\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-text\":\"PREMIUM PRODUCT\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"14\",\"order\":\"0\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"position\":\"relative\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"5\",\"0\",\"0\"],\"padding\":[\"17\",\"17\",\"17\",\"17\"],\"background-color\":\"rgba(0,0,0,0.65)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"50\",\"50\",\"50\",\"50\"],\"border-radius-unit\":\"%\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"#000000\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"50\",\"50\",\"50\",\"50\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"flipup\",\"transition-type\":\"\",\"split\":\"full\",\"delay\":\"10\",\"link-type\":\"lightbox\",\"url-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-separate\":\",\",\"margin-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-icon\":\"eg-icon-search\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"3\",\"order\":\"1\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"text\",\"enable-hover\":\"\",\"font-size\":\"12\",\"line-height\":\"22\",\"color\":\"#777777\",\"font-family\":\"\\\"Open Sans\\\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"20\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"slideright\",\"delay\":\"34\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"margin-unit\":\"px\",\"source-separate\":\",\",\"source-text\":\"The best for your small business\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"15\",\"order\":\"1\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"position\":\"relative\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"17\",\"17\",\"17\",\"17\"],\"background-color\":\"rgba(0,0,0,0.65)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"50\",\"50\",\"50\",\"50\"],\"border-radius-unit\":\"%\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"#000000\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"50\",\"50\",\"50\",\"50\"],\"border-radius-unit-hover\":\"%\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"flipup\",\"transition-type\":\"\",\"split\":\"full\",\"delay\":\"20\",\"link-type\":\"post\",\"url-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-separate\":\",\",\"margin-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-icon\":\"eg-icon-basket\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"11\",\"order\":\"2\",\"container\":\"m\",\"settings\":{\"0\":\"Default\",\"source\":\"text\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"enable-hover\":\"\",\"font-size\":\"50\",\"line-height\":\"50\",\"color\":\"#000000\",\"font-family\":\"\\\"Raleway\\\"\",\"font-weight\":\"800\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"position\":\"relative\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"20\",\"20\",\"0\",\"20\"],\"background-color\":\"#eeeeee\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"1\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#e5e5e5\",\"border-style\":\"solid\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"slideright\",\"transition-type\":\"\",\"split\":\"full\",\"delay\":\"34\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"margin-unit\":\"px\",\"source-separate\":\",\",\"source-text\":\"<span style=\\\"font-size:30px; font-weight:300;\\\">$<\\/span> 39.99\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"12\",\"order\":\"3\",\"container\":\"m\",\"settings\":{\"0\":\"Default\",\"source\":\"text\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"enable-hover\":\"\",\"font-size\":\"12\",\"line-height\":\"15\",\"color\":\"#000000\",\"font-family\":\"\\\"Raleway\\\"\",\"font-weight\":\"700\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"position\":\"relative\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"20\",\"20\",\"20\"],\"background-color\":\"#eeeeee\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#e5e5e5\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"slideright\",\"transition-type\":\"\",\"split\":\"full\",\"delay\":\"34\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"margin-unit\":\"px\",\"source-separate\":\",\",\"source-text\":\"INCL. SHIPPING\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"5\",\"order\":\"4\",\"container\":\"m\",\"settings\":{\"0\":\"Default\",\"source\":\"text\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"enable-hover\":\"\",\"font-size\":\"15\",\"line-height\":\"18\",\"color\":\"#777777\",\"font-family\":\"\\\"Open Sans\\\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"position\":\"relative\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"17\",\"20\",\"17\",\"20\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"1\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#e5e5e5\",\"border-style\":\"solid\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"slideright\",\"transition-type\":\"\",\"split\":\"full\",\"delay\":\"34\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"margin-unit\":\"px\",\"source-separate\":\",\",\"source-text\":\"4GB Webspace Included\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"6\",\"order\":\"5\",\"container\":\"m\",\"settings\":{\"0\":\"Default\",\"source\":\"text\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"enable-hover\":\"\",\"font-size\":\"15\",\"line-height\":\"18\",\"color\":\"#777777\",\"font-family\":\"\\\"Open Sans\\\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"position\":\"relative\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"17\",\"20\",\"17\",\"20\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"1\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#e5e5e5\",\"border-style\":\"solid\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"slideright\",\"transition-type\":\"\",\"split\":\"full\",\"delay\":\"34\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"margin-unit\":\"px\",\"source-separate\":\",\",\"source-text\":\"2 Domains\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"7\",\"order\":\"6\",\"container\":\"m\",\"settings\":{\"0\":\"Default\",\"source\":\"text\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"enable-hover\":\"\",\"font-size\":\"15\",\"line-height\":\"18\",\"color\":\"#777777\",\"font-family\":\"\\\"Open Sans\\\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"position\":\"relative\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"17\",\"20\",\"17\",\"20\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"1\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#e5e5e5\",\"border-style\":\"solid\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"slideright\",\"transition-type\":\"\",\"split\":\"full\",\"delay\":\"34\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"margin-unit\":\"px\",\"source-separate\":\",\",\"source-text\":\"PHP5 Enabled\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"8\",\"order\":\"7\",\"container\":\"m\",\"settings\":{\"0\":\"Default\",\"source\":\"text\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"enable-hover\":\"\",\"font-size\":\"15\",\"line-height\":\"18\",\"color\":\"#777777\",\"font-family\":\"\\\"Open Sans\\\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"position\":\"relative\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"20\",\"20\",\"20\",\"20\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"1\",\"0\",\"1\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#e5e5e5\",\"border-style\":\"solid\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"slideright\",\"transition-type\":\"\",\"split\":\"full\",\"delay\":\"34\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"margin-unit\":\"px\",\"source-separate\":\",\",\"source-text\":\"24h Support\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"9\",\"order\":\"8\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"text\",\"enable-hover\":\"on\",\"font-size\":\"13\",\"line-height\":\"20\",\"color\":\"#ffffff\",\"font-family\":\"\\\"Raleway\\\"\",\"font-weight\":\"700\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"position\":\"relative\",\"align\":\"t_l\",\"top\":\"0\",\"top-unit-hover\":\"px\",\"right\":\"0\",\"right-unit-hover\":\"px\",\"bottom\":\"0\",\"bottom-unit-hover\":\"px\",\"left\":\"0\",\"left-unit-hover\":\"px\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"20\",\"0\",\"20\",\"0\"],\"padding\":[\"8\",\"25\",\"8\",\"25\"],\"background-color\":\"#e33a0c\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\".eg-kriki-element-2{.eg-kriki-element-4{}\",\"font-size-hover\":\"13\",\"line-height-hover\":\"20\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\\\"Raleway\\\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"#000000\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\".eg-kriki-element-2{.eg-kriki-element-4{}\",\"hideunder\":\"0\",\"transition\":\"skewright\",\"transition-type\":\"\",\"delay\":\"34\",\"link-type\":\"post\",\"url-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"force-important\":\"true\",\"absolute-unit\":\"px\",\"margin-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"source-separate\":\",\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-text\":\"BUY NOW\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"13\",\"order\":\"9\",\"container\":\"m\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"solid\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"solid\",\"background-color-hover\":\"#FFF\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\"}}]", NULL);
INSERT INTO `rtl_lnd_eg_item_skins` VALUES("37", "Jimmy Carter", "jimmy-carter", "{\"eg-item-skin-element-last-id\":\"24\",\"choose-layout\":\"masonry\",\"show-content\":\"bottom\",\"content-align\":\"left\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"transparent\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"100\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#ffffff\",\"full-padding\":[\"30\",\"30\",\"27\",\"30\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"#e5e5e5\",\"full-border-style\":\"solid\",\"content-bg-color\":\"#ffffff\",\"content-padding\":[\"27\",\"0\",\"0\",\"0\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"#e5e5e5\",\"content-border-style\":\"solid\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"#000000\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"3\",\"6\",\"1\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"fade\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"none\",\"media-animation\":\"3dturnright\",\"media-animation-delay\":\"8\",\"google-fonts\":[\"Droid+Serif:400,700\",\"Open+Sans:400,600,700,800\"]}", "[{\"id\":\"0\",\"order\":\"0\",\"container\":\"c\",\"settings\":{\"0\":\"\",\"source\":\"text\",\"enable-hover\":\"\",\"font-size\":\"13\",\"line-height\":\"15\",\"color\":\"#363839\",\"font-family\":\"\\\"Open Sans\\\"\",\"font-weight\":\"800\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"left\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"5\",\"10\",\"5\",\"10\"],\"background-color\":\"rgba(255,255,255,0.75)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"skewright\",\"delay\":\"15\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"margin-unit\":\"px\",\"source-separate\":\",\",\"source-text\":\"I\'m a custom caption\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"1\",\"order\":\"0\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"on\",\"font-size\":\"20\",\"line-height\":\"25\",\"color\":\"#000000\",\"font-family\":\"\\\"Droid Serif\\\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"block\",\"text-align\":\"left\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"20\",\"line-height-hover\":\"25\",\"color-hover\":\"#000000\",\"font-family-hover\":\"\\\"Droid Serif\\\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"transparent\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"15\",\"link-type\":\"post\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top\":\"0\",\"top-unit\":\"px\",\"right\":\"0\",\"right-unit\":\"px\",\"bottom\":\"0\",\"bottom-unit\":\"px\",\"left\":\"0\",\"left-unit\":\"px\",\"split\":\"full\",\"transition-type\":\"\",\"tag-type\":\"div\",\"align\":\"t_l\",\"margin-unit\":\"px\",\"top-left-right\":\"0\",\"bottom-left-right\":\"0\",\"force-important\":\"true\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"limit-type\":\"words\",\"limit-num\":\"10\",\"source-separate\":\",\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"source-post\":\"title\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\"}},{\"id\":\"2\",\"order\":\"1\",\"container\":\"c\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"solid\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"solid\",\"background-color-hover\":\"#FFF\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-separate\":\",\",\"source-text\":\"LINE-BREAK\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\"}},{\"id\":\"3\",\"order\":\"1\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"on\",\"font-size\":\"12\",\"line-height\":\"14\",\"color\":\"#999999\",\"font-family\":\"\\\"Open Sans\\\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"left\",\"clear\":\"none\",\"margin\":[\"5\",\"20\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"#ffffff\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#aaaaaa\",\"border-style\":\"solid\",\"css\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000000\",\"font-family-hover\":\"\\\"Open Sans\\\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#aaaaaa\",\"border-style-hover\":\"solid\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"34\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"margin-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"source-separate\":\", \",\"source-post\":\"cat_list\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\"}},{\"id\":\"4\",\"order\":\"2\",\"container\":\"c\",\"settings\":{\"0\":\"\",\"source\":\"text\",\"enable-hover\":\"\",\"font-size\":\"13\",\"line-height\":\"15\",\"color\":\"#ffffff\",\"font-family\":\"\\\"Open Sans\\\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"position\":\"relative\",\"align\":\"t_l\",\"top\":\"0\",\"top-unit-hover\":\"px\",\"right\":\"0\",\"right-unit-hover\":\"px\",\"bottom\":\"0\",\"bottom-unit-hover\":\"px\",\"left\":\"0\",\"left-unit-hover\":\"px\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"left\",\"clear\":\"both\",\"margin\":[\"-5\",\"0\",\"0\",\"0\"],\"padding\":[\"5\",\"10\",\"5\",\"10\"],\"background-color\":\"#e74124\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\".eg-kriki-element-2{.eg-kriki-element-4{}\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\".eg-kriki-element-2{.eg-kriki-element-4{}\",\"hideunder\":\"0\",\"transition\":\"skewright\",\"transition-type\":\"\",\"delay\":\"9\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"force-important\":\"\",\"absolute-unit\":\"px\",\"margin-unit\":\"px\",\"source-separate\":\",\",\"source-text\":\"ADD ANYTHING\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"5\",\"order\":\"2\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"on\",\"font-size\":\"12\",\"line-height\":\"14\",\"color\":\"#777777\",\"font-family\":\"\\\"Open Sans\\\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"left\",\"clear\":\"none\",\"margin\":[\"5\",\"20\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"#ffffff\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000000\",\"font-family-hover\":\"\\\"Open Sans\\\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"34\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"margin-unit\":\"px\",\"source-separate\":\",\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"source-post\":\"num_comments\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\"}},{\"id\":\"6\",\"order\":\"3\",\"container\":\"m\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top\":\"0\",\"top-unit\":\"px\",\"right\":\"0\",\"right-unit\":\"px\",\"bottom\":\"0\",\"bottom-unit\":\"px\",\"left\":\"0\",\"left-unit\":\"px\",\"split\":\"full\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"align\":\"t_l\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"background-color-hover\":\"#FFF\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"top-left-right\":\"0\",\"bottom-left-right\":\"0\",\"force-important\":\"\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"absolute-unit\":\"px\",\"source-separate\":\",\",\"source-text\":\"LINE-BREAK\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\"}},{\"id\":\"7\",\"order\":\"4\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"text\",\"enable-hover\":\"\",\"font-size\":\"6\",\"line-height\":\"7\",\"color\":\"transparent\",\"font-family\":\"\",\"font-weight\":\"300\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"2\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#000000\",\"border-style\":\"solid\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"25\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-left-right\":\"0\",\"bottom-left-right\":\"0\",\"split\":\"full\",\"transition-type\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"margin-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"absolute-unit\":\"px\",\"source-text\":\"anemptytextlline\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\"}},{\"id\":\"8\",\"order\":\"5\",\"container\":\"m\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-left-right\":\"0\",\"bottom-left-right\":\"0\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"background-color-hover\":\"#FFF\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\"}},{\"id\":\"9\",\"order\":\"6\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"15\",\"line-height\":\"22\",\"color\":\"#555555\",\"font-family\":\"\\\"Droid Serif\\\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"block\",\"text-align\":\"left\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"5\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"20\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-left-right\":\"0\",\"bottom-left-right\":\"0\",\"transition-type\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"margin-unit\":\"px\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"limit-type\":\"words\",\"limit-num\":\"15\",\"source-separate\":\",\",\"source-post\":\"excerpt\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\"}},{\"id\":\"10\",\"order\":\"7\",\"container\":\"m\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-left-right\":\"0\",\"bottom-left-right\":\"0\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"background-color-hover\":\"#FFF\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\"}},{\"id\":\"11\",\"order\":\"8\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"text\",\"enable-hover\":\"on\",\"font-size\":\"15\",\"line-height\":\"14\",\"color\":\"#e74124\",\"font-family\":\"\\\"Droid Serif\\\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"display\":\"block\",\"text-align\":\"left\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"20\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"#ffffff\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"15\",\"line-height-hover\":\"14\",\"color-hover\":\"#000000\",\"font-family-hover\":\"\\\"Droid Serif\\\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"capitalize\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"34\",\"link-type\":\"post\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"margin-unit\":\"px\",\"source-separate\":\",\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"source-text\":\"<i class=\\\"eg-icon-angle-right\\\"><\\/i> Read More\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\"}}]", NULL);
INSERT INTO `rtl_lnd_eg_item_skins` VALUES("38", "Ronald Reagan", "ronald-reagan", "{\"eg-item-skin-element-last-id\":\"8\",\"choose-layout\":\"masonry\",\"show-content\":\"bottom\",\"content-align\":\"left\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"transparent\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"100\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"transparent\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"transparent\",\"full-border-style\":\"none\",\"full-overflow-hidden\":\"false\",\"content-bg-color\":\"#ffffff\",\"content-padding\":[\"20\",\"20\",\"20\",\"20\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"none\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"#000000\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"none\",\"cover-animation-center-type\":\"out\",\"cover-animation-delay-center\":\"4\",\"cover-animation-center\":\"fade\",\"cover-animation-bottom-type\":\"out\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"none\",\"media-animation\":\"none\",\"media-animation-delay\":\"0\"}", "[{\"id\":\"0\",\"order\":\"0\",\"container\":\"tl\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"13\",\"line-height\":\"20\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"700\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"left\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"10\",\"20\",\"10\",\"20\"],\"background-color\":\"#4d384b\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"slideup\",\"delay\":\"6\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"limit-type\":\"none\",\"limit-num\":\"\",\"transition-type\":\"out\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"margin-unit\":\"px\",\"source-separate\":\"\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-post\":\"date_modified\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"1\",\"order\":\"0\",\"container\":\"br\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"20\",\"line-height\":\"23\",\"color\":\"#ffffff\",\"font-family\":\"\\\"Droid Serif\\\"\",\"font-weight\":\"300\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"block\",\"text-align\":\"left\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"10\",\"10\"],\"padding\":[\"5\",\"10\",\"5\",\"10\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"slidedown\",\"delay\":\"15\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"limit-type\":\"words\",\"limit-num\":\"10\",\"transition-type\":\"out\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"margin-unit\":\"px\",\"source-separate\":\",\",\"source-post\":\"title\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"2\",\"order\":\"0\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"on\",\"font-size\":\"12\",\"line-height\":\"14\",\"color\":\"#999999\",\"font-family\":\"\\\"Open Sans\\\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"20\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000000\",\"font-family-hover\":\"\\\"Open Sans\\\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"transparent\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"slideright\",\"delay\":\"34\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"margin-unit\":\"px\",\"source-separate\":\", \",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"source-post\":\"cat_list\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"8\",\"order\":\"0\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"20\",\"line-height\":\"28\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"17\",\"17\",\"17\",\"17\"],\"background-color\":\"#000000\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"20\",\"line-height-hover\":\"28\",\"color-hover\":\"#000000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"rotatescale\",\"delay\":\"10\",\"link-type\":\"post\",\"url-link\":\"\",\"javascript-link\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"margin-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"source-icon\":\"eg-icon-link\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"4\",\"order\":\"1\",\"container\":\"m\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"enable-hover\":\"on\",\"font-size\":\"12\",\"line-height\":\"14\",\"color\":\"#999\",\"font-family\":\"\\\"Open Sans\\\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"position\":\"relative\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000000\",\"font-family-hover\":\"\\\"Open Sans\\\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"transparent\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"slideright\",\"transition-type\":\"\",\"split\":\"full\",\"delay\":\"34\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"margin-unit\":\"px\",\"source-separate\":\",\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"source-post\":\"num_comments\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"5\",\"order\":\"2\",\"container\":\"m\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"limit-type\":\"words\",\"limit-num\":\"20\",\"enable-hover\":\"\",\"font-size\":\"15\",\"line-height\":\"20\",\"color\":\"#444444\",\"font-family\":\"\\\"Droid Serif\\\"\",\"font-weight\":\"300\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"position\":\"relative\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"display\":\"block\",\"text-align\":\"left\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"7\",\"0\",\"0\",\"0\"],\"padding\":[\"15\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"1\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#e5e5e5\",\"border-style\":\"solid\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"slideright\",\"transition-type\":\"\",\"split\":\"full\",\"delay\":\"34\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"margin-unit\":\"px\",\"source-post\":\"excerpt\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}}]", NULL);
INSERT INTO `rtl_lnd_eg_item_skins` VALUES("39", "GeorgeBush", "georgebush", "{\"eg-item-skin-element-last-id\":\"4\",\"choose-layout\":\"even\",\"show-content\":\"none\",\"content-align\":\"left\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"content\",\"container-background-color\":\"#e33a0c\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"100\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#ffffff\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"transparent\",\"full-border-style\":\"none\",\"content-bg-color\":\"#ffffff\",\"content-padding\":[\"0\",\"0\",\"0\",\"0\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"none\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"#000000\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"fade\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"covergrowup\",\"cover-group-animation\":\"none\",\"media-animation\":\"none\",\"media-animation-delay\":\"0\",\"google-fonts\":[\"Raleway:400,800,900\"]}", "[{\"id\":\"0\",\"order\":\"0\",\"container\":\"br\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"limit-type\":\"none\",\"limit-num\":\"3\",\"enable-hover\":\"\",\"font-size\":\"35\",\"line-height\":\"38\",\"color\":\"#ffffff\",\"font-family\":\"\\\"Raleway\\\"\",\"font-weight\":\"800\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"position\":\"relative\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"display\":\"block\",\"text-align\":\"left\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"20\",\"0\",\"0\",\"20\"],\"padding\":[\"0\",\"20\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"none\",\"transition-type\":\"\",\"split\":\"full\",\"delay\":\"30\",\"link-type\":\"post\",\"url-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-separate\":\",\",\"margin-unit\":\"px\",\"source-post\":\"title\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\"}},{\"id\":\"1\",\"order\":\"1\",\"container\":\"br\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"limit-type\":\"words\",\"limit-num\":\"8\",\"enable-hover\":\"\",\"font-size\":\"18\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\\\"Raleway\\\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"position\":\"relative\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"display\":\"block\",\"text-align\":\"left\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"5\",\"0\",\"20\",\"20\"],\"padding\":[\"0\",\"20\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"none\",\"transition-type\":\"\",\"split\":\"full\",\"delay\":\"30\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-separate\":\",\",\"margin-unit\":\"px\",\"source-post\":\"excerpt\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\"}}]", NULL);
INSERT INTO `rtl_lnd_eg_item_skins` VALUES("40", "Essential Preview", "essential-preview", "{\"eg-item-skin-element-last-id\":\"9\",\"choose-layout\":\"even\",\"show-content\":\"none\",\"content-align\":\"center\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"rgba(10,10,10,0.75)\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"100\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#ffffff\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"#000000\",\"full-border-style\":\"none\",\"full-overflow-hidden\":\"false\",\"content-bg-color\":\"#ffffff\",\"content-padding\":[\"0\",\"0\",\"0\",\"0\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"none\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"#000000\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"cover-animation-top-type\":\"out\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"none\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"fade\",\"cover-animation-bottom-type\":\"out\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"none\",\"cover-group-animation\":\"none\",\"media-animation\":\"none\",\"media-animation-delay\":\"0\",\"google-fonts\":[\"Open+Sans:700;800\"]}", "[{\"id\":\"1\",\"order\":\"0\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"16\",\"line-height\":\"24\",\"color\":\"#ffffff\",\"font-family\":\"\\\"Open Sans\\\"\",\"font-weight\":\"700\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"4\",\"12\",\"3\",\"12\"],\"background-color\":\"rgba(255,255,255,0.10)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"transparent\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.20)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"flipdown\",\"delay\":\"0\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"source-post\":\"title\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"9\",\"order\":\"1\",\"container\":\"c\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"solid\",\"shadow-color\":\"#000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"solid\",\"background-color-hover\":\"#FFF\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"#000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\"}},{\"id\":\"0\",\"order\":\"2\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"text\",\"enable-hover\":\"on\",\"font-size\":\"12\",\"line-height\":\"24\",\"color\":\"#ffffff\",\"font-family\":\"\\\"Open Sans\\\"\",\"font-weight\":\"800\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"3\",\"10\",\"2\",\"10\"],\"background-color\":\"#e33a0c\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"transparent\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#617f52\",\"border-style\":\"none\",\"font-size-hover\":\"12\",\"line-height-hover\":\"24\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\\\"Open Sans\\\"\",\"font-weight-hover\":\"800\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"#ff4d1c\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"transparent\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#617f52\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"slideup\",\"delay\":\"0\",\"link-type\":\"meta\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"source-text\":\"Check it Out\",\"link-type-meta\":\"eg-demogrid-link\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}}]", NULL);
INSERT INTO `rtl_lnd_eg_item_skins` VALUES("41", "More Demo Examples", "more-demo-examples", "{\"eg-item-skin-element-last-id\":\"9\",\"choose-layout\":\"even\",\"show-content\":\"none\",\"content-align\":\"center\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"rgba(64,70,85,0.60)\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"100\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#ffffff\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"#000000\",\"full-border-style\":\"none\",\"full-overflow-hidden\":\"false\",\"content-bg-color\":\"#ffffff\",\"content-padding\":[\"0\",\"0\",\"0\",\"0\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"none\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"#000000\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"cover-animation-top-type\":\"out\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"none\",\"cover-animation-center-type\":\"out\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"fade\",\"cover-animation-bottom-type\":\"out\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"none\",\"cover-group-animation\":\"none\",\"media-animation\":\"none\",\"media-animation-delay\":\"0\",\"google-fonts\":[\"Open+Sans:700;800\"]}", "[{\"id\":\"1\",\"order\":\"0\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"16\",\"line-height\":\"24\",\"color\":\"#ffffff\",\"font-family\":\"\\\"Open Sans\\\"\",\"font-weight\":\"700\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"4\",\"12\",\"3\",\"12\"],\"background-color\":\"rgba(0,0,0,0.75)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"transparent\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.20)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"flipdown\",\"delay\":\"0\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"source-post\":\"title\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"9\",\"order\":\"1\",\"container\":\"c\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"solid\",\"shadow-color\":\"#000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"solid\",\"background-color-hover\":\"#FFF\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"#000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\"}},{\"id\":\"0\",\"order\":\"2\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"text\",\"enable-hover\":\"on\",\"font-size\":\"12\",\"line-height\":\"24\",\"color\":\"#ffffff\",\"font-family\":\"\\\"Open Sans\\\"\",\"font-weight\":\"800\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"3\",\"10\",\"2\",\"10\"],\"background-color\":\"#e33a0c\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"transparent\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#617f52\",\"border-style\":\"none\",\"font-size-hover\":\"12\",\"line-height-hover\":\"24\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\\\"Open Sans\\\"\",\"font-weight-hover\":\"800\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"#ff4d1c\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"transparent\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#617f52\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"slideup\",\"delay\":\"0\",\"link-type\":\"meta\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"source-text\":\"Check it Out\",\"link-type-meta\":\"eg-demogrid-link\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}}]", NULL);
INSERT INTO `rtl_lnd_eg_item_skins` VALUES("42", "Wilbert", "wilbert", "{\"eg-item-skin-element-last-id\":\"2\",\"choose-layout\":\"even\",\"show-content\":\"none\",\"content-align\":\"left\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"rgba(17,17,17,0.65)\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"100\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#ffffff\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"transparent\",\"full-border-style\":\"none\",\"full-overflow-hidden\":\"false\",\"content-bg-color\":\"#ffffff\",\"content-padding\":[\"0\",\"0\",\"0\",\"0\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"none\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"#000000\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"out\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"fade\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"none\",\"media-animation\":\"none\",\"media-animation-delay\":\"0\"}", "[{\"id\":\"0\",\"order\":\"0\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"text\",\"enable-hover\":\"\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"none\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"transparent\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"0\",\"link-type\":\"lightbox\",\"url-link\":\"\",\"javascript-link\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"out\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"margin-unit\":\"px\",\"source-separate\":\",\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"source-text\":\"<img src=\\\"%eg-clients-icon%\\\" \\/>\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\"}}]", NULL);
INSERT INTO `rtl_lnd_eg_item_skins` VALUES("43", "Phillie", "phillie", "{\"eg-item-skin-element-last-id\":\"3\",\"choose-layout\":\"even\",\"show-content\":\"none\",\"content-align\":\"left\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"#ffffff\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"100\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#ffffff\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"1\",\"1\",\"1\",\"1\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"#ffffff\",\"full-border-style\":\"solid\",\"full-overflow-hidden\":\"false\",\"content-bg-color\":\"#ffffff\",\"content-padding\":[\"0\",\"0\",\"0\",\"0\"],\"content-border\":[\"1\",\"1\",\"1\",\"1\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"#ffffff\",\"content-border-style\":\"solid\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"#000000\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"out\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"none\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"none\",\"media-animation\":\"none\",\"media-animation-delay\":\"0\",\"google-fonts\":[\"Raleway:700,800,900\"]}", "[{\"id\":\"0\",\"order\":\"0\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"text\",\"enable-hover\":\"\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"none\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"transparent\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"0\",\"link-type\":\"lightbox\",\"url-link\":\"\",\"javascript-link\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"out\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"margin-unit\":\"px\",\"source-separate\":\",\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"source-text\":\"<img src=\\\"%eg-clients-icon-dark%\\\" \\/>\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\"}},{\"id\":\"3\",\"order\":\"0\",\"container\":\"tl\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"13\",\"line-height\":\"20\",\"color\":\"#ffffff\",\"font-family\":\"\\\"Raleway\\\"\",\"font-weight\":\"800\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"2\",\"7\",\"2\",\"7\"],\"background-color\":\"#000000\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-size-x\":\"100\",\"background-size-y\":\"100\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"slideup\",\"delay\":\"0\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-bottom\":\"81.67\",\"left-right\":\"38.5\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"%\",\"margin-unit\":\"px\",\"source-post\":\"title\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}}]", NULL);
INSERT INTO `rtl_lnd_eg_item_skins` VALUES("44", "Jason", "jason", "{\"eg-item-skin-element-last-id\":\"32\",\"choose-layout\":\"masonry\",\"show-content\":\"bottom\",\"content-align\":\"center\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"rgba(255,255,255,0.20)\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"100\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#ffffff\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"1\",\"1\",\"1\",\"1\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"#e5e5e5\",\"full-border-style\":\"solid\",\"full-overflow-hidden\":\"true\",\"content-bg-color\":\"#ffffff\",\"content-padding\":[\"30\",\"30\",\"30\",\"30\"],\"content-border\":[\"1\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"#e5e5e5\",\"content-border-style\":\"solid\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"rgba(0,0,0,0.20)\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"-1\",\"2\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"fade\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"fade\",\"media-animation\":\"none\",\"media-animation-delay\":\"0\"}", "[{\"id\":\"0\",\"order\":\"0\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"15\",\"line-height\":\"18\",\"color\":\"#000000\",\"font-family\":\"\\\"Raleway\\\"\",\"font-weight\":\"700\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"30\",\"link-type\":\"post\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"20\",\"hide-on-video\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-post\":\"title\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"32\",\"order\":\"0\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"17\",\"17\",\"17\",\"17\"],\"background-color\":\"#e33a0c\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-size-x\":\"100\",\"background-size-y\":\"100\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"#000000\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"slide\",\"delay\":\"10\",\"link-type\":\"lightbox\",\"url-link\":\"\",\"javascript-link\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"hide-on-video\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"margin-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"source-icon\":\"eg-icon-search\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"25\",\"order\":\"1\",\"container\":\"m\",\"settings\":{\"0\":\"Default\",\"source\":\"woocommerce\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"enable-hover\":\"\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#89af72\",\"font-family\":\"\\\"Open Sans\\\"\",\"font-weight\":\"700\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"position\":\"relative\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"10\",\"0\",\"0\",\"0\"],\"padding\":[\"2\",\"7\",\"1\",\"7\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"slideleft\",\"transition-type\":\"\",\"split\":\"full\",\"delay\":\"30\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-separate\":\",\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"margin-unit\":\"px\",\"source-woocommerce\":\"wc_full_price\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"31\",\"order\":\"2\",\"container\":\"m\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"solid\",\"shadow-color\":\"#000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"solid\",\"background-color-hover\":\"#FFF\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"#000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"30\",\"order\":\"3\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"woocommerce\",\"enable-hover\":\"\",\"font-size\":\"13\",\"line-height\":\"30\",\"color\":\"#000000\",\"font-family\":\"\\\"Open Sans\\\"\",\"font-weight\":\"700\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-size-x\":\"100\",\"background-size-y\":\"100\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"slideleft\",\"delay\":\"30\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"hide-on-video\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"margin-unit\":\"px\",\"source-woocommerce\":\"wc_star_rating\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"26\",\"order\":\"4\",\"container\":\"m\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"solid\",\"shadow-color\":\"#000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"solid\",\"background-color-hover\":\"#FFF\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"#000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"28\",\"order\":\"5\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"woocommerce\",\"enable-hover\":\"on\",\"font-size\":\"12\",\"line-height\":\"20\",\"color\":\"#ffffff\",\"font-family\":\"\\\"Open Sans\\\"\",\"font-weight\":\"700\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"5\",\"10\",\"4\",\"10\"],\"background-color\":\"#e33a0c\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-size-x\":\"100\",\"background-size-y\":\"100\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"5\",\"5\",\"5\",\"5\"],\"border-radius-unit\":\"px\",\"border-color\":\"#e5e5e5\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"20\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\\\"Open Sans\\\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"capitalize\",\"background-color-hover\":\"#000000\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"5\",\"5\",\"5\",\"5\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#e33a0c\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"flipup\",\"delay\":\"10\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"hide-on-video\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"margin-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"source-woocommerce\":\"wc_add_to_cart_button\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}}]", NULL);
INSERT INTO `rtl_lnd_eg_item_skins` VALUES("45", "FlickrStream", "flickrstream", "{\"eg-item-skin-element-last-id\":\"19\",\"choose-layout\":\"even\",\"show-content\":\"bottom\",\"content-align\":\"left\",\"image-repeat\":\"no-repeat\",\"image-fit\":\"cover\",\"image-align-horizontal\":\"center\",\"image-align-vertical\":\"center\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"rgba(0,0,0,0.50)\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"100\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#222222\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"transparent\",\"full-border-style\":\"none\",\"full-overflow-hidden\":\"false\",\"content-bg-color\":\"#222222\",\"content-padding\":[\"0\",\"0\",\"0\",\"0\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"none\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"#000000\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"fade\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"fade\",\"media-animation\":\"none\",\"media-animation-delay\":\"0\",\"link-set-to\":\"cover\",\"link-link-type\":\"lightbox\",\"link-url-link\":\"\",\"link-meta-link\":\"\",\"link-javascript-link\":\"\",\"link-target\":\"_self\"}", "[{\"id\":\"1\",\"order\":\"0\",\"container\":\"br\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"enable-hover\":\"\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"right\",\"clear\":\"none\",\"margin\":[\"0\",\"15\",\"10\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(0,0,0,0.50)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"fade\",\"delay\":\"0\",\"link-type\":\"post\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"css\":\"\",\"css-hover\":\"\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-function\":\"link\",\"hideunderheight\":\"0\",\"hidetype\":\"visibility\",\"link-target\":\"_blank\",\"source-text-style-disable\":\"\",\"show-on-lightbox-video\":\"\",\"source-icon\":\"eg-icon-link\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},\"\",{\"id\":\"15\",\"order\":\"1\",\"container\":\"br\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"enable-hover\":\"\",\"font-size\":\"13\",\"line-height\":\"19\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"700\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"position\":\"relative\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"left\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"15\",\"20\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"transition\":\"fade\",\"transition-type\":\"\",\"delay\":\"0\",\"link-type\":\"none\",\"url-link\":\"\",\"meta-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-function\":\"link\",\"hideunderheight\":\"0\",\"hidetype\":\"visibility\",\"link-target\":\"_self\",\"source-text-style-disable\":\"\",\"margin-unit\":\"px\",\"source-post\":\"title\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},\"\",{\"id\":\"17\",\"order\":\"2\",\"container\":\"br\",\"settings\":{\"0\":\"Default\",\"source\":\"text\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"enable-hover\":\"\",\"font-size\":\"13\",\"line-height\":\"19\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"700\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"position\":\"relative\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"left\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"15\",\"20\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"transition\":\"fade\",\"transition-type\":\"\",\"delay\":\"0\",\"link-type\":\"none\",\"url-link\":\"\",\"meta-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-function\":\"link\",\"hideunderheight\":\"0\",\"hidetype\":\"visibility\",\"link-target\":\"_self\",\"source-text-style-disable\":\"\",\"margin-unit\":\"px\",\"show-on-lightbox-video\":\"\",\"source-text\":\"<i class=\\\"eg-icon-star-empty\\\"><\\/i> %favorites%\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"19\",\"order\":\"3\",\"container\":\"br\",\"settings\":{\"0\":\"Default\",\"source\":\"text\",\"source-separate\":\",\",\"source-function\":\"link\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"source-text-style-disable\":\"\",\"enable-hover\":\"\",\"font-size\":\"13\",\"line-height\":\"19\",\"color\":\"rgba(255,255,255,0.5)\",\"font-family\":\"\",\"font-weight\":\"700\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"position\":\"relative\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"left\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"15\",\"20\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"hideunderheight\":\"0\",\"hidetype\":\"visibility\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"transition\":\"fade\",\"transition-type\":\"\",\"delay\":\"0\",\"link-type\":\"none\",\"url-link\":\"\",\"meta-link\":\"\",\"javascript-link\":\"\",\"link-target\":\"_self\",\"tag-type\":\"div\",\"force-important\":\"true\",\"facebook-sharing-link\":\"site\",\"facebook-link-url\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"margin-unit\":\"px\",\"show-on-lightbox-video\":\"\",\"source-text\":\"by %author_name%\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}}]", NULL);
INSERT INTO `rtl_lnd_eg_item_skins` VALUES("46", "FacebookStream", "facebookstream", "{\"eg-item-skin-element-last-id\":\"33\",\"choose-layout\":\"masonry\",\"show-content\":\"top\",\"content-align\":\"left\",\"image-repeat\":\"no-repeat\",\"image-fit\":\"cover\",\"image-align-horizontal\":\"center\",\"image-align-vertical\":\"center\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"rgba(54,88,153,0.65)\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"100\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#ffffff\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"#e5e5e5\",\"full-border-style\":\"none\",\"full-overflow-hidden\":\"false\",\"content-bg-color\":\"#ffffff\",\"content-padding\":[\"30\",\"30\",\"26\",\"30\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"double\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"#000000\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"1\",\"10\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"fade\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"none\",\"media-animation\":\"none\",\"media-animation-delay\":\"0\",\"link-set-to\":\"none\",\"link-link-type\":\"none\",\"link-url-link\":\"\",\"link-meta-link\":\"\",\"link-javascript-link\":\"\",\"link-target\":\"_self\"}", "[{\"id\":\"0\",\"order\":\"0\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"14\",\"line-height\":\"22\",\"color\":\"#363839\",\"font-family\":\"Arial, Helvetica, sans-serif\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"block\",\"text-align\":\"left\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"#ffffff\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"20\",\"line-height-hover\":\"25\",\"color-hover\":\"#13c0df\",\"font-family-hover\":\"\\\"Raleway\\\"\",\"font-weight-hover\":\"800\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"capitalize\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"30\",\"link-type\":\"post\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"hide-on-video\":\"\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-function\":\"link\",\"hideunderheight\":\"0\",\"hidetype\":\"visibility\",\"link-target\":\"_blank\",\"source-text-style-disable\":\"\",\"show-on-lightbox-video\":\"\",\"source-post\":\"title\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\"}},{\"id\":\"25\",\"order\":\"0\",\"container\":\"c\",\"settings\":{\"0\":\"\",\"source\":\"text\",\"enable-hover\":\"on\",\"font-size\":\"13\",\"line-height\":\"20\",\"color\":\"#ffffff\",\"font-family\":\"Arial, Helvetica, sans-serif\",\"font-weight\":\"700\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"5\",\"10\",\"3\",\"10\"],\"background-color\":\"rgba(0,0,0,0.15)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-size-x\":\"100\",\"background-size-y\":\"100\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"13\",\"line-height-hover\":\"20\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"Arial, Helvetica, sans-serif\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(0,0,0,0.50)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"fade\",\"delay\":\"0\",\"link-type\":\"lightbox\",\"url-link\":\"\",\"javascript-link\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"hide-on-video\":\"true\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"margin-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-function\":\"link\",\"hideunderheight\":\"0\",\"hidetype\":\"visibility\",\"link-target\":\"_self\",\"source-text-style-disable\":\"\",\"show-on-lightbox-video\":\"\",\"source-text\":\"SHOW IMAGE\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"28\",\"order\":\"1\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"text\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"enable-hover\":\"on\",\"font-size\":\"13\",\"line-height\":\"20\",\"color\":\"#ffffff\",\"font-family\":\"Arial, Helvetica, sans-serif\",\"font-weight\":\"900\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"position\":\"relative\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"5\"],\"padding\":[\"5\",\"10\",\"3\",\"10\"],\"background-color\":\"rgba(0,0,0,0.15)\",\"bg-alpha\":\"100\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"20\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"Arial, Helvetica, sans-serif\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(0,0,0,0.50)\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"\",\"transition\":\"fade\",\"transition-type\":\"\",\"delay\":\"0\",\"link-type\":\"lightbox\",\"url-link\":\"\",\"meta-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"margin-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-function\":\"link\",\"hideunderheight\":\"0\",\"hidetype\":\"visibility\",\"link-target\":\"_self\",\"source-text-style-disable\":\"\",\"show-on-lightbox-video\":\"true\",\"source-text\":\"PLAY VIDEO\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"3\",\"order\":\"1\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"text\",\"enable-hover\":\"\",\"font-size\":\"14\",\"line-height\":\"22\",\"color\":\"#365899\",\"font-family\":\"Arial, Helvetica, sans-serif\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"10\",\"15\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"#ffffff\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#e5e5e5\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"14\",\"line-height-hover\":\"14\",\"color-hover\":\"#000000\",\"font-family-hover\":\"Arial, Helvetica, sans-serif\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"capitalize\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#e5e5e5\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"34\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\", \",\"limit-type\":\"none\",\"limit-num\":\"10\",\"hide-on-video\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"source-function\":\"link\",\"hideunderheight\":\"0\",\"hidetype\":\"visibility\",\"link-target\":\"_self\",\"source-text-style-disable\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"show-on-lightbox-video\":\"\",\"source-text\":\"<i class=\\\"eg-icon-thumbs-up-alt\\\" style=\\\"background:#365899;color:#fff;float:left;width:23px;height:23px;font-size:12px;text-align:center;border-radius:14px;margin-right:5px;\\\"><\\/i> %likes_short%\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\"}},{\"id\":\"33\",\"order\":\"2\",\"container\":\"m\",\"settings\":{\"0\":\"Default\",\"source\":\"text\",\"source-separate\":\", \",\"limit-type\":\"none\",\"limit-num\":\"10\",\"enable-hover\":\"\",\"font-size\":\"14\",\"line-height\":\"22\",\"color\":\"#90949c\",\"font-family\":\"Arial, Helvetica, sans-serif\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"position\":\"relative\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"10\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"14\",\"line-height-hover\":\"22\",\"color-hover\":\"#7f7f7f\",\"font-family-hover\":\"Arial, Helvetica, sans-serif\",\"font-weight-hover\":\"900\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"transparent\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"transition\":\"skewleft\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"url-link\":\"\",\"meta-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-function\":\"link\",\"hideunderheight\":\"0\",\"hidetype\":\"visibility\",\"link-target\":\"_self\",\"source-text-style-disable\":\"\",\"margin-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"show-on-lightbox-video\":\"\",\"source-text\":\"<i class=\\\"eg-icon-calendar-empty\\\" style=\\\"background:#90949c;color:#fff;float:left;width:23px;height:23px;font-size:12px;text-align:center;border-radius:14px;margin-right:5px;\\\"><\\/i> %date%\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}}]", NULL);
INSERT INTO `rtl_lnd_eg_item_skins` VALUES("47", "YoutubeStream", "youtubestream", "{\"eg-item-skin-element-last-id\":\"35\",\"choose-layout\":\"masonry\",\"show-content\":\"bottom\",\"content-align\":\"left\",\"image-repeat\":\"no-repeat\",\"image-fit\":\"cover\",\"image-align-horizontal\":\"center\",\"image-align-vertical\":\"center\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"rgba(0,0,0,0.65)\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"100\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#ffffff\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"#e5e5e5\",\"full-border-style\":\"none\",\"full-overflow-hidden\":\"false\",\"content-bg-color\":\"#ffffff\",\"content-padding\":[\"20\",\"20\",\"20\",\"20\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"double\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"#000000\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"1\",\"10\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"fade\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"none\",\"media-animation\":\"none\",\"media-animation-delay\":\"0\",\"link-set-to\":\"cover\",\"link-link-type\":\"lightbox\",\"link-url-link\":\"\",\"link-meta-link\":\"\",\"link-javascript-link\":\"\",\"link-target\":\"_self\"}", "[{\"id\":\"0\",\"order\":\"0\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"on\",\"font-size\":\"14\",\"line-height\":\"19\",\"color\":\"#167ac6\",\"font-family\":\"Arial, Helvetica, sans-serif\",\"font-weight\":\"900\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"display\":\"block\",\"text-align\":\"left\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"#ffffff\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"14\",\"line-height-hover\":\"19\",\"color-hover\":\"#167ac6\",\"font-family-hover\":\"Arial, Helvetica, sans-serif\",\"font-weight-hover\":\"800\",\"text-decoration-hover\":\"underline\",\"font-style-hover\":\"\",\"text-transform-hover\":\"capitalize\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"30\",\"link-type\":\"post\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"hide-on-video\":\"\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-function\":\"link\",\"hideunderheight\":\"0\",\"hidetype\":\"visibility\",\"link-target\":\"_blank\",\"source-text-style-disable\":\"\",\"show-on-lightbox-video\":\"\",\"source-post\":\"title\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\"}},{\"id\":\"25\",\"order\":\"0\",\"container\":\"c\",\"settings\":{\"0\":\"\",\"source\":\"icon\",\"enable-hover\":\"\",\"font-size\":\"60\",\"line-height\":\"60\",\"color\":\"#ffffff\",\"font-family\":\"Arial, Helvetica, sans-serif\",\"font-weight\":\"700\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-size-x\":\"100\",\"background-size-y\":\"100\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"60\",\"line-height-hover\":\"60\",\"color-hover\":\"rgba(255,255,255,0.85)\",\"font-family-hover\":\"Arial, Helvetica, sans-serif\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"transparent\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"zoomback\",\"delay\":\"0\",\"link-type\":\"lightbox\",\"url-link\":\"\",\"javascript-link\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"hide-on-video\":\"true\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"margin-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-function\":\"link\",\"hideunderheight\":\"0\",\"hidetype\":\"visibility\",\"link-target\":\"_self\",\"source-text-style-disable\":\"\",\"source-icon\":\"eg-icon-play\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"33\",\"order\":\"1\",\"container\":\"m\",\"settings\":{\"0\":\"Default\",\"source\":\"text\",\"source-separate\":\", \",\"limit-type\":\"chars\",\"limit-num\":\"100\",\"enable-hover\":\"\",\"font-size\":\"14\",\"line-height\":\"22\",\"color\":\"#90949c\",\"font-family\":\"Arial, Helvetica, sans-serif\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"position\":\"relative\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"10\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"14\",\"line-height-hover\":\"22\",\"color-hover\":\"#7f7f7f\",\"font-family-hover\":\"Arial, Helvetica, sans-serif\",\"font-weight-hover\":\"900\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"transparent\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"transition\":\"skewleft\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"post\",\"url-link\":\"\",\"meta-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-function\":\"link\",\"hideunderheight\":\"0\",\"hidetype\":\"visibility\",\"link-target\":\"_blank\",\"source-text-style-disable\":\"\",\"margin-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"show-on-lightbox-video\":\"\",\"source-text\":\"%views_short% views\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"34\",\"order\":\"2\",\"container\":\"m\",\"settings\":{\"0\":\"Default\",\"source\":\"text\",\"source-separate\":\", \",\"source-function\":\"link\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"source-text-style-disable\":\"\",\"enable-hover\":\"\",\"font-size\":\"12\",\"line-height\":\"12\",\"color\":\"#90949c\",\"font-family\":\"Arial, Helvetica, sans-serif\",\"font-weight\":\"700\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"position\":\"relative\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"5\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"#ffffff\",\"bg-alpha\":\"100\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#e5e5e5\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"22\",\"color-hover\":\"#e81c4f\",\"font-family-hover\":\"Arial, Helvetica, sans-serif\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"capitalize\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#e5e5e5\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"hideunderheight\":\"0\",\"hidetype\":\"visibility\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"transition\":\"none\",\"transition-type\":\"\",\"delay\":\"34\",\"link-type\":\"post\",\"url-link\":\"\",\"meta-link\":\"\",\"javascript-link\":\"\",\"link-target\":\"_blank\",\"tag-type\":\"div\",\"force-important\":\"true\",\"facebook-sharing-link\":\"\",\"facebook-link-url\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"margin-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"show-on-lightbox-video\":\"\",\"source-text\":\"<i class=\\\"eg-icon-thumbs-up-1\\\"><\\/i>%likes_short%\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\"}},{\"id\":\"35\",\"order\":\"3\",\"container\":\"m\",\"settings\":{\"0\":\"Default\",\"source\":\"text\",\"source-separate\":\", \",\"source-function\":\"link\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"source-text-style-disable\":\"\",\"enable-hover\":\"\",\"font-size\":\"12\",\"line-height\":\"12\",\"color\":\"#90949c\",\"font-family\":\"Arial, Helvetica, sans-serif\",\"font-weight\":\"700\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"position\":\"relative\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"5\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"#ffffff\",\"bg-alpha\":\"100\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#e5e5e5\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"22\",\"color-hover\":\"#e81c4f\",\"font-family-hover\":\"Arial, Helvetica, sans-serif\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"capitalize\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#e5e5e5\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"hideunderheight\":\"0\",\"hidetype\":\"visibility\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"transition\":\"none\",\"transition-type\":\"\",\"delay\":\"34\",\"link-type\":\"post\",\"url-link\":\"\",\"meta-link\":\"\",\"javascript-link\":\"\",\"link-target\":\"_blank\",\"tag-type\":\"div\",\"force-important\":\"true\",\"facebook-sharing-link\":\"site\",\"facebook-link-url\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"margin-unit\":\"px\",\"show-on-lightbox-video\":\"\",\"source-text\":\"<i class=\\\"eg-icon-thumbs-down\\\"><\\/i>%dislikes_short%\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\"}}]", NULL);
INSERT INTO `rtl_lnd_eg_item_skins` VALUES("48", "TwitterStream", "twitterstream", "{\"eg-item-skin-element-last-id\":\"38\",\"choose-layout\":\"masonry\",\"show-content\":\"top\",\"content-align\":\"left\",\"image-repeat\":\"no-repeat\",\"image-fit\":\"cover\",\"image-align-horizontal\":\"center\",\"image-align-vertical\":\"center\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"rgba(41,47,51,0.20)\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"100\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#ffffff\",\"full-padding\":[\"30\",\"30\",\"30\",\"30\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"#e5e5e5\",\"full-border-style\":\"none\",\"full-overflow-hidden\":\"false\",\"content-bg-color\":\"#ffffff\",\"content-padding\":[\"0\",\"0\",\"20\",\"0\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"double\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"#000000\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"1\",\"10\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"fade\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"none\",\"media-animation\":\"zoomtodefault\",\"media-animation-delay\":\"0\",\"link-set-to\":\"none\",\"link-link-type\":\"none\",\"link-url-link\":\"\",\"link-meta-link\":\"\",\"link-javascript-link\":\"\",\"link-target\":\"_self\"}", "[{\"id\":\"25\",\"order\":\"0\",\"container\":\"c\",\"settings\":{\"0\":\"\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"30\",\"line-height\":\"30\",\"color\":\"#ffffff\",\"font-family\":\"Arial, Helvetica, sans-serif\",\"font-weight\":\"700\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-size-x\":\"100\",\"background-size-y\":\"100\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"30\",\"line-height-hover\":\"30\",\"color-hover\":\"rgba(255,255,255,0.85)\",\"font-family-hover\":\"Arial, Helvetica, sans-serif\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"transparent\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"fade\",\"delay\":\"0\",\"link-type\":\"lightbox\",\"url-link\":\"\",\"javascript-link\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"hide-on-video\":\"true\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"margin-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-function\":\"link\",\"hideunderheight\":\"0\",\"hidetype\":\"visibility\",\"link-target\":\"_self\",\"source-text-style-disable\":\"\",\"show-on-lightbox-video\":\"\",\"source-icon\":\"eg-icon-search\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"37\",\"order\":\"0\",\"container\":\"br\",\"settings\":{\"0\":\"Default\",\"source\":\"text\",\"source-separate\":\", \",\"source-function\":\"link\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"source-text-style-disable\":\"\",\"enable-hover\":\"\",\"font-size\":\"13\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"Arial, Helvetica, sans-serif\",\"font-weight\":\"700\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"position\":\"relative\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"left\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"10\",\"15\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#e5e5e5\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"22\",\"color-hover\":\"#e81c4f\",\"font-family-hover\":\"Arial, Helvetica, sans-serif\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"capitalize\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#e5e5e5\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"hideunderheight\":\"0\",\"hidetype\":\"visibility\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"transition\":\"slideshortup\",\"transition-type\":\"\",\"delay\":\"0\",\"link-type\":\"post\",\"url-link\":\"\",\"meta-link\":\"\",\"javascript-link\":\"\",\"link-target\":\"_blank\",\"tag-type\":\"div\",\"force-important\":\"true\",\"facebook-sharing-link\":\"\",\"facebook-link-url\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"margin-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"show-on-lightbox-video\":\"\",\"source-text\":\"@%author_name%\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"35\",\"order\":\"0\",\"container\":\"m\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"40\",\"enable-hover\":\"on\",\"font-size\":\"26\",\"line-height\":\"32\",\"color\":\"#292f33\",\"font-family\":\"Arial, Helvetica, sans-serif\",\"font-weight\":\"300\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"position\":\"relative\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"display\":\"block\",\"text-align\":\"left\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"10\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"26\",\"line-height-hover\":\"32\",\"color-hover\":\"#0084b4\",\"font-family-hover\":\"Arial, Helvetica, sans-serif\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"underline\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"transparent\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"transition\":\"none\",\"transition-type\":\"\",\"delay\":\"30\",\"link-type\":\"post\",\"url-link\":\"\",\"meta-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-function\":\"link\",\"hideunderheight\":\"0\",\"hidetype\":\"visibility\",\"link-target\":\"_blank\",\"source-text-style-disable\":\"\",\"margin-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"show-on-lightbox-video\":\"\",\"source-post\":\"title\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\"}},\"\",{\"id\":\"33\",\"order\":\"1\",\"container\":\"m\",\"settings\":{\"0\":\"Default\",\"source\":\"text\",\"source-separate\":\", \",\"limit-type\":\"none\",\"limit-num\":\"10\",\"enable-hover\":\"on\",\"font-size\":\"13\",\"line-height\":\"22\",\"color\":\"#aab8c2\",\"font-family\":\"Arial, Helvetica, sans-serif\",\"font-weight\":\"700\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"position\":\"relative\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"15\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"22\",\"color-hover\":\"#19cf68\",\"font-family-hover\":\"Arial, Helvetica, sans-serif\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"transparent\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"transition\":\"skewleft\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"sharetwitter\",\"url-link\":\"\",\"meta-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-function\":\"link\",\"hideunderheight\":\"0\",\"hidetype\":\"visibility\",\"link-target\":\"_self\",\"source-text-style-disable\":\"\",\"margin-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"source-text\":\"<i class=\\\"eg-icon-shuffle-1\\\"><\\/i> %retweets%\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"36\",\"order\":\"1\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"source-separate\":\",\",\"source-function\":\"link\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"source-text-style-disable\":\"\",\"enable-hover\":\"on\",\"font-size\":\"30\",\"line-height\":\"30\",\"color\":\"#ffffff\",\"font-family\":\"Arial, Helvetica, sans-serif\",\"font-weight\":\"700\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"position\":\"relative\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"30\",\"line-height-hover\":\"30\",\"color-hover\":\"rgba(255,255,255,0.85)\",\"font-family-hover\":\"Arial, Helvetica, sans-serif\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"transparent\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"hideunderheight\":\"0\",\"hidetype\":\"visibility\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"transition\":\"fade\",\"transition-type\":\"\",\"delay\":\"0\",\"link-type\":\"lightbox\",\"url-link\":\"\",\"meta-link\":\"\",\"javascript-link\":\"\",\"link-target\":\"_self\",\"tag-type\":\"div\",\"force-important\":\"true\",\"facebook-sharing-link\":\"\",\"facebook-link-url\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"margin-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"show-on-lightbox-video\":\"true\",\"source-icon\":\"eg-icon-play\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"3\",\"order\":\"2\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"text\",\"enable-hover\":\"on\",\"font-size\":\"13\",\"line-height\":\"22\",\"color\":\"#aab8c2\",\"font-family\":\"Arial, Helvetica, sans-serif\",\"font-weight\":\"700\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"15\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"#ffffff\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#e5e5e5\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"13\",\"line-height-hover\":\"22\",\"color-hover\":\"#e81c4f\",\"font-family-hover\":\"Arial, Helvetica, sans-serif\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"capitalize\",\"background-color-hover\":\"#ffffff\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#e5e5e5\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"34\",\"link-type\":\"post\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\", \",\"limit-type\":\"none\",\"limit-num\":\"10\",\"hide-on-video\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"source-function\":\"link\",\"hideunderheight\":\"0\",\"hidetype\":\"visibility\",\"link-target\":\"_blank\",\"source-text-style-disable\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-text\":\"<i class=\\\"eg-icon-heart\\\"><\\/i> %likes%\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\"}}]", NULL);
INSERT INTO `rtl_lnd_eg_item_skins` VALUES("49", "VimeoStream", "vimeostream", "{\"eg-item-skin-element-last-id\":\"34\",\"choose-layout\":\"even\",\"show-content\":\"none\",\"content-align\":\"left\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"rgba(0,0,0,0.65)\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"100\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#ffffff\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"#e5e5e5\",\"full-border-style\":\"none\",\"full-overflow-hidden\":\"false\",\"content-bg-color\":\"#ffffff\",\"content-padding\":[\"20\",\"20\",\"20\",\"20\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"double\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"#000000\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"1\",\"10\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"fade\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"none\",\"media-animation\":\"none\",\"media-animation-delay\":\"0\",\"link-set-to\":\"none\",\"link-link-type\":\"lightbox\",\"link-url-link\":\"\",\"link-meta-link\":\"\",\"link-javascript-link\":\"\",\"link-target\":\"_self\"}", "[{\"id\":\"0\",\"order\":\"0\",\"container\":\"c\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"24\",\"line-height\":\"28\",\"color\":\"#ffffff\",\"font-family\":\"Arial, Helvetica, sans-serif\",\"font-weight\":\"900\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"10\",\"0\",\"10\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"24\",\"line-height-hover\":\"28\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"Arial, Helvetica, sans-serif\",\"font-weight-hover\":\"900\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"capitalize\",\"background-color-hover\":\"transparent\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"fade\",\"delay\":\"0\",\"link-type\":\"post\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"hide-on-video\":\"\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-function\":\"link\",\"hideunderheight\":\"0\",\"hidetype\":\"visibility\",\"link-target\":\"_blank\",\"source-text-style-disable\":\"\",\"source-post\":\"title\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"34\",\"order\":\"0\",\"container\":\"br\",\"settings\":{\"0\":\"Default\",\"source\":\"text\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"3\",\"enable-hover\":\"\",\"font-size\":\"12\",\"line-height\":\"12\",\"color\":\"rgba(255,255,255,0.5)\",\"font-family\":\"Arial, Helvetica, sans-serif\",\"font-weight\":\"700\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"position\":\"relative\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"10\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"transition\":\"slideshortup\",\"transition-type\":\"\",\"delay\":\"30\",\"link-type\":\"post\",\"url-link\":\"\",\"meta-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-function\":\"link\",\"hideunderheight\":\"0\",\"hidetype\":\"visibility\",\"link-target\":\"_self\",\"source-text-style-disable\":\"\",\"margin-unit\":\"px\",\"source-text\":\"%duration%\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"33\",\"order\":\"1\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"text\",\"source-separate\":\", \",\"limit-type\":\"chars\",\"limit-num\":\"100\",\"enable-hover\":\"\",\"font-size\":\"18\",\"line-height\":\"22\",\"color\":\"#99aabc\",\"font-family\":\"Arial, Helvetica, sans-serif\",\"font-weight\":\"700\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"position\":\"relative\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"5\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"10\",\"0\",\"10\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"18\",\"line-height-hover\":\"22\",\"color-hover\":\"#99aabc\",\"font-family-hover\":\"Arial, Helvetica, sans-serif\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"transparent\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"transition\":\"fade\",\"transition-type\":\"\",\"delay\":\"0\",\"link-type\":\"none\",\"url-link\":\"\",\"meta-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-function\":\"link\",\"hideunderheight\":\"0\",\"hidetype\":\"visibility\",\"link-target\":\"_blank\",\"source-text-style-disable\":\"\",\"margin-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"source-text\":\"by %author_name%\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"25\",\"order\":\"2\",\"container\":\"c\",\"settings\":{\"0\":\"\",\"source\":\"text\",\"enable-hover\":\"on\",\"font-size\":\"14\",\"line-height\":\"40\",\"color\":\"#44bbff\",\"font-family\":\"Arial, Helvetica, sans-serif\",\"font-weight\":\"700\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"10\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"30\",\"0\",\"30\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-size-x\":\"100\",\"background-size-y\":\"100\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"2\",\"2\",\"2\",\"2\"],\"border-radius\":[\"4\",\"4\",\"4\",\"4\"],\"border-radius-unit\":\"px\",\"border-color\":\"#44bbff\",\"border-style\":\"solid\",\"css\":\"\",\"font-size-hover\":\"14\",\"line-height-hover\":\"40\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"Arial, Helvetica, sans-serif\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"transparent\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"2\",\"2\",\"2\",\"2\"],\"border-radius-hover\":[\"4\",\"4\",\"4\",\"4\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"fade\",\"delay\":\"0\",\"link-type\":\"lightbox\",\"url-link\":\"\",\"javascript-link\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"hide-on-video\":\"true\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"margin-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-function\":\"link\",\"hideunderheight\":\"0\",\"hidetype\":\"visibility\",\"link-target\":\"_self\",\"source-text-style-disable\":\"\",\"source-text\":\"Play Video\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}}]", NULL);
INSERT INTO `rtl_lnd_eg_item_skins` VALUES("50", "InstagramStream", "instagramstream", "{\"eg-item-skin-element-last-id\":\"37\",\"choose-layout\":\"even\",\"show-content\":\"none\",\"content-align\":\"left\",\"image-repeat\":\"no-repeat\",\"image-fit\":\"cover\",\"image-align-horizontal\":\"center\",\"image-align-vertical\":\"center\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"rgba(0,0,0,0.50)\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"100\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#ffffff\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"#e5e5e5\",\"full-border-style\":\"none\",\"full-overflow-hidden\":\"false\",\"content-bg-color\":\"#ffffff\",\"content-padding\":[\"20\",\"20\",\"20\",\"20\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"double\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"#000000\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"1\",\"10\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"fade\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"none\",\"media-animation\":\"none\",\"media-animation-delay\":\"0\",\"link-set-to\":\"cover\",\"link-link-type\":\"lightbox\",\"link-url-link\":\"\",\"link-meta-link\":\"\",\"link-javascript-link\":\"\",\"link-target\":\"_self\"}", "[{\"id\":\"0\",\"order\":\"0\",\"container\":\"c\",\"settings\":{\"0\":\"\",\"source\":\"text\",\"enable-hover\":\"\",\"font-size\":\"16\",\"line-height\":\"16\",\"color\":\"#ffffff\",\"font-family\":\"Arial, Helvetica, sans-serif\",\"font-weight\":\"900\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"5\",\"0\",\"5\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"24\",\"line-height-hover\":\"28\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"Arial, Helvetica, sans-serif\",\"font-weight-hover\":\"900\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"capitalize\",\"background-color-hover\":\"transparent\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"fade\",\"delay\":\"0\",\"link-type\":\"lightbox\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"hide-on-video\":\"false\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-function\":\"link\",\"hideunderheight\":\"0\",\"hidetype\":\"visibility\",\"link-target\":\"_self\",\"source-text-style-disable\":\"\",\"show-on-lightbox-video\":\"hide\",\"source-text\":\"<i class=\\\"eg-icon-heart\\\"><\\/i> %likes_short%\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"35\",\"order\":\"0\",\"container\":\"tl\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"enable-hover\":\"\",\"font-size\":\"24\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"position\":\"relative\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"right\",\"clear\":\"none\",\"margin\":[\"10\",\"7\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"24\",\"line-height-hover\":\"22\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"transparent\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"hide-on-video\":\"false\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"transition\":\"none\",\"transition-type\":\"\",\"delay\":\"0\",\"link-type\":\"lightbox\",\"url-link\":\"\",\"meta-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-function\":\"link\",\"hideunderheight\":\"0\",\"hidetype\":\"visibility\",\"link-target\":\"_self\",\"source-text-style-disable\":\"\",\"margin-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"adv-rules\":{\"ar-show\":\"show\",\"ar-type\":[\"off\",\"off\",\"off\",\"off\",\"off\",\"off\",\"off\",\"off\",\"off\"],\"ar-meta\":[\"\",\"\",\"\",\"\",\"\",\"\",\"\",\"\",\"\"],\"ar-operator\":[\"isset\",\"isset\",\"isset\",\"isset\",\"isset\",\"isset\",\"isset\",\"isset\",\"isset\"],\"ar-value\":[\"\",\"\",\"\",\"\",\"\",\"\",\"\",\"\",\"\"],\"ar-value-2\":[\"\",\"\",\"\",\"\",\"\",\"\",\"\",\"\",\"\"],\"ar-logic\":[\"and\",\"and\",\"and\",\"and\",\"and\",\"and\"],\"ar-logic-glob\":[\"and\",\"and\"]},\"show-on-lightbox-video\":\"true\",\"source-icon\":\"eg-icon-videocam\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\"}},{\"id\":\"37\",\"order\":\"1\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"text\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"enable-hover\":\"\",\"font-size\":\"16\",\"line-height\":\"16\",\"color\":\"#ffffff\",\"font-family\":\"Arial, Helvetica, sans-serif\",\"font-weight\":\"900\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"position\":\"relative\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"5\",\"0\",\"5\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"20\",\"line-height-hover\":\"25\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\\\"Raleway\\\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"capitalize\",\"background-color-hover\":\"transparent\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"false\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"transition\":\"fade\",\"transition-type\":\"\",\"delay\":\"0\",\"link-type\":\"lightbox\",\"url-link\":\"\",\"meta-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-function\":\"link\",\"hideunderheight\":\"0\",\"hidetype\":\"visibility\",\"show-on-lightbox-video\":\"true\",\"link-target\":\"_self\",\"source-text-style-disable\":\"\",\"margin-unit\":\"px\",\"source-text\":\"<i class=\\\"eg-icon-play\\\"><\\/i> %likes_short%\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"36\",\"order\":\"2\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"text\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"enable-hover\":\"\",\"font-size\":\"16\",\"line-height\":\"16\",\"color\":\"#ffffff\",\"font-family\":\"Arial, Helvetica, sans-serif\",\"font-weight\":\"900\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"position\":\"relative\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"5\",\"0\",\"5\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"17\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"false\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"transition\":\"fade\",\"transition-type\":\"\",\"delay\":\"0\",\"link-type\":\"post\",\"url-link\":\"\",\"meta-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-function\":\"link\",\"hideunderheight\":\"0\",\"hidetype\":\"visibility\",\"link-target\":\"_blank\",\"source-text-style-disable\":\"\",\"margin-unit\":\"px\",\"show-on-lightbox-video\":\"false\",\"source-text\":\"<i class=\\\"eg-icon-align-left\\\"><\\/i> %num_comments%\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}}]", NULL);
INSERT INTO `rtl_lnd_eg_item_skins` VALUES("51", "The Landscaper", "the-landscaper", "{\"eg-item-skin-element-last-id\":\"30\",\"choose-layout\":\"even\",\"show-content\":\"none\",\"content-align\":\"center\",\"image-repeat\":\"no-repeat\",\"image-fit\":\"cover\",\"image-align-horizontal\":\"center\",\"image-align-vertical\":\"center\",\"element-x-ratio\":\"3\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"rgba(10,10,10,0.65)\",\"0\":\" \\u067e\\u06cc\\u0634\\u200c\\u0641\\u0631\\u0636\",\"element-container-background-color-opacity\":\"100\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#ffffff\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"2\",\"2\",\"2\",\"2\"],\"full-border-color\":\"transparent\",\"full-border-style\":\"solid\",\"full-overflow-hidden\":\"false\",\"content-bg-color\":\"#ffffff\",\"content-padding\":[\"\",\"\",\"\",\"\"],\"content-border\":[\"\",\"\",\"\",\"\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"double\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"#000000\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"none\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"fade\",\"media-animation\":\"none\",\"media-animation-delay\":\"0\",\"link-set-to\":\"none\",\"link-link-type\":\"none\",\"link-url-link\":\"\",\"link-meta-link\":\"\",\"link-javascript-link\":\"\",\"link-target\":\"_self\"}", "[{\"id\":\"8\",\"order\":\"0\",\"container\":\"c\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"solid\",\"shadow-color\":\"#000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"false\",\"enable-hover\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"solid\",\"background-color-hover\":\"#FFF\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"#000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-function\":\"link\",\"hideunderheight\":\"0\",\"hidetype\":\"visibility\",\"link-target\":\"_self\",\"source-text-style-disable\":\"\",\"show-on-lightbox-video\":\"false\",\"source-text\":\"LINE-BREAK\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"24\",\"order\":\"1\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"enable-hover\":\"\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\\\"Roboto\\\", sans-serif\",\"font-weight\":\"700\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"position\":\"relative\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\\\"Roboto\\\", sans-serif\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"capitalize\",\"background-color-hover\":\"transparent\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"transition\":\"slidedown\",\"transition-type\":\"\",\"delay\":\"5\",\"link-type\":\"post\",\"url-link\":\"\",\"meta-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"force-important\":\"false\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-function\":\"link\",\"hideunderheight\":\"0\",\"hidetype\":\"display\",\"link-target\":\"_self\",\"source-text-style-disable\":\"\",\"margin-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"source-post\":\"title\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"30\",\"order\":\"2\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"text\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"enable-hover\":\"on\",\"font-size\":\"13\",\"line-height\":\"30\",\"color\":\"#ffffff\",\"font-family\":\"\\\"Roboto\\\", sans-serif\",\"font-weight\":\"800\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"position\":\"relative\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"left\",\"margin\":[\"15\",\"0\",\"0\",\"0\"],\"padding\":[\"3\",\"15\",\"2\",\"15\"],\"background-color\":\"#a2c046\",\"bg-alpha\":\"100\",\"shadow-color\":\"transparent\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"1\",\"1\",\"1\",\"1\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"solid\",\"font-size-hover\":\"13\",\"line-height-hover\":\"30\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\\\"Roboto\\\", sans-serif\",\"font-weight-hover\":\"800\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"#9ab643\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"transparent\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"1\",\"1\",\"1\",\"1\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"hide-on-video\":\"false\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"transition\":\"slidedown\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"post\",\"url-link\":\"\",\"meta-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-function\":\"link\",\"hideunderheight\":\"0\",\"hidetype\":\"visibility\",\"link-target\":\"_self\",\"source-text-style-disable\":\"\",\"margin-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"show-on-lightbox-video\":\"false\",\"source-text\":\"\\u0645\\u0634\\u0627\\u0647\\u062f\\u0647 \\u06af\\u0627\\u0644\\u0631\\u06cc\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"9\",\"order\":\"3\",\"container\":\"c\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"solid\",\"shadow-color\":\"#000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"\",\"enable-hover\":\"\",\"tag-type\":\"div\",\"force-important\":\"false\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"solid\",\"background-color-hover\":\"#FFF\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"#000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-function\":\"link\",\"hideunderheight\":\"0\",\"hidetype\":\"visibility\",\"link-target\":\"_self\",\"source-text-style-disable\":\"\",\"source-text\":\"LINE-BREAK\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}}]", NULL);
INSERT INTO `rtl_lnd_eg_item_skins` VALUES("52", "The Landscaper Home", "the-landscaper-home", "{\"eg-item-skin-element-last-id\":\"23\",\"choose-layout\":\"masonry\",\"show-content\":\"bottom\",\"content-align\":\"center\",\"image-repeat\":\"no-repeat\",\"image-fit\":\"cover\",\"image-align-horizontal\":\"center\",\"image-align-vertical\":\"center\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"rgba(8,8,8,0.75)\",\"0\":\" \\u067e\\u06cc\\u0634\\u200c\\u0641\\u0631\\u0636\",\"element-container-background-color-opacity\":\"100\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"transparant\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"transparent\",\"full-border-style\":\"none\",\"full-overflow-hidden\":\"false\",\"content-bg-color\":\"#transparant\",\"content-padding\":[\"20\",\"30\",\"0\",\"30\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"double\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"rgba(0,0,0,0.20)\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"1\",\"2\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"fade\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"none\",\"media-animation\":\"none\",\"media-animation-delay\":\"0\",\"link-set-to\":\"none\",\"link-link-type\":\"none\",\"link-url-link\":\"\",\"link-meta-link\":\"\",\"link-javascript-link\":\"\",\"link-target\":\"_self\"}", "[{\"id\":\"4\",\"order\":\"0\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"on\",\"font-size\":\"13\",\"line-height\":\"16\",\"color\":\"#a2c046\",\"font-family\":\"\\\"Roboto\\\"\",\"font-weight\":\"800\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"10\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"13\",\"line-height-hover\":\"16\",\"color-hover\":\"#a2c046\",\"font-family-hover\":\"\\\"Roboto\\\"\",\"font-weight-hover\":\"800\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"transparent\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"none\",\"delay\":\"34\",\"link-type\":\"post\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"transition-type\":\"always\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"tag-type\":\"p\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"source-function\":\"none\",\"hideunderheight\":\"0\",\"hidetype\":\"visibility\",\"hide-on-video\":\"false\",\"link-target\":\"_self\",\"source-text-style-disable\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"show-on-lightbox-video\":\"false\",\"source-post\":\"cat_list\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\"}},{\"id\":\"2\",\"order\":\"0\",\"container\":\"c\",\"settings\":{\"0\":\"\",\"source\":\"text\",\"enable-hover\":\"on\",\"font-size\":\"13\",\"line-height\":\"20\",\"color\":\"#ffffff\",\"font-family\":\"\\\"Roboto\\\"\",\"font-weight\":\"800\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"8\",\"15\",\"8\",\"15\"],\"background-color\":\"#a2c046\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"1\",\"1\",\"1\",\"1\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\"\",\"font-size-hover\":\"13\",\"line-height-hover\":\"20\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\\\"Roboto\\\"\",\"font-weight-hover\":\"800\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"capitalize\",\"background-color-hover\":\"#92ad3f\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"1\",\"1\",\"1\",\"1\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\"\",\"hideunder\":\"0\",\"transition\":\"slidedown\",\"delay\":\"10\",\"link-type\":\"post\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"hide-on-video\":\"false\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-function\":\"link\",\"hideunderheight\":\"0\",\"hidetype\":\"visibility\",\"link-target\":\"_self\",\"source-text-style-disable\":\"\",\"show-on-lightbox-video\":\"false\",\"source-text\":\"\\u0645\\u0634\\u0627\\u0647\\u062f\\u0647 \\u06af\\u0627\\u0644\\u0631\\u06cc\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"0\",\"order\":\"1\",\"container\":\"m\",\"settings\":{\"0\":\"\",\"source\":\"post\",\"enable-hover\":\"on\",\"font-size\":\"18\",\"line-height\":\"25\",\"color\":\"#ababab\",\"font-family\":\"\\\"Roboto Slab\\\"\",\"font-weight\":\"700\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"css\":\".eg-cleveland-element-0{}\",\"font-size-hover\":\"18\",\"line-height-hover\":\"25\",\"color-hover\":\"#464646\",\"font-family-hover\":\"\\\"Roboto Slab\\\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"capitalize\",\"background-color-hover\":\"transparent\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"css-hover\":\".eg-cleveland-element-0{}\",\"hideunder\":\"0\",\"transition\":\"fade\",\"delay\":\"20\",\"link-type\":\"post\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"transition-type\":\"out\",\"position\":\"relative\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"tag-type\":\"div\",\"align\":\"t_l\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"force-important\":\"\",\"absolute-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-function\":\"link\",\"hideunderheight\":\"0\",\"hidetype\":\"visibility\",\"link-target\":\"_self\",\"source-text-style-disable\":\"\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"source-post\":\"title\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}}]", NULL);
INSERT INTO `rtl_lnd_eg_item_skins` VALUES("53", "The Landscaper Lightbox", "the-landscaper-lightbox", "{\"eg-item-skin-element-last-id\":\"31\",\"choose-layout\":\"even\",\"show-content\":\"none\",\"content-align\":\"center\",\"element-x-ratio\":\"3\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"rgba(10,10,10,0.65)\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"100\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#ffffff\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"2\",\"2\",\"2\",\"2\"],\"full-border-color\":\"transparent\",\"full-border-style\":\"solid\",\"full-overflow-hidden\":\"false\",\"content-bg-color\":\"#ffffff\",\"content-padding\":[\"\",\"\",\"\",\"\"],\"content-border\":[\"\",\"\",\"\",\"\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"double\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"#000000\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"none\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"fade\",\"media-animation\":\"none\",\"media-animation-delay\":\"0\",\"link-set-to\":\"none\",\"link-link-type\":\"none\",\"link-url-link\":\"\",\"link-meta-link\":\"\",\"link-javascript-link\":\"\",\"link-target\":\"_self\"}", "[{\"id\":\"8\",\"order\":\"0\",\"container\":\"c\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"solid\",\"shadow-color\":\"#000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"\",\"enable-hover\":\"\",\"tag-type\":\"div\",\"force-important\":\"false\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"solid\",\"background-color-hover\":\"#FFF\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"#000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-function\":\"link\",\"hideunderheight\":\"0\",\"hidetype\":\"visibility\",\"link-target\":\"_self\",\"source-text-style-disable\":\"\",\"source-text\":\"LINE-BREAK\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"24\",\"order\":\"2\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"enable-hover\":\"\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\\\"Roboto\\\", sans-serif\",\"font-weight\":\"700\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"position\":\"relative\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\\\"Roboto\\\", sans-serif\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"capitalize\",\"background-color-hover\":\"transparent\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"transition\":\"slidedown\",\"transition-type\":\"\",\"delay\":\"5\",\"link-type\":\"post\",\"url-link\":\"\",\"meta-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"force-important\":\"false\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-function\":\"link\",\"hideunderheight\":\"0\",\"hidetype\":\"display\",\"link-target\":\"_self\",\"source-text-style-disable\":\"\",\"margin-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"source-post\":\"title\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"31\",\"order\":\"1\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"20\",\"0\"],\"padding\":[\"17\",\"17\",\"17\",\"17\"],\"background-color\":\"#a2c046\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-size-x\":\"100\",\"background-size-y\":\"100\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"#000000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"50\",\"50\",\"50\",\"50\"],\"border-radius-unit\":\"%\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"#98b63c\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"#000000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#98b63c\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"falldown\",\"delay\":\"10\",\"link-type\":\"lightbox\",\"url-link\":\"\",\"javascript-link\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-function\":\"link\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"hideunderheight\":\"0\",\"hidetype\":\"visibility\",\"hide-on-video\":\"\",\"tag-type\":\"div\",\"force-important\":\"false\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"link-target\":\"_self\",\"source-text-style-disable\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"margin-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"source-icon\":\"eg-icon-search\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"9\",\"order\":\"3\",\"container\":\"c\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"solid\",\"shadow-color\":\"#000\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"\",\"enable-hover\":\"\",\"tag-type\":\"div\",\"force-important\":\"false\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"solid\",\"background-color-hover\":\"#FFF\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"#000\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-function\":\"link\",\"hideunderheight\":\"0\",\"hidetype\":\"visibility\",\"link-target\":\"_self\",\"source-text-style-disable\":\"\",\"source-text\":\"LINE-BREAK\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}}]", NULL);
INSERT INTO `rtl_lnd_eg_item_skins` VALUES("54", "ESGBlankSkin", "esgblankskin", "{\"eg-item-skin-element-last-id\":\"0\",\"choose-layout\":\"even\",\"show-content\":\"none\",\"content-align\":\"left\",\"image-repeat\":\"no-repeat\",\"image-fit\":\"cover\",\"image-align-horizontal\":\"center\",\"image-align-vertical\":\"center\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"splitted-item\":\"none\",\"cover-type\":\"full\",\"container-background-color\":\"rgba(0, 0, 0, 0)\",\"cover-always-visible-desktop\":\"false\",\"cover-always-visible-mobile\":\"false\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"rgba(255, 255, 255, 0)\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"transparent\",\"full-border-style\":\"none\",\"full-overflow-hidden\":\"false\",\"content-bg-color\":\"rgba(255, 255, 255, 0)\",\"content-padding\":[\"0\",\"0\",\"0\",\"0\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"none\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"#000000\",\"content-box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"none\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"none\",\"media-animation\":\"none\",\"media-animation-delay\":\"0\",\"element-hover-image\":\"false\",\"hover-image-animation\":\"fade\",\"hover-image-animation-delay\":\"0\",\"link-set-to\":\"none\",\"link-link-type\":\"none\",\"link-url-link\":\"\",\"link-meta-link\":\"\",\"link-javascript-link\":\"\",\"link-target\":\"_self\"}", "[]", NULL);

/* INSERT TABLE DATA: rtl_lnd_eg_navigation_skins */
INSERT INTO `rtl_lnd_eg_navigation_skins` VALUES("1", "Flat Light", "flat-light", "/********************************\r\n	-	FLAT LIGHT BUTTONS -\r\n*********************************/\r\n.flat-light .navigationbuttons,\r\n.flat-light .esg-pagination,\r\n.flat-light .esg-filters{	text-transform:uppercase;\r\n							text-align: center;\r\n						}\r\n\r\n.flat-light .esg-filterbutton,\r\n.flat-light .esg-navigationbutton,\r\n.flat-light .esg-sortbutton,\r\n.flat-light .esg-cartbutton {	color:#000;\r\n								margin-right:5px;\r\n								cursor:pointer;\r\n								position: relative;\r\n								z-index:2;\r\n								padding:1px 30px;\r\n								border:none;\r\n								line-height:38px;\r\n								border-radius:5px;\r\n								-moz-border-radius:5px;\r\n								-webkit-border-radius:5px;\r\n								font-size:12px;\r\n								font-weight:700;\r\n								font-family:\"Open Sans\",sans-serif;\r\n								display: inline-block;\r\n								background: #fff;\r\n								margin-bottom:5px;\r\n							}\r\n\r\n.flat-light .esg-navigationbutton	{ padding:2px 12px; }\r\n.flat-light .esg-navigationbutton *	{ color:#000; }\r\n.flat-light .esg-pagination-button:last-child { margin-right: 0; }\r\n\r\n.flat-light  .esg-sortbutton-wrapper,\r\n.flat-light  .esg-cartbutton-wrapper { display:inline-block; }\r\n.flat-light  .esg-sortbutton-order,\r\n.flat-light  .esg-cartbutton-order {	display:inline-block;\r\n										vertical-align:top;\r\n										border:none;\r\n										width:40px;\r\n										line-height:40px;\r\n										border-radius:5px;\r\n										-moz-border-radius:5px;\r\n										-webkit-border-radius:5px;\r\n										font-size:12px;\r\n										font-weight:700;\r\n										color:#999;\r\n										cursor: pointer;\r\n										background:#eee;\r\n										background: #fff;\r\n										margin-left:5px;\r\n									}\r\n\r\n.flat-light .esg-cartbutton {	color:#fff;\r\n								cursor: default !important;\r\n							}\r\n.flat-light .esg-cartbutton .esgicon-basket	{\r\n												color:#fff;\r\n												font-size:15px;\r\n												line-height:15px;\r\n												margin-right:10px;\r\n											}\r\n.flat-light .esg-cartbutton-wrapper { cursor: default !important; }\r\n\r\n.flat-light .esg-sortbutton,\r\n.flat-light .esg-cartbutton {	display:inline-block;\r\n								position:relative;\r\n								cursor: pointer;\r\n								margin-right:0px;\r\n								border-radius:5px;\r\n								-moz-border-radius:5px;\r\n								-webkit-border-radius:5px;\r\n							}\r\n\r\n.flat-light .esg-navigationbutton:hover,\r\n.flat-light .esg-filterbutton:hover,\r\n.flat-light .esg-sortbutton:hover,\r\n.flat-light .esg-sortbutton-order:hover,\r\n.flat-light .esg-cartbutton-order:hover,\r\n.flat-light .esg-filterbutton.selected {\r\n										border-color:none;color:#000;\r\n										background:#fff;\r\n									   }\r\n\r\n.flat-light .esg-navigationbutton:hover * { color:#333; }\r\n\r\n.flat-light .esg-sortbutton-order.tp-desc:hover	{ color:#333; }\r\n\r\n.flat-light .esg-filter-checked	{	padding:1px 3px;\r\n									color:#cbcbcb;\r\n									background:#cbcbcb;\r\n									margin-left:7px;\r\n									font-size:9px;\r\n									font-weight:300;\r\n									line-height:9px;\r\n									vertical-align: middle;\r\n								}\r\n.flat-light .esg-filterbutton.selected .esg-filter-checked,\r\n.flat-light .esg-filterbutton:hover .esg-filter-checked	{\r\n															padding:1px 3px 1px 3px;\r\n															color:#fff;\r\n															background:#000;\r\n															margin-left:7px;\r\n															font-size:9px;\r\n															font-weight:300;\r\n															line-height:9px;\r\n															vertical-align: middle;\r\n														}");
INSERT INTO `rtl_lnd_eg_navigation_skins` VALUES("2", "Flat Dark", "flat-dark", "/********************************\r\n	-	FLAT DARK BUTTONS -\r\n*********************************/\r\n.flat-dark .navigationbuttons,\r\n.flat-dark .esg-pagination,\r\n.flat-dark .esg-filters {\r\n							text-transform:uppercase;\r\n							text-align: center;\r\n						}\r\n\r\n.flat-dark .esg-filterbutton,\r\n.flat-dark .esg-navigationbutton,\r\n.flat-dark .esg-sortbutton,\r\n.flat-dark .esg-cartbutton {color:#fff;\r\n							margin-right:5px;\r\n							cursor:pointer;\r\n							padding:1px 30px;\r\n							border:none;\r\n							line-height:38px;\r\n							border-radius:5px;\r\n							-moz-border-radius:5px;\r\n							-webkit-border-radius:5px;\r\n							font-size:12px;\r\n							font-weight:600;\r\n							font-family:\"Open Sans\",sans-serif;\r\n							display: inline-block;\r\n							background:#3a3a3a;\r\n							background: rgba(0,0,0,0.2);\r\n							margin-bottom:5px;\r\n							}\r\n\r\n.flat-dark .esg-navigationbutton { padding:1px 18px; }\r\n.flat-dark .esg-navigationbutton * { color:#fff; }\r\n.flat-dark .esg-pagination-button:last-child,\r\n.flat-dark .esg-filterbutton:last-child{ margin-right: 0; }\r\n.flat-dark .esg-left, .flat-dark .esg-right { padding:1px 12px; }\r\n\r\n.flat-dark  .esg-sortbutton-wrapper,\r\n.flat-dark  .esg-cartbutton-wrapper	{ display:inline-block; }\r\n.flat-dark  .esg-sortbutton-order,\r\n.flat-dark  .esg-cartbutton-order { display:inline-block;\r\n									vertical-align:top;\r\n									border:none;\r\n									width:40px;\r\n									line-height:40px;\r\n									border-radius:5px;\r\n									-moz-border-radius:5px;\r\n									-webkit-border-radius:5px;\r\n									font-size:12px;\r\n									font-weight:700;\r\n									color:#999;\r\n									cursor: pointer;\r\n									background:#eee;\r\n									background: rgba(0,0,0,0.2);\r\n									margin-left:5px;\r\n								}\r\n\r\n.flat-dark .esg-cartbutton {color:#fff;\r\n							cursor: default !important;\r\n							}\r\n.flat-dark .esg-cartbutton .esgicon-basket {color:#fff;\r\n											font-size:15px;\r\n											line-height:15px;\r\n											margin-right:10px;\r\n											}\r\n.flat-dark  .esg-cartbutton-wrapper	{ cursor: default !important; }\r\n\r\n.flat-dark .esg-sortbutton,\r\n.flat-dark .esg-cartbutton { display:inline-block;\r\n							position:relative;\r\n							cursor: pointer;\r\n							margin-right:0px;\r\n							border-radius:5px;\r\n							-moz-border-radius:5px;\r\n							-webkit-border-radius:5px;\r\n							}\r\n\r\n.flat-dark .esg-navigationbutton:hover,\r\n.flat-dark .esg-filterbutton:hover,\r\n.flat-dark .esg-sortbutton:hover,\r\n.flat-dark .esg-sortbutton-order:hover,\r\n.flat-dark .esg-cartbutton-order:hover,\r\n.flat-dark .esg-filterbutton.selected { color:#fff;\r\n										border-color:none;\r\n										background:#4a4a4a;\r\n										background: rgba(0,0,0,0.5);\r\n									 }\r\n\r\n.flat-dark .esg-navigationbutton:hover * { color:#fff; }\r\n.flat-dark .esg-sortbutton-order.tp-desc:hover	{ color:#fff; }\r\n.flat-dark .esg-filter-checked {padding:1px 3px;\r\n								color:transparent;\r\n								background:#000;\r\n								background: rgba(0,0,0,0.2);\r\n								margin-left:7px;\r\n								font-size:9px;\r\n								font-weight:300;\r\n								line-height:9px;\r\n								vertical-align: middle:\r\n								}\r\n								\r\n.flat-dark .esg-filterbutton.selected .esg-filter-checked,\r\n.flat-dark .esg-filterbutton:hover .esg-filter-checked {padding:1px 3px 1px 3px;\r\n														color:#fff;\r\n														background:#000;\r\n														background: rgba(0,0,0,0.2);\r\n														margin-left:7px;\r\n														font-size:9px;\r\n														font-weight:300;\r\n														line-height:9px;\r\n														vertical-align: middle\r\n														}");
INSERT INTO `rtl_lnd_eg_navigation_skins` VALUES("3", "Minimal Dark", "minimal-dark", "/********************************\r\n	-	MINIMAL DARK BUTTONS -\r\n*********************************/\r\n\r\n.minimal-dark .navigationbuttons,\r\n.minimal-dark .esg-pagination,\r\n.minimal-dark .esg-filters { text-align: center; }\r\n\r\n.minimal-dark .esg-filterbutton,\r\n.minimal-dark .esg-navigationbutton,\r\n.minimal-dark .esg-sortbutton,\r\n.minimal-dark .esg-cartbutton { color:#fff;\r\n								color:rgba(255,255,255,1);\r\n								margin-right:5px;\r\n								cursor:pointer;\r\n								padding:0px 17px;\r\n								border:1px solid rgb(255,255,255);\r\n								border:1px solid rgba(255,255,255,0.1);\r\n								line-height:38px;\r\n								border-radius:5px;\r\n								-moz-border-radius:5px;\r\n								-webkit-border-radius:5px;\r\n								font-size:12px;\r\n								font-weight:600;\r\n								font-family:\"Open Sans\",sans-serif;\r\n								display: inline-block;\r\n								background:transparent;\r\n								margin-bottom:5px;\r\n								}\r\n\r\n\r\n.minimal-dark .esg-navigationbutton * {\r\n										color:#fff;\r\n										color:rgba(255,255,255,1);\r\n									}\r\n.minimal-dark .esg-navigationbutton	{ padding:0px 11px; }\r\n.minimal-dark .esg-pagination-button { padding:0px 16px; }\r\n.minimal-dark .esg-pagination-button:last-child { margin-right: 0; }\r\n\r\n.minimal-dark  .esg-sortbutton-wrapper,\r\n.minimal-dark  .esg-cartbutton-wrapper { display:inline-block; }\r\n.minimal-dark  .esg-sortbutton-order,\r\n.minimal-dark  .esg-cartbutton-order {  display:inline-block;\r\n										vertical-align:top;\r\n										border:1px solid rgb(255,255,255);\r\n										border:1px solid rgba(255,255,255,0.1);\r\n										width:40px;\r\n										line-height:38px;\r\n										border-radius: 0px 5px 5px 0px;\r\n										-moz-border-radius: 0px 5px 5px 0px;\r\n										-webkit-border-radius: 0px 5px 5px 0px;\r\n										font-size:12px;\r\n										font-weight:600;\r\n										color:#fff;\r\n										cursor: pointer;\r\n										background:transparent;\r\n									}\r\n\r\n.minimal-dark .esg-cartbutton {\r\n								color:#fff;\r\n								cursor: default !important;\r\n							  }\r\n.minimal-dark .esg-cartbutton .esgicon-basket {\r\n												color:#fff;\r\n												font-size:15px;\r\n												line-height:15px;\r\n												margin-right:10px;\r\n											  }\r\n.minimal-dark  .esg-cartbutton-wrapper { cursor: default !important; }\r\n\r\n.minimal-dark .esg-sortbutton,\r\n.minimal-dark .esg-cartbutton {\r\n								display:inline-block;\r\n								position:relative;\r\n								cursor: pointer;\r\n								margin-right:0px;\r\n								border-right:none;\r\n								border-radius:5px 0px 0px 5px;\r\n								-moz-border-radius:5px 0px 0px 5px;\r\n								-webkit-border-radius:5px 0px 0px 5px;\r\n							   }\r\n\r\n.minimal-dark .esg-navigationbutton:hover,\r\n.minimal-dark .esg-filterbutton:hover,\r\n.minimal-dark .esg-sortbutton:hover,\r\n.minimal-dark .esg-sortbutton-order:hover,\r\n.minimal-dark .esg-cartbutton-order:hover,\r\n.minimal-dark .esg-filterbutton.selected {\r\n											border-color:#fff;\r\n											border-color:rgba(255,255,255,0.2);\r\n											color:#fff;\r\n											box-shadow: 0px 3px 5px 0px rgba(0,0,0,0.13);\r\n											background:#333;\r\n											background: rgba(255,255,255,0.1);\r\n										  }\r\n\r\n.minimal-dark .esg-navigationbutton:hover * { color:#fff; }\r\n\r\n.minimal-dark .esg-sortbutton-order.tp-desc:hover {	border-color:#fff;\r\n													border-color:rgba(255,255,255,0.2);\r\n													color:#fff;\r\n													box-shadow: 0px -3px 5px 0px rgba(0,0,0,0.13) !important;\r\n												  }\r\n\r\n.minimal-dark .esg-filter-checked {\r\n									padding:1px 3px;\r\n									color:transparent;\r\n									background:#000;\r\n									background: rgba(0,0,0,0.10);\r\n									margin-left:7px;\r\n									font-size:9px;\r\n									font-weight:300;\r\n									line-height:9px;\r\n									vertical-align: middle;\r\n								  }\r\n.minimal-dark .esg-filterbutton.selected .esg-filter-checked,\r\n.minimal-dark .esg-filterbutton:hover .esg-filter-checked {\r\n															padding:1px 3px 1px 3px;\r\n															color:#fff;\r\n															background:#000;\r\n															background: rgba(0,0,0,0.10);\r\n															margin-left:7px;\r\n															font-size:9px;\r\n															font-weight:300;\r\n															line-height:9px;\r\n															vertical-align: middle;\r\n														  }");
INSERT INTO `rtl_lnd_eg_navigation_skins` VALUES("4", "Minimal Light", "minimal-light", "/******************************\r\n	-	MINIMAL LIGHT SKIN	-\r\n********************************/\r\n\r\n.minimal-light .navigationbuttons,\r\n.minimal-light .esg-pagination,\r\n.minimal-light .esg-filters { text-align: center; }\r\n\r\n.minimal-light .esg-filterbutton,\r\n.minimal-light .esg-navigationbutton,\r\n.minimal-light .esg-sortbutton,\r\n.minimal-light .esg-cartbutton a{ \r\n								color:#999;\r\n								margin-right:5px;\r\n								cursor:pointer;\r\n								padding:0px 16px;\r\n								border:1px solid #e5e5e5;\r\n								line-height:38px;\r\n								border-radius:5px;\r\n								-moz-border-radius:5px;\r\n								-webkit-border-radius:5px;\r\n								font-size:12px;\r\n								font-weight:700;\r\n								font-family:\"Open Sans\",sans-serif;\r\n								display: inline-block;\r\n								background:#fff;\r\n								margin-bottom:5px;\r\n							  }\r\n\r\n/*.minimal-light .esg-cartbutton a { color: #999; }*/\r\n\r\n.minimal-light .esg-navigationbutton * { color:#999; }\r\n.minimal-light .esg-navigationbutton	{ padding:0px 16px; }\r\n.minimal-light .esg-pagination-button:last-child { margin-right: 0; }\r\n.minimal-light .esg-left, .minimal-light .esg-right	{ padding:0px 11px; }\r\n\r\n.minimal-light  .esg-sortbutton-wrapper,\r\n.minimal-light  .esg-cartbutton-wrapper { display:inline-block; }\r\n.minimal-light  .esg-sortbutton-order,\r\n.minimal-light  .esg-cartbutton-order {	display:inline-block;\r\n										vertical-align:top;\r\n										border:1px solid #e5e5e5;\r\n										width:40px;\r\n										line-height:38px;\r\n										border-radius: 0px 5px 5px 0px;\r\n										-moz-border-radius: 0px 5px 5px 0px;\r\n										-webkit-border-radius: 0px 5px 5px 0px;\r\n										font-size:12px;\r\n										font-weight:700;\r\n										color:#999;\r\n										cursor: pointer;\r\n										background:#fff;\r\n									   }\r\n\r\n.minimal-light .esg-cartbutton {\r\n								color:#333;\r\n								cursor: default !important;\r\n								}\r\n.minimal-light .esg-cartbutton .esgicon-basket {color:#333;\r\n												font-size:15px;\r\n												line-height:15px;\r\n												margin-right:10px;\r\n												}\r\n.minimal-light  .esg-cartbutton-wrapper { cursor: default !important; }\r\n\r\n.minimal-light .esg-sortbutton,\r\n.minimal-light .esg-cartbutton { display:inline-block;\r\n								position:relative;\r\n								cursor: pointer;\r\n								margin-right:0px;\r\n								border-right:none;\r\n								border-radius:5px 0px 0px 5px;\r\n								-moz-border-radius:5px 0px 0px 5px;\r\n								-webkit-border-radius:5px 0px 0px 5px;\r\n								}\r\n\r\n.minimal-light .esg-navigationbutton:hover,\r\n.minimal-light .esg-filterbutton:hover,\r\n.minimal-light .esg-sortbutton:hover,\r\n.minimal-light .esg-sortbutton-order:hover,\r\n.minimal-light .esg-cartbutton a:hover,\r\n.minimal-light .esg-filterbutton.selected {\r\n											background-color:#fff;\r\n											border-color:#bbb;\r\n											color:#333;\r\n											box-shadow: 0px 3px 5px 0px rgba(0,0,0,0.13);\r\n										  }\r\n\r\n.minimal-light .esg-navigationbutton:hover * { color:#333; }\r\n\r\n.minimal-light .esg-sortbutton-order.tp-desc:hover {\r\n													border-color:#bbb;\r\n													color:#333;\r\n													box-shadow: 0px -3px 5px 0px rgba(0,0,0,0.13) !important;\r\n												   }\r\n\r\n.minimal-light .esg-filter-checked { \r\n									padding:1px 3px;\r\n									color:#cbcbcb;\r\n									background:#cbcbcb;\r\n									margin-left:7px;\r\n									font-size:9px;\r\n									font-weight:300;\r\n									line-height:9px;\r\n									vertical-align: middle;\r\n									}\r\n.minimal-light .esg-filterbutton.selected .esg-filter-checked,\r\n.minimal-light .esg-filterbutton:hover .esg-filter-checked {\r\n															padding:1px 3px 1px 3px;\r\n															color:#fff;\r\n															background:#000;\r\n															margin-left:7px;\r\n															font-size:9px;\r\n															font-weight:300;\r\n															line-height:9px;\r\n															vertical-align: middle;\r\n														   }");
INSERT INTO `rtl_lnd_eg_navigation_skins` VALUES("5", "Simple Light", "simple-light", "/******************************\r\n	-	SIMPLE LIGHT SKIN	-\r\n********************************/\r\n\r\n.simple-light .navigationbuttons,\r\n.simple-light .esg-pagination,\r\n.simple-light .esg-filters { text-align: center; }\r\n\r\n.simple-light .esg-filterbutton,\r\n.simple-light .esg-navigationbutton,\r\n.simple-light .esg-sortbutton,\r\n.simple-light .esg-cartbutton a {\r\n								color:#000;\r\n								margin-right:5px;\r\n								cursor:pointer;\r\n								padding:0px 11px;\r\n								border:1px solid #e5e5e5;\r\n								line-height:30px;\r\n								font-size:12px;\r\n								font-weight:400;\r\n								font-family:\\\\\\\"Open Sans\\\\\\\",sans-serif;\r\n								display: inline-block;\r\n								background:#eee;\r\n								margin-bottom:5px;\r\n							  }\r\n\r\n.simple-light .esg-navigationbutton * {	color:#000; }\r\n.simple-light .esg-left,\r\n.simple-light .esg-right { color:#000; padding:0px 7px;}\r\n.simple-light .esg-pagination-button:last-child { margin-right: 0; }\r\n\r\n.simple-light .esg-sortbutton-wrapper,\r\n.simple-light .esg-cartbutton-wrapper {	display:inline-block; }\r\n.simple-light .esg-sortbutton-order,\r\n.simple-light .esg-cartbutton-order {\r\n									display: inline-block;\r\n									vertical-align: top;\r\n									border: 1px solid #e5e5e5;\r\n									width: 29px;\r\n									line-height: 30px;\r\n									font-size: 9px;\r\n									font-weight: 400;\r\n									color: #000;\r\n									cursor: pointer;\r\n									background: #eee;\r\n									}\r\n\r\n.simple-light .esg-cartbutton {\r\n								color:#333;\r\n								cursor: default !important;\r\n							  }\r\n.simple-light .esg-cartbutton .esgicon-basket {\r\n												color:#333;\r\n												font-size:15px;\r\n												line-height:15px;\r\n												margin-right:10px;\r\n											  }\r\n.simple-light  .esg-cartbutton-wrapper { cursor: default !important; }\r\n\r\n.simple-light .esg-sortbutton,\r\n.simple-light .esg-cartbutton {\r\n								display:inline-block;\r\n								position:relative;\r\n								cursor: pointer;\r\n								margin-right:5px;\r\n							  }\r\n\r\n\r\n.simple-light .esg-navigationbutton:hover,\r\n.simple-light .esg-filterbutton:hover,\r\n.simple-light .esg-sortbutton:hover,\r\n.simple-light .esg-sortbutton-order:hover,\r\n.simple-light .esg-cartbutton a:hover,\r\n.simple-light .esg-filterbutton.selected {\r\n											background-color:#fff;\r\n											border-color:#bbb;\r\n											color:#333;\r\n											box-shadow: 0px 3px 5px 0px rgba(0,0,0,0.13);\r\n										 }\r\n\r\n.simple-light .esg-navigationbutton:hover * { color:#333; }\r\n\r\n.simple-light .esg-sortbutton-order.tp-desc:hover {\r\n													border-color:#bbb;\r\n													color:#333;\r\n													box-shadow: 0px -3px 5px 0px rgba(0,0,0,0.13) !important;\r\n												  }\r\n\r\n.simple-light .esg-filter-checked {\r\n									padding:3px;\r\n									color:#c5c5c5;\r\n									background:#ddd;\r\n									margin-left:7px;\r\n									font-size:9px;\r\n									font-weight:400;\r\n									line-height:20px;\r\n									vertical-align: middle;\r\n								  }\r\n.simple-light .esg-filterbutton.selected .esg-filter-checked,\r\n.simple-light .esg-filterbutton:hover .esg-filter-checked {\r\n															padding: 3px;\r\n															color:#fff;\r\n															background:#000;\r\n															margin-left:7px;\r\n															font-size:9px;\r\n															font-weight:400;\r\n															line-height:20px;\r\n															vertical-align: middle\r\n														}");
INSERT INTO `rtl_lnd_eg_navigation_skins` VALUES("6", "Simple Dark", "simple-dark", "/********************************\r\n-	SIMPLE DARK BUTTONS -\r\n*********************************/\r\n\r\n.simple-dark .navigationbuttons,\r\n.simple-dark .esg-pagination,\r\n.simple-dark .esg-filters {	text-align: center; }\r\n\r\n.simple-dark .esg-filterbutton,\r\n.simple-dark .esg-navigationbutton,\r\n.simple-dark .esg-sortbutton,\r\n.simple-dark .esg-cartbutton {\r\n								color:#fff;\r\n								margin-right:5px;\r\n								cursor:pointer;\r\n								padding:0px 10px;\r\n								border:1px solid rgb(255,255,255);\r\n								border:1px solid rgba(255,255,255,0.15);\r\n								line-height:29px;\r\n								font-size:12px;\r\n								font-weight:600;\r\n								font-family:\"Open Sans\",sans-serif;\r\n								display: inline-block;\r\n								background: rgba(255,255,255,0.08 );\r\n								margin-bottom:5px;\r\n							  }\r\n\r\n.simple-dark .esg-navigationbutton * {\r\n										color:#fff;\r\n									 }\r\n.simple-dark .esg-left, .simple-dark .esg-right { padding:0px 5px !important; }\r\n\r\n.simple-dark  .esg-sortbutton-wrapper,\r\n.simple-dark  .esg-cartbutton-wrapper {	display:inline-block; }\r\n.simple-dark  .esg-sortbutton-order,\r\n.simple-dark  .esg-cartbutton-order {\r\n									display: inline-block;\r\n									vertical-align: top;\r\n									border:1px solid rgb(255,255,255);\r\n									border:1px solid rgba(255,255,255,0.15);\r\n									width: 29px;\r\n									line-height: 29px;\r\n									font-size: 9px;\r\n									font-weight: 600;\r\n									color: #fff;\r\n									cursor: pointer;\r\n									background: rgba(255,255,255,0.08 );\r\n									}\r\n\r\n.simple-dark .esg-cartbutton {\r\n							color:#fff;\r\n							cursor: default !important;\r\n							}\r\n							\r\n.simple-dark .esg-cartbutton .esgicon-basket {\r\n												color:#fff;\r\n												font-size:15px;\r\n												line-height:15px;\r\n												margin-right:10px;\r\n											  }\r\n.simple-dark  .esg-cartbutton-wrapper {	cursor: default !important; }\r\n\r\n.simple-dark .esg-sortbutton,\r\n.simple-dark .esg-cartbutton {\r\n								display:inline-block;\r\n								position:relative;\r\n								cursor: pointer;\r\n								margin-right:5px;\r\n							  }\r\n\r\n\r\n.simple-dark .esg-navigationbutton:hover,\r\n.simple-dark .esg-filterbutton:hover,\r\n.simple-dark .esg-sortbutton:hover,\r\n.simple-dark .esg-sortbutton-order:hover,\r\n.simple-dark .esg-cartbutton-order:hover,\r\n.simple-dark .esg-filterbutton.selected {\r\n										border-color:#fff;\r\n										color:#000;\r\n										box-shadow: 0px 3px 5px 0px rgba(0,0,0,0.13);\r\n										background:#fff;\r\n										}\r\n\r\n.simple-dark .esg-navigationbutton:hover * { color:#000; }\r\n.simple-dark .esg-pagination-button:last-child { margin-right: 0; }\r\n\r\n.simple-dark .esg-sortbutton-order.tp-desc:hover {\r\n													border-color:#fff;\r\n													border-color:rgba(255,255,255,0.2);\r\n													color:#000;\r\n													box-shadow: 0px -3px 5px 0px rgba(0,0,0,0.13) !important;\r\n												 }\r\n\r\n.simple-dark .esg-filter-checked {\r\n									padding:1px;\r\n									color:transparent;\r\n									background:#000;\r\n									background: rgba(255,255,255,0.15);\r\n									margin-left:7px;\r\n									font-size:9px;\r\n									font-weight:300;\r\n									line-height:9px;\r\n									vertical-align: middle;\r\n								  }\r\n\r\n.simple-dark .esg-filterbutton.selected .esg-filter-checked,\r\n.simple-dark .esg-filterbutton:hover .esg-filter-checked {\r\n															padding:1px;\r\n															color:#000;\r\n															background:#fff;\r\n															margin-left:7px;\r\n															font-size:9px;\r\n															font-weight:300;\r\n															line-height:9px;\r\n															vertical-align: middle;\r\n														  }");
INSERT INTO `rtl_lnd_eg_navigation_skins` VALUES("7", "Text Dark", "text-dark", "/********************************\r\n-	TEXT DARK BUTTONS -\r\n*********************************/\r\n\r\n.text-dark .navigationbuttons,\r\n.text-dark .esg-pagination,\r\n.text-dark .esg-filters { text-align: center; }\r\n\r\n.text-dark .esg-filterbutton,\r\n.text-dark .esg-navigationbutton,\r\n.text-dark .esg-sortbutton,\r\n.text-dark .esg-cartbutton {\r\n							color:#fff;\r\n							color:rgba(255,255,255,0.4);\r\n							margin-right:5px;\r\n							cursor:pointer;\r\n							padding:0px 15px 0px 10px;\r\n							line-height:20px;\r\n							font-size:12px;\r\n							font-weight:600;\r\n							font-family:\"Open Sans\",sans-serif;\r\n							display: inline-block;\r\n							background:transparent;\r\n							margin-bottom:5px;\r\n						  }\r\n\r\n.text-dark .esg-navigationbutton * {\r\n									color:#fff;\r\n									color:rgba(255,255,255,0.4);\r\n								   }\r\n\r\n.text-dark  .esg-sortbutton-wrapper,\r\n.text-dark  .esg-cartbutton-wrapper { display:inline-block; }\r\n.text-dark  .esg-sortbutton-order,\r\n.text-dark  .esg-cartbutton-order {\r\n									display: inline-block;\r\n									vertical-align: middle;\r\n									width: 29px;\r\n									line-height: 20px;\r\n									font-size: 9px;\r\n									font-weight: 700;\r\n									color:#fff;\r\n									color:rgba(255,255,255,0.4);\r\n									cursor: pointer;\r\n									background: transparent;\r\n								  }\r\n\r\n.text-dark .esg-cartbutton {\r\n							color:#fff;\r\n							color:rgba(255,255,255,0.4);\r\n							cursor: default !important;\r\n							}\r\n.text-dark .esg-cartbutton .esgicon-basket {\r\n											color:#fff;\r\n											color:rgba(255,255,255,0.4);\r\n											font-size:15px;\r\n											line-height:15px;\r\n											margin-right:10px;\r\n											}\r\n.text-dark  .esg-cartbutton-wrapper { cursor: default !important; }\r\n\r\n.text-dark .esg-sortbutton,\r\n.text-dark .esg-cartbutton {\r\n							display:inline-block;\r\n							position:relative;\r\n							cursor: pointer;\r\n							margin-right:0px;\r\n							}\r\n\r\n.text-dark .esg-navigationbutton:hover,\r\n.text-dark .esg-filterbutton:hover,\r\n.text-dark .esg-sortbutton:hover,\r\n.text-dark .esg-filterbutton.selected,\r\n.text-dark .esg-sortbutton-order:hover,\r\n.text-dark .esg-cartbutton-order:hover { color:#fff; }\r\n\r\n.text-dark .esg-navigationbutton:hover,\r\n.text-dark .esg-filterbutton:hover span:first-child,\r\n.text-dark .esg-filterbutton.selected span:first-child { text-decoration: none; }\r\n\r\n.text-dark .esg-filterbutton {\r\n								border-right:1px solid #fff;\r\n								border-right:1px solid rgba(255,255,255,0.15);\r\n							  }\r\n.text-dark .esg-filterbutton:last-child	{ border-right:none; }\r\n\r\n.text-dark .esg-sortbutton-order {\r\n									padding-left:10px;\r\n									border-left:1px solid #fff;\r\n									border-left:1px solid rgba(255,255,255,0.15);\r\n								 }\r\n\r\n.text-dark .esg-navigationbutton:hover * { color:#fff; }\r\n\r\n.text-dark .esg-sortbutton-order.tp-desc:hover {\r\n												border-color:#fff;\r\n												border-color:rgba(255,255,255,0.15);\r\n												color:#fff;\r\n												}\r\n\r\n.text-dark .esg-filter-checked {\r\n								padding:1px 3px;\r\n								color:transparent;\r\n								background:#000;\r\n								background: rgba(0,0,0,0.10);\r\n								margin-left:7px;\r\n								font-size:9px;\r\n								font-weight:300;\r\n								line-height:9px;\r\n								vertical-align: middle;\r\n								}\r\n\r\n.text-dark .esg-filter-checked * { }\r\n.text-dark .esg-filterbutton.selected .esg-filter-checked,\r\n.text-dark .esg-filterbutton:hover .esg-filter-checked {\r\n														padding:1px 3px 1px 3px;\r\n														color:#fff;\r\n														background:#000;\r\n														background: rgba(0,0,0,0.10);\r\n														margin-left:7px;\r\n														font-size:9px;\r\n														font-weight:300;\r\n														line-height:9px;\r\n														vertical-align: middle\r\n														}");
INSERT INTO `rtl_lnd_eg_navigation_skins` VALUES("8", "Text Light", "text-light", "/********************************\r\n-	TEXT LIGHT BUTTONS -\r\n*********************************/\r\n\r\n.text-light .navigationbuttons,\r\n.text-light .esg-pagination,\r\n.text-light .esg-filters {\r\n						text-align: center;\r\n						position: relative;\r\n						z-index:2;\r\n						}\r\n\r\n.text-light .esg-filterbutton,\r\n.text-light .esg-navigationbutton,\r\n.text-light .esg-sortbutton,\r\n.text-light .esg-cartbutton {\r\n							color:#999;\r\n							margin-right:5px;\r\n							cursor:pointer;\r\n							padding:0px 15px 0px 10px;\r\n							line-height:20px;\r\n							font-size:12px;\r\n							font-weight:600;\r\n							font-family:\"Open Sans\",sans-serif;\r\n							display: inline-block;\r\n							background:transparent;\r\n							margin-bottom:5px;\r\n							}\r\n\r\n.text-light .esg-navigationbutton * { color:#999; }\r\n\r\n.text-light  .esg-sortbutton-wrapper,\r\n.text-light  .esg-cartbutton-wrapper { display:inline-block; }\r\n.text-light  .esg-sortbutton-order,\r\n.text-light  .esg-cartbutton-order {\r\n									display: inline-block;\r\n									vertical-align: middle;\r\n									width: 29px;\r\n									line-height: 20px;\r\n									font-size: 9px;\r\n									font-weight: 700;\r\n									color:#999;\r\n									cursor: pointer;\r\n									background: transparent;\r\n									}\r\n\r\n.text-light .esg-cartbutton {\r\n							color:#999;\r\n							cursor: default !important;\r\n							}\r\n.text-light .esg-cartbutton .esgicon-basket {\r\n											color:#999;\r\n											font-size:15px;\r\n											line-height:15px;\r\n											margin-right:10px;\r\n											}\r\n.text-light .esg-cartbutton-wrapper { cursor: default !important; }\r\n\r\n.text-light .esg-sortbutton,\r\n.text-light .esg-cartbutton {\r\n							display:inline-block;\r\n							position:relative;\r\n							cursor: pointer;\r\n							margin-right:0px;\r\n							}\r\n\r\n.text-light .esg-navigationbutton:hover,\r\n.text-light .esg-filterbutton:hover,\r\n.text-light .esg-sortbutton:hover,\r\n.text-light .esg-filterbutton.selected,\r\n.text-light .esg-sortbutton-order:hover,\r\n.text-light .esg-cartbutton-order:hover { color:#444; }\r\n\r\n.text-light .esg-navigationbutton:hover,\r\n.text-light .esg-filterbutton:hover span:first-child,\r\n.text-light .esg-filterbutton.selected span:first-child { text-decoration: underline; }\r\n\r\n.text-light .esg-filterbutton {	border-right:1px solid #e5e5e5; }\r\n.text-light .esg-filterbutton:last-child { border-right:none; }\r\n\r\n.text-light .esg-sortbutton-order {\r\n									padding-left:10px;\r\n									border-left:1px solid #e5e5e5;\r\n								  }\r\n\r\n.text-light .esg-navigationbutton:hover * {	color:#444; }\r\n\r\n.text-light .esg-sortbutton-order.tp-desc:hover {\r\n												border-color:#e5e5e5;\r\n												color:#444;\r\n												}\r\n\r\n.text-light .esg-filter-checked {\r\n								padding:1px 3px;\r\n								color:transparent;\r\n								background:#eee;\r\n								background: rgba(0,0,0,0.05);\r\n								margin-left:7px;\r\n								font-size:9px;\r\n								font-weight:300;\r\n								line-height:9px;\r\n								vertical-align: middle;\r\n								}\r\n.text-light .esg-filter-checked * { }\r\n.text-light .esg-filterbutton.selected .esg-filter-checked,\r\n.text-light .esg-filterbutton:hover .esg-filter-checked {\r\n														padding:1px 3px 1px 3px;\r\n														color:#333;\r\n														background:#eee;\r\n														background: rgba(0,0,0,0.05);\r\n														margin-left:7px;\r\n														font-size:9px;\r\n														font-weight:300;\r\n														line-height:9px;\r\n														vertical-align: middle;\r\n														}\r\n");
INSERT INTO `rtl_lnd_eg_navigation_skins` VALUES("9", "The Landscaper", "the-landscaper", "/********************************\n	-	FLAT LIGHT BUTTONS -\n*********************************/\n.the-landscaper .esg-filter-wrapper {\n  width: 100%;\n}\n.the-landscaper .navigationbuttons,\n.the-landscaper .esg-pagination,\n.the-landscaper .esg-filters{\n  text-transform:uppercase;\n  text-align: center;\n}\n\n.the-landscaper .esg-filterbutton {\n  position: relative;\n}\n.the-landscaper .esg-loadmore-wrapper {\n  margin-top: 30px;\n}\n\n\n  .the-landscaper .esg-filterbutton,\n  .the-landscaper .esg-sortbutton,\n  .the-landscaper .esg-cartbutton {\n    display: block;\n    padding: 14px 25px;\n    color: #999999;\n    font-family: \"Roboto\", sans-serif;\n    font-size: 15px;\n    font-weight: bold;\n    z-index: 2;\n    text-transform: none;\n    cursor: pointer;\n    background-color: #f5f5f5;\n    border-radius: 1px;\n    transition: all 100ms ease-in;\n  }\n\n.the-landscaper .esg-navigationbutton.esg-left,\n.the-landscaper .esg-navigationbutton.esg-right {\n  border-color: #50524B;\n}\n\n@media(min-width: 992px) {\n  .the-landscaper .esg-filterbutton,\n  .the-landscaper .esg-sortbutton,\n  .the-landscaper .esg-cartbutton {\n    position: relative;\n    display: inline-block;\n    margin-right: 7px;\n  }\n  .the-landscaper .esg-filter-checked {\n    padding: 1px 3px;\n    color: #999999;\n    background: #f9f9f9;\n    margin-left: 7px;\n    font-size: 9px;\n    font-weight: 300;\n    line-height: 9px;\n    vertical-align: middle;\n  }\n}\n\n\n.the-landscaper .esg-filterbutton.selected,\n.the-landscaper .esg-filterbutton:hover {\n  background-color: #A2C046;\n  color: #ffffff;\n  border-color: #A2C046;\n}\n.the-landscaper .esg-navigationbutton {\n  display: inline-block;\n  bottom: 22px;\n  padding: 12px 13px;\n  font-family: \"Roboto\", sans-serif;\n  font-weight: bold;\n  cursor: pointer;\n  color: #999999;\n  border: 2px solid #dedede;\n  border-radius: 1px;\n  -webkit-border-radius: 1px;\n  transition: all 100ms ease-out;\n}\n.the-landscaper .esg-navigationbutton:hover {\n  border-color: #cccccc;\n}\n.the-landscaper .esg-navigationbutton * { \n  color:#999999;\n  transition: all 100ms ease-out;\n}\n\n.the-landscaper .esg-navigationbutton:hover * { color:#ffffff; }\n\n.the-landscaper .esg-sortbutton-order.tp-desc:hover	{ color:#333333; }\n\n\n.the-landscaper  .esg-sortbutton-wrapper,\n.the-landscaper  .esg-cartbutton-wrapper { display:inline-block; }\n.the-landscaper  .esg-sortbutton-order,\n.the-landscaper  .esg-cartbutton-order {\n  display:inline-block;\n  vertical-align:top;\n  border:none;\n  width:40px;\n  line-height:40px;\n  font-size:12px;\n  font-weight:700;\n  color:#999;\n  cursor: pointer;\n  background:#eee;\n  background: #fff;\n  margin-left:5px;\n									}\n\n.the-landscaper .esg-cartbutton {	color:#fff;\n								cursor: default !important;\n							}\n.the-landscaper .esg-cartbutton .esgicon-basket	{\n  color:#fff;\n  font-size:15px;\n  line-height:15px;\n  margin-right:10px;\n											}\n.the-landscaper .esg-cartbutton-wrapper { cursor: default !important; }\n\n.the-landscaper .esg-sortbutton,\n.the-landscaper .esg-cartbutton {\n  display:inline-block;\n  position:relative;\n  cursor: pointer;\n  margin-right:0px;\n  border-radius:2px;\n}");
INSERT INTO `rtl_lnd_eg_navigation_skins` VALUES("10", "The Landscaper Home", "the-landscaper-home", "/********************************\n	-	The Landscaper Home -\n*********************************/\n.the-landscaper-home .navigationbuttons,\n.the-landscaper-home .esg-pagination,\n.the-landscaper-home .esg-filters{\n  text-transform:uppercase;\n  text-align: center;\n}\n\n.the-landscaper-home .esg-filterbutton {\n  position: relative;\n}\n.the-landscaper-home .esg-loadmore-wrapper {\n  margin-top: 30px;\n}\n\n.the-landscaper-home .esg-filterbutton,\n.the-landscaper-home .esg-sortbutton,\n.the-landscaper-home .esg-cartbutton {\n    display: block;\n    padding: 15px 22px;\n    color: #cecece;\n    font-family: \"Roboto\", sans-serif;\n    font-size: 15px;\n    font-weight: bold;\n    z-index: 2;\n    text-transform: none;\n    cursor: pointer;\n    border-bottom: 1px solid rgba(0,0,0,.1);\n    transition: all 100ms ease-in;\n}\n\n.the-landscaper-home .esg-navigationbutton.esg-left,\n.the-landscaper-home .esg-navigationbutton.esg-right {\n  border-color: #50524B;\n}\n\n\n@media(min-width: 992px) {\n.the-landscaper-home .esg-filterbutton,\n.the-landscaper-home .esg-sortbutton,\n.the-landscaper-home .esg-cartbutton {\n  position: relative;\n  display: inline-block;\n  border-right: 1px solid rgba(0,0,0,.1);\n  margin-right: 7px;\n  border: 2px solid #DCDCDC;\n  color: #999999;\n}\n.the-landscaper-home .esg-filter-checked {\n  padding: 1px 3px;\n  color: #cbcbcb;\n  background: #cbcbcb;\n  margin-left: 7px;\n  font-size: 9px;\n  font-weight: 300;\n  line-height: 9px;\n  vertical-align: middle;\n  }\n}\n\n.the-landscaper-home .esg-filterbutton.selected,\n.the-landscaper-home .esg-filterbutton:hover {\n  background-color: #A2C046;\n  color: #ffffff;\n  border-color: #A2C046;\n}\n.the-landscaper-home .esg-navigationbutton {\n  position: relative;\n  display: inline-block;\n  padding: 13px 22px;\n  font-family: \"Roboto\", sans-serif;\n  font-weight: bold;\n  cursor: pointer;\n  color: #ffffff;\n  background-color: #a2c046;\n  -ms-transform: skew(-25deg);\n  -webkit-transform: skew(-25deg);\n  transform: skew(-25deg);\n  transition: all 100ms ease-out;\n}\n.the-landscaper-home .esg-navigationbutton * {\n  display: inline-block;\n  -ms-transform: skew(25deg);\n  -webkit-transform: skew(25deg);\n  transform: skew(25deg);\n}\n.the-landscaper-home .esg-navigationbutton:hover {\n  color:#ffffff;\n  background-color: #98b63c;\n}\n.the-landscaper-home .esg-navigationbutton.esg-left:before,\n.the-landscaper-home .esg-navigationbutton.esg-right::before {\n  position: absolute;\n  content: \"\";\n  top: 0;\n  width: 0;\n  height: 0;\n  border-style: solid;\n  transition: all 100ms ease-out;\n  -ms-transform: skew(25deg);\n  -webkit-transform: skew(25deg);\n  transform: skew(25deg);\n}\n.the-landscaper-home .esg-navigationbutton.esg-left {\n  padding: 14px 22px 14px 11px;\n  border-radius: 0 0 0 2px;\n}\n.the-landscaper-home .esg-navigationbutton.esg-right {\n  padding: 14px 11px 14px 22px;\n  border-radius: 0 2px 2px 0;\n}\n\n.the-landscaper-home .esg-navigationbutton.esg-left::before {\n  left: -12px;\n  border-width: 50px 48px 0 0;\n  border-radius: 2px 0 0 2px;\n  border-color: #a2c046 transparent transparent transparent;\n}\n.the-landscaper-home .esg-navigationbutton.esg-left:hover::before {\n  border-color: #9ab83f transparent transparent transparent;\n}\n.the-landscaper-home .esg-navigationbutton.esg-right:before {\n  right: -12px;\n  border-width: 0 0 50px 48px;\n  border-radius: 0 2px 2px 0;\n  border-color: transparent transparent #a2c046 transparent;\n}\n.the-landscaper-home .esg-navigationbutton.esg-right:hover::before {\n  border-color: transparent transparent #9ab83f transparent;\n}\n.the-landscaper-home .esg-navigationbutton.esg-right::after {\n  position: absolute;\n  content: \"\";\n  top: 0;\n  height: 48px;\n  left: 0;\n  border-left: 1px solid rgba(255, 255, 255, 0.1);\n}\n\n\n\n.the-landscaper-home .esg-sortbutton-order.tp-desc:hover {\n  color:#333333;\n}\n\n.the-landscaper-home .esg-sortbutton-wrapper,\n.the-landscaper-home .esg-cartbutton-wrapper {\n  display:inline-block;\n}\n.the-landscaper-home .esg-sortbutton-order,\n.the-landscaper-home .esg-cartbutton-order {\n  display:inline-block;\n  vertical-align:top;\n  border:none;\n  width:40px;\n  line-height:40px;\n  font-size:12px;\n  font-weight:700;\n  color:#999;\n  cursor: pointer;\n  background:#eee;\n  background: #fff;\n  margin-left:5px;\n}\n\n.the-landscaper-home .esg-cartbutton {\n  color:#fff;\n  cursor: default !important;\n}\n.the-landscaper-home .esg-cartbutton .esgicon-basket {\n  color:#fff;\n  font-size:15px;\n  line-height:15px;\n  margin-right:10px;\n}\n.the-landscaper-home .esg-cartbutton-wrapper {\n  cursor: default !important;\n}\n\n.the-landscaper-home .esg-sortbutton,\n.the-landscaper-home .esg-cartbutton {\n  display:inline-block;\n  position:relative;\n  cursor: pointer;\n  margin-right:0px;\n  border-radius:2px;\n}");
INSERT INTO `rtl_lnd_eg_navigation_skins` VALUES("11", "Pat LaFontaine", "pat-lafontaine", "/*************************************\n	-	Pat LaFontaine 3.0.0 SKIN -\n*************************************/\n.pat-lafontaine .esg-overflowtrick {\n  margin: 20px 0\n}\n\n.pat-lafontaine .navigationbuttons,\n.pat-lafontaine .esg-pagination,\n.pat-lafontaine .esg-filters {\n	text-transform: uppercase;\n	text-align: center;\n}\n\n.pat-lafontaine .esg-filters {margin-bottom: 1px !important}\n\n.pat-lafontaine .esg-filter-wrapper.dropdownstyle>.esg-selected-filterbutton,\n.pat-lafontaine input.eg-search-input,\n.pat-lafontaine .esg-filterbutton,\n.pat-lafontaine .esg-navigationbutton,\n.pat-lafontaine .esg-sortbutton,\n.pat-lafontaine .esg-cartbutton,\n.pat-lafontaine .esg-filter-wrapper.eg-search-wrapper  .eg-search-clean,\n.pat-lafontaine .esg-filter-wrapper.eg-search-wrapper  .eg-search-submit {\n	color: #000;\n	margin-right: 1px;\n	cursor: pointer;\n	position: relative;\n	z-index: 2;\n	padding: 0px 20px;\n	border: none;\n	line-height: 50px;\n	border-radius: 0;\n	font-size: 14px;\n	font-weight: 400;\n	font-family: \"Barlow Condensed\", sans-serif;\n	display: inline-block;\n	background: #eaedf1;\n	margin-bottom: 0 !important;\n	white-space: nowrap;\n	min-height: 50px;\n	vertical-align: middle;\n  	transition: all 0.3s ease;\n  	min-width: 50px;\n}\n\n.pat-lafontaine .esg-filter-wrapper {\n  margin: 0 !important\n    }\n\n.pat-lafontaine .esg-allfilter {\n  background: #f03e3f !important;\n  color: #fff !important\n}\n\n.pat-lafontaine .esg-allfilter.hovered {\n  background: #000 !important;\n  color: #fff !important\n}\n\n.pat-lafontaine span.eg-el-amount {\n  letter-spacing: 1px\n}\n\n.pat-lafontaine span.eg-el-amount:before {\n  content: \"[\";\n  opacity: 0.5\n}\n\n.pat-lafontaine span.eg-el-amount:after {\n  content: \"]\";\n  opacity: 0.5\n}\n\n.pat-lafontaine .esg-cartbutton a {\n	color: #000;\n}\n\n.pat-lafontaine input.eg-search-input::placeholder {\n	line-height: 40px;\n	vertical-align: middle;\n	color:#999;\n}\n\n.pat-lafontaine .esg-navigationbutton {\n	padding: 0px;\n	min-width: 50px;\n}\n\n.pat-lafontaine .esg-navigationbutton.esg-loadmore {\n  padding: 0 20px;\n  text-transform: uppercase;\n}\n\n.pat-lafontaine .esg-navigationbutton * {\n	color: #000;\n}\n\n.pat-lafontaine .esg-navigationbutton.hovered i {\n  	color: #fff;\n}\n\n.pat-lafontaine .esg-pagination-button:last-child {\n	margin-right: 0;\n}\n\n.pat-lafontaine .esg-sortbutton-wrapper,\n.pat-lafontaine .esg-cartbutton-wrapper {\n	display: inline-block;\n  	margin-right: 1px !important;\n  	margin-left: 0 !important;\n}\n\n.pat-lafontaine .esg-sortbutton-order,\n.pat-lafontaine .esg-cartbutton-order {\n	display: inline-block;\n	vertical-align: middle;\n	border: none;\n	width: 50px;\n	line-height: 50px;\n	font-size: 12px;\n	font-weight: 700;\n	color: #999;\n	cursor: pointer;\n	background: #eaedf1;\n	margin-left: 1px;\n  	border-radius: 0;\n}\n\n.pat-lafontaine .esg-sortbutton-order.eg-icon-down-open:before {\n  	content: \"arrow_downward\";\n 	font-family: \"Material Icons\";\n  	font-size: 18px;\n  	color: #000;\n  	vertical-align: middle;\n}\n\n.pat-lafontaine .esg-sortbutton-order.hovered.eg-icon-down-open:before {\n  color: #fff\n}\n\n.pat-lafontaine .esg-cartbutton {\n	color: #999;\n	cursor: default !important;\n 	border-radius: 0 !important;\n  	padding: 0 20px 0 16px\n}\n\n.pat-lafontaine .esg-cartbutton.hovered .eg-icon-basket,\n.pat-lafontaine .esg-cartbutton.hovered .ess-cart-content {\n  color: #fff\n}\n\n.pat-lafontaine .esg-cartbutton .esgicon-basket {\n	color: #999;\n	font-size: 15px;\n	line-height: 15px;\n	margin-right: 10px;\n}\n\n.pat-lafontaine .esg-cartbutton-wrapper {\n	cursor: default !important;\n}\n\n.pat-lafontaine .esg-sortbutton,\n.pat-lafontaine .esg-cartbutton {\n	display: inline-block;\n	position: relative;\n	cursor: pointer;\n	margin-right: 0px;\n	border-radius: 5px;\n}\n\n.pat-lafontaine input.eg-search-input.hovered,\n.pat-lafontaine input.eg-search-input:focus,\n.pat-lafontaine .esg-filter-wrapper.dropdownstyle>.esg-selected-filterbutton.hovered,\n.pat-lafontaine .esg-filter-wrapper.dropdownstyle>.esg-selected-filterbutton.hoveredfilter,\n.pat-lafontaine .esg-navigationbutton.hovered,\n.pat-lafontaine .esg-filterbutton.hovered,\n.pat-lafontaine .esg-sortbutton.hovered,\n.pat-lafontaine .esg-sortbutton-order.hovered,\n.pat-lafontaine .esg-cartbutton-order.hovered,\n.pat-lafontaine .esg-filterbutton.selected,\n.pat-lafontaine .esg-cartbutton.hovered,\n.pat-lafontaine .esg-filter-wrapper.eg-search-wrapper  .eg-search-clean.hovered,\n.pat-lafontaine .esg-filter-wrapper.eg-search-wrapper  .eg-search-submit.hovered {\n	border-color: none;\n	color: #fff;\n	background: #000;\n}\n\n.pat-lafontaine .esg-navigationbutton.hovered * {\n	color: #000;\n}\n\n.pat-lafontaine .esg-sortbutton-order.hovered.tp-desc {\n	color: #000;\n}\n\n.pat-lafontaine .esg-filter-checked {\n	color: #cbcbcb;\n	background: none;\n	margin-left: 10px;\n	font-size: 9px;\n	font-weight: 300;\n	line-height: 13px;\n	vertical-align: middle;\n  	display: inline-block;\n    transform: translateY(-1px);\n  	border: 1px solid #cbcbcb;\n}\n.pat-lafontaine .esg-filterbutton.hovered .esg-filter-checked {\n	color: #fff;\n	background: #000;\n}\n\n.pat-lafontaine .esg-filterbutton.selected .esg-filter-checked {\n  background: #fff;\n  color: #000;\n  border: 1px solid #fff;\n}\n\n.pat-lafontaine .esg-filter-wrapper.eg-search-wrapper {\n	white-space: nowrap;\n}\n\n.pat-lafontaine .esg-filter-wrapper.eg-search-wrapper .eg-search-submit {\n	margin-left: 5px;\n}\n\n.pat-lafontaine .esg-filter-wrapper.eg-search-wrapper .eg-search-clean,\n.pat-lafontaine .esg-filter-wrapper.eg-search-wrapper .eg-search-submit {\n	width:40px;\n	padding:0px;\n	margin-left: 5px;\n	margin-right:0px;\n}\n\n.pat-lafontaine .esg-filter-wrapper.eg-search-wrapper .eg-search-input {\n	width:auto;\n}\n\n.pat-lafontaine .esg-sortbutton {\n  	border-radius: 0;\n  	padding-right: 40px\n}\n\n.pat-lafontaine .esg-sortbutton:after,\n.pat-lafontaine .esg-selected-filterbutton .eg-icon-down-open:before{\n  	content: \"\";\n  	position: absolute;\n  	width: 5px;\n  	height: 5px;\n  	border-left: 1px solid #000;\n  	border-bottom: 1px solid #000;\n  	transform: rotate(-45deg) translateY(-6px);\n  	right: 15px;\n  	top: 50%\n}\n\n.pat-lafontaine .esg-sortbutton.hovered:after {\n  	border-left: 1px solid #fff;\n  	border-bottom: 1px solid #fff;\n}\n\n.pat-lafontaine .esg-dropdown-wrapper {\n	transform: translateZ(10px) translateX(-50%);\n	left: 50%;\n	background:transparent;\n	padding:0px;\n}\n\n.pat-lafontaine .esg-dropdown-wrapper .esg-filterbutton {\n	position: relative;\n  	width: 100%;\n}\n\n.pat-lafontaine .esg-selected-filterbutton .eg-icon-down-open {\n	margin-right: -10px;\n	font-size: 12px;\n	color:#999;\n}\n\n.pat-lafontaine .dropdownstyle .esg-filterbutton .esg-filter-checked {\n  margin-left: 0;\n  transform: translateY(-2px);\n}\n\n.pat-lafontaine .esg-selected-filterbutton.hoveredfilter .eg-icon-down-open,\n.pat-lafontaine .esg-selected-filterbutton.hovered .eg-icon-down-open {\n	color:#000;\n}\n\n.pat-lafontaine .eg-search-wrapper {background: #3d3b3e}\n.pat-lafontaine .eg-search-wrapper .eg-search-input {\n  background: #3d3b3e;\n  font-style: italic;\n  border-bottom: 1px solid #868689;\n  line-height: 22px;\n  min-height: 22px;\n  padding: 0;\n  margin: 0 0 0 20px !important;\n}\n\n.pat-lafontaine .eg-search-wrapper .eg-search-input.hovered,\n.pat-lafontaine .eg-search-wrapper .eg-search-input:focus,\n.pat-lafontaine .eg-search-wrapper .eg-search-input:active,\n.pat-lafontaine .esg-filter-wrapper.eg-search-wrapper .eg-search-submit {\n  background-color: #3d3b3e !important;\n  color: #fff !important;\n}\n\n.pat-lafontaine .eg-search-wrapper .eg-search-input.hovered,\n.pat-lafontaine .eg-search-wrapper input:-webkit-autofill,\n.pat-lafontaine .eg-search-wrapper input:-webkit-autofill:hover,\n.pat-lafontaine .eg-search-wrapper input:-webkit-autofill:focus {\n  border-bottom: 1px solid #fff;\n  -webkit-text-fill-color: #fff;\n  -webkit-box-shadow: 0 0 0px 1000px #3d3b3e inset;\n}\n\n.pat-lafontaine .esg-filter-wrapper.eg-search-wrapper .eg-search-submit {\n  margin-left: 0;\n  width: 46px;\n}\n.pat-lafontaine .esg-filter-wrapper.eg-search-wrapper .eg-search-submit.hovered {\n  background: #000;\n}\n\n.pat-lafontaine .esg-filter-wrapper.eg-search-wrapper .eg-search-clean {\n  margin-left: 0;\n  width: 46px;\n  background: #000;\n  color: #fff\n}\n\n.pat-lafontaine .esg-filter-wrapper.eg-search-wrapper .eg-search-clean.hovered {\n  background: #f03e3f;\n}\n\n@import url(\"https://fonts.googleapis.com/css2?family=Barlow+Condensed:ital,wght@0,400;0,500;0,600;1,400&display=swap\");\n@import url(\"https://fonts.googleapis.com/icon?family=Material+Icons\");\n\n");
INSERT INTO `rtl_lnd_eg_navigation_skins` VALUES("12", "Grant Fuhr", "grant-fuhr", "/*************************************\n	-	Grant Fuhr 3.0.0 SKIN -\n*************************************/\n.grant-fuhr .esg-filters {\n  margin-bottom: 20px !important;\n}\n\n.grant-fuhr .navigationbuttons,\n.grant-fuhr .esg-pagination,\n.grant-fuhr .esg-filters {\n	text-transform: uppercase;\n	text-align: center;\n}\n\n\n.grant-fuhr .esg-filter-wrapper.dropdownstyle>.esg-selected-filterbutton,\n.grant-fuhr input.eg-search-input,\n.grant-fuhr .esg-filterbutton,\n.grant-fuhr .esg-navigationbutton,\n.grant-fuhr .esg-sortbutton,\n.grant-fuhr .esg-cartbutton,\n.grant-fuhr .esg-filter-wrapper.eg-search-wrapper  .eg-search-clean,\n.grant-fuhr .esg-filter-wrapper.eg-search-wrapper  .eg-search-submit {\n	color: #fff;\n	margin-right: 13px;\n	cursor: pointer;\n	position: relative;\n	z-index: 2;\n	padding: 0px 15px;\n	border: none;\n	line-height: 50px;\n	font-size: 12px;\n	font-weight: 400;\n	font-family: \"Open Sans\", sans-serif;\n  	font-style: italic;\n  	letter-spacing: 1px;\n	display: inline-block;\n	background: #2e2e34;\n	margin-bottom: 1px;\n	white-space: nowrap;\n	min-height: 50px;\n	vertical-align: top;\n  	border-radius: 0px !important;\n  	min-width: 42px;\n  	text-transform: none;\n}\n.grant-fuhr .esg-cartbutton-wrapper {\n  margin: 0 11px !important;\n}\n\n.grant-fuhr .esg-filterbutton.esg-allfilter {\n  	text-decoration: underline;\n}\n\n.grant-fuhr .esg-sortbutton-wrapper {\n  position: relative;\n  margin: 0 2px 0 8px !important;\n}\n\n.grant-fuhr .esg-sortbutton-wrapper .esg-sortbutton {\n  padding-right: 35px;\n}\n\n.grant-fuhr .esg-filterbutton:before,\n.grant-fuhr .eg-search-wrapper:before,\n.grant-fuhr .esg-cartbutton:before,\n.grant-fuhr .esg-sortbutton-wrapper .esg-sortbutton:before,\n.grant-fuhr .esg-filter-wrapper.dropdownstyle:before {\n  	width: 0;\n	height: 0;\n	border-style: solid;\n	border-width: 0 0 50px 12px;\n	border-color: transparent transparent #2e2e34 transparent;\n  	position: absolute;\n  	content:\"\";\n  	top: 0;\n  	left: -12px\n}\n\n.grant-fuhr .esg-sortbutton-wrapper .esg-sortbutton.hovered:before {\n  border-color: transparent transparent #fff157 transparent;\n}\n\n.grant-fuhr .esg-filterbutton:after,\n.grant-fuhr .eg-search-wrapper .eg-search-clean:after,\n.grant-fuhr .esg-cartbutton:after,\n.grant-fuhr .esg-sortbutton-order:after,\n.grant-fuhr .esg-filter-wrapper.dropdownstyle:after {\n  	width: 0;\n	height: 0;\n	border-style: solid;\n	border-width: 50px 12px 0 0;\n	border-color: #2e2e34 transparent transparent transparent;\n  	position: absolute;\n  	content:\"\";\n  	top: 0;\n  	right: -12px\n}\n\n.grant-fuhr .esg-filter-wrapper.dropdownstyle:after {\n  right: 1px\n}\n\n.grant-fuhr .esg-filterbutton.hovered:before,\n.grant-fuhr .esg-filterbutton.selected:before,\n.grant-fuhr .esg-cartbutton.hovered:before,\n.grant-fuhr .esg-sortbutton-wrapper.hovered:before,\n.grant-fuhr .esg-filter-wrapper.dropdownstyle:hover:before {\n  border-color: transparent transparent #fff157 transparent;\n}\n\n.grant-fuhr .esg-filterbutton.hovered:after,\n.grant-fuhr .esg-filterbutton.selected:after,\n.grant-fuhr .esg-cartbutton.hovered:after,\n.grant-fuhr .esg-sortbutton-wrapper.hovered:after,\n.grant-fuhr .esg-filter-wrapper.dropdownstyle:hover:after {\n  border-color: #fff157 transparent transparent transparent;\n}\n\n.esg-sortbutton-order.tp-desc {\n  transform: none;\n}\n\n.esg-sortbutton-order.tp-desc:before {\n  transform: scaleY(-1);\n}\n\n.grant-fuhr .esg-filterbutton .eg-el-amount {\n  position: absolute;\n  line-height: 27px;\n  min-width: 27px;\n  border-radius: 50%;\n  background: #fff157;\n  color: #000;\n  top: -13px;\n  right: -5px;\n  text-align: center;\n  z-index: 2;\n  font-style: normal;\n  font-weight: 600;\n\n}\n\n.grant-fuhr .esg-filterbutton .eg-el-amount:before,\n.grant-fuhr .esg-filterbutton .eg-el-amount:after {\n  display: none\n}\n\n.grant-fuhr .esg-filterbutton.selected .eg-el-amount {\n  background: #2e2e34;\n  color: #fff;\n}\n\n.grant-fuhr .esg-cartbutton a {\n	color: #fff;\n}\n\n.grant-fuhr .esg-cartbutton.hovered a {\n  color: #000;\n}\n\n.grant-fuhr .eg-search-wrapper {\n  position: relative\n}\n\n.grant-fuhr .eg-search-wrapper:before {\n  border-color: transparent transparent #fff157 transparent;\n}\n\n.grant-fuhr input.eg-search-input {\n  background: #fff157;\n  outline-style: none;\n  margin-bottom: 0 !important;\n}\n\n.grant-fuhr input.eg-search-input::placeholder {\n	line-height: 40px;\n	vertical-align: middle;\n	color:#000;\n}\n\n.grant-fuhr input.eg-search-input:focus::placeholder {\n  opacity: 0;\n}\n\n.grant-fuhr .esg-filter-wrapper.eg-search-wrapper .eg-search-submit {\n  margin-left: 0 !important;\n  min-width: 50px;\n  background: #fff157;\n  color: #000;\n}\n\n.grant-fuhr .esg-filter-wrapper.eg-search-wrapper .eg-search-submit.hovered {\n  background: #2e2e34 !important;\n  color: #fff157 !important;\n}\n\n.grant-fuhr .esg-filter-wrapper.eg-search-wrapper .eg-search-clean {\n  margin-left: 0 !important;\n  min-width: 50px;\n}\n\n.grant-fuhr .esg-filter-wrapper.eg-search-wrapper .eg-search-clean.hovered:after {\n	border-color: #fff157 transparent transparent transparent;\n}\n\n.grant-fuhr .esg-sortbutton-order.eg-icon-down-open:before {\n  	content: \"arrow_downward\";\n 	font-family: \"Material Icons\";\n  	font-size: 18px;\n  	color: #000;\n  	vertical-align: middle;\n}\n\n.grant-fuhr .esg-sortbutton-order.hovered.eg-icon-down-open:before {\n  color: #fff\n}\n\n.grant-fuhr .esg-navigationbutton {\n	padding: 0px;\n	width:40px;\n}\n\n.grant-fuhr .esg-navigationbutton.esg-loadmore {\n  	width: auto;\n  	padding: 0 20px\n}\n\n.grant-fuhr .esg-navigationbutton * {\n	color: #999;\n}\n\n.grant-fuhr .esg-pagination-button:last-child {\n	margin-right: 0;\n}\n\n.grant-fuhr .esg-navigationbutton.selected,\n.grant-fuhr .esg-navigationbutton.hovered {\n  color: #000 !important;\n}\n\n.grant-fuhr .esg-navigationbutton.esg-right,\n.grant-fuhr .esg-navigationbutton.esg-left {\n  width: 50px;\n}\n\n.grant-fuhr .esg-navigationbutton.esg-right i,\n.grant-fuhr .esg-navigationbutton.esg-left i {\n  color: #fff;\n}\n\n.grant-fuhr .esg-navigationbutton.esg-right.hovered i,\n.grant-fuhr .esg-navigationbutton.esg-left.hovered i {\n  color: #000;\n}\n\n.grant-fuhr .esg-sortbutton-wrapper,\n.grant-fuhr .esg-cartbutton-wrapper {\n	display: inline-block;\n}\n\n.grant-fuhr .esg-sortbutton-order,\n.grant-fuhr .esg-cartbutton-order {\n	display: inline-block;\n	vertical-align: top;\n	border: none;\n	width: 50px;\n	line-height: 40px;\n	border-radius: 0;\n	font-size: 12px;\n	font-weight: 700;\n	color: #999;\n	cursor: pointer;\n	background: #fff157;\n	margin-left: 0;\n  	line-height: 50px;\n}\n\n.grant-fuhr .esg-sortbutton-order.hovered,\n.grant-fuhr .esg-cartbutton-order.hovered {\n  	color: #fff157 !important;\n  	background: #2e2e34 !important;\n}\n\n.grant-fuhr .esg-sortbutton-order:after {\n	border-color: #fff157 transparent transparent transparent;\n}\n\n.grant-fuhr .esg-sortbutton-order.hovered:after {\n  border-color: #2e2e34 transparent transparent transparent;\n}\n\n.grant-fuhr .esg-cartbutton {\n	color: #999;\n	cursor: default !important;\n}\n\n.grant-fuhr .esg-cartbutton .esgicon-basket {\n	color: #999;\n	font-size: 15px;\n	line-height: 15px;\n	margin-right: 10px;\n}\n\n.grant-fuhr .esg-cartbutton-wrapper {\n	cursor: default !important;\n}\n\n.grant-fuhr .esg-sortbutton,\n.grant-fuhr .esg-cartbutton {\n	display: inline-block;\n	position: relative;\n	cursor: pointer;\n	margin-right: 0px;\n	border-radius: 5px;\n}\n\n.grant-fuhr input.eg-search-input.hovered,\n.grant-fuhr input.eg-search-input:focus,\n.grant-fuhr .esg-filter-wrapper.dropdownstyle>.esg-selected-filterbutton.hovered,\n.grant-fuhr .esg-filter-wrapper.dropdownstyle>.esg-selected-filterbutton.hoveredfilter,\n.grant-fuhr .esg-navigationbutton.hovered,\n.grant-fuhr .esg-filterbutton.hovered,\n.grant-fuhr .esg-sortbutton.hovered,\n.grant-fuhr .esg-sortbutton-order.hovered,\n.grant-fuhr .esg-cartbutton-order.hovered,\n.grant-fuhr .esg-filterbutton.selected,\n.grant-fuhr .esg-cartbutton.hovered,\n.grant-fuhr .esg-filter-wrapper.eg-search-wrapper  .eg-search-clean.hovered,\n.grant-fuhr .esg-filter-wrapper.eg-search-wrapper  .eg-search-submit.hovered {\n	border-color: none;\n	color: #000;\n	background: #fff157;\n}\n\n.grant-fuhr .esg-navigationbutton.hovered * {\n	color: #000;\n}\n\n.grant-fuhr .esg-sortbutton-order.hovered.tp-desc {\n	color: #000;\n}\n\n.grant-fuhr .esg-allfilter.esg-allfilter {\n}\n\n.grant-fuhr .esg-filter-checked {\n	color: #cbcbcb;\n	background: #cbcbcb;\n	margin-left: 10px;\n	font-size: 9px;\n	font-weight: 300;\n	line-height: 9px;\n	vertical-align: middle;\n}\n\n.grant-fuhr .esg-filterbutton.selected .esg-filter-checked,\n.grant-fuhr .esg-filterbutton.hovered .esg-filter-checked {\n	color: #fff;\n	background: #000;\n}\n\n.grant-fuhr .esg-filter-wrapper.eg-search-wrapper {\n	white-space: nowrap;\n}\n\n.grant-fuhr .esg-filter-wrapper.eg-search-wrapper .eg-search-submit {\n	margin-left: 5px;\n}\n\n.grant-fuhr .esg-filter-wrapper.eg-search-wrapper .eg-search-clean,\n.grant-fuhr .esg-filter-wrapper.eg-search-wrapper .eg-search-submit {\n	width:40px;\n	padding:0px;\n	margin-left: 5px;\n	margin-right:0px;\n}\n\n.grant-fuhr .esg-filter-wrapper.eg-search-wrapper .eg-search-input {\n	width:auto;\n}\n\n.grant-fuhr .esg-dropdown-wrapper {\n	transform: translateZ(10px) translateX(-50%);\n	left: 50%;\n	background:transparent;\n	padding:0px;\n}\n\n.grant-fuhr .esg-dropdown-wrapper .esg-filterbutton {\n	position: relative\n}\n\n.grant-fuhr .esg-selected-filterbutton .eg-icon-down-open {\n	margin-right: -10px;\n	font-size: 12px;\n	color:#999;\n}\n.grant-fuhr .esg-selected-filterbutton.hoveredfilter .eg-icon-down-open,\n.grant-fuhr .esg-selected-filterbutton.hovered .eg-icon-down-open {\n	color:#000;\n}\n\n.grant-fuhr .esg-sortbutton:after,\n.grant-fuhr .esg-selected-filterbutton .eg-icon-down-open:before {\n  	content: \"\";\n  	position: absolute;\n  	width: 5px;\n  	height: 5px;\n  	border-left: 1px solid #fff157;\n  	border-bottom: 1px solid #fff157;\n  	transform: rotate(-45deg) translateY(-6px);\n  	right: 15px;\n  	top: 50%\n}\n\n.grant-fuhr .esg-sortbutton.hovered:after,\n.grant-fuhr .esg-selected-filterbutton.hovered .eg-icon-down-open:before,\n.grant-fuhr .esg-filter-wrapper.dropdownstyle:hover .esg-selected-filterbutton .eg-icon-down-open:before {\n  	border-left: 1px solid #000;\n  	border-bottom: 1px solid #000;\n}\n\n.grant-fuhr .esg-dropdown-wrapper .esg-filterbutton {\n  width: 100%;\n  margin: 0;\n}\n\n.grant-fuhr .esg-dropdown-wrapper .esg-filterbutton:before,\n.grant-fuhr .esg-dropdown-wrapper .esg-filterbutton:after {\n  display: none;\n}\n\n.grant-fuhr .esg-filter-wrapper.dropdownstyle:hover .esg-selected-filterbutton {\n  background: #fff157;\n  color: #000;\n}\n\n@import url(\"https://fonts.googleapis.com/icon?family=Material+Icons\");\n\n");
INSERT INTO `rtl_lnd_eg_navigation_skins` VALUES("13", "Leon Draisaitl", "leon-draisaitl", "/*************************************\n	-	LEON DRAISAITL 3.0.0 SKIN   -\n*************************************/\n.leon-draisaitl .esg-overflowtrick {\n  margin: 20px 0;\n}\n\n.leon-draisaitl .navigationbuttons,\n.leon-draisaitl .esg-pagination,\n.leon-draisaitl .esg-filters {\n	text-align: center;\n}\n\n.leon-draisaitl .esg-filter-wrapper.dropdownstyle>.esg-selected-filterbutton,\n.leon-draisaitl input.eg-search-input,\n.leon-draisaitl .esg-filterbutton,\n.leon-draisaitl .esg-navigationbutton,\n.leon-draisaitl .esg-sortbutton,\n.leon-draisaitl .esg-cartbutton,\n.leon-draisaitl .esg-sortbutton-order,\n.leon-draisaitl .esg-cartbutton-order,\n.leon-draisaitl .esg-filter-wrapper.eg-search-wrapper  .eg-search-clean,\n.leon-draisaitl .esg-filter-wrapper.eg-search-wrapper  .eg-search-submit {\n	color: #000;\n	cursor: pointer;\n	padding: 0px 20px;\n	border: 2px solid #000;\n	line-height: 50px;\n	font-size: 16px;\n	font-weight: 500;\n	font-family: \"Roboto Mono\", monospace;\n 	display: inline-block;\n	background: transparent;\n	margin: -2px -2px 0 0 !important;\n	white-space: nowrap;\n	min-height: 50px;\n	vertical-align: middle;\n  	min-width: 54px;\n  	box-shadow: inset 0px 0px 0px 0px #000;\n  	transition: all 0.4s ease;\n}\n\n.leon-draisaitl .esg-sortbutton-wrapper,\n.leon-draisaitl .esg-filter-wrapper,\n.leon-draisaitl .esg-cartbutton-wrapper {\n  margin: 0 !important;\n}\n\n.leon-draisaitl .esg-cartbutton a {\n	color:#000;\n}\n\n.leon-draisaitl input.eg-search-input::placeholder {\n	line-height: 30px;\n	vertical-align: middle;\n	color:#000;\n}\n\n.leon-draisaitl input.eg-search-input.hovered::placeholder {\n  color: #fff;\n}\n\n.leon-draisaitl .esg-navigationbutton * {\n	color: #000;\n}\n\n.leon-draisaitl .esg-left,\n.leon-draisaitl .esg-right {\n	color: #000;\n	padding: 0px 7px;\n}\n\n.leon-draisaitl .esg-pagination-button:last-child {\n	margin-right: 0;\n}\n\n.leon-draisaitl .esg-sortbutton-wrapper,\n.leon-draisaitl .esg-cartbutton-wrapper {\n	display: inline-block;\n	vertical-align: top;\n}\n\n.leon-draisaitl .esg-sortbutton-order,\n.leon-draisaitl .esg-cartbutton-order {\n	padding: 0px;\n	width: 29px;\n	font-size: 9px;\n}\n\n.leon-draisaitl .esg-cartbutton {\n	color: #333;\n	cursor: default !important;\n}\n\n.leon-draisaitl .esg-cartbutton.hovered *,\n.leon-draisaitl .esg-navigationbutton.hovered * {\n  color: #fff !important;\n}\n\n.leon-draisaitl .esg-cartbutton .esgicon-basket {\n	color: #333;\n	font-size: 15px;\n	line-height: 15px;\n	margin-right: 10px;\n}\n\n.leon-draisaitl .esg-cartbutton-wrapper {\n	cursor: default !important;\n}\n\n.leon-draisaitl .esg-sortbutton,\n.leon-draisaitl .esg-cartbutton {\n	display: inline-block;\n	position: relative;\n	cursor: pointer;\n	margin-right: 5px;\n}\n\n.leon-draisaitl input.eg-search-input.hovered,\n.leon-draisaitl input.eg-search-input:focus,\n.leon-draisaitl .esg-navigationbutton.hovered,\n.leon-draisaitl .esg-filterbutton.hovered,\n.leon-draisaitl .esg-sortbutton.hovered,\n.leon-draisaitl .esg-sortbutton-order.hovered,\n.leon-draisaitl .esg-cartbutton.hovered,\n.leon-draisaitl .esg-filterbutton.selected,\n.leon-draisaitl .esg-filter-wrapper.dropdownstyle>.esg-selected-filterbutton.hovered,\n.leon-draisaitl .esg-filter-wrapper.dropdownstyle>.esg-selected-filterbutton.hoveredfilter,\n.leon-draisaitl .esg-filter-wrapper.eg-search-wrapper  .eg-search-clean.hovered,\n.leon-draisaitl .esg-filter-wrapper.eg-search-wrapper  .eg-search-submit.hovered {\n	background-color: #fff;\n	border-color: #000;\n	color: #fff;\n	box-shadow: inset 0px 0px 0px 50px #000;\n}\n\n.leon-draisaitl .esg-cartbutton.hovered a {\n	color:#000;\n}\n\n.leon-draisaitl .esg-navigationbutton.hovered * {\n	color: #333;\n}\n\n.leon-draisaitl .esg-sortbutton-order.hovered .tp-desc {\n	border-color: #bbb;\n	color: #333;\n	box-shadow: 0px -3px 5px 0px rgba(0, 0, 0, 0.13) !important;\n}\n\n.leon-draisaitl .esg-filter-checked {\n	color: #aaa;\n  	border: 2px solid #000;\n	background: transparent;\n	margin-left: 10px;\n	font-size: 9px;\n	font-weight: 400;\n	line-height: 14px;\n	vertical-align: middle;\n  	text-align: center;\n  	min-width: 18px;\n  	display: inline-block;\n}\n\n.leon-draisaitl .esg-filterbutton.selected .esg-filter-checked,\n.leon-draisaitl .esg-filterbutton.hovered .esg-filter-checked {\n	color: #000;\n	background: #fff;\n}\n\n.leon-draisaitl .esg-filter-wrapper.eg-search-wrapper {\n	line-height: 30px;\n	white-space: nowrap;\n}\n\n.leon-draisaitl .esg-filter-wrapper.eg-search-wrapper .eg-search-submit {\n	margin-left: 5px;\n}\n\n.leon-draisaitl .esg-filter-wrapper.eg-search-wrapper .eg-search-clean,\n.leon-draisaitl .esg-filter-wrapper.eg-search-wrapper .eg-search-submit {\n	width:29px;\n	padding:0px;\n	margin-left: 5px;\n	margin-right:0px;\n}\n\n.leon-draisaitl .esg-filter-wrapper.eg-search-wrapper .eg-search-input {\n	width:auto;\n	border-radius:0px;\n}\n\n.leon-draisaitl .esg-dropdown-wrapper {\n	left: 0px;\n	background: #fff;\n  	border: 2px solid #000;\n  	margin-top: -2px;\n  	padding: 0;\n}\n\n.leon-draisaitl .esg-dropdown-wrapper .esg-filterbutton {\n	position: relative;\n	text-align: left;\n	background:transparent;\n	padding: 5px 20px;\n	border:none;\n	box-shadow: none;\n  	box-sizing: border-box;\n}\n\n.leon-draisaitl .esg-dropdown-wrapper .esg-filterbutton.esg-allfilter {\n  width: 100%;\n}\n\n.leon-draisaitl .esg-dropdown-wrapper .esg-filterbutton.selected,\n.leon-draisaitl .esg-dropdown-wrapper .esg-filterbutton.hovered {\n  background: #000;\n}\n\n.leon-draisaitl .esg-dropdown-wrapper .esg-filterbutton .esg-filter-checked {\n  margin: 0 10px 0 -2px;\n}\n\n.leon-draisaitl .esg-selected-filterbutton .eg-icon-down-open {\n	margin-right: -10px;\n	font-size: 9px;\n	color:#000;\n}\n.leon-draisaitl .esg-selected-filterbutton.hovered .eg-icon-down-open,\n.leon-draisaitl .esg-selected-filterbutton.hoveredfilter .eg-icon-down-open {\n	color: #fff;\n}\n\n.leon-draisaitl .esg-sortbutton-order.eg-icon-down-open:before {\n    content: \"arrow_downward\";\n    font-family: \"Material Icons\";\n  	font-size: 19px;\n  	vertical-align: middle;\n}\n\n@import url(\"https://fonts.googleapis.com/css2?family=Roboto+Mono:wght@400;500&display=swap\");\n@import url(\"https://fonts.googleapis.com/icon?family=Material+Icons\");\n");
INSERT INTO `rtl_lnd_eg_navigation_skins` VALUES("14", "Uwe Krupp", "uwe-krupp", "/*************************************\n	-	UWE KRUPP 3.0.0 SKIN   -\n*************************************/\n.uwe-krupp .esg-overflowtrick {\n  margin: 50px 0;\n}\n\n.uwe-krupp .navigationbuttons,\n.uwe-krupp .esg-pagination,\n.uwe-krupp .esg-filters {\n	text-align: center;\n}\n\n.uwe-krupp .esg-filter-wrapper.dropdownstyle>.esg-selected-filterbutton,\n.uwe-krupp input.eg-search-input,\n.uwe-krupp .esg-filterbutton,\n.uwe-krupp .esg-navigationbutton,\n.uwe-krupp .esg-sortbutton,\n.uwe-krupp .esg-cartbutton,\n.uwe-krupp .esg-sortbutton-order,\n.uwe-krupp .esg-cartbutton-order,\n.uwe-krupp .esg-filter-wrapper.eg-search-wrapper  .eg-search-clean,\n.uwe-krupp .esg-filter-wrapper.eg-search-wrapper  .eg-search-submit {\n	color: #6a666b;\n  	letter-spacing: 1px;\n	margin-right: 5px;\n	cursor: pointer;\n	padding: 0px 15px;\n	line-height: 40px;\n	font-size: 13px;\n	font-weight: 400;\n	font-family: \"Arvo\", serif;\n 	display: inline-block;\n	background: rgba(255, 255, 255, 0.65);\n	margin-bottom: 5px;\n	white-space: nowrap;\n	min-height: 40px;\n	vertical-align: middle;\n  	min-width: 40px;\n  	border-radius: 12px;\n}\n\n.uwe-krupp .esg-cartbutton a {\n	color:#000;\n}\n\n.uwe-krupp input.eg-search-input::placeholder {\n	line-height: 30px;\n	vertical-align: middle;\n	color: #6a666b;\n}\n\n.uwe-krupp input.eg-search-input:focus::placeholder {\n  opacity: 0;\n}\n\n.uwe-krupp .esg-navigationbutton.esg-right,\n.uwe-krupp .esg-navigationbutton.esg-left {\n  background: #b0a5b4;\n}\n\n.uwe-krupp .esg-navigationbutton.esg-left {\n  border-radius: 0 12px 12px 0px;\n}\n\n.uwe-krupp .esg-navigationbutton.esg-right {\n  border-radius: 12px 0px 0px 12px;\n}\n\n.uwe-krupp .esg-navigationbutton * {\n	color: #000;\n}\n\n.uwe-krupp .esg-left,\n.uwe-krupp .esg-right {\n	color: #000;\n	padding: 0px 7px;\n}\n\n.uwe-krupp .esg-pagination-button:last-child {\n	margin-right: 0;\n}\n\n.uwe-krupp .esg-sortbutton-wrapper,\n.uwe-krupp .esg-cartbutton-wrapper {\n	display: inline-block;\n	vertical-align: top;\n}\n\n.uwe-krupp .esg-sortbutton-order,\n.uwe-krupp .esg-cartbutton-order {\n	padding: 0px;\n	width: 29px;\n	font-size: 9px;\n}\n\n.uwe-krupp .esg-cartbutton {\n	color: #757176;\n	cursor: default !important;\n}\n\n.uwe-krupp .esg-cartbutton .esgicon-basket {\n	color: #757176;\n	font-size: 15px;\n	line-height: 15px;\n	margin-right: 10px;\n}\n\n.uwe-krupp .esg-cartbutton .ess-cart-content {\n  color: #757176;\n}\n\n.uwe-krupp .esg-cartbutton-wrapper {\n	cursor: default !important;\n}\n\n.uwe-krupp .esg-sortbutton,\n.uwe-krupp .esg-cartbutton {\n	display: inline-block;\n	position: relative;\n	cursor: pointer;\n	margin-right: 5px;\n}\n\n.uwe-krupp input.eg-search-input.hovered,\n.uwe-krupp input.eg-search-input:focus,\n.uwe-krupp .esg-navigationbutton.hovered,\n.uwe-krupp .esg-filterbutton.hovered,\n.uwe-krupp .esg-sortbutton.hovered,\n.uwe-krupp .esg-sortbutton-order.hovered,\n.uwe-krupp .esg-cartbutton.hovered,\n.uwe-krupp .esg-filterbutton.selected,\n.uwe-krupp .esg-filter-wrapper.dropdownstyle>.esg-selected-filterbutton.hovered,\n.uwe-krupp .esg-filter-wrapper.dropdownstyle>.esg-selected-filterbutton.hoveredfilter,\n.uwe-krupp .esg-filter-wrapper.eg-search-wrapper  .eg-search-clean.hovered,\n.uwe-krupp .esg-filter-wrapper.eg-search-wrapper  .eg-search-submit.hovered {\n	background-color: #fff;\n	color: #333;\n}\n\n.uwe-krupp .esg-cartbutton.hovered a {\n	color:#000;\n}\n\n.uwe-krupp .esg-navigationbutton.hovered * {\n	color: #333;\n}\n\n.uwe-krupp .esg-sortbutton-order.hovered .tp-desc {\n	border-color: #bbb;\n	color: #333;\n	box-shadow: 0px -3px 5px 0px rgba(0, 0, 0, 0.13) !important;\n}\n\n.uwe-krupp .esg-filter-checked {\n	color: #b0a5b4;\n	background: transparent;\n  	border: 1px solid #b0a5b4;\n	margin-left: 10px;\n	font-size: 9px;\n	font-weight: 400;\n	line-height: 12px;\n 	min-width: 12px;\n	vertical-align: middle;\n  	display: inline-block;\n  	transform: translateY(-1px);\n}\n\n.uwe-krupp .esg-filterbutton.selected .esg-filter-checked,\n.uwe-krupp .esg-filterbutton.hovered .esg-filter-checked {\n	color: #fff;\n	background: #000;\n  	border: 1px solid #000;\n}\n\n.uwe-krupp .esg-filter-wrapper.eg-search-wrapper {\n	line-height: 30px;\n	white-space: nowrap;\n}\n\n.uwe-krupp .esg-filter-wrapper.eg-search-wrapper .eg-search-submit {\n	margin-left: 5px;\n}\n\n.uwe-krupp .esg-filter-wrapper.eg-search-wrapper .eg-search-clean,\n.uwe-krupp .esg-filter-wrapper.eg-search-wrapper .eg-search-submit {\n	width:29px;\n	padding:0px;\n	margin-left: 5px;\n	margin-right:0px;\n}\n\n.uwe-krupp .esg-filter-wrapper.eg-search-wrapper .eg-search-input {\n	width:auto;\n	border-radius: 12px 0px 0px 12px;\n  	border: none;\n}\n\n.uwe-krupp .esg-filter-wrapper.eg-search-wrapper .eg-search-submit {\n  border-radius: 0px 12px 12px 0px;\n  margin-left: 0;\n}\n\n.uwe-krupp .esg-filter-wrapper.eg-search-wrapper .eg-search-submit.hovered,\n.uwe-krupp .esg-filter-wrapper.eg-search-wrapper .eg-search-clean {\n  background: #b0a5b4;\n  color: #fff;\n}\n\n.uwe-krupp .esg-dropdown-wrapper {\n	left: 0px;\n	background:#fff;\n}\n\n.uwe-krupp .esg-dropdown-wrapper .esg-filterbutton {\n	position: relative;\n	text-align: left;\n	background:transparent;\n	padding:0px;\n	border:none;\n	box-shadow: none;\n}\n\n.uwe-krupp .esg-selected-filterbutton .eg-icon-down-open {\n	margin-right: -10px;\n	font-size: 9px;\n	color:#000;\n}\n.uwe-krupp .esg-selected-filterbutton.hovered .eg-icon-down-open,\n.uwe-krupp .esg-selected-filterbutton.hoveredfilter .eg-icon-down-open{\n	color:#333;\n}\n\n.uwe-krupp .esg-sortbutton-order.eg-icon-down-open {\n  background: #b0a5b4;\n  color: #fff;\n}\n\n.uwe-krupp .esg-sortbutton-order.eg-icon-down-open:before {\n    content: \"arrow_downward\";\n    font-family: \"Material Icons\";\n  	font-size: 19px;\n  	vertical-align: middle;\n}\n\n@import url(\"https://fonts.googleapis.com/css2?family=Arvo:wght@400;700&display=swap\");\n@import url(\"https://fonts.googleapis.com/icon?family=Material+Icons\");\n\n");
INSERT INTO `rtl_lnd_eg_navigation_skins` VALUES("15", "Clark Gillies", "clark-gillies", "/*************************************\n	-	CLARK GILLIES 3.0.0 SKIN   -\n*************************************/\n.clark-gillies .navigationbuttons,\n.clark-gillies .esg-pagination,\n.clark-gillies .esg-filters {\n	text-align: center;\n}\n\n.clark-gillies .esg-filters {\n  margin-bottom: 20px !important;\n}\n\n.clark-gillies .esg-filter-wrapper {\n  margin: 0 !important;\n}\n\n.clark-gillies .esg-filter-wrapper.dropdownstyle>.esg-selected-filterbutton,\n.clark-gillies input.eg-search-input,\n.clark-gillies .esg-filterbutton,\n.clark-gillies .esg-navigationbutton,\n.clark-gillies .esg-sortbutton,\n.clark-gillies .esg-cartbutton,\n.clark-gillies .esg-sortbutton-order,\n.clark-gillies .esg-cartbutton-order,\n.clark-gillies .esg-filter-wrapper.eg-search-wrapper  .eg-search-clean,\n.clark-gillies .esg-filter-wrapper.eg-search-wrapper  .eg-search-submit {\n	color: #000;\n	margin: 0 10px 0 0 !important;\n	cursor: pointer;\n	padding: 0px 10px;\n  	border: none;\n	line-height: 28px;\n	font-size: 13px;\n	font-weight: 400;\n	font-family: \"Arvo\", serif;\n 	display: inline-block;\n	background: transparent;\n	white-space: nowrap;\n	min-height: 28px;\n	vertical-align: middle;\n  	letter-spacing: -0.5px;\n  	min-width: 24px;\n  	position: relative;\n  	transition: all 0.3s ease;\n}\n\n.clark-gillies .esg-filterbutton:before,\n.clark-gillies .esg-selected-filterbutton:before,\n.clark-gillies .esg-sortbutton:before {\n  content: \"\";\n  position: absolute;\n  z-index: -1;\n  height: 2px;\n  width: calc(100% - 20px);\n  left: 10px;\n  bottom: 0;\n  background: #000;\n  transition: all 0.3s ease;\n}\n\n.clark-gillies .esg-filterbutton.hovered:before,\n.clark-gillies .esg-filterbutton.selected:before,\n.clark-gillies .esg-filter-wrapper:hover .esg-selected-filterbutton:before,\n.clark-gillies .esg-sortbutton.hovered:before{\n  width: 100%;\n  height: 100%;\n  left: 0;\n}\n\n.clark-gillies .esg-selected-filterbutton.hoveredfilter .eg-icon-down-open {\n  color: #fff !important;\n}\n\n.clark-gillies .esg-cartbutton a {\n	color:#fff;\n}\n\n.clark-gillies input.eg-search-input::placeholder {\n	line-height: 30px;\n	vertical-align: middle;\n	color:#000;\n}\n\n.clark-gillies input.eg-search-input:focus::placeholder {\n  opacity: 0;\n}\n\n.clark-gillies .esg-navigationbutton {\n  min-width: 28px;\n}\n\n.clark-gillies .esg-navigationbutton * {\n	color: #fff;\n}\n\n.clark-gillies .esg-left,\n.clark-gillies .esg-right,\n.clark-gillies .esg-loadmore {\n	color: #fff;\n	padding: 2px 7px;\n  	transition: all 0.3s ease;\n  	box-shadow: inset 0 0 0 20px #000;\n}\n.clark-gillies .esg-left.hovered,\n.clark-gillies .esg-right.hovered,\n.clark-gillies .esg-loadmore.hovered {\n  color: #000 !important;\n  box-shadow: inset 0 0 0 2px #000;\n}\n\n.clark-gillies .esg-loadmore {\n  padding: 0 10px;\n}\n\n.clark-gillies .esg-pagination-button:last-child {\n	margin-right: 0;\n}\n\n.clark-gillies .esg-sortbutton-wrapper,\n.clark-gillies .esg-cartbutton-wrapper {\n	display: inline-block;\n	vertical-align: top;\n}\n\n.clark-gillies .esg-sortbutton-order,\n.clark-gillies .esg-cartbutton-order,\n.clark-gillies .esg-filter-wrapper.eg-search-wrapper .eg-search-clean {\n	padding: 0px;\n	min-width: 30px;\n	font-size: 9px;\n  	transition: all 0.3s ease;\n  	box-shadow: inset 0 0 0 2px #000;\n  	margin-right: 20px !important;\n}\n\n.clark-gillies .esg-sortbutton-order.hovered,\n.clark-gillies .esg-cartbutton-order.hovered,\n.clark-gillies .esg-filter-wrapper.eg-search-wrapper .eg-search-clean.hovered {\n  	box-shadow: inset 0 0 0 20px #000\n}\n\n.clark-gillies .esg-filter-wrapper.eg-search-wrapper .eg-search-clean {\n  font-size: 12px;\n  line-height: 28px !important;\n}\n\n.clark-gillies .esg-sortbutton-order.eg-icon-down-open:before {\n    content: \"arrow_downward\";\n    font-family: \"Material Icons\";\n  	font-size: 19px;\n  	vertical-align: middle;\n}\n\n.clark-gillies .esg-cartbutton {\n	color: #fff;\n	cursor: default !important;\n  	transition: all 0.3s ease;\n  	box-shadow: inset 0 0 0 20px #000;\n}\n\n.clark-gillies .esg-cartbutton.hovered {\n  	box-shadow: inset 0 0 0 2px #000;\n}\n\n.clark-gillies .esg-cartbutton .ess-cart-content {\n  	color: #fff;\n}\n\n.clark-gillies .esg-cartbutton.hovered .ess-cart-content {\n  	color: #000;\n}\n\n.clark-gillies .esg-cartbutton .esgicon-basket {\n	color: #fff;\n	font-size: 15px;\n	line-height: 15px;\n	margin-right: 10px;\n}\n\n.clark-gillies .esg-cartbutton-wrapper {\n	cursor: default !important;\n}\n\n.clark-gillies .esg-sortbutton,\n.clark-gillies .esg-cartbutton {\n	display: inline-block;\n	position: relative;\n	cursor: pointer;\n	margin-right: 0 !important;\n}\n\n.clark-gillies input.eg-search-input.hovered,\n.clark-gillies input.eg-search-input:focus,\n.clark-gillies .esg-navigationbutton.hovered,\n.clark-gillies .esg-filterbutton.hovered,\n.clark-gillies .esg-sortbutton.hovered,\n.clark-gillies .esg-sortbutton-order.hovered,\n.clark-gillies .esg-cartbutton.hovered,\n.clark-gillies .esg-filterbutton.selected,\n.clark-gillies .esg-filter-wrapper.dropdownstyle>.esg-selected-filterbutton.hovered,\n.clark-gillies .esg-filter-wrapper.dropdownstyle>.esg-selected-filterbutton.hoveredfilter,\n.clark-gillies .esg-filter-wrapper.eg-search-wrapper  .eg-search-clean.hovered,\n.clark-gillies .esg-filter-wrapper.eg-search-wrapper  .eg-search-submit.hovered {\n	color: #fff;\n}\n\n.clark-gillies .esg-cartbutton.hovered a {\n	color:#000;\n}\n\n.clark-gillies .esg-navigationbutton.hovered * {\n	color: #333;\n}\n\n.clark-gillies .esg-sortbutton-order.hovered .tp-desc {\n	border-color: #bbb;\n	color: #333;\n	box-shadow: 0px -3px 5px 0px rgba(0, 0, 0, 0.13) !important;\n}\n\n.clark-gillies .esg-filter-checked {\n	color: #000;\n	margin-left: 10px;\n	font-size: 9px;\n	font-weight: 400;\n	line-height: 20px;\n	vertical-align: middle;\n  	border: 1px solid #000;\n  	background: transparent;\n  	padding: 1px 0;\n}\n\n.clark-gillies .esg-filterbutton.selected .esg-filter-checked,\n.clark-gillies .esg-filterbutton.hovered .esg-filter-checked,\n.clark-gillies .esg-dropdown-wrapper .esg-filter-checked {\n	color: #000;\n	background: #fff;\n}\n\n.clark-gillies .esg-dropdown-wrapper .esg-filter-checked {\n  margin-left: 0;\n}\n\n.clark-gillies .esg-filter-wrapper.eg-search-wrapper {\n	line-height: 22px;\n	white-space: nowrap;\n}\n\n.clark-gillies .esg-filter-wrapper.eg-search-wrapper .eg-search-submit {\n	margin-left: 0;\n  	border-bottom: 2px solid #000;\n}\n\n.clark-gillies .esg-filter-wrapper.eg-search-wrapper .eg-search-clean,\n.clark-gillies .esg-filter-wrapper.eg-search-wrapper .eg-search-submit {\n	width: 29px;\n	padding: 0px;\n	margin-left: 0px;\n	margin-right: 0px;\n  	min-height: 26px;\n  	line-height: 26px;\n}\n\n.clark-gillies .esg-filter-wrapper.eg-search-wrapper .eg-search-input {\n	width: auto;\n	border-radius: 0px;\n  	border-bottom: 2px solid #000;\n  	margin: 0 !important;\n  	padding: 2px 0;\n  	min-height: 22px;\n  	line-height: 22px;\n  	font-size: 13px;\n}\n\n.clark-gillies .esg-filter-wrapper.eg-search-wrapper .eg-search-input:focus,\n.clark-gillies .esg-filter-wrapper.eg-search-wrapper .eg-search-input:active,\n.clark-gillies .esg-filter-wrapper.eg-search-wrapper .eg-search-input.hovered {\n  color: #000;\n}\n\n.clark-gillies .esg-dropdown-wrapper {\n	left: 0px;\n	background: #000;\n 	width: 100%;\n}\n\n.clark-gillies .esg-dropdown-wrapper .esg-filterbutton {\n	position: relative;\n	text-align: left;\n	background: transparent;\n	padding: 0px;\n	border: none;\n	box-shadow: none;\n  	color: #fff;\n}\n\n.clark-gillies .esg-dropdown-wrapper .esg-filterbutton.hovered {\n  opacity: 0.6;\n}\n\n.clark-gillies .esg-selected-filterbutton .eg-icon-down-open {\n	margin-right: -10px;\n	font-size: 9px;\n	color:#000;\n}\n.clark-gillies .esg-selected-filterbutton.hovered .eg-icon-down-open,\n.clark-gillies .esg-selected-filterbutton.hoveredfilter .eg-icon-down-open{\n	color:#333;\n}\n\n.clark-gillies .esg-filterbutton .eg-el-amount:before,\n.clark-gillies .esg-filterbutton .eg-el-amount:after {\n  content: \"\";\n}\n\n@import url(\"https://fonts.googleapis.com/css2?family=Arvo:wght@400;700&display=swap\");\n@import url(\"https://fonts.googleapis.com/icon?family=Material+Icons\");\n\n");
INSERT INTO `rtl_lnd_eg_navigation_skins` VALUES("16", "Rod Langway", "rod-langway", "/*************************************\n	-	ROD LANGWAY 3.0.0 SKIN	-\n*************************************/\n.rod-langway .esg-overflowtrick {\n  margin: 20px 0;\n}\n\n.rod-langway .navigationbuttons,\n.rod-langway .esg-pagination,\n.rod-langway .esg-filters {\n	text-align: center;\n}\n\n.rod-langway .esg-filter-wrapper.dropdownstyle>.esg-selected-filterbutton,\n.rod-langway input.eg-search-input,\n.rod-langway .esg-filterbutton,\n.rod-langway .esg-navigationbutton,\n.rod-langway .esg-sortbutton,\n.rod-langway .esg-cartbutton,\n.rod-langway .esg-filter-wrapper.eg-search-wrapper  .eg-search-clean,\n.rod-langway .esg-filter-wrapper.eg-search-wrapper  .eg-search-submit {\n	color: #000;\n	margin-right: 0;\n	cursor: pointer;\n	padding: 4px 17px 0;\n	border: none;\n  	box-sizing: border-box;\n	line-height: 35px;\n	font-size: 10px;\n  	text-transform: uppercase;\n  	letter-spacing: 3px;\n	font-weight: 700;\n	font-family: \"Josefin Sans\", sans-serif;\n	display: inline-block;\n	background: #fff;\n	margin-bottom: 5px;\n	white-space: nowrap;\n	min-height: 40px;\n	vertical-align: middle;\n  	border-radius: 0;\n}\n.rod-langway  .esg-filterbutton .eg-el-amount {\n  background: #ced3d7;\n  display: inline-block;\n  line-height: 24px;\n  min-width: 26px;\n  padding-top: 2px;\n  text-align: center;\n  font-weight: 500;\n  font-size: 12px;\n  letter-spacing: 0;\n}\n\n.rod-langway  .esg-filterbutton.hovered .eg-el-amount,\n.rod-langway  .esg-filterbutton.selected .eg-el-amount {\n  background: #2f2f3a;\n  color: #fff;\n}\n\n.rod-langway .esg-filterbutton .eg-el-amount:before,\n.rod-langway .esg-filterbutton .eg-el-amount:after {\n  content: \"\";\n}\n\n.rod-langway .esg-filter-wrapper.eg-search-wrapper  .eg-search-clean,\n.rod-langway .esg-filter-wrapper.eg-search-wrapper  .eg-search-submit {\n  margin-left: 0 !important;\n  font-size: 14px;\n  letter-spacing: 0;\n  line-height: 40px;\n}\n\n.rod-langway .esg-filter-wrapper.eg-search-wrapper  .eg-search-clean,\n.rod-langway .esg-cartbutton {\n  background: #ced3d7;\n}\n\n.rod-langway .esg-filter-wrapper.eg-search-wrapper  .eg-search-clean.hovered,\n.rod-langway .esg-cartbutton.hovered {\n  background: #b0b5b9 !important;\n}\n\n.rod-langway .esg-cartbutton a {\n	color: #000;\n}\n\n.rod-langway .esg-cartbutton a:hover {\n	color: #000;\n}\n\n.rod-langway input.eg-search-input::placeholder {\n	line-height: 38px;\n	vertical-align: middle;\n	color: #b0b5b9;\n}\n\n.rod-langway input.eg-search-input:focus::placeholder {\n  opacity: 0;\n}\n\n.rod-langway .esg-navigationbutton {\n  line-height: 40px;\n  min-width: 40px;\n  letter-spacing: 0;\n  font-size: 14px;\n  font-weight: 400;\n}\n\n.rod-langway .esg-navigationbutton.esg-left {\n  transform: translateX(-40px)\n}\n\n.rod-langway .esg-navigationbutton.esg-right {\n  transform: translateX(40px)\n}\n\n.rod-langway .esg-navigationbutton * {\n	color: #000;\n\n}\n\n.rod-langway .esg-navigationbutton.hovered i {\n	color: #000;\n}\n\n.rod-langway .esg-navigationbutton {\n	padding: 0px 11px;\n}\n\n.rod-langway .esg-pagination-button {\n	padding: 0px 16px;\n}\n\n.rod-langway .esg-pagination-button:last-child {\n	margin-right: 0;\n}\n\n.rod-langway .esg-sortbutton-wrapper,\n.rod-langway .esg-cartbutton-wrapper {\n	display: inline-block;\n}\n\n.rod-langway .esg-sortbutton-order,\n.rod-langway .esg-cartbutton-order {\n	display: inline-block;\n	vertical-align: top;\n	width: 40px;\n	line-height: 40px;\n	border-radius: 0;\n  	border: none;\n	font-size: 12px;\n	font-weight: 600;\n	color: #000;\n	cursor: pointer;\n  	background: #ced3d7;\n}\n\n.rod-langway .esg-sortbutton-order.hovered,\n.rod-langway .esg-cartbutton-order.hovered {\n  background: #b0b5b9 !important;\n}\n\n.rod-langway .esg-cartbutton {\n	color: #fff;\n	cursor: default !important;\n}\n\n.rod-langway .esg-cartbutton .esgicon-basket {\n	color: #fff;\n	font-size: 15px;\n	line-height: 15px;\n	margin-right: 10px;\n}\n\n.rod-langway .esg-cartbutton-wrapper {\n	cursor: default !important;\n}\n\n.rod-langway .esg-sortbutton,\n.rod-langway .esg-cartbutton {\n	display: inline-block;\n	position: relative;\n	cursor: pointer;\n}\n\n.rod-langway .esg-sortbutton{\n	margin-right: 0px;\n	border-right: none;\n	border-radius: 0;\n}\n\n.rod-langway .esg-filter-wrapper.dropdownstyle>.esg-selected-filterbutton.hovered,\n.rod-langway .esg-filter-wrapper.dropdownstyle>.esg-selected-filterbutton.hoveredfilter,\n.rod-langway .esg-navigationbutton.hovered,\n.rod-langway .esg-filterbutton.hovered,\n.rod-langway .esg-sortbutton.hovered,\n.rod-langway .esg-sortbutton-order.hovered,\n.rod-langway .esg-cartbutton-order.hovered,\n.rod-langway .esg-filterbutton.selected,\n.rod-langway .esg-cartbutton.hovered,\n.rod-langway .esg-filter-wrapper.eg-search-wrapper  .eg-search-clean.hovered,\n.rod-langway .esg-filter-wrapper.eg-search-wrapper  .eg-search-submit.hovered {\n	color: #000;\n	box-shadow: none;\n	background: #ced3d7;\n}\n\n.rod-langway .esg-navigationbutton.hovered * {\n	color: #fff;\n}\n\n.rod-langway .esg-sortbutton-order.hovered .tp-desc {\n	border-color: #fff;\n	border-color: rgba(255, 255, 255, 0.2);\n	color: #fff;\n	box-shadow: 0px -3px 5px 0px rgba(0, 0, 0, 0.13) !important;\n}\n\n.rod-langway .esg-filter-checked {\n	color: #ced3d7;\n  	border: 1px solid #333;\n  	letter-spacing: 0;\n	background: transparent;\n	font-size: 9px;\n	font-weight: 300;\n	vertical-align: middle;\n  	line-height: 14px;\n	margin-left: 7px;\n  	display: inline-block;\n  	width: 14px;\n  	height: 14px;\n  	transform: translateY(-2px);\n}\n\n.rod-langway .esg-filter-wrapper.dropdownstyle .esg-filter-checked {\n	margin-left: 0;\n	margin-right: 10px;\n	border:1px solid rgba(255,255,255,.2);\n}\n\n.rod-langway .esg-filterbutton.selected .esg-filter-checked,\n.rod-langway .esg-filterbutton.hovered .esg-filter-checked {\n	color: #000;\n  	border: 1px solid #000;\n}\n\n/* */\n.rod-langway .esg-filter-wrapper.eg-search-wrapper {\n	white-space: nowrap;\n}\n\n\n.rod-langway .esg-filter-wrapper.eg-search-wrapper .eg-search-clean,\n.rod-langway .esg-filter-wrapper.eg-search-wrapper .eg-search-submit {\n	width:40px;\n	padding:0px;\n	margin-left:5px;\n	margin-right:0px;\n}\n\n.rod-langway .esg-filter-wrapper.eg-search-wrapper .eg-search-input {\n	width:auto;\n}\n\n.rod-langway .esg-dropdown-wrapper {\n	transform: translateZ(10px) translateX(-50%);\n	left: 50%;\n	background: #000;\n	border-radius: 0;\n  	padding: 0;\n}\n\n.rod-langway .esg-dropdown-wrapper .esg-filterbutton {\n	position: relative;\n	border: none;\n	box-shadow: none;\n	text-align: left;\n	color: #fff;\n	background: transparent;\n	line-height: 25px;\n	min-height: 25px;\n  	padding: 10px 20px;\n  	display: inline-block;\n  	width: 100%;\n  	box-sizing: border-box;\n  	margin: 0;\n}\n\n.rod-langway .esg-dropdown-wrapper .esg-filterbutton.hovered,\n.rod-langway .esg-dropdown-wrapper .esg-filterbutton.selected {\n	color: #000;\n  	background: #fff;\n}\n\n\n.rod-langway .esg-selected-filterbutton .eg-icon-down-open {\n	margin-right: -10px;\n	color: #000;\n	font-size: 11px;\n}\n\n.rod-langway .esg-sortbutton-order.eg-icon-down-open:before {\n    content: \"arrow_downward\";\n    font-family: \"Material Icons\";\n  	font-size: 19px;\n  	vertical-align: middle;\n}\n@import url(\"https://fonts.googleapis.com/css2?family=Josefin+Sans:wght@400;500;700&display=swap\");\n@import url(\"https://fonts.googleapis.com/icon?family=Material+Icons\");\n\n");
INSERT INTO `rtl_lnd_eg_navigation_skins` VALUES("17", "Ray Bourge", "ray-bourque", "/**************************************\n	-	RAY BOURGE V3.0.0 SKIN    -\n**************************************/\n\n\n\n.ray-bourque .esg-overflowtrick {\n  margin: 20px 0;\n}\n\n.ray-bourque .navigationbuttons,\n.ray-bourque .esg-pagination,\n.ray-bourque .esg-filters {\n	text-align: center;\n}\n\n.ray-bourque .esg-filter-wrapper.dropdownstyle>.esg-selected-filterbutton,\n.ray-bourque input.eg-search-input,\n.ray-bourque .esg-filterbutton,\n.ray-bourque .esg-navigationbutton,\n.ray-bourque .esg-sortbutton,\n.ray-bourque .esg-cartbutton,\n.ray-bourque .esg-filter-wrapper.eg-search-wrapper  .eg-search-clean,\n.ray-bourque .esg-filter-wrapper.eg-search-wrapper  .eg-search-submit {\n	color: rgba(255, 255, 255, 1);\n	margin-right: 0;\n	cursor: pointer;\n	padding: 0px 17px;\n	border: none;\n	line-height: 40px;\n	font-size: 13px;\n  	letter-spacing: 1px;\n	font-weight: 400;\n	font-family: \"Barlow Condensed\", sans-serif;\n	display: inline-block;\n	background: #000;\n	margin-bottom: 5px;\n	white-space: nowrap;\n	min-height: 40px;\n	vertical-align: middle;\n  	border-radius: 0;\n}\n.ray-bourque  .esg-filterbutton .eg-el-amount {\n  background: #2d2b2b;\n  display: inline-block;\n  line-height: 22px;\n  min-width: 22px;\n  text-align: center;\n  font-weight: 500;\n}\n\n.ray-bourque  .esg-filterbutton.hovered .eg-el-amount,\n.ray-bourque  .esg-filterbutton.selected .eg-el-amount {\n  background: #eaedf1;\n}\n\n.ray-bourque  .esg-filterbutton .eg-el-amount:before,\n.ray-bourque  .esg-filterbutton .eg-el-amount:after {\n  content: \"\";\n}\n\n.ray-bourque .esg-filter-wrapper.eg-search-wrapper  .eg-search-clean,\n.ray-bourque .esg-filter-wrapper.eg-search-wrapper  .eg-search-submit {\n  margin-left: 0 !important;\n}\n\n.ray-bourque .esg-filter-wrapper.eg-search-wrapper  .eg-search-clean {\n  background: #434242;\n}\n\n.ray-bourque .esg-cartbutton a {\n	color: #fff;\n}\n\n.ray-bourque .esg-cartbutton a:hover {\n	color: #000;\n}\n\n.ray-bourque input.eg-search-input::placeholder {\n	line-height: 38px;\n	vertical-align: middle;\n	color:#fff;\n}\n\n.ray-bourque input.eg-search-input:focus::placeholder {\n  opacity: 0;\n}\n\n.ray-bourque .esg-navigationbutton * {\n	color: rgba(255, 255, 255, 1);\n}\n\n.ray-bourque .esg-navigationbutton.hovered i {\n	color: #000;\n}\n\n.ray-bourque .esg-navigationbutton {\n	padding: 0px 11px;\n}\n\n.ray-bourque .esg-pagination-button {\n	padding: 0px 16px;\n}\n\n.ray-bourque .esg-pagination-button:last-child {\n	margin-right: 0;\n}\n\n.ray-bourque .esg-sortbutton-wrapper,\n.ray-bourque .esg-cartbutton-wrapper {\n	display: inline-block;\n}\n\n.ray-bourque .esg-sortbutton-order,\n.ray-bourque .esg-cartbutton-order {\n	display: inline-block;\n	vertical-align: top;\n	width: 40px;\n	line-height: 38px;\n	border-radius: 0;\n  	border: none;\n	font-size: 12px;\n	font-weight: 600;\n	color: #fff;\n	cursor: pointer;\n	background: #434242;\n}\n\n.ray-bourque .esg-cartbutton {\n	color: #fff;\n	cursor: default !important;\n}\n\n.ray-bourque .esg-cartbutton .esgicon-basket {\n	color: #fff;\n	font-size: 15px;\n	line-height: 15px;\n	margin-right: 10px;\n}\n\n.ray-bourque .esg-cartbutton-wrapper {\n	cursor: default !important;\n}\n\n.ray-bourque .esg-sortbutton,\n.ray-bourque .esg-cartbutton {\n	display: inline-block;\n	position: relative;\n	cursor: pointer;\n}\n.ray-bourque .esg-sortbutton{\n	margin-right: 0px;\n	border-right: none;\n	border-radius: 0;\n}\n\n.ray-bourque .esg-filter-wrapper.dropdownstyle>.esg-selected-filterbutton.hovered,\n.ray-bourque .esg-filter-wrapper.dropdownstyle>.esg-selected-filterbutton.hoveredfilter,\n.ray-bourque .esg-navigationbutton.hovered,\n.ray-bourque .esg-filterbutton.hovered,\n.ray-bourque .esg-sortbutton.hovered,\n.ray-bourque .esg-sortbutton-order.hovered,\n.ray-bourque .esg-cartbutton-order.hovered,\n.ray-bourque .esg-filterbutton.selected,\n.ray-bourque .esg-cartbutton.hovered,\n.ray-bourque .esg-filter-wrapper.eg-search-wrapper  .eg-search-clean.hovered,\n.ray-bourque .esg-filter-wrapper.eg-search-wrapper  .eg-search-submit.hovered {\n	color: #000;\n	box-shadow: none;\n	background: #fff;\n}\n\n.ray-bourque .esg-navigationbutton.hovered * {\n	color: #fff;\n}\n\n.ray-bourque .esg-sortbutton-order.hovered .tp-desc {\n	border-color: #fff;\n	border-color: rgba(255, 255, 255, 0.2);\n	color: #fff;\n	box-shadow: 0px -3px 5px 0px rgba(0, 0, 0, 0.13) !important;\n}\n\n.ray-bourque .esg-filter-checked {\n	color: rgba(255,255,255,.5);\n  	border: 1px solid rgba(255,255,255,.5);\n	background: transparent;\n	font-size: 9px;\n	font-weight: 300;\n	vertical-align: middle;\n  	line-height: 12px;\n	margin-left: 7px;\n  	display: inline-block;\n  	width: 14px;\n  	height: 14px;\n  	transform: translateY(-2px);\n}\n\n.ray-bourque .esg-filter-wrapper.dropdownstyle .esg-filter-checked {\n	margin-left: 0;\n	margin-right: 10px;\n	border:1px solid rgba(255,255,255,.2);\n}\n\n.ray-bourque .esg-filterbutton.selected .esg-filter-checked,\n.ray-bourque .esg-filterbutton.hovered .esg-filter-checked {\n	color: #000;\n  	border: 1px solid #000;\n}\n\n/* */\n.ray-bourque .esg-filter-wrapper.eg-search-wrapper {\n	white-space: nowrap;\n}\n\n\n.ray-bourque .esg-filter-wrapper.eg-search-wrapper .eg-search-clean,\n.ray-bourque .esg-filter-wrapper.eg-search-wrapper .eg-search-submit {\n	width:40px;\n	padding:0px;\n	margin-left:5px;\n	margin-right:0px;\n}\n\n.ray-bourque .esg-filter-wrapper.eg-search-wrapper .eg-search-input {\n	width:auto;\n}\n\n.ray-bourque .esg-dropdown-wrapper {\n	transform: translateZ(10px) translateX(-50%);\n	left: 50%;\n	background: #000;\n	border-radius: 0;\n  	padding: 0;\n}\n\n.ray-bourque .esg-dropdown-wrapper .esg-filterbutton {\n	position: relative;\n	border: none;\n	box-shadow: none;\n	text-align: left;\n	color: #fff;\n	background: transparent;\n	line-height: 25px;\n	min-height: 25px;\n  	padding: 10px 20px;\n  	display: inline-block;\n  	width: 100%;\n  	box-sizing: border-box;\n  	margin: 0;\n}\n\n.ray-bourque .esg-dropdown-wrapper .esg-filterbutton.hovered,\n.ray-bourque .esg-dropdown-wrapper .esg-filterbutton.selected {\n	color: #000;\n  	background: #fff;\n}\n\n\n.ray-bourque .esg-selected-filterbutton .eg-icon-down-open {\n	margin-right: -10px;\n	color:#fff;\n	font-size:12px;\n}\n\n.ray-bourque .esg-sortbutton-order.eg-icon-down-open:before {\n    content: \"arrow_downward\";\n    font-family: \"Material Icons\";\n  	font-size: 19px;\n  	vertical-align: middle;\n}\n\n@import url(\"https://fonts.googleapis.com/css2?family=Barlow+Condensed:wght@400;500&display=swap\");\n@import url(\"https://fonts.googleapis.com/icon?family=Material+Icons\");\n\n");

/* INSERT TABLE DATA: rtl_lnd_options */
INSERT INTO `rtl_lnd_options` VALUES("1", "siteurl", "http://localhost/Landscaper", "yes");
INSERT INTO `rtl_lnd_options` VALUES("2", "home", "http://localhost/Landscaper", "yes");
INSERT INTO `rtl_lnd_options` VALUES("3", "blogname", "قالب خدمات باغبانی", "yes");
INSERT INTO `rtl_lnd_options` VALUES("4", "blogdescription", "یک سایت دیگر با وردپرس فارسی", "yes");
INSERT INTO `rtl_lnd_options` VALUES("5", "users_can_register", "0", "yes");
INSERT INTO `rtl_lnd_options` VALUES("6", "admin_email", "info@wpressi.ir", "yes");
INSERT INTO `rtl_lnd_options` VALUES("7", "start_of_week", "6", "yes");
INSERT INTO `rtl_lnd_options` VALUES("8", "use_balanceTags", "0", "yes");
INSERT INTO `rtl_lnd_options` VALUES("9", "use_smilies", "1", "yes");
INSERT INTO `rtl_lnd_options` VALUES("10", "require_name_email", "1", "yes");
INSERT INTO `rtl_lnd_options` VALUES("11", "comments_notify", "1", "yes");
INSERT INTO `rtl_lnd_options` VALUES("12", "posts_per_rss", "10", "yes");
INSERT INTO `rtl_lnd_options` VALUES("13", "rss_use_excerpt", "0", "yes");
INSERT INTO `rtl_lnd_options` VALUES("14", "mailserver_url", "mail.example.com", "yes");
INSERT INTO `rtl_lnd_options` VALUES("15", "mailserver_login", "login@example.com", "yes");
INSERT INTO `rtl_lnd_options` VALUES("16", "mailserver_pass", "password", "yes");
INSERT INTO `rtl_lnd_options` VALUES("17", "mailserver_port", "110", "yes");
INSERT INTO `rtl_lnd_options` VALUES("18", "default_category", "1", "yes");
INSERT INTO `rtl_lnd_options` VALUES("19", "default_comment_status", "open", "yes");
INSERT INTO `rtl_lnd_options` VALUES("20", "default_ping_status", "open", "yes");
INSERT INTO `rtl_lnd_options` VALUES("21", "default_pingback_flag", "1", "yes");
INSERT INTO `rtl_lnd_options` VALUES("22", "posts_per_page", "10", "yes");
INSERT INTO `rtl_lnd_options` VALUES("23", "date_format", "j F, Y", "yes");
INSERT INTO `rtl_lnd_options` VALUES("24", "time_format", "g:i a", "yes");
INSERT INTO `rtl_lnd_options` VALUES("25", "links_updated_date_format", "F j, Y g:i a", "yes");
INSERT INTO `rtl_lnd_options` VALUES("26", "comment_moderation", "0", "yes");
INSERT INTO `rtl_lnd_options` VALUES("27", "moderation_notify", "1", "yes");
INSERT INTO `rtl_lnd_options` VALUES("28", "permalink_structure", "/%postname%/", "yes");
INSERT INTO `rtl_lnd_options` VALUES("29", "rewrite_rules", "a:189:{s:24:\"^wc-auth/v([1]{1})/(.*)?\";s:63:\"index.php?wc-auth-version=$matches[1]&wc-auth-route=$matches[2]\";s:22:\"^wc-api/v([1-3]{1})/?$\";s:51:\"index.php?wc-api-version=$matches[1]&wc-api-route=/\";s:24:\"^wc-api/v([1-3]{1})(.*)?\";s:61:\"index.php?wc-api-version=$matches[1]&wc-api-route=$matches[2]\";s:7:\"shop/?$\";s:27:\"index.php?post_type=product\";s:37:\"shop/feed/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?post_type=product&feed=$matches[1]\";s:32:\"shop/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?post_type=product&feed=$matches[1]\";s:24:\"shop/page/([0-9]{1,})/?$\";s:45:\"index.php?post_type=product&paged=$matches[1]\";s:11:\"^wp-json/?$\";s:22:\"index.php?rest_route=/\";s:14:\"^wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:21:\"^index.php/wp-json/?$\";s:22:\"index.php?rest_route=/\";s:24:\"^index.php/wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:17:\"^wp-sitemap\\.xml$\";s:23:\"index.php?sitemap=index\";s:17:\"^wp-sitemap\\.xsl$\";s:36:\"index.php?sitemap-stylesheet=sitemap\";s:23:\"^wp-sitemap-index\\.xsl$\";s:34:\"index.php?sitemap-stylesheet=index\";s:48:\"^wp-sitemap-([a-z]+?)-([a-z\\d_-]+?)-(\\d+?)\\.xml$\";s:75:\"index.php?sitemap=$matches[1]&sitemap-subtype=$matches[2]&paged=$matches[3]\";s:34:\"^wp-sitemap-([a-z]+?)-(\\d+?)\\.xml$\";s:47:\"index.php?sitemap=$matches[1]&paged=$matches[2]\";s:47:\"category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:42:\"category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:23:\"category/(.+?)/embed/?$\";s:46:\"index.php?category_name=$matches[1]&embed=true\";s:35:\"category/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:32:\"category/(.+?)/wc-api(/(.*))?/?$\";s:54:\"index.php?category_name=$matches[1]&wc-api=$matches[3]\";s:17:\"category/(.+?)/?$\";s:35:\"index.php?category_name=$matches[1]\";s:44:\"tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:39:\"tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:20:\"tag/([^/]+)/embed/?$\";s:36:\"index.php?tag=$matches[1]&embed=true\";s:32:\"tag/([^/]+)/page/?([0-9]{1,})/?$\";s:43:\"index.php?tag=$matches[1]&paged=$matches[2]\";s:29:\"tag/([^/]+)/wc-api(/(.*))?/?$\";s:44:\"index.php?tag=$matches[1]&wc-api=$matches[3]\";s:14:\"tag/([^/]+)/?$\";s:25:\"index.php?tag=$matches[1]\";s:45:\"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:40:\"type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:21:\"type/([^/]+)/embed/?$\";s:44:\"index.php?post_format=$matches[1]&embed=true\";s:33:\"type/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?post_format=$matches[1]&paged=$matches[2]\";s:15:\"type/([^/]+)/?$\";s:33:\"index.php?post_format=$matches[1]\";s:55:\"product-category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_cat=$matches[1]&feed=$matches[2]\";s:50:\"product-category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_cat=$matches[1]&feed=$matches[2]\";s:31:\"product-category/(.+?)/embed/?$\";s:44:\"index.php?product_cat=$matches[1]&embed=true\";s:43:\"product-category/(.+?)/page/?([0-9]{1,})/?$\";s:51:\"index.php?product_cat=$matches[1]&paged=$matches[2]\";s:25:\"product-category/(.+?)/?$\";s:33:\"index.php?product_cat=$matches[1]\";s:52:\"product-tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_tag=$matches[1]&feed=$matches[2]\";s:47:\"product-tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_tag=$matches[1]&feed=$matches[2]\";s:28:\"product-tag/([^/]+)/embed/?$\";s:44:\"index.php?product_tag=$matches[1]&embed=true\";s:40:\"product-tag/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?product_tag=$matches[1]&paged=$matches[2]\";s:22:\"product-tag/([^/]+)/?$\";s:33:\"index.php?product_tag=$matches[1]\";s:35:\"product/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:45:\"product/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:65:\"product/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"product/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"product/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:41:\"product/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:24:\"product/([^/]+)/embed/?$\";s:40:\"index.php?product=$matches[1]&embed=true\";s:28:\"product/([^/]+)/trackback/?$\";s:34:\"index.php?product=$matches[1]&tb=1\";s:48:\"product/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?product=$matches[1]&feed=$matches[2]\";s:43:\"product/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?product=$matches[1]&feed=$matches[2]\";s:36:\"product/([^/]+)/page/?([0-9]{1,})/?$\";s:47:\"index.php?product=$matches[1]&paged=$matches[2]\";s:43:\"product/([^/]+)/comment-page-([0-9]{1,})/?$\";s:47:\"index.php?product=$matches[1]&cpage=$matches[2]\";s:33:\"product/([^/]+)/wc-api(/(.*))?/?$\";s:48:\"index.php?product=$matches[1]&wc-api=$matches[3]\";s:39:\"product/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:50:\"product/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:32:\"product/([^/]+)(?:/([0-9]+))?/?$\";s:46:\"index.php?product=$matches[1]&page=$matches[2]\";s:24:\"product/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:34:\"product/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:54:\"product/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"product/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"product/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:30:\"product/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:35:\"gallery/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:45:\"gallery/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:65:\"gallery/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"gallery/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"gallery/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:41:\"gallery/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:24:\"gallery/([^/]+)/embed/?$\";s:42:\"index.php?portfolio=$matches[1]&embed=true\";s:28:\"gallery/([^/]+)/trackback/?$\";s:36:\"index.php?portfolio=$matches[1]&tb=1\";s:36:\"gallery/([^/]+)/page/?([0-9]{1,})/?$\";s:49:\"index.php?portfolio=$matches[1]&paged=$matches[2]\";s:43:\"gallery/([^/]+)/comment-page-([0-9]{1,})/?$\";s:49:\"index.php?portfolio=$matches[1]&cpage=$matches[2]\";s:33:\"gallery/([^/]+)/wc-api(/(.*))?/?$\";s:50:\"index.php?portfolio=$matches[1]&wc-api=$matches[3]\";s:39:\"gallery/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:50:\"gallery/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:32:\"gallery/([^/]+)(?:/([0-9]+))?/?$\";s:48:\"index.php?portfolio=$matches[1]&page=$matches[2]\";s:24:\"gallery/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:34:\"gallery/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:54:\"gallery/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"gallery/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"gallery/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:30:\"gallery/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:59:\"portfolio_category/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:57:\"index.php?portfolio_category=$matches[1]&feed=$matches[2]\";s:54:\"portfolio_category/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:57:\"index.php?portfolio_category=$matches[1]&feed=$matches[2]\";s:35:\"portfolio_category/([^/]+)/embed/?$\";s:51:\"index.php?portfolio_category=$matches[1]&embed=true\";s:47:\"portfolio_category/([^/]+)/page/?([0-9]{1,})/?$\";s:58:\"index.php?portfolio_category=$matches[1]&paged=$matches[2]\";s:29:\"portfolio_category/([^/]+)/?$\";s:40:\"index.php?portfolio_category=$matches[1]\";s:54:\"portfolio_tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?portfolio_tag=$matches[1]&feed=$matches[2]\";s:49:\"portfolio_tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?portfolio_tag=$matches[1]&feed=$matches[2]\";s:30:\"portfolio_tag/([^/]+)/embed/?$\";s:46:\"index.php?portfolio_tag=$matches[1]&embed=true\";s:42:\"portfolio_tag/([^/]+)/page/?([0-9]{1,})/?$\";s:53:\"index.php?portfolio_tag=$matches[1]&paged=$matches[2]\";s:24:\"portfolio_tag/([^/]+)/?$\";s:35:\"index.php?portfolio_tag=$matches[1]\";s:48:\".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$\";s:18:\"index.php?feed=old\";s:20:\".*wp-app\\.php(/.*)?$\";s:19:\"index.php?error=403\";s:18:\".*wp-register.php$\";s:23:\"index.php?register=true\";s:32:\"feed/(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:27:\"(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:8:\"embed/?$\";s:21:\"index.php?&embed=true\";s:20:\"page/?([0-9]{1,})/?$\";s:28:\"index.php?&paged=$matches[1]\";s:27:\"comment-page-([0-9]{1,})/?$\";s:39:\"index.php?&page_id=11&cpage=$matches[1]\";s:17:\"wc-api(/(.*))?/?$\";s:29:\"index.php?&wc-api=$matches[2]\";s:41:\"comments/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:36:\"comments/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:17:\"comments/embed/?$\";s:21:\"index.php?&embed=true\";s:26:\"comments/wc-api(/(.*))?/?$\";s:29:\"index.php?&wc-api=$matches[2]\";s:44:\"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:39:\"search/(.+)/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:20:\"search/(.+)/embed/?$\";s:34:\"index.php?s=$matches[1]&embed=true\";s:32:\"search/(.+)/page/?([0-9]{1,})/?$\";s:41:\"index.php?s=$matches[1]&paged=$matches[2]\";s:29:\"search/(.+)/wc-api(/(.*))?/?$\";s:42:\"index.php?s=$matches[1]&wc-api=$matches[3]\";s:14:\"search/(.+)/?$\";s:23:\"index.php?s=$matches[1]\";s:47:\"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:42:\"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:23:\"author/([^/]+)/embed/?$\";s:44:\"index.php?author_name=$matches[1]&embed=true\";s:35:\"author/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?author_name=$matches[1]&paged=$matches[2]\";s:32:\"author/([^/]+)/wc-api(/(.*))?/?$\";s:52:\"index.php?author_name=$matches[1]&wc-api=$matches[3]\";s:17:\"author/([^/]+)/?$\";s:33:\"index.php?author_name=$matches[1]\";s:69:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:45:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/embed/?$\";s:74:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]\";s:54:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/wc-api(/(.*))?/?$\";s:82:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&wc-api=$matches[5]\";s:39:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$\";s:63:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]\";s:56:\"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:51:\"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:32:\"([0-9]{4})/([0-9]{1,2})/embed/?$\";s:58:\"index.php?year=$matches[1]&monthnum=$matches[2]&embed=true\";s:44:\"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]\";s:41:\"([0-9]{4})/([0-9]{1,2})/wc-api(/(.*))?/?$\";s:66:\"index.php?year=$matches[1]&monthnum=$matches[2]&wc-api=$matches[4]\";s:26:\"([0-9]{4})/([0-9]{1,2})/?$\";s:47:\"index.php?year=$matches[1]&monthnum=$matches[2]\";s:43:\"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:38:\"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:19:\"([0-9]{4})/embed/?$\";s:37:\"index.php?year=$matches[1]&embed=true\";s:31:\"([0-9]{4})/page/?([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&paged=$matches[2]\";s:28:\"([0-9]{4})/wc-api(/(.*))?/?$\";s:45:\"index.php?year=$matches[1]&wc-api=$matches[3]\";s:13:\"([0-9]{4})/?$\";s:26:\"index.php?year=$matches[1]\";s:27:\".?.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\".?.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\".?.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"(.?.+?)/embed/?$\";s:41:\"index.php?pagename=$matches[1]&embed=true\";s:20:\"(.?.+?)/trackback/?$\";s:35:\"index.php?pagename=$matches[1]&tb=1\";s:40:\"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:35:\"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:28:\"(.?.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&paged=$matches[2]\";s:35:\"(.?.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&cpage=$matches[2]\";s:25:\"(.?.+?)/wc-api(/(.*))?/?$\";s:49:\"index.php?pagename=$matches[1]&wc-api=$matches[3]\";s:28:\"(.?.+?)/order-pay(/(.*))?/?$\";s:52:\"index.php?pagename=$matches[1]&order-pay=$matches[3]\";s:33:\"(.?.+?)/order-received(/(.*))?/?$\";s:57:\"index.php?pagename=$matches[1]&order-received=$matches[3]\";s:25:\"(.?.+?)/orders(/(.*))?/?$\";s:49:\"index.php?pagename=$matches[1]&orders=$matches[3]\";s:29:\"(.?.+?)/view-order(/(.*))?/?$\";s:53:\"index.php?pagename=$matches[1]&view-order=$matches[3]\";s:28:\"(.?.+?)/downloads(/(.*))?/?$\";s:52:\"index.php?pagename=$matches[1]&downloads=$matches[3]\";s:31:\"(.?.+?)/edit-account(/(.*))?/?$\";s:55:\"index.php?pagename=$matches[1]&edit-account=$matches[3]\";s:31:\"(.?.+?)/edit-address(/(.*))?/?$\";s:55:\"index.php?pagename=$matches[1]&edit-address=$matches[3]\";s:34:\"(.?.+?)/payment-methods(/(.*))?/?$\";s:58:\"index.php?pagename=$matches[1]&payment-methods=$matches[3]\";s:32:\"(.?.+?)/lost-password(/(.*))?/?$\";s:56:\"index.php?pagename=$matches[1]&lost-password=$matches[3]\";s:34:\"(.?.+?)/customer-logout(/(.*))?/?$\";s:58:\"index.php?pagename=$matches[1]&customer-logout=$matches[3]\";s:37:\"(.?.+?)/add-payment-method(/(.*))?/?$\";s:61:\"index.php?pagename=$matches[1]&add-payment-method=$matches[3]\";s:40:\"(.?.+?)/delete-payment-method(/(.*))?/?$\";s:64:\"index.php?pagename=$matches[1]&delete-payment-method=$matches[3]\";s:45:\"(.?.+?)/set-default-payment-method(/(.*))?/?$\";s:69:\"index.php?pagename=$matches[1]&set-default-payment-method=$matches[3]\";s:31:\".?.+?/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:42:\".?.+?/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:24:\"(.?.+?)(?:/([0-9]+))?/?$\";s:47:\"index.php?pagename=$matches[1]&page=$matches[2]\";s:27:\"[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\"[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\"[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\"[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"([^/]+)/embed/?$\";s:37:\"index.php?name=$matches[1]&embed=true\";s:20:\"([^/]+)/trackback/?$\";s:31:\"index.php?name=$matches[1]&tb=1\";s:40:\"([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:35:\"([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:28:\"([^/]+)/page/?([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&paged=$matches[2]\";s:35:\"([^/]+)/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&cpage=$matches[2]\";s:25:\"([^/]+)/wc-api(/(.*))?/?$\";s:45:\"index.php?name=$matches[1]&wc-api=$matches[3]\";s:31:\"[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:42:\"[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:24:\"([^/]+)(?:/([0-9]+))?/?$\";s:43:\"index.php?name=$matches[1]&page=$matches[2]\";s:16:\"[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:26:\"[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:46:\"[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:22:\"[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";}", "yes");
INSERT INTO `rtl_lnd_options` VALUES("30", "hack_file", "0", "yes");
INSERT INTO `rtl_lnd_options` VALUES("31", "blog_charset", "UTF-8", "yes");
INSERT INTO `rtl_lnd_options` VALUES("32", "moderation_keys", "", "no");
INSERT INTO `rtl_lnd_options` VALUES("34", "category_base", "", "yes");
INSERT INTO `rtl_lnd_options` VALUES("35", "ping_sites", "http://rpc.pingomatic.com/", "yes");
INSERT INTO `rtl_lnd_options` VALUES("36", "comment_max_links", "2", "yes");
INSERT INTO `rtl_lnd_options` VALUES("37", "gmt_offset", "", "yes");
INSERT INTO `rtl_lnd_options` VALUES("38", "default_email_category", "1", "yes");
INSERT INTO `rtl_lnd_options` VALUES("39", "recently_edited", "", "no");
INSERT INTO `rtl_lnd_options` VALUES("44", "comment_registration", "0", "yes");
INSERT INTO `rtl_lnd_options` VALUES("45", "html_type", "text/html", "yes");
INSERT INTO `rtl_lnd_options` VALUES("46", "use_trackback", "0", "yes");
INSERT INTO `rtl_lnd_options` VALUES("47", "default_role", "subscriber", "yes");
INSERT INTO `rtl_lnd_options` VALUES("48", "db_version", "49752", "yes");
INSERT INTO `rtl_lnd_options` VALUES("49", "uploads_use_yearmonth_folders", "1", "yes");
INSERT INTO `rtl_lnd_options` VALUES("50", "upload_path", "", "yes");
INSERT INTO `rtl_lnd_options` VALUES("51", "blog_public", "1", "yes");
INSERT INTO `rtl_lnd_options` VALUES("52", "default_link_category", "2", "yes");
INSERT INTO `rtl_lnd_options` VALUES("53", "show_on_front", "page", "yes");
INSERT INTO `rtl_lnd_options` VALUES("54", "tag_base", "", "yes");
INSERT INTO `rtl_lnd_options` VALUES("55", "show_avatars", "1", "yes");
INSERT INTO `rtl_lnd_options` VALUES("56", "avatar_rating", "G", "yes");
INSERT INTO `rtl_lnd_options` VALUES("57", "upload_url_path", "", "yes");
INSERT INTO `rtl_lnd_options` VALUES("58", "thumbnail_size_w", "150", "yes");
INSERT INTO `rtl_lnd_options` VALUES("59", "thumbnail_size_h", "150", "yes");
INSERT INTO `rtl_lnd_options` VALUES("60", "thumbnail_crop", "1", "yes");
INSERT INTO `rtl_lnd_options` VALUES("61", "medium_size_w", "300", "yes");
INSERT INTO `rtl_lnd_options` VALUES("62", "medium_size_h", "300", "yes");
INSERT INTO `rtl_lnd_options` VALUES("63", "avatar_default", "mystery", "yes");
INSERT INTO `rtl_lnd_options` VALUES("64", "large_size_w", "1024", "yes");
INSERT INTO `rtl_lnd_options` VALUES("65", "large_size_h", "1024", "yes");
INSERT INTO `rtl_lnd_options` VALUES("66", "image_default_link_type", "none", "yes");
INSERT INTO `rtl_lnd_options` VALUES("67", "image_default_size", "", "yes");
INSERT INTO `rtl_lnd_options` VALUES("68", "image_default_align", "", "yes");
INSERT INTO `rtl_lnd_options` VALUES("69", "close_comments_for_old_posts", "0", "yes");
INSERT INTO `rtl_lnd_options` VALUES("70", "close_comments_days_old", "14", "yes");
INSERT INTO `rtl_lnd_options` VALUES("71", "thread_comments", "1", "yes");
INSERT INTO `rtl_lnd_options` VALUES("72", "thread_comments_depth", "5", "yes");
INSERT INTO `rtl_lnd_options` VALUES("73", "page_comments", "0", "yes");
INSERT INTO `rtl_lnd_options` VALUES("74", "comments_per_page", "50", "yes");
INSERT INTO `rtl_lnd_options` VALUES("75", "default_comments_page", "newest", "yes");
INSERT INTO `rtl_lnd_options` VALUES("76", "comment_order", "asc", "yes");
INSERT INTO `rtl_lnd_options` VALUES("77", "sticky_posts", "a:0:{}", "yes");
INSERT INTO `rtl_lnd_options` VALUES("78", "widget_categories", "a:2:{i:2;a:4:{s:5:\"title\";s:0:\"\";s:5:\"count\";i:0;s:12:\"hierarchical\";i:0;s:8:\"dropdown\";i:0;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `rtl_lnd_options` VALUES("79", "widget_text", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `rtl_lnd_options` VALUES("80", "widget_rss", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `rtl_lnd_options` VALUES("81", "uninstall_plugins", "a:1:{s:49:\"better-delete-revision/better-delete-revision.php\";s:13:\"bdr_uninstall\";}", "no");
INSERT INTO `rtl_lnd_options` VALUES("82", "timezone_string", "Asia/Tehran", "yes");
INSERT INTO `rtl_lnd_options` VALUES("83", "page_for_posts", "18", "yes");
INSERT INTO `rtl_lnd_options` VALUES("84", "page_on_front", "11", "yes");
INSERT INTO `rtl_lnd_options` VALUES("85", "default_post_format", "0", "yes");
INSERT INTO `rtl_lnd_options` VALUES("86", "link_manager_enabled", "0", "yes");
INSERT INTO `rtl_lnd_options` VALUES("87", "finished_splitting_shared_terms", "1", "yes");
INSERT INTO `rtl_lnd_options` VALUES("88", "site_icon", "0", "yes");
INSERT INTO `rtl_lnd_options` VALUES("89", "medium_large_size_w", "768", "yes");
INSERT INTO `rtl_lnd_options` VALUES("90", "medium_large_size_h", "0", "yes");
INSERT INTO `rtl_lnd_options` VALUES("91", "initial_db_version", "38590", "yes");
INSERT INTO `rtl_lnd_options` VALUES("92", "rtl_lnd_user_roles", "a:7:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:132:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:17:\"edit_shop_webhook\";b:1;s:17:\"read_shop_webhook\";b:1;s:19:\"delete_shop_webhook\";b:1;s:18:\"edit_shop_webhooks\";b:1;s:25:\"edit_others_shop_webhooks\";b:1;s:21:\"publish_shop_webhooks\";b:1;s:26:\"read_private_shop_webhooks\";b:1;s:20:\"delete_shop_webhooks\";b:1;s:28:\"delete_private_shop_webhooks\";b:1;s:30:\"delete_published_shop_webhooks\";b:1;s:27:\"delete_others_shop_webhooks\";b:1;s:26:\"edit_private_shop_webhooks\";b:1;s:28:\"edit_published_shop_webhooks\";b:1;s:25:\"manage_shop_webhook_terms\";b:1;s:23:\"edit_shop_webhook_terms\";b:1;s:25:\"delete_shop_webhook_terms\";b:1;s:25:\"assign_shop_webhook_terms\";b:1;s:18:\"manage_woocommerce\";b:1;s:24:\"view_woocommerce_reports\";b:1;s:12:\"edit_product\";b:1;s:12:\"read_product\";b:1;s:14:\"delete_product\";b:1;s:13:\"edit_products\";b:1;s:20:\"edit_others_products\";b:1;s:16:\"publish_products\";b:1;s:21:\"read_private_products\";b:1;s:15:\"delete_products\";b:1;s:23:\"delete_private_products\";b:1;s:25:\"delete_published_products\";b:1;s:22:\"delete_others_products\";b:1;s:21:\"edit_private_products\";b:1;s:23:\"edit_published_products\";b:1;s:20:\"manage_product_terms\";b:1;s:18:\"edit_product_terms\";b:1;s:20:\"delete_product_terms\";b:1;s:20:\"assign_product_terms\";b:1;s:15:\"edit_shop_order\";b:1;s:15:\"read_shop_order\";b:1;s:17:\"delete_shop_order\";b:1;s:16:\"edit_shop_orders\";b:1;s:23:\"edit_others_shop_orders\";b:1;s:19:\"publish_shop_orders\";b:1;s:24:\"read_private_shop_orders\";b:1;s:18:\"delete_shop_orders\";b:1;s:26:\"delete_private_shop_orders\";b:1;s:28:\"delete_published_shop_orders\";b:1;s:25:\"delete_others_shop_orders\";b:1;s:24:\"edit_private_shop_orders\";b:1;s:26:\"edit_published_shop_orders\";b:1;s:23:\"manage_shop_order_terms\";b:1;s:21:\"edit_shop_order_terms\";b:1;s:23:\"delete_shop_order_terms\";b:1;s:23:\"assign_shop_order_terms\";b:1;s:16:\"edit_shop_coupon\";b:1;s:16:\"read_shop_coupon\";b:1;s:18:\"delete_shop_coupon\";b:1;s:17:\"edit_shop_coupons\";b:1;s:24:\"edit_others_shop_coupons\";b:1;s:20:\"publish_shop_coupons\";b:1;s:25:\"read_private_shop_coupons\";b:1;s:19:\"delete_shop_coupons\";b:1;s:27:\"delete_private_shop_coupons\";b:1;s:29:\"delete_published_shop_coupons\";b:1;s:26:\"delete_others_shop_coupons\";b:1;s:25:\"edit_private_shop_coupons\";b:1;s:27:\"edit_published_shop_coupons\";b:1;s:24:\"manage_shop_coupon_terms\";b:1;s:22:\"edit_shop_coupon_terms\";b:1;s:24:\"delete_shop_coupon_terms\";b:1;s:24:\"assign_shop_coupon_terms\";b:1;s:18:\"bcn_manage_options\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:34:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:10:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}s:8:\"customer\";a:2:{s:4:\"name\";s:8:\"Customer\";s:12:\"capabilities\";a:1:{s:4:\"read\";b:1;}}s:12:\"shop_manager\";a:2:{s:4:\"name\";s:12:\"Shop manager\";s:12:\"capabilities\";a:92:{s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:4:\"read\";b:1;s:18:\"read_private_pages\";b:1;s:18:\"read_private_posts\";b:1;s:10:\"edit_posts\";b:1;s:10:\"edit_pages\";b:1;s:20:\"edit_published_posts\";b:1;s:20:\"edit_published_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"edit_private_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:17:\"edit_others_pages\";b:1;s:13:\"publish_posts\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_posts\";b:1;s:12:\"delete_pages\";b:1;s:20:\"delete_private_pages\";b:1;s:20:\"delete_private_posts\";b:1;s:22:\"delete_published_pages\";b:1;s:22:\"delete_published_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:19:\"delete_others_pages\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:17:\"moderate_comments\";b:1;s:12:\"upload_files\";b:1;s:6:\"export\";b:1;s:6:\"import\";b:1;s:10:\"list_users\";b:1;s:18:\"edit_theme_options\";b:1;s:18:\"manage_woocommerce\";b:1;s:24:\"view_woocommerce_reports\";b:1;s:12:\"edit_product\";b:1;s:12:\"read_product\";b:1;s:14:\"delete_product\";b:1;s:13:\"edit_products\";b:1;s:20:\"edit_others_products\";b:1;s:16:\"publish_products\";b:1;s:21:\"read_private_products\";b:1;s:15:\"delete_products\";b:1;s:23:\"delete_private_products\";b:1;s:25:\"delete_published_products\";b:1;s:22:\"delete_others_products\";b:1;s:21:\"edit_private_products\";b:1;s:23:\"edit_published_products\";b:1;s:20:\"manage_product_terms\";b:1;s:18:\"edit_product_terms\";b:1;s:20:\"delete_product_terms\";b:1;s:20:\"assign_product_terms\";b:1;s:15:\"edit_shop_order\";b:1;s:15:\"read_shop_order\";b:1;s:17:\"delete_shop_order\";b:1;s:16:\"edit_shop_orders\";b:1;s:23:\"edit_others_shop_orders\";b:1;s:19:\"publish_shop_orders\";b:1;s:24:\"read_private_shop_orders\";b:1;s:18:\"delete_shop_orders\";b:1;s:26:\"delete_private_shop_orders\";b:1;s:28:\"delete_published_shop_orders\";b:1;s:25:\"delete_others_shop_orders\";b:1;s:24:\"edit_private_shop_orders\";b:1;s:26:\"edit_published_shop_orders\";b:1;s:23:\"manage_shop_order_terms\";b:1;s:21:\"edit_shop_order_terms\";b:1;s:23:\"delete_shop_order_terms\";b:1;s:23:\"assign_shop_order_terms\";b:1;s:16:\"edit_shop_coupon\";b:1;s:16:\"read_shop_coupon\";b:1;s:18:\"delete_shop_coupon\";b:1;s:17:\"edit_shop_coupons\";b:1;s:24:\"edit_others_shop_coupons\";b:1;s:20:\"publish_shop_coupons\";b:1;s:25:\"read_private_shop_coupons\";b:1;s:19:\"delete_shop_coupons\";b:1;s:27:\"delete_private_shop_coupons\";b:1;s:29:\"delete_published_shop_coupons\";b:1;s:26:\"delete_others_shop_coupons\";b:1;s:25:\"edit_private_shop_coupons\";b:1;s:27:\"edit_published_shop_coupons\";b:1;s:24:\"manage_shop_coupon_terms\";b:1;s:22:\"edit_shop_coupon_terms\";b:1;s:24:\"delete_shop_coupon_terms\";b:1;s:24:\"assign_shop_coupon_terms\";b:1;}}}", "yes");
INSERT INTO `rtl_lnd_options` VALUES("93", "fresh_site", "0", "yes");
INSERT INTO `rtl_lnd_options` VALUES("94", "WPLANG", "fa_IR", "yes");
INSERT INTO `rtl_lnd_options` VALUES("95", "widget_search", "a:2:{i:2;a:1:{s:5:\"title\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `rtl_lnd_options` VALUES("96", "widget_recent-posts", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `rtl_lnd_options` VALUES("97", "widget_recent-comments", "a:2:{i:2;a:2:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:5;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `rtl_lnd_options` VALUES("98", "widget_archives", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `rtl_lnd_options` VALUES("99", "widget_meta", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `rtl_lnd_options` VALUES("100", "sidebars_widgets", "a:9:{s:19:\"wp_inactive_widgets\";a:0:{}s:7:\"sidebar\";a:8:{i:0;s:22:\"black-studio-tinymce-1\";i:1;s:8:\"search-2\";i:2;s:17:\"recent-comments-2\";i:3;s:12:\"categories-2\";i:4;s:13:\"qt_brochure-1\";i:5;s:13:\"qt_brochure-2\";i:6;s:11:\"tag_cloud-1\";i:7;s:13:\"qt_facebook-1\";}s:19:\"topbar-widgets-left\";a:0:{}s:14:\"topbar-widgets\";a:4:{i:0;s:13:\"qt_icon_box-1\";i:1;s:13:\"qt_icon_box-2\";i:2;s:13:\"qt_icon_box-3\";i:3;s:17:\"qt_social_icons-1\";}s:14:\"header-widgets\";a:3:{i:0;s:13:\"qt_icon_box-4\";i:1;s:13:\"qt_icon_box-5\";i:2;s:13:\"qt_icon_box-6\";}s:12:\"page-sidebar\";a:2:{i:0;s:10:\"nav_menu-1\";i:1;s:22:\"black-studio-tinymce-2\";}s:12:\"shop-sidebar\";a:5:{i:0;s:26:\"woocommerce_price_filter-1\";i:1;s:32:\"woocommerce_top_rated_products-1\";i:2;s:28:\"woocommerce_product_search-1\";i:3;s:32:\"woocommerce_product_categories-1\";i:4;s:22:\"black-studio-tinymce-4\";}s:11:\"main-footer\";a:4:{i:0;s:22:\"black-studio-tinymce-3\";i:1;s:10:\"nav_menu-2\";i:2;s:10:\"nav_menu-3\";i:3;s:18:\"qt_opening_hours-1\";}s:13:\"array_version\";i:3;}", "yes");
INSERT INTO `rtl_lnd_options` VALUES("101", "widget_pages", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `rtl_lnd_options` VALUES("102", "widget_calendar", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `rtl_lnd_options` VALUES("103", "widget_media_audio", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `rtl_lnd_options` VALUES("104", "widget_media_image", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `rtl_lnd_options` VALUES("105", "widget_media_video", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `rtl_lnd_options` VALUES("106", "widget_tag_cloud", "a:2:{i:1;a:3:{s:5:\"title\";s:21:\"ابربرچسب ها\";s:5:\"count\";i:0;s:8:\"taxonomy\";s:8:\"post_tag\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `rtl_lnd_options` VALUES("107", "widget_nav_menu", "a:4:{i:1;a:1:{s:8:\"nav_menu\";i:43;}i:2;a:2:{s:5:\"title\";s:15:\"سیاست ها\";s:8:\"nav_menu\";i:41;}i:3;a:2:{s:5:\"title\";s:15:\"خدمات ما\";s:8:\"nav_menu\";i:43;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `rtl_lnd_options` VALUES("108", "widget_custom_html", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `rtl_lnd_options` VALUES("109", "cron", "a:20:{i:1627842817;a:1:{s:26:\"action_scheduler_run_queue\";a:1:{s:32:\"0d04ed39571b55704c122d726248bbac\";a:3:{s:8:\"schedule\";s:12:\"every_minute\";s:4:\"args\";a:1:{i:0;s:7:\"WP Cron\";}s:8:\"interval\";i:60;}}}i:1627845115;a:1:{s:33:\"wc_admin_process_orders_milestone\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1627845119;a:1:{s:14:\"wc_admin_daily\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1627845171;a:1:{s:29:\"wc_admin_unsnooze_admin_notes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1627845503;a:1:{s:34:\"wp_privacy_delete_old_export_files\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1627845958;a:1:{s:32:\"woocommerce_cancel_unpaid_orders\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1627848000;a:1:{s:27:\"woocommerce_scheduled_sales\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1627851782;a:3:{s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1627853158;a:1:{s:24:\"woocommerce_cleanup_logs\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1627863958;a:1:{s:28:\"woocommerce_cleanup_sessions\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1627883234;a:1:{s:18:\"ai1wm_cleanup_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1627883744;a:1:{s:18:\"wp_https_detection\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1627888919;a:1:{s:32:\"recovery_mode_clean_expired_keys\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1627890002;a:1:{s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1627895080;a:1:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1627921272;a:1:{s:25:\"delete_expired_transients\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1627928768;a:2:{s:33:\"woocommerce_cleanup_personal_data\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:30:\"woocommerce_tracker_send_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1628104360;a:1:{s:30:\"wp_site_health_scheduled_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1629138418;a:1:{s:25:\"woocommerce_geoip_updater\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:11:\"fifteendays\";s:4:\"args\";a:0:{}s:8:\"interval\";i:1296000;}}}s:7:\"version\";i:2;}", "yes");
INSERT INTO `rtl_lnd_options` VALUES("110", "theme_mods_twentyseventeen", "a:2:{s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1510304695;s:4:\"data\";a:4:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:6:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";i:3;s:10:\"archives-2\";i:4;s:12:\"categories-2\";i:5;s:6:\"meta-2\";}s:9:\"sidebar-2\";a:0:{}s:9:\"sidebar-3\";a:0:{}}}}", "yes");
INSERT INTO `rtl_lnd_options` VALUES("123", "current_theme", "The Landscaper", "yes");
INSERT INTO `rtl_lnd_options` VALUES("124", "theme_mods_the-landscaper", "a:44:{i:0;b:0;s:18:\"custom_css_post_id\";i:-1;s:18:\"nav_menu_locations\";a:3:{s:7:\"primary\";i:42;s:13:\"services-menu\";i:43;s:11:\"footer-menu\";i:41;}s:7:\"qt_logo\";s:63:\"http://localhost/Landscaper/wp-content/uploads/2017/11/logo.png\";s:14:\"qt_logo_retina\";s:66:\"http://localhost/Landscaper/wp-content/uploads/2017/11/logo_2x.png\";s:19:\"qt_logo_transparent\";s:75:\"http://localhost/Landscaper/wp-content/uploads/2017/11/logo_transparent.png\";s:26:\"qt_logo_retina_transparent\";s:98:\"http://localhost/Landscaper/wp-content/themes/the-landscaper/assets/images/logo_transparent_2x.png\";s:17:\"qt_404_page_image\";s:88:\"http://localhost/Landscaper/wp-content/themes/the-landscaper/assets/images/404_image.png\";s:24:\"qt_footerbottom_textleft\";s:200:\" فارسی و راستچین سازی توسط : <i style=\"font-size:12px;color: #f52b0e\" class=\"fa fa-heart\"></i>محمد قاسمی <i style=\"font-size:12px;color: #f52b0e\" class=\"fa fa-heart\"></i>\";s:26:\"qt_footerbottom_textmiddle\";s:243:\"<p><a href=\"#\" target=\"_blank\"><i class=\"fa fa-facebook-square\"></i></a><a href=\"#\" target=\"_blank\"><i class=\"fa fa-twitter-square\"></i></a><a href=\"#\"><i class=\"fa fa-linkedin-square\"></i></a><a href=\"#\"><i class=\"fa fa-telegram\"></i></a></p>\";s:25:\"qt_footerbottom_textright\";s:71:\"این قالب در سایت راستچین به فروش می رسد.\";s:18:\"qt_maintitle_align\";s:5:\"right\";s:20:\"qt_breadcrumbs_align\";s:5:\"right\";s:15:\"qt_blog_tooltip\";s:23:\"اشتراک گذاری\";s:20:\"qt_gallery_maintitle\";s:10:\"گالری\";s:19:\"qt_gallery_subtitle\";s:43:\"انتخاب بهترین کارهای ما\";s:19:\"qt_gallery_prevtext\";s:8:\"قبلی\";s:19:\"qt_gallery_nexttext\";s:8:\"بعدی\";s:22:\"qt_gallery_summarytext\";s:36:\"<span class=\"fas fa-th-list\"></span>\";s:17:\"qt_blog_read_more\";s:25:\"بیشتر بخوانید\";s:20:\"qt_gallery_cat_title\";s:28:\"دسته بندی گالری\";s:22:\"qt_404_page_text_title\";s:52:\"وای! این صفحه را نمیتوان یافت\";s:16:\"qt_404_page_text\";s:95:\"هیچ چیز در اینجا پیدا نشد، جستجو را در زیر انجام دهید\";s:15:\"qt_blog_twitter\";s:12:\"توئیتر\";s:16:\"qt_blog_facebook\";s:12:\"فیسبوک\";s:18:\"qt_blog_googleplus\";s:17:\"گوگل پلاس\";s:16:\"qt_blog_linkedin\";s:16:\"لینکداین\";s:20:\"qt_default_esg_style\";s:6:\"enable\";s:20:\"qt_custom_google_api\";s:39:\"AIzaSyD9FeGHrKW1cBRhfCOl-doaHxzdxA7bLF0\";s:21:\"qt_theme_primary_font\";s:8:\"IranSans\";s:23:\"qt_theme_secondary_font\";s:9:\"IranYekan\";s:13:\"qt_nav_layout\";s:7:\"default\";s:20:\"qt_header_background\";s:7:\"#403f3f\";s:21:\"qt_header_title_color\";s:7:\"#ffffff\";s:20:\"qt_header_icon_color\";s:7:\"#81d742\";s:26:\"qt_header_icon_color_hover\";s:7:\"#7bbf3b\";s:17:\"qt_weekday_monday\";s:12:\"دوشنبه\";s:18:\"qt_weekday_tuesday\";s:13:\"سه شنبه\";s:20:\"qt_weekday_wednesday\";s:16:\"چهارشنبه\";s:19:\"qt_weekday_thursday\";s:14:\"پنجشنبه\";s:17:\"qt_weekday_friday\";s:8:\"جمعه\";s:19:\"qt_weekday_saturday\";s:8:\"شنبه\";s:17:\"qt_weekday_sunday\";s:12:\"یکشنبه\";s:22:\"qt_opening_closed_text\";s:17:\"تعطیل است\";}", "yes");
INSERT INTO `rtl_lnd_options` VALUES("125", "theme_switched", "", "yes");
INSERT INTO `rtl_lnd_options` VALUES("126", "widget_qt_icon_box", "a:7:{i:1;a:6:{s:5:\"title\";s:37:\"آمریکا, نیویورک سیتی\";s:4:\"text\";s:0:\"\";s:4:\"link\";s:0:\"\";s:7:\"new_tab\";s:0:\"\";s:4:\"icon\";s:7:\"fa-home\";s:6:\"layout\";s:5:\"small\";}i:2;a:6:{s:5:\"title\";s:11:\"021-1230000\";s:4:\"text\";s:0:\"\";s:4:\"link\";s:14:\"tel:0211230000\";s:7:\"new_tab\";s:0:\"\";s:4:\"icon\";s:8:\"fa-phone\";s:6:\"layout\";s:5:\"small\";}i:3;a:6:{s:5:\"title\";s:34:\"شنبه - جمعه: 08:00 - 17:00\";s:4:\"text\";s:0:\"\";s:4:\"link\";s:0:\"\";s:7:\"new_tab\";s:0:\"\";s:4:\"icon\";s:10:\"fa-clock-o\";s:6:\"layout\";s:5:\"small\";}i:4;a:6:{s:5:\"title\";s:26:\"کیفیت کار بالا\";s:4:\"text\";s:25:\"خدمات باغبانی\";s:4:\"link\";s:1:\"#\";s:7:\"new_tab\";s:0:\"\";s:4:\"icon\";s:15:\"fa fas fa-check\";s:6:\"layout\";s:3:\"big\";}i:5;a:6:{s:5:\"title\";s:26:\"سرعت بالای کار\";s:4:\"text\";s:25:\"خدمات باغبانی\";s:4:\"link\";s:1:\"#\";s:7:\"new_tab\";s:0:\"\";s:4:\"icon\";s:15:\"fa fas fa-check\";s:6:\"layout\";s:3:\"big\";}i:6;a:6:{s:5:\"title\";s:33:\"قیمت و هزینه مناسب\";s:4:\"text\";s:25:\"خدمات باغبانی\";s:4:\"link\";s:1:\"#\";s:7:\"new_tab\";s:0:\"\";s:4:\"icon\";s:15:\"fa fas fa-check\";s:6:\"layout\";s:3:\"big\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `rtl_lnd_options` VALUES("127", "widget_qt_opening_hours", "a:2:{i:1;a:19:{s:5:\"title\";s:19:\"ساعات کاری\";s:11:\"Monday_from\";s:5:\"07:00\";s:9:\"Monday_to\";s:5:\"17:00\";s:12:\"Tuesday_from\";s:5:\"07:00\";s:10:\"Tuesday_to\";s:5:\"17:00\";s:14:\"Wednesday_from\";s:5:\"07:00\";s:12:\"Wednesday_to\";s:5:\"17:00\";s:13:\"Thursday_from\";s:5:\"07:00\";s:11:\"Thursday_to\";s:5:\"17:00\";s:11:\"Friday_from\";s:5:\"07:00\";s:9:\"Friday_to\";s:5:\"17:00\";s:13:\"Saturday_from\";s:5:\"07:00\";s:11:\"Saturday_to\";s:5:\"17:00\";s:11:\"Sunday_from\";s:0:\"\";s:9:\"Sunday_to\";s:0:\"\";s:9:\"separator\";s:1:\"-\";s:6:\"closed\";s:10:\"تعطیل\";s:9:\"highlight\";s:2:\"on\";s:10:\"extra_info\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `rtl_lnd_options` VALUES("128", "widget_qt_feature_page", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `rtl_lnd_options` VALUES("129", "widget_qt_social_icons", "a:2:{i:1;a:11:{s:10:\"fb_profile\";s:34:\"http://facebook.com/qreativethemes\";s:13:\"twttr_profile\";s:33:\"http://twitter.com/qreativethemes\";s:14:\"google_profile\";s:1:\"#\";s:13:\"lnkin_profile\";s:0:\"\";s:15:\"youtube_profile\";s:0:\"\";s:13:\"insta_profile\";s:1:\"#\";s:14:\"tumblr_profile\";s:0:\"\";s:15:\"pintrst_profile\";s:0:\"\";s:12:\"yelp_profile\";s:0:\"\";s:13:\"houzz_profile\";s:0:\"\";s:7:\"new_tab\";s:2:\"on\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `rtl_lnd_options` VALUES("130", "widget_qt_testimonials", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `rtl_lnd_options` VALUES("131", "widget_qt_cta_banner", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `rtl_lnd_options` VALUES("132", "widget_qt_cta_button", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `rtl_lnd_options` VALUES("133", "widget_qt_count_box", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `rtl_lnd_options` VALUES("134", "widget_qt_google_map", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `rtl_lnd_options` VALUES("135", "widget_qt_recent_posts", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `rtl_lnd_options` VALUES("136", "widget_qt_recent_posts_block", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `rtl_lnd_options` VALUES("137", "widget_qt_brochure", "a:3:{i:1;a:5:{s:5:\"title\";s:16:\"بروشورها\";s:13:\"brochure_icon\";s:14:\"fa-file-word-o\";s:12:\"brochure_url\";s:1:\"#\";s:12:\"brochure_btn\";s:26:\"دانلود فایل .DOC\";s:7:\"new_tab\";s:0:\"\";}i:2;a:5:{s:5:\"title\";s:0:\"\";s:13:\"brochure_icon\";s:13:\"fa-file-pdf-o\";s:12:\"brochure_url\";s:1:\"#\";s:12:\"brochure_btn\";s:26:\"دانلود فایل .PDF\";s:7:\"new_tab\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `rtl_lnd_options` VALUES("138", "widget_qt_facebook", "a:2:{i:1;a:8:{s:5:\"title\";s:0:\"\";s:6:\"fb_url\";s:39:\"https://www.facebook.com/QreativeThemes\";s:6:\"height\";i:156;s:5:\"width\";i:263;s:10:\"hide_cover\";s:0:\"\";s:13:\"show_facepile\";s:0:\"\";s:10:\"show_posts\";s:0:\"\";s:12:\"small_header\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `rtl_lnd_options` VALUES("139", "widget_qt_team_member", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `rtl_lnd_options` VALUES("140", "acf_version", "5.9.9", "yes");
INSERT INTO `rtl_lnd_options` VALUES("142", "tp_eg_grids_version", "3.0", "yes");
INSERT INTO `rtl_lnd_options` VALUES("143", "tp_eg_custom_css_imported", "true", "yes");
INSERT INTO `rtl_lnd_options` VALUES("144", "tp_eg_custom_css", "/* HENRY HARRISON */\r\n\r\na.eg-henryharrison-element-1,\r\na.eg-henryharrison-element-2 {\r\n  -webkit-transition: all .4s linear;  \r\n    -moz-transition: all .4s linear;  \r\n    -o-transition: all .4s linear;  \r\n    -ms-transition: all .4s linear;  \r\n    transition: all .4s linear; \r\n}\r\n\r\n/* JIMMY CARTER */\r\n.eg-jimmy-carter-element-11 i:before { margin-left:0px; margin-right:0px;}\r\n\r\n\r\n/* HARDING */\r\n.eg-harding-element-17 { letter-spacing:1px}\r\n.eg-harding-wrapper .esg-entry-media { overflow:hidden; \r\n            box-sizing:border-box;\r\n            -webkit-box-sizing:border-box;\r\n            -moz-box-sizing:border-box;\r\n 