<?php
/**
 * Include all ACF fields/options through this file
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if( function_exists('acf_add_local_field_group') ):

acf_add_local_field_group(array (
	'key' => 'group_55bf77413206a',
	'title' => 'طرح وبلاگ',
	'fields' => array (
		array (
			'key' => 'field_55f5e34d70179',
			'label' => 'طرح وبلاگ',
			'name' => 'blog_type',
			'type' => 'radio',
			'instructions' => 'طرح وبلاگ را انتخاب نمایید (پیش فرض لیست است)',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array (
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'choices' => array (
				'list' => 'لیست',
				'grid' => 'مشبک',
			),
			'other_choice' => 0,
			'save_other_choice' => 0,
			'default_value' => '',
			'layout' => 'horizontal',
		),
		array (
			'key' => 'field_55bf77471acd2',
			'label' => 'ستون های وبلاگ',
			'name' => 'blog_columns',
			'type' => 'radio',
			'instructions' => 'نمایش مشبک بصورت 2 و 3 و یا 4 ستونه',
			'required' => 0,
			'conditional_logic' => array (
				array (
					array (
						'field' => 'field_55f5e34d70179',
						'operator' => '==',
						'value' => 'grid',
					),
				),
			),
			'wrapper' => array (
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'choices' => array (
				2 => '2 ستون',
				3 => '3 ستون',
				4 => '4 ستون',
			),
			'other_choice' => 0,
			'save_other_choice' => 0,
			'default_value' => 2,
			'layout' => 'horizontal',
		),
	),
	'location' => array (
		array (
			array (
				'param' => 'page_type',
				'operator' => '==',
				'value' => 'posts_page',
			),
		),
	),
	'menu_order' => 4,
	'position' => 'normal',
	'style' => 'default',
	'label_placement' => 'top',
	'instruction_placement' => 'label',
	'hide_on_screen' => '',
	'active' => 1,
	'description' => '',
));

acf_add_local_field_group(array (
	'key' => 'group_5514864997520',
	'title' => 'اسلایدر صفحه',
	'fields' => array (
		array (
			'key' => 'field_57b61b85f96a4',
			'label' => 'اسلایدها',
			'name' => 'slides',
			'type' => 'tab',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array (
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'placement' => 'left',
			'endpoint' => 0,
		),
		array (
			'key' => 'field_54bce505c530b',
			'label' => '',
			'name' => 'slide',
			'type' => 'repeater',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array (
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'collapsed' => '',
			'min' => '',
			'max' => '',
			'layout' => 'block',
			'button_label' => 'افزودن اسلاید جدید',
			'sub_fields' => array (
				array(
					'key' => 'field_5e8f3c0af7aaf',
					'label' => 'عکس اسلاید',
					'name' => '',
					'type' => 'tab',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'placement' => 'top',
					'endpoint' => 0,
				),
				array (
					'key' => 'field_54bce51dc530c',
					'label' => 'عکس',
					'name' => 'slidebg_image',
					'type' => 'image',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array (
						'width' => 100,
						'class' => '',
						'id' => '',
					),
					'return_format' => 'id',
					'preview_size' => 'medium',
					'library' => 'all',
					'min_width' => '',
					'min_height' => '',
					'min_size' => '',
					'max_width' => '',
					'max_height' => '',
					'max_size' => '',
					'mime_types' => '',
				),
				array (
					'key' => 'field_55b0de6d47227',
					'label' => 'عنوان کوچک',
					'name' => 'slide_top_heading',
					'type' => 'text',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => array (
						array (
							array (
								'field' => 'field_54bee675bd14b',
								'operator' => '==',
								'value' => '1',
							),
						),
					),
					'wrapper' => array (
						'width' => 100,
						'class' => '',
						'id' => '',
					),
					'default_value' => '',
					'placeholder' => '',
					'prepend' => '',
					'append' => '',
					'maxlength' => '',
					'readonly' => 0,
					'disabled' => 0,
				),
				array (
					'key' => 'field_55ca06f5b822d',
					'label' => 'عنوان',
					'name' => 'slide_heading',
					'type' => 'textarea',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => array (
						array (
							array (
								'field' => 'field_54bee675bd14b',
								'operator' => '==',
								'value' => '1',
							),
						),
					),
					'wrapper' => array (
						'width' => 100,
						'class' => '',
						'id' => '',
					),
					'default_value' => '',
					'placeholder' => '',
					'maxlength' => '',
					'rows' => '3',
					'new_lines' => 'br',
					'readonly' => 0,
					'disabled' => 0,
				),
				array (
					'key' => 'field_54bce55fc530e',
					'label' => 'محتوا',
					'name' => 'slide_text',
					'type' => 'wysiwyg',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => array (
						array (
							array (
								'field' => 'field_54bee675bd14b',
								'operator' => '==',
								'value' => '1',
							),
						),
					),
					'wrapper' => array (
						'width' => 100,
						'class' => '',
						'id' => '',
					),
					'default_value' => '',
					'tabs' => 'visual',
					'toolbar' => 'basic',
					'media_upload' => 0,
				),
				array(
					'key' => 'field_5bcf6724cd4f2',
					'label' => 'دکمه ها',
					'name' => 'slide_buttons',
					'type' => 'repeater',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => array (
						array (
							array (
								'field' => 'field_54bee675bd14b',
								'operator' => '==',
								'value' => '1',
							),
						),
					),
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'collapsed' => '',
					'min' => 0,
					'max' => 2,
					'layout' => 'table',
					'button_label' => 'افزودن دکمه',
					'sub_fields' => array(
						array(
							'key' => 'field_5bcf673acd4f3',
							'label' => 'لینک دکمه',
							'name' => 'slide_button_link',
							'type' => 'link',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '33',
								'class' => '',
								'id' => '',
							),
							'return_format' => 'url',
						),
						array(
							'key' => 'field_5bcf6762cd4f4',
							'label' => 'متن دکمه',
							'name' => 'slide_button_text',
							'type' => 'text',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '33',
								'class' => '',
								'id' => '',
							),
							'default_value' => '',
							'placeholder' => '',
							'prepend' => '',
							'append' => '',
							'maxlength' => '',
						),
						array(
							'key' => 'field_5bcf678bcd4f5',
							'label' => 'حالت دکمه',
							'name' => 'slide_button_style',
							'type' => 'select',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '33',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'primary' => 'اصلی',
								'outline' => 'دور خط',
							),
							'default_value' => array(
								0 => 'primary',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
					),
				),
				array (
					'key' => 'field_573e19ceaa1fe',
					'label' => 'لینک اسلاید',
					'name' => 'link_slide',
					'type' => 'text',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => array (
						array (
							array (
								'field' => 'field_54bee675bd14b',
								'operator' => '!=',
								'value' => '1',
							),
						),
					),
					'wrapper' => array (
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'default_value' => '',
					'placeholder' => '',
					'prepend' => '',
					'append' => '',
					'maxlength' => '',
					'readonly' => 0,
					'disabled' => 0,
				),
				array (
					'key' => 'field_573e19ecaa1ff',
					'label' => 'حالت لینک',
					'name' => 'link_target',
					'type' => 'radio',
					'instructions' => 'باز شدن در برگه جدید؟',
					'required' => 0,
					'conditional_logic' => array (
						array (
							array (
								'field' => 'field_54bee675bd14b',
								'operator' => '!=',
								'value' => '1',
							),
						),
					),
					'wrapper' => array (
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'choices' => array (
						'yes' => 'بله',
						'no' => 'خیر',
					),
					'other_choice' => 0,
					'save_other_choice' => 0,
					'default_value' => 'yes',
					'layout' => 'horizontal',
					'allow_null' => 0,
				),
				array(
					'key' => 'field_5e8f3c22f7ab0',
					'label' => 'تنظیمات اسلاید',
					'name' => '',
					'type' => 'tab',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'placement' => 'top',
					'endpoint' => 0,
				),
				array(
					'key' => 'field_5e8f3ea308b8a',
					'label' => 'رنگ عنوان کوچک',
					'name' => 'slide_subheading_color',
					'type' => 'color_picker',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'default_value' => '',
				),
				array(
					'key' => 'field_5e8f3ec808b8b',
					'label' => 'رنگ عنوان',
					'name' => 'slide_heading_color',
					'type' => 'color_picker',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'default_value' => '',
				),
				array(
					'key' => 'field_5e8f42dfd1f65',
					'label' => 'رنگ محتوا',
					'name' => 'slide_content_color',
					'type' => 'color_picker',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'default_value' => '',
				),
				array(
					'key' => 'field_5da47df9b2fe2',
					'label' => 'رنگ پوشش',
					'name' => 'slide_overlay_color',
					'type' => 'color_picker',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '50',
						'class' => '',
						'id' => '',
					),
					'default_value' => '',
				),
				array(
					'key' => 'field_5da47e27b2fe3',
					'label' => 'شفافیت پوشش',
					'name' => 'slide_overlay_opacity',
					'type' => 'range',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '50',
						'class' => '',
						'id' => '',
					),
					'default_value' => '',
					'min' => 0,
					'max' => 1,
					'step' => '0.1',
					'prepend' => 0,
					'append' => '',
				),
				array(
					'key' => 'field_5e8f49756060e',
					'label' => 'رنگ دکمه ها',
					'name' => 'button_colors',
					'type' => 'group',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '100',
						'class' => '',
						'id' => '',
					),
					'layout' => 'block',
					'sub_fields' => array(
						array(
							'key' => 'field_5e8f478251dca',
							'label' => 'دکمه پیش فرض',
							'name' => '',
							'type' => 'tab',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'placement' => 'top',
							'endpoint' => 0,
						),
						array(
							'key' => 'field_5e8f456f9dc2a',
							'label' => 'رنگ متن',
							'name' => 'slide_button_color',
							'type' => 'color_picker',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '33',
								'class' => 'clear clearfix',
								'id' => '',
							),
							'default_value' => '',
						),
						array(
							'key' => 'field_5e8f45239dc27',
							'label' => 'پس زمینه',
							'name' => 'slide_button_background',
							'type' => 'color_picker',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '33',
								'class' => '',
								'id' => '',
							),
							'default_value' => '',
						),
						array(
							'key' => 'field_5e8f45579dc29',
							'label' => 'پس زمینه با عبور ماوس',
							'name' => 'slide_button_background_hover',
							'type' => 'color_picker',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '33',
								'class' => '',
								'id' => '',
							),
							'default_value' => '',
						),
						array(
							'key' => 'field_5e8f47cd51dcb',
							'label' => 'دکمه دور خط',
							'name' => '',
							'type' => 'tab',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'placement' => 'top',
							'endpoint' => 0,
						),
						array(
							'key' => 'field_5e8f47f951dcd',
							'label' => 'رنگ متن',
							'name' => 'slide_button_outline_color',
							'type' => 'color_picker',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '33',
								'class' => 'clear clearfix',
								'id' => '',
							),
							'default_value' => '',
						),
						array(
							'key' => 'field_5e8f480c51dce',
							'label' => 'حاشیه',
							'name' => 'slide_button_outline_border',
							'type' => 'color_picker',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '33',
								'class' => '',
								'id' => '',
							),
							'default_value' => '',
						),
						array(
							'key' => 'field_5e8f482151dcf',
							'label' => 'حاشیه با عبور ماوس',
							'name' => 'slide_button_outline_border_hover',
							'type' => 'color_picker',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '33',
								'class' => '',
								'id' => '',
							),
							'default_value' => '',
						),
					),
				),
				array(
					'key' => 'field_5e903dfd534b4',
					'label' => 'ترازبندی عنوان',
					'name' => 'slide_caption_align',
					'type' => 'button_group',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'choices' => array(
						'left' => '<i class="dashicons dashicons-editor-alignleft"></i>',
						'center' => '<i class="dashicons dashicons-editor-aligncenter"></i>',
						'right' => '<i class="dashicons dashicons-editor-alignright"></i>',
					),
					'allow_null' => 1,
					'default_value' => '',
					'layout' => 'horizontal',
					'return_format' => 'value',
				),
				array(
					'key' => 'field_5ed8fb74d2e13',
					'label' => 'برچسب عنوان',
					'name' => 'slide_heading_tag',
					'type' => 'select',
					'instructions' => 'برای این اسلاید می توانید تگ عنوان را تغییر دهید. برای سئو سایت مفید است',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'choices' => array(
						'h1' => 'H1',
						'h2' => 'H2',
						'h3' => 'H3',
						'h4' => 'H4',
						'h5' => 'H5',
						'h6' => 'H6',
					),
					'default_value' => 'h1',
					'allow_null' => 0,
					'multiple' => 0,
					'ui' => 0,
					'return_format' => 'value',
					'ajax' => 0,
					'placeholder' => '',
				),
			),
		),
		array (
			'key' => 'field_57b61b95f96a5',
			'label' => 'تنظیمات',
			'name' => '_copy',
			'type' => 'tab',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array (
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'placement' => 'left',
			'endpoint' => 0,
		),
		array (
			'key' => 'field_57349e20490bd',
			'label' => 'انیمیشن',
			'name' => 'slide_animation',
			'type' => 'radio',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array (
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'choices' => array (
				'carousel-slide' => 'اسلاید',
				'carousel-fade' => 'محو شدن',
			),
			'other_choice' => 0,
			'save_other_choice' => 0,
			'default_value' => 'carousel-slide',
			'layout' => 'horizontal',
			'allow_null' => 0,
		),
		array (
			'key' => 'field_54c7832068bbc',
			'label' => 'چرخش خودکار',
			'name' => 'auto_cycle',
			'type' => 'true_false',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array (
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'message' => '',
			'default_value' => 1,
			'ui' => 1,
			'ui_on_text' => 'Yes',
			'ui_off_text' => 'No',
		),
		array (
			'key' => 'field_54c7833568bbd',
			'label' => 'تاخیر',
			'name' => 'slide_interval',
			'type' => 'number',
			'instructions' => 'زمان تاخیر (1s = 1000ms)',
			'required' => 1,
			'conditional_logic' => array (
				array (
					array (
						'field' => 'field_54c7832068bbc',
						'operator' => '==',
						'value' => '1',
					),
				),
			),
			'wrapper' => array (
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'default_value' => 6000,
			'placeholder' => '',
			'prepend' => '',
			'append' => 'ms',
			'min' => '',
			'max' => '',
			'step' => '',
			'readonly' => 0,
			'disabled' => 0,
		),
		array(
			'key' => 'field_5acd3b450d857',
			'label' => 'توقف با عبور ماوس',
			'name' => 'pause_hover',
			'type' => 'true_false',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => array (
				array (
					array (
						'field' => 'field_54c7832068bbc',
						'operator' => '==',
						'value' => '1',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'message' => '',
			'default_value' => 0,
			'ui' => 1,
			'ui_on_text' => 'Yes',
			'ui_off_text' => 'No',
		),
		array (
			'key' => 'field_54bee675bd14b',
			'label' => 'عناوین اسلاید',
			'name' => 'slide_captions',
			'type' => 'true_false',
			'instructions' => 'نمایش و یا عدم نمایش عناوین اسلاید',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array (
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'message' => '',
			'default_value' => 0,
			'ui' => 1,
			'ui_on_text' => 'Yes',
			'ui_off_text' => 'No',
		),

		array(
			'key' => 'field_55ca02e43bc06',
			'label' => 'ترازبندی عنوان',
			'name' => 'caption_align',
			'type' => 'button_group',
			'instructions' => 'می توانید ترازبندی عناوین را برای تمام اسلایدها تغییر دهید',
			'required' => 0,
			'conditional_logic' => array (
				array (
					array (
						'field' => 'field_54bee675bd14b',
						'operator' => '==',
						'value' => '1',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'choices' => array(
				'left' => '<i class="dashicons dashicons-editor-alignleft"></i>',
				'center' => '<i class="dashicons dashicons-editor-aligncenter"></i>',
				'right' => '<i class="dashicons dashicons-editor-alignright"></i>',
			),
			'allow_null' => 0,
			'default_value' => 'left',
			'layout' => 'horizontal',
			'return_format' => 'value',
		),
		array (
			'key' => 'field_55b36734b33c4',
			'label' => 'نقاط اسلایدر',
			'name' => 'slide_indicators',
			'type' => 'true_false',
			'instructions' => 'نقاط اسلایدر را در پایین آن ها نمایش می دهد',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array (
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'message' => '',
			'default_value' => 1,
			'ui' => 1,
			'ui_on_text' => 'Yes',
			'ui_off_text' => 'No',
		),
		array (
			'key' => 'field_59fc52b068bcf',
			'label' => 'پشتیبانی از لمس',
			'name' => 'enable_touch_support',
			'type' => 'true_false',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array (
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'instructions' => 'پشتیبانی از کشیدن',
			'default_value' => 1,
			'ui' => 1,
			'ui_on_text' => 'Yes',
			'ui_off_text' => 'No',
		),
		array(
			'key' => 'field_5ddd5908d3d19',
			'label' => 'ارتفاع ثابت',
			'name' => 'slide_fixed_height',
			'type' => 'true_false',
			'instructions' => 'ارتفاع ثابت را برای اسلایدر ها در دستگاه های مختلف تنظیم کنید',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'message' => '',
			'default_value' => 0,
			'ui' => 1,
			'ui_on_text' => 'Yes',
			'ui_off_text' => 'No',
		),
		array(
			'key' => 'field_5ddd5933d3d1a',
			'label' => 'ارتفاع در موبایل',
			'name' => 'slide_height_mobile',
			'type' => 'number',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_5ddd5908d3d19',
						'operator' => '==',
						'value' => '1',
					),
				),
			),
			'wrapper' => array(
				'width' => '24',
				'class' => '',
				'id' => '',
			),
			'default_value' => '',
			'placeholder' => '',
			'prepend' => '',
			'append' => 'px',
			'min' => '0',
			'max' => '',
			'step' => '',
		),
		array(
			'key' => 'field_5ddd5971d3d1b',
			'label' => 'ارتفاع در تبلت',
			'name' => 'slide_height_tablet',
			'type' => 'number',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_5ddd5908d3d19',
						'operator' => '==',
						'value' => '1',
					),
				),
			),
			'wrapper' => array(
				'width' => '24',
				'class' => '',
				'id' => '',
			),
			'default_value' => '',
			'placeholder' => '',
			'prepend' => '',
			'append' => 'px',
			'min' => '0',
			'max' => '',
			'step' => '',
		),
		array(
			'key' => 'field_5ddd597fd3d1c',
			'label' => 'ارتفاع در دسکتاپ های کوچک',
			'name' => 'slide_height_desktop_small',
			'type' => 'number',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_5ddd5908d3d19',
						'operator' => '==',
						'value' => '1',
					),
				),
			),
			'wrapper' => array(
				'width' => '26',
				'class' => '',
				'id' => '',
			),
			'default_value' => '',
			'placeholder' => '',
			'prepend' => '',
			'append' => 'px',
			'min' => '0',
			'max' => '',
			'step' => '',
		),
		array(
			'key' => 'field_5ddd60112ee8f',
			'label' => 'ارتفاع در دسکتاپ های بزرگ',
			'name' => 'slide_height_desktop_large',
			'type' => 'number',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_5ddd5908d3d19',
						'operator' => '==',
						'value' => '1',
					),
				),
			),
			'wrapper' => array(
				'width' => '26',
				'class' => '',
				'id' => '',
			),
			'default_value' => '',
			'placeholder' => '',
			'prepend' => '',
			'append' => 'px',
			'min' => '0',
			'max' => '',
			'step' => '',
		),
	),
	'location' => array (
		array (
			array (
				'param' => 'page_template',
				'operator' => '==',
				'value' => 'template-front-fullslider.php',
			),
		),
	),
	'menu_order' => 5,
	'position' => 'normal',
	'style' => 'default',
	'label_placement' => 'top',
	'instruction_placement' => 'label',
	'hide_on_screen' => '',
	'active' => 1,
	'description' => '',
));

acf_add_local_field_group(array (
	'key' => 'group_55ae81bbeabb1',
	'title' => 'تصاویر گالری',
	'fields' => array (
		array (
			'key' => 'field_55b0fd27b4149',
			'label' => 'طرح گالری',
			'name' => 'gallery_layout',
			'type' => 'select',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array (
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'choices' => array (
				'split' => 'جدا (محتوا در راست و گالری در چپ)',
				'fullwidth' => 'تمام عرض (گالری در بالا و محتوا در پایین)',
			),
			'default_value' => array (
				'split' => 'split',
			),
			'allow_null' => 0,
			'multiple' => 0,
			'ui' => 0,
			'ajax' => 0,
			'placeholder' => '',
			'disabled' => 0,
			'readonly' => 0,
		),
		array (
			'key' => 'field_55ae8436d1ab0',
			'label' => 'ستون های گالری',
			'name' => 'gallery_columns',
			'type' => 'select',
			'instructions' => 'تعداد ستون های گالری را انتخاب نمایید',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array (
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'choices' => array (
				1 => 1,
				2 => 2,
				3 => 3,
				4 => 4,
				5 => 5,
			),
			'default_value' => array (
				'' => '',
			),
			'allow_null' => 0,
			'multiple' => 0,
			'ui' => 0,
			'ajax' => 0,
			'placeholder' => '',
			'disabled' => 0,
			'readonly' => 0,
		),
		array (
			'key' => 'field_5892367bf7637',
			'label' => 'فضای بین تصاویر گالری',
			'name' => 'gallery_images_gap',
			'type' => 'select',
			'instructions' => 'فضای بین تصاویر گالری را انتخاب نمایید',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array (
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'choices' => array (
				0 => '0px',
				1 => '1px',
				2 => '2px',
				3 => '3px',
				4 => '4px',
				5 => '5px',
				10 => '10px',
				15 => '15px',
				20 => '20px',
				25 => '25px',
				30 => '30px',
				35 => '35px',
			),
			'default_value' => 15,
			'allow_null' => 0,
			'multiple' => 0,
			'ui' => 0,
			'ajax' => 0,
			'return_format' => 'value',
			'placeholder' => '',
		),
		array (
			'key' => 'field_55b23f535ff85',
			'label' => 'تصاویر گالری',
			'name' => 'gallery_field',
			'type' => 'gallery',
			'instructions' => 'تصاویر گالری خود را انتخاب نمایید',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array (
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'min' => '',
			'max' => '',
			'preview_size' => 'thumbnail',
			'library' => 'all',
			'min_width' => '',
			'min_height' => '',
			'min_size' => '',
			'max_width' => '',
			'max_height' => '',
			'max_size' => '',
			'mime_types' => 'png, jpg',
		),
		array (
			'key' => 'field_5899a7965000c',
			'label' => 'موقعیت فیلد متن اضافی',
			'name' => 'extra_textarea_position',
			'type' => 'radio',
			'instructions' => 'موقعیت متن اضافی را در بالا و یا پایین گالری تنظیم نمایید',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array (
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'choices' => array (
				'above' => 'بالای تصاویر',
				'below' => 'پایین تصاویر',
				'hide' => 'مخفی',
			),
			'allow_null' => 0,
			'other_choice' => 0,
			'save_other_choice' => 0,
			'default_value' => 'below',
			'layout' => 'horizontal',
			'return_format' => 'value',
		),
		array (
			'key' => 'field_55b5f88c965b1',
			'label' => 'فیلد متن اضافی',
			'name' => 'extra_textarea',
			'type' => 'wysiwyg',
			'instructions' => 'استفاده میشود و برای قبل و بعد از تصاویر گالری',
			'required' => 0,
			'conditional_logic' => array (
				array (
					array (
						'field' => 'field_5899a7965000c',
						'operator' => '==',
						'value' => 'above',
					),
				),
				array(
					array (
						'field' => 'field_5899a7965000c',
						'operator' => '==',
						'value' => 'below',
					),
				),
			),
			'wrapper' => array (
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'default_value' => '',
			'tabs' => 'all',
			'toolbar' => 'basic',
			'media_upload' => 1,
		),
	),
	'location' => array (
		array (
			array (
				'param' => 'post_type',
				'operator' => '==',
				'value' => 'portfolio',
			),
		),
	),
	'menu_order' => 6,
	'position' => 'normal',
	'style' => 'default',
	'label_placement' => 'top',
	'instruction_placement' => 'label',
	'hide_on_screen' => '',
	'active' => 1,
	'description' => '',
));

acf_add_local_field_group(array (
	'key' => 'group_57b5d592c82b0',
	'title' => 'هدر صفحه',
	'fields' => array (
		array (
			'key' => 'field_57b5d59d3b01a',
			'label' => 'نوع هدر',
			'name' => 'home_header_layout',
			'type' => 'select',
			'instructions' => 'نوع هدر صفحه را انتخاب نمایید (بر تنظیمات قالب اولویت دارد)',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array (
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'choices' => array (
				'null' => 'Set from customizer',
				'default' => 'هدر اصلی',
				'wide' => 'هدر عریض',
				'fullwidth' => 'هدر تمام عرض',
				'transparent' => 'هدر شفاف',
				'sidebar' => 'هدر با سایدبار',
				'overlay' => 'هدر پوششی',
			),
			'default_value' => array (
			),
			'allow_null' => 0,
			'multiple' => 0,
			'ui' => 0,
			'ajax' => 0,
			'return_format' => 'value',
			'placeholder' => '',
		),
	),
	'location' => array (
		array (
			array (
				'param' => 'page_template',
				'operator' => '==',
				'value' => 'template-front-fullslider.php',
			),
		),
		array (
			array (
				'param' => 'page_template',
				'operator' => '==',
				'value' => 'template-front-slider-alt.php',
			),
		),
	),
	'menu_order' => 11,
	'position' => 'normal',
	'style' => 'default',
	'label_placement' => 'top',
	'instruction_placement' => 'label',
	'hide_on_screen' => '',
	'active' => 1,
	'description' => '',
));


acf_add_local_field_group(array (
	'key' => 'group_55a57b09e49da',
	'title' => 'تنظیمات صفحه',
	'fields' => array (
		array (
			'key' => 'field_56040f12455f8',
			'label' => 'تنظیمات',
			'name' => '',
			'type' => 'tab',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array (
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'placement' => 'left',
			'endpoint' => 0,
		),
		array (
			'key' => 'field_579a769295f8d',
			'label' => 'طرح هدر',
			'name' => 'header_layout',
			'type' => 'select',
			'instructions' => 'نوع هدر صفحه را انتخاب نمایید (بر تنظیمات قالب اولویت دارد)',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array (
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'choices' => array (
				'null' => 'پیش فرض (تنظیمات قالب)',
				'default' => 'هدر اصلی',
				'wide' => 'هدر عریض',
				'fullwidth' => 'هدر تمام عرض',
				'transparent' => 'هدر شفاف',
				'sidebar' => 'هدر با سایدبار',
				'overlay' => 'هدر پوششی',
			),
			'default_value' => array (
			),
			'allow_null' => 0,
			'multiple' => 0,
			'ui' => 0,
			'ajax' => 0,
			'return_format' => 'value',
			'placeholder' => '',
		),
		array (
			'key' => 'field_55ec43552f9a5',
			'label' => 'نواریالایی',
			'name' => 'topbar',
			'type' => 'radio',
			'instructions' => 'نمایش یا عدم نمایش نوار بالایی',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array (
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'choices' => array (
				'show' => 'نمایش',
				'hide' => 'مخفی',
			),
			'other_choice' => 0,
			'save_other_choice' => 0,
			'default_value' => '',
			'layout' => 'horizontal',
			'allow_null' => 1,
			'return_format' => 'value',
		),
		array (
			'key' => 'field_55f71e5830c20',
			'label' => 'سربرگ صفحه',
			'name' => 'page_title_area',
			'type' => 'select',
			'instructions' => 'طرح هدر را انتخاب نمایید، یا اینکه یک فاصله داخلی به آن بدهید و یا کلا آن را برای این برگه / نوشته مخفی نمایید.',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array (
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'choices' => array (
				'header-small' => 'نمایش (ارتفاع کم)',
				'header-large' => 'نمایش (ارتفاع زیاد)',
				'header-custom' => 'ارتفاع دلخواه',
				'header-hide' => 'مخفی',
			),
			'default_value' => array (
			),
			'allow_null' => 0,
			'multiple' => 0,
			'ui' => 0,
			'ajax' => 0,
			'return_format' => 'value',
			'placeholder' => '',
		),
		array (
			'key' => 'field_57b614b98652d',
			'label' => 'فاصله داخلی بالای هدر',
			'name' => 'page_area_padding_top',
			'type' => 'number',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => array (
				array (
					array (
						'field' => 'field_55f71e5830c20',
						'operator' => '==',
						'value' => 'header-custom',
					),
				),
			),
			'wrapper' => array (
				'width' => '50',
				'class' => '',
				'id' => '',
			),
			'default_value' => '',
			'placeholder' => '',
			'prepend' => '',
			'append' => 'px',
			'min' => '',
			'max' => '',
			'step' => '',
		),
		array (
			'key' => 'field_57b614f58652e',
			'label' => 'فاصله داخلی پایین هدر',
			'name' => 'page_area_padding_bottom',
			'type' => 'number',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => array (
				array (
					array (
						'field' => 'field_55f71e5830c20',
						'operator' => '==',
						'value' => 'header-custom',
					),
				),
			),
			'wrapper' => array (
				'width' => '50',
				'class' => '',
				'id' => '',
			),
			'default_value' => '',
			'placeholder' => '',
			'prepend' => '',
			'append' => 'px',
			'min' => '',
			'max' => '',
			'step' => '',
		),
		array (
			'key' => 'field_55c12598baaa0',
			'label' => 'ترازبندی هدر صفحه',
			'name' => 'header_text_align',
			'type' => 'radio',
			'instructions' => 'موقعیت عنوان و زیرنویس آن را تعیین نمایید',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array (
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'choices' => array (
				'left' => 'چپ',
				'center' => 'وسط',
				'right' => 'راست',
			),
			'other_choice' => 0,
			'save_other_choice' => 0,
			'default_value' => 'left',
			'layout' => 'horizontal',
			'allow_null' => 0,
			'return_format' => 'value',
		),
		array (
			'key' => 'field_5734b0693e910',
			'label' => 'عنوان صفحه',
			'name' => 'display_page_title',
			'type' => 'radio',
			'instructions' => 'عنوان صفحه را در این برگه نمایش داده و یا مخفی کنید',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array (
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'choices' => array (
				'show' => 'نمایش',
				'hide' => 'مخفی',
			),
			'other_choice' => 0,
			'save_other_choice' => 0,
			'default_value' => '',
			'layout' => 'horizontal',
			'allow_null' => 1,
			'return_format' => 'value',
		),
		array (
			'key' => 'field_55f195ea251f3',
			'label' => 'رنگ عنوان برگه',
			'name' => 'page_title_color',
			'type' => 'color_picker',
			'instructions' => 'رنگ عنوان برگه را در این برگه تغییر دهید',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array (
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'default_value' => '',
		),
		array (
			'key' => 'field_5734afbd978a3',
			'label' => 'رنگ زیر نویس',
			'name' => 'sub_title_color',
			'type' => 'color_picker',
			'instructions' => 'رنگ زیر نویس برگه را در این برگه تغییر دهید',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array (
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'default_value' => '',
		),
		array (
			'key' => 'field_57bca87a3d78e',
			'label' => 'نوار موقعیت یاب',
			'name' => 'display_breadcrumbs',
			'type' => 'radio',
			'instructions' => 'نوار موقعیت یاب را نمایش دهید یا مخفی نمایید',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array (
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'choices' => array (
				'show' => 'نمایش',
				'hide' => 'مخفی',
			),
			'other_choice' => 0,
			'save_other_choice' => 0,
			'default_value' => '',
			'layout' => 'horizontal',
			'allow_null' => 1,
			'return_format' => 'value',
		),
		array (
			'key' => 'field_56040f8abb138',
			'label' => 'پس زمینه',
			'name' => '',
			'type' => 'tab',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array (
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'placement' => 'left',
			'endpoint' => 0,
		),
		array (
			'key' => 'field_55a57b185845b',
			'label' => 'عکس پس زمینه',
			'name' => 'header_bgimage',
			'type' => 'image',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array (
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'return_format' => 'url',
			'preview_size' => 'medium',
			'library' => 'all',
			'min_width' => '',
			'min_height' => '',
			'min_size' => '',
			'max_width' => '',
			'max_height' => '',
			'max_size' => '',
			'mime_types' => '',
		),
		array (
			'key' => 'field_5604016e34433',
			'label' => 'موقعیت افقی تصویر پس زمینه',
			'name' => 'header_bg_horizontal',
			'type' => 'radio',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array (
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'choices' => array (
				'left' => 'چپ',
				'center' => 'مرکز',
				'right' => 'راست',
			),
			'other_choice' => 0,
			'save_other_choice' => 0,
			'default_value' => '',
			'layout' => 'horizontal',
			'allow_null' => 0,
			'return_format' => 'value',
		),
		array (
			'key' => 'field_560401a934434',
			'label' => 'موقعیت عمودی تصویر پس زمینه',
			'name' => 'header_bg_vertical',
			'type' => 'radio',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array (
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'choices' => array (
				'top' => 'بالا',
				'center' => 'مرکز',
				'bottom' => 'پایین',
			),
			'other_choice' => 0,
			'save_other_choice' => 0,
			'default_value' => '',
			'layout' => 'horizontal',
			'allow_null' => 0,
			'return_format' => 'value',
		),
		array (
			'key' => 'field_55a790b5df629',
			'label' => 'اندازه تصویر پس زمینه',
			'name' => 'header_bgsize',
			'type' => 'radio',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array (
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'choices' => array (
				'auto' => 'خودکار',
				'cover' => 'پوشش',
			),
			'allow_null' => 0,
			'other_choice' => 0,
			'save_other_choice' => 0,
			'default_value' => 'auto',
			'layout' => 'horizontal',
			'return_format' => 'value',
		),
		array (
			'key' => 'field_55a57c74b5b40',
			'label' => 'پیوست تصویر پس زمینه',
			'name' => 'header_bgattachment',
			'type' => 'radio',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array (
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'choices' => array (
				'scroll' => 'عادی',
				'fixed' => 'ثابت',
			),
			'allow_null' => 0,
			'other_choice' => 0,
			'save_other_choice' => 0,
			'default_value' => '',
			'layout' => 'horizontal',
			'return_format' => 'value',
		),
		array (
			'key' => 'field_55a57bad6eb75',
			'label' => 'رنگ پس زمینه',
			'name' => 'header_bgcolor',
			'type' => 'color_picker',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array (
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'default_value' => '',
		),
	),
	'location' => array (
		array (
			array (
				'param' => 'post_type',
				'operator' => '==',
				'value' => 'page',
			),
			array (
				'param' => 'post_type',
				'operator' => '==',
				'value' => 'post',
			),
		),
		array(
			array (
				'param' => 'post_type',
				'operator' => '==',
				'value' => 'portfolio',
			),
		),
		array (
			array (
				'param' => 'page_template',
				'operator' => '!=',
				'value' => 'template-front-fullslider.php',
			),
			array (
				'param' => 'page_template',
				'operator' => '!=',
				'value' => 'template-front-slider-alt.php',
			),
			array (
				'param' => 'post_type',
				'operator' => '!=',
				'value' => 'product',
			),
		),
	),
	'menu_order' => 7,
	'position' => 'normal',
	'style' => 'default',
	'label_placement' => 'top',
	'instruction_placement' => 'label',
	'hide_on_screen' => '',
	'active' => 1,
	'description' => '',
));

acf_add_local_field_group(array (
	'key' => 'group_55db6ad236d49',
	'title' => 'اسلایدر جایگزین صفحه',
	'fields' => array (
		array (
			'key' => 'field_55db6fe0f415f',
			'label' => 'افزودن اسلایدر',
			'name' => 'add_slider',
			'type' => 'radio',
			'instructions' => '',
			'required' => 1,
			'conditional_logic' => 0,
			'wrapper' => array (
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'choices' => array (
				'rev' => 'رولوشن اسلایدر',
				'layer' => 'لایر اسلایدر',
			),
			'other_choice' => 0,
			'save_other_choice' => 0,
			'default_value' => 'rev',
			'layout' => 'horizontal',
		),
		array (
			'key' => 'field_55db6aec90ea2',
			'label' => 'آی دی رولوشن اسلایدر',
			'name' => 'revolution_slider_id',
			'type' => 'text',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => array (
				array (
					array (
						'field' => 'field_55db6fe0f415f',
						'operator' => '==',
						'value' => 'rev',
					),
				),
			),
			'wrapper' => array (
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'default_value' => '',
			'placeholder' => '',
			'prepend' => '',
			'append' => '',
			'maxlength' => '',
			'readonly' => 0,
			'disabled' => 0,
		),
		array (
			'key' => 'field_55db6f8ce1399',
			'label' => 'آی دی لایر اسلایدر',
			'name' => 'layer_slider_id',
			'type' => 'text',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => array (
				array (
					array (
						'field' => 'field_55db6fe0f415f',
						'operator' => '==',
						'value' => 'layer',
					),
				),
			),
			'wrapper' => array (
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'default_value' => '',
			'placeholder' => '',
			'prepend' => '',
			'append' => '',
			'maxlength' => '',
			'readonly' => 0,
			'disabled' => 0,
		),
	),
	'location' => array (
		array (
			array (
				'param' => 'page_template',
				'operator' => '==',
				'value' => 'template-front-slider-alt.php',
			),
		),
	),
	'menu_order' => 8,
	'position' => 'acf_after_title',
	'style' => 'default',
	'label_placement' => 'top',
	'instruction_placement' => 'label',
	'hide_on_screen' => '',
	'active' => 1,
	'description' => '',
));

acf_add_local_field_group(array (
	'key' => 'group_55148649cb0e9',
	'title' => 'نمایش سایدبار',
	'fields' => array (
		array (
			'key' => 'field_550aeac522177-2',
			'label' => 'موقعیت سایدبار',
			'name' => 'display_sidebar',
			'type' => 'radio',
			'instructions' => 'موقعیت سایدبار را برای نمایش در این برگه تنظیم نمایید',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array (
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'choices' => array (
				'Hide' => 'مخفی',
				'Left' => 'چپ',
				'Right' => 'راست',
			),
			'other_choice' => 0,
			'save_other_choice' => 0,
			'default_value' => '',
			'layout' => 'horizontal',
		),
	),
	'location' => array (
		array (
			array (
				'param' => 'post_type',
				'operator' => '==',
				'value' => 'page',
			),
			array (
				'param' => 'page_template',
				'operator' => '!=',
				'value' => 'template-front-fullslider.php',
			),
			array (
				'param' => 'page_template',
				'operator' => '!=',
				'value' => 'template-front-slider-alt.php',
			),
		),
	),
	'menu_order' => 9,
	'position' => 'normal',
	'style' => 'default',
	'label_placement' => 'top',
	'instruction_placement' => 'label',
	'hide_on_screen' => '',
	'active' => 1,
	'description' => '',
));

acf_add_local_field_group(array (
	'key' => 'group_55a2c548011cb',
	'title' => 'زیرنویس',
	'fields' => array (
		array (
			'key' => 'field_55a2ca8d285f0',
			'label' => '',
			'name' => 'subtitle',
			'type' => 'text',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array (
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'default_value' => '',
			'placeholder' => '',
			'prepend' => 'زیرنویس برگه',
			'append' => '',
			'maxlength' => '',
			'readonly' => 0,
			'disabled' => 0,
		),
	),
	'location' => array (
		array (
			array (
				'param' => 'post_type',
				'operator' => '==',
				'value' => 'page',
			),
			array (
				'param' => 'page_template',
				'operator' => '!=',
				'value' => 'template-front-fullslider.php',
			),
			array (
				'param' => 'page_template',
				'operator' => '!=',
				'value' => 'template-front-slider-alt.php',
			),
		),
		array(
			array (
				'param' => 'post_type',
				'operator' => '==',
				'value' => 'portfolio',
			),
		),
	),
	'menu_order' => 10,
	'position' => 'acf_after_title',
	'style' => 'seamless',
	'label_placement' => 'top',
	'instruction_placement' => 'label',
	'hide_on_screen' => '',
	'active' => 1,
	'description' => '',
));

endif;