<?php
/**
 * Widget: Count Box
 *
 * @package thelandscaper-toolkit
 */

if ( ! class_exists( 'QT_Count_Box' ) ) {
	class QT_Count_Box extends WP_Widget {

		/**
		 * Register widget with WordPress.
		 */
		public function __construct() {
			parent::__construct(
				false,
				esc_html__( 'QT: Counter', 'the-landscaper-wp' ),
				array(
					'description' => esc_html__( 'Animated counter', 'the-landscaper-wp' ),
					'classname'   => 'widget-count-box',
				)
			);
		}

		/**
		 * Front-end display of widget.
		 *
		 * @see WP_Widget::widget()
		 *
		 * @param array $args     Widget arguments.
		 * @param array $instance Saved values from database.
		 */
		public function widget( $args, $instance ) {

			wp_enqueue_script( 'waypoints' );
			wp_enqueue_script( 'thelandscaper-toolkit-countbox' );

			echo $args['before_widget'];
			?>

			<div class="counter count-box">
				<?php if( esc_attr( $instance['count_icon'] ) ) : ?>
					<div class="count-icon">
						<i class="fa <?php echo esc_attr( $instance['count_icon'] ); ?>"></i>
					</div>
				<?php endif; ?>
				<div class="count-text">
					<?php if( $instance['count_before'] ) : ?>
						<span class="count-before"><?php echo esc_attr( $instance['count_before'] ); ?></span>
					<?php endif; ?>
					<span class="count-number"
						data-to="<?php echo wp_kses_post( $instance['count_to'] ); ?>" data-speed="2000">
					</span>
					<?php if( $instance['count_after'] ) : ?>
						<span class="count-after"><?php echo esc_attr( $instance['count_after'] ); ?></span>
					<?php endif; ?>
					<span class="count-title"><?php echo esc_attr( $instance['title'] ); ?></span>
				</div>
			</div>

			<?php
			echo $args['after_widget'];
		}

		/**
		 * Sanitize widget form values as they are saved.
		 *
		 * @see WP_Widget::update()
		 *
		 * @param array $new_instance Values just sent to be saved.
		 * @param array $old_instance Previously saved values from database.
		 *
		 * @return array Updated safe values to be saved.
		 */
		public function update( $new_instance, $old_instance ) {
			$instance = array();

			$instance['count_before'] = sanitize_text_field( $new_instance['count_before'] );
			$instance['count_to']     = wp_kses_post( $new_instance['count_to'] );
			$instance['count_after']  = sanitize_text_field( $new_instance['count_after'] );
			$instance['count_icon']   = wp_kses_post( $new_instance['count_icon'] );
			$instance['title']        = wp_kses_post( $new_instance['title'] );

			return $instance;
		}

		/**
		 * Back-end widget form.
		 *
		 * @see WP_Widget::form()
		 *
		 * @param array $instance Previously saved values from database.
		 */
		public function form( $instance ) {
			$count_before = empty( $instance['count_before'] ) ? '' : $instance['count_before'];
			$count_to     = empty( $instance['count_to'] ) ? '' : $instance['count_to'];
			$count_after  = empty( $instance['count_after'] ) ? '' : $instance['count_after'];
			$count_icon   = empty( $instance['count_icon'] ) ? '' : $instance['count_icon'];
			$title        = empty( $instance['title'] ) ? '' : $instance['title'];
			?>

			<p>
				<label for="<?php echo esc_attr( $this->get_field_id( 'count_to' ) ); ?>"><?php esc_html_e( 'Count Number', 'the-landscaper-wp' ); ?>:</label> <br />
				<input id="<?php echo esc_attr( $this->get_field_id( 'count_to' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'count_to' ) ); ?>" type="number" value="<?php echo esc_attr( $count_to ); ?>" />
			</p>

			<p>
				<label for="<?php echo esc_attr( $this->get_field_id( 'count_before' ) ); ?>"><?php esc_html_e( 'Symbol before number (optional)', 'the-landscaper-wp' ); ?>:</label> <br />
				<input id="<?php echo esc_attr( $this->get_field_id( 'count_before' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'count_before' ) ); ?>" type="text" value="<?php echo esc_attr( $count_before ); ?>" />
			</p>

			<p>
				<label for="<?php echo esc_attr( $this->get_field_id( 'count_after' ) ); ?>"><?php esc_html_e( 'Symbol after number (optional)', 'the-landscaper-wp' ); ?>:</label> <br />
				<input id="<?php echo esc_attr( $this->get_field_id( 'count_after' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'count_after' ) ); ?>" type="text" value="<?php echo esc_attr( $count_after ); ?>" />
			</p>

			<?php if ( '5' === get_theme_mod( 'qt_fontawesome_version' ) ) { ?>

				<p>
					<label for="<?php echo esc_attr( $this->get_field_id( 'count_icon' ) ); ?>"><?php esc_html_e( 'Icon', 'the-landscaper-wp' ); ?>:</label><br>
					<input class="widefat icp-auto" id="<?php echo esc_attr( $this->get_field_id( 'count_icon' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'count_icon' ) ); ?>" type="text" value="<?php echo esc_attr( $count_icon ); ?>" /><br>
					<em><?php echo wp_kses_post( thelandscaper_toolkit_fa_example_text() ); ?></em>
				</p>

			<?php } else { ?>

				<p>
					<label for="<?php echo esc_attr( $this->get_field_id( 'count_icon' ) ); ?>"><?php esc_html_e( 'Icon', 'the-landscaper-wp' ); ?>:</label> <em><?php echo wp_kses_post( thelandscaper_toolkit_fa_example_text() ); ?></em>
	                    <input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'count_icon' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'count_icon' ) ); ?>" type="text" value="<?php echo esc_attr( $count_icon ); ?>" />
				</p>

			<?php } ?>

			<p>
				<label for="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>"><?php esc_html_e( 'Title', 'the-landscaper-wp' ); ?>:</label> <br />
				<input id="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'title' ) ); ?>" type="text" value="<?php echo esc_attr( $title ); ?>" />
			</p>

			<script type="text/javascript">
				jQuery( document ).ready( function() {
					if ( jQuery( '.widget-liquid-right .icp-auto, .so-content .icp-auto' ).length ) {
						jQuery( '.widget-liquid-right .icp-auto, .so-content .icp-auto' ).fontIconPicker({
							source: <?php echo wp_json_encode( thelandscaper_toolkit_fa_icon_array() ); ?>,
							emptyIcon: true,
							hasSearch: true,
							iconsPerPage: 250,
						});
					}
				});
			</script>
	
			<?php
		}
	}
}