<?php
/**
 * Widget: Icon Box
 *
 * @package thelandscaper-toolkit
 */

if ( ! class_exists( 'QT_Icon_Box' ) ) {
	class QT_Icon_Box extends WP_Widget {

		/**
		 * Register widget with WordPress.
		 */
		public function __construct() {
			parent::__construct(
				false,
				esc_html__( 'QT: Icon Box', 'the-landscaper-wp' ),
				array(
					'description' => esc_html__( 'A box with an icon, heading and text', 'the-landscaper-wp' ),
					'classname'   => 'widget-icon-box',
				)
			);
		}

		/**
		 * Front-end display of widget.
		 *
		 * @see WP_Widget::widget()
		 *
		 * @param array $args     Widget arguments.
		 * @param array $instance Saved values from database.
		 */
		public function widget( $args, $instance ) {

			// Open Link in new tab option
			$link_new_tab = empty( $instance['new_tab'] ) ? true : false;

			echo $args['before_widget'];

			if ( ! empty ( $instance['link'] ) ) :
			?>
				<a class="icon-box icon-<?php echo esc_attr( $instance['layout'] ); ?>" href="<?php echo esc_url( $instance['link'] ); ?>" <?php echo empty ( $instance['new_tab'] ) ? '' : 'target="_blank" rel="noopener noreferrer"'; ?>>
			<?php else : ?>
				<div class="icon-box icon-<?php echo esc_attr( $instance['layout'] ); ?>">
			<?php endif; ?>
				<?php if ( $instance['icon'] != '' ) : ?>
					<i class="fa <?php echo esc_attr( $instance['icon'] ); ?>"></i>
				<?php endif; ?>
				<?php if ( $instance['title'] != '' ) : ?>
					<h6 class="title"><?php echo wp_kses_post( $instance['title'] ); ?></h6>
				<?php endif; ?>
				<?php if ( $instance['text'] != '' ) : ?>
					<span class="subtitle"><?php echo wp_kses_post( $instance['text'] ); ?></span>
				<?php endif; ?>
			</<?php echo empty ( $instance['link'] ) ? 'div' : 'a'; ?>>

			<?php
			echo $args['after_widget'];

		}

		/**
		 * Sanitize widget form values as they are saved.
		 *
		 * @see WP_Widget::update()
		 *
		 * @param array $new_instance Values just sent to be saved.
		 * @param array $old_instance Previously saved values from database.
		 *
		 * @return array Updated safe values to be saved.
		 */
		public function update( $new_instance, $old_instance ) {
			$instance = array();

			$instance['title']   = wp_kses_post( $new_instance['title'] );
			$instance['text']    = wp_kses_post( $new_instance['text'] );
			$instance['link']    = esc_url( $new_instance['link'] );
			$instance['new_tab'] = ! empty( $new_instance['new_tab'] ) ? sanitize_key( $new_instance['new_tab'] ) : '';
			$instance['icon']    = wp_kses_post( $new_instance['icon'] );
			$instance['layout']  = sanitize_key( $new_instance['layout'] );

			return $instance;
		}

		/**
		 * Back-end widget form.
		 *
		 * @see WP_Widget::form()
		 *
		 * @param array $instance Previously saved values from database.
		 */
		public function form( $instance ) {
			$title   = empty( $instance['title'] ) ? '' : $instance['title'];
			$text    = empty( $instance['text'] ) ? '' : $instance['text'];
			$link    = empty( $instance['link'] ) ? '' : $instance['link'];
			$new_tab = empty( $instance['new_tab'] ) ? '' : $instance['new_tab'];
			$icon    = empty( $instance['icon'] ) ? '' : $instance['icon'];
			$layout  = empty( $instance['layout'] ) ? '' : $instance['layout'];
			?>

			<?php if ( '5' === get_theme_mod( 'qt_fontawesome_version' ) ) { ?>

				<p>
					<label for="<?php echo esc_attr( $this->get_field_id( 'icon' ) ); ?>"><?php esc_html_e( 'Icon', 'the-landscaper-wp' ); ?>:</label><br>
					<input class="icp-auto" type="text" id="<?php echo esc_attr( $this->get_field_id( 'icon' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'icon' ) ); ?>" value="<?php echo esc_attr( $icon ); ?>" /><br>
					<em><?php echo wp_kses_post( thelandscaper_toolkit_fa_example_text() ); ?></em>
				</p>

			<?php } else { ?>

				<p>
					<label for="<?php echo esc_attr( $this->get_field_id( 'icon' ) ); ?>"><?php esc_html_e( 'Icon', 'the-landscaper-wp' ); ?>:</label> <em><?php echo wp_kses_post( thelandscaper_toolkit_fa_example_text() ); ?></em>
                    <input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'icon' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'icon' ) ); ?>" type="text" value="<?php echo esc_attr( $icon ); ?>" />
				</p>

			<?php } ?>

			<p class="icon-layout">
				<label for="<?php echo esc_attr( $this->get_field_id( 'layout' ) ); ?>"><?php esc_html_e( 'Icon Size', 'the-landscaper-wp' ); ?>:</label> <br>
				<select id="<?php echo esc_attr( $this->get_field_id( 'layout' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'layout' ) ); ?>">
					<option value="small" <?php selected( $layout, 'small' ); ?>><?php esc_html_e( 'Small Icon', 'the-landscaper-wp' ); ?></option>
					<option value="big" <?php selected( $layout, 'big' ); ?>><?php esc_html_e( 'Big Icon', 'the-landscaper-wp' ); ?></option>
				</select>
			</p>

			<p>
				<label for="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>"><?php esc_html_e( 'Title', 'the-landscaper-wp' ); ?>:</label>
				<input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'title' ) ); ?>" type="text" value="<?php echo esc_attr( $title ); ?>" />
			</p>

			<p>
				<label for="<?php echo esc_attr( $this->get_field_id( 'text' ) ); ?>"><?php esc_html_e( 'Text', 'the-landscaper-wp' ); ?>:</label> <br />
				<input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'text' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'text' ) ); ?>" type="text" value="<?php echo esc_attr( $text ); ?>" />
			</p>

			<p>
				<label for="<?php echo esc_attr( $this->get_field_id( 'link' ) ); ?>"><?php esc_html_e( 'Link (optional)', 'the-landscaper-wp' ); ?>:</label> <br>
				<input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'link' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'link' ) ); ?>" type="text" value="<?php echo esc_url( $link ); ?>" />
			</p>

			<p>
				<input class="checkbox" type="checkbox" <?php checked( $new_tab, 'on'); ?> id="<?php echo esc_attr( $this->get_field_id( 'new_tab' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'new_tab' ) ); ?>" value="on" />
				<label for="<?php echo esc_attr( $this->get_field_id( 'new_tab' ) ); ?>"><?php esc_html_e( 'Open link in new browser tab?', 'the-landscaper-wp' ); ?></label>
			</p>

			<script type="text/javascript">
				jQuery( document ).ready( function() {
					if ( jQuery( '.widget-liquid-right .icp-auto, .so-content .icp-auto' ).length ) {
						jQuery( '.widget-liquid-right .icp-auto, .so-content .icp-auto' ).fontIconPicker({
							source: <?php echo wp_json_encode( thelandscaper_toolkit_fa_icon_array() ); ?>,
							emptyIcon: true,
							hasSearch: true,
							iconsPerPage: 250,
						});
					}
				});
			</script>

			<?php
		}
	}
}