<?php
/**
 * Widget: Team Member
 *
 * @package thelandscaper-toolkit
 */

if ( ! class_exists( 'QT_Team_Member' ) ) {
	class QT_Team_Member extends WP_Widget {

		/**
		 * Register widget with WordPress.
		 */
		public function __construct() {
			parent::__construct(
				false,
				esc_html__( 'QT: Team Member', 'the-landscaper-wp' ),
				array(
					'description' => esc_html__( 'Add a staff/team member', 'the-landscaper-wp' ),
					'classname'   => 'widget-team-member',
				)
			);
		}
		
		/**
		 * Front-end display of widget.
		 *
		 * @see WP_Widget::widget()
		 *
		 * @param array $args     Widget arguments.
		 * @param array $instance Saved values from database.
		 */
		public function widget( $args, $instance ) {

			// Define Font Awesome 4 social icon classes
			$icon_classes = array(
				'fa fa-facebook',
				'fa fa-twitter',
				'fa fa-linkedin',
				'fa fa-instagram',
				'fa fa-envelope',
				'fa fa-phone',
			);

			// Overwrite if Font Awesome version 5 is selected
			if ( '5' === get_theme_mod( 'qt_fontawesome_version' ) ) {
				$icon_classes = array(
					'fab fa-facebook-f',
					'fab fa-twitter',
					'fab fa-linkedin',
					'fab fa-instagram',
					'fas fa-envelope',
					'fas fa-phone-alt',
				);
			}

			// Check if fields are empty
			$instance['instagram'] = empty( $instance['instagram'] ) ? '' : $instance['instagram'];
			$instance['phone'] = empty( $instance['phone'] ) ? '' : $instance['phone'];

			// Check if image ID is set
			$person_image_id = empty( $instance['person_image_id'] ) ? '' : $instance['person_image_id'];

			echo $args['before_widget'];
		 	?>

			<div class="team-member">
				<?php if ( $instance['person_image'] ) : ?>
					<div class="team-member-image">
						<?php if ( $person_image_id ) { ?>
							<?php echo wp_get_attachment_image( $person_image_id, 'full' ); ?>
						<?php } else { ?>
							<img loading="lazy" src="<?php echo esc_url( $instance['person_image'] ); ?>" alt="<?php echo esc_attr( $instance['person_name'] ); ?>">
						<?php } ?>
						<?php if ( $instance['facebook'] || $instance['twitter'] || $instance['linkedin'] || $instance['instagram'] || $instance['email'] || $instance['phone'] ) : ?>
						<div class="team-member-social">
							<div class="overlay-center">
								<?php if ( $instance['facebook'] ) : ?>
									<a href="<?php echo esc_url( $instance['facebook'] ); ?>" aria-label="<?php esc_attr_e( 'Facebook', 'the-landscaper-wp' ); ?>" <?php echo empty ( $instance['new_tab'] ) ? '' : 'target="_blank" rel="noopener noreferrer"'; ?>><i class="<?php echo esc_attr( $icon_classes[0] ); ?>"></i></a>
								<?php endif; ?>
								<?php if ( $instance['twitter'] ) : ?>
									<a href="<?php echo esc_url( $instance['twitter'] ); ?>" aria-label="<?php esc_attr_e( 'Twitter', 'the-landscaper-wp' ); ?>" <?php echo empty ( $instance['new_tab'] ) ? '' : 'target="_blank" rel="noopener noreferrer"'; ?>><i class="<?php echo esc_attr( $icon_classes[1] ); ?>"></i></a>
								<?php endif; ?>
								<?php if ( $instance['linkedin'] ) : ?>
									<a href="<?php echo esc_url( $instance['linkedin'] ); ?>" aria-label="<?php esc_attr_e( 'LinkedIn', 'the-landscaper-wp' ); ?>" <?php echo empty ( $instance['new_tab'] ) ? '' : 'target="_blank" rel="noopener noreferrer"'; ?>><i class="<?php echo esc_attr( $icon_classes[2] ); ?>"></i></a>
								<?php endif; ?>
								<?php if ( $instance['instagram'] ) : ?>
									<a href="<?php echo esc_url( $instance['instagram'] ); ?>" aria-label="<?php esc_attr_e( 'Instagram', 'the-landscaper-wp' ); ?>" <?php echo empty ( $instance['new_tab'] ) ? '' : 'target="_blank" rel="noopener noreferrer"'; ?>><i class="<?php echo esc_attr( $icon_classes[3] ); ?>"></i></a>
								<?php endif; ?>
								<?php if ( $instance['email'] ) : ?>
									<a href="mailto:<?php echo sanitize_email( $instance['email'] ); ?>" aria-label="<?php esc_attr_e( 'Email', 'the-landscaper-wp' ); ?>"><i class="<?php echo esc_attr( $icon_classes[4] ); ?>"></i></a>
								<?php endif; ?>
								<?php if ( $instance['phone'] ) : ?>
									<a href="tel:<?php echo esc_attr( $instance['phone'] ); ?>" aria-label="<?php esc_attr_e( 'Phone', 'the-landscaper-wp' ); ?>"><i class="<?php echo esc_attr( $icon_classes[5] ); ?>"></i></a>
								<?php endif; ?>
							</div>
						</div>
						<?php endif; ?>
						<?php if ( $instance['person_link_url'] ) : ?>
							<a href="<?php echo esc_url( $instance['person_link_url'] ); ?>" aria-label="<?php echo esc_attr( $instance['person_link_text'] ); ?>" class="link-overlay"></a>
						<?php endif; ?>
					</div>
				<?php endif; ?>
				<div class="team-member-content">
					<h4 class="team-member-name">
						<?php if ( ! empty ( $instance['person_link_url'] ) ) : ?>
							<a href="<?php echo esc_url( $instance['person_link_url'] ); ?>">
						<?php endif; ?>
						<?php echo wp_kses_post( $instance['person_name'] ); ?>
						<?php echo empty ( $instance['person_link_url'] ) ? '' : '</a>'; ?>
					</h4>
					<?php if ( ! empty ( $instance['person_tag'] ) ) : ?>
						<span class="team-member-tag"><?php echo esc_html( $instance['person_tag'] ); ?></span>
					<?php endif; ?>
					<?php if ( ! empty ( $instance['person_description'] ) ) : ?>
						<p class="team-member-description"><?php echo wp_kses_post( $instance['person_description'] ); ?></p>
					<?php endif; ?>
					<?php if ( $instance['person_link_text'] ) : ?>
						<a href="<?php echo esc_url( $instance['person_link_url'] ); ?>" class="text-link"><?php echo esc_html( $instance['person_link_text'] ); ?></a>
					<?php endif; ?>
				</div>
			</div>

			<?php
			echo $args['after_widget'];
		}
		
		/**
		 * Sanitize widget form values as they are saved.
		 *
		 * @see WP_Widget::update()
		 *
		 * @param array $new_instance Values just sent to be saved.
		 * @param array $old_instance Previously saved values from database.
		 *
		 * @return array Updated safe values to be saved.
		 */
		public function update( $new_instance, $old_instance ) {
			$instance = array();

			$instance['person_name']		= sanitize_text_field( $new_instance['person_name'] );
			$instance['person_tag']			= sanitize_text_field( $new_instance['person_tag'] );
			$instance['person_image']		= esc_url_raw( $new_instance['person_image'] );
			$instance['person_image_id']	= esc_html( $new_instance['person_image_id'] );
			$instance['person_description']	= wp_kses_post( $new_instance['person_description'] );
			$instance['person_link_url']	= sanitize_text_field( $new_instance['person_link_url'] );
			$instance['person_link_text']	= sanitize_text_field( $new_instance['person_link_text'] );

			$instance['facebook']			= sanitize_text_field( $new_instance['facebook'] );
			$instance['twitter']			= sanitize_text_field( $new_instance['twitter'] );
			$instance['instagram']			= sanitize_text_field( $new_instance['instagram'] );
			$instance['linkedin']			= sanitize_text_field( $new_instance['linkedin'] );
			$instance['email']				= sanitize_text_field( $new_instance['email'] );
			$instance['phone']				= sanitize_text_field( $new_instance['phone'] );
			$instance['new_tab']			= ! empty( $new_instance['new_tab'] ) ? sanitize_key( $new_instance['new_tab'] ) : '';
			
			return $instance;
		}

		/**
		 * Back-end widget form.
		 *
		 * @see WP_Widget::form()
		 *
		 * @param array $instance Previously saved values from database.
		 */
		public function form( $instance ) {
			$person_name		= empty( $instance['person_name'] ) ? '' : $instance['person_name'];
			$person_tag			= empty( $instance['person_tag'] ) ? '' : $instance['person_tag'];
			$person_image		= empty( $instance['person_image'] ) ? '' : $instance['person_image'];
			$person_image_id 	= empty( $instance['person_image_id'] ) ? '' : $instance['person_image_id'];
			$person_description	= empty( $instance['person_description'] ) ? '' : $instance['person_description'];
			$person_link_url	= empty( $instance['person_link_url'] ) ? '' : $instance['person_link_url'];
			$person_link_text	= empty( $instance['person_link_text'] ) ? '' : $instance['person_link_text'];

			$facebook 			= empty( $instance['facebook'] ) ? '' : $instance['facebook'];
			$twitter 			= empty( $instance['twitter'] ) ? '' : $instance['twitter'];
			$instagram 			= empty( $instance['instagram'] ) ? '' : $instance['instagram'];
			$linkedin 			= empty( $instance['linkedin'] ) ? '' : $instance['linkedin'];
			$email 				= empty( $instance['email'] ) ? '' : $instance['email'];
			$phone 				= empty( $instance['phone'] ) ? '' : $instance['phone'];
			$new_tab     		= empty( $instance['new_tab'] ) ? '' : $instance['new_tab'];
			?>

			<p>
				<label for="<?php echo esc_attr( $this->get_field_id( 'person_name' ) ); ?>"><?php esc_html_e( 'Person Name', 'the-landscaper-wp'   ); ?>:</label><br>
				<input id="<?php echo esc_attr( $this->get_field_id( 'person_name' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'person_name' ) ); ?>" type="text" value="<?php echo esc_attr( $person_name ); ?>" />
			</p>

			<p>
				<label for="<?php echo esc_attr( $this->get_field_id( 'person_tag' ) ); ?>"><?php esc_html_e( 'Person Tag', 'the-landscaper-wp'   ); ?>:</label><br>
				<input id="<?php echo esc_attr( $this->get_field_id( 'person_tag' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'person_tag' ) ); ?>" type="text" value="<?php echo esc_attr( $person_tag ); ?>" />
			</p>

			<p>
				<label for="<?php echo esc_attr( $this->get_field_id( 'person_image' ) ); ?>"><?php esc_html_e( 'Person Image URL', 'the-landscaper-wp' ); ?>:</label><br>

				<input class="widefat upload-file-url" id="<?php echo esc_attr( $this->get_field_id( 'person_image' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'person_image' ) ); ?>" type="text" value="<?php echo esc_attr( $person_image ); ?>" />

				<input class="widefat upload-file-id" id="<?php echo esc_attr( $this->get_field_id( 'person_image_id' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'person_image_id' ) ); ?>" type="hidden" value="<?php echo esc_attr( $person_image_id ); ?>" />

				<input type="button" class="upload-file-button button" value="Select Image" />
			</p>

			<p>
				<label for="<?php echo esc_attr( $this->get_field_id( 'person_description' ) ); ?>"><?php esc_html_e( 'Person Description', 'the-landscaper-wp'   ); ?>:</label><br>
				<textarea class="widefat" rows="4" id="<?php echo esc_attr( $this->get_field_id( 'person_description' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'person_description' ) ); ?>"><?php echo esc_attr( $person_description ); ?></textarea>
			</p>

			<p>
				<label for="<?php echo esc_attr( $this->get_field_id( 'person_link_url' ) ); ?>"><?php esc_html_e( 'Link to URL (optional)', 'the-landscaper-wp'   ); ?>:</label><br>
				<input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'person_link_url' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'person_link_url' ) ); ?>" type="text" value="<?php echo esc_attr( $person_link_url ); ?>" />
			</p>

			<p>
				<label for="<?php echo esc_attr( $this->get_field_id( 'person_link_text' ) ); ?>"><?php esc_html_e( 'Link to Text (optional)', 'the-landscaper-wp'   ); ?>:</label><br>
				<input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'person_link_text' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'person_link_text' ) ); ?>" type="text" value="<?php echo esc_attr( $person_link_text ); ?>" />
			</p>

			<p>
				<label for="<?php echo esc_attr( $this->get_field_id( 'facebook' ) ); ?>">Facebook <?php esc_html_e( 'URL', 'the-landscaper-wp'   ); ?>:</label><br>
				<input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'facebook' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'facebook' ) ); ?>" type="text" value="<?php echo esc_attr( $facebook ); ?>" />
			</p>

			<p>
				<label for="<?php echo esc_attr( $this->get_field_id( 'twitter' ) ); ?>">Twitter <?php esc_html_e( 'URL', 'the-landscaper-wp'   ); ?>:</label><br>
				<input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'twitter' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'twitter' ) ); ?>" type="text" value="<?php echo esc_attr( $twitter ); ?>" />
			</p>

			<p>
				<label for="<?php echo esc_attr( $this->get_field_id( 'linkedin' ) ); ?>">LinkedIn <?php esc_html_e( 'URL', 'the-landscaper-wp'   ); ?>:</label><br>
				<input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'linkedin' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'linkedin' ) ); ?>" type="text" value="<?php echo esc_attr( $linkedin ); ?>" />
			</p>

			<p>
				<label for="<?php echo esc_attr( $this->get_field_id( 'instagram' ) ); ?>">Instagram <?php esc_html_e( 'URL', 'the-landscaper-wp'   ); ?>:</label><br>
				<input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'instagram' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'instagram' ) ); ?>" type="text" value="<?php echo esc_attr( $instagram ); ?>" />
			</p>

			<p>
				<label for="<?php echo esc_attr( $this->get_field_id( 'email' ) ); ?>"><?php esc_html_e( 'Email Address', 'the-landscaper-wp'   ); ?>:</label><br>
				<input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'email' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'email' ) ); ?>" type="text" value="<?php echo esc_attr( $email ); ?>" />
			</p>

			<p>
				<label for="<?php echo esc_attr( $this->get_field_id( 'phone' ) ); ?>"><?php esc_html_e( 'Phone Number', 'the-landscaper-wp'   ); ?>:</label><br>
				<input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'phone' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'phone' ) ); ?>" type="text" value="<?php echo esc_attr( $phone ); ?>" />
			</p>

			<p>
				<input class="checkbox" type="checkbox" <?php checked( $new_tab, 'on'); ?> id="<?php echo esc_attr( $this->get_field_id( 'new_tab' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'new_tab' ) ); ?>" value="on" />
				<label for="<?php echo esc_attr( $this->get_field_id( 'new_tab' ) ); ?>"><?php esc_html_e( 'Open social links in new browser tab?', 'the-landscaper-wp' ); ?></label>
			</p>

			<?php 
		}
	}
}