<?php

/**
 * Topbar settings for sidebar header layout
 */

/* Navigation settings for sidebar header layout */
$wp_customize->add_setting( 'qt_nav_bg_sidebar', array(
	'default' 				=> '#3a3a3a',
	'transport'				=> 'refresh',
    'sanitize_callback' 	=> 'sanitize_hex_color',
) );

$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'qt_nav_bg_sidebar', array(
	'label'         		=> esc_html__( 'Navigation background color', 'the-landscaper-wp' ),
	'description' 			=> esc_html__( 'Change the background color of the navigation', 'the-landscaper-wp' ),
	'section'     			=> 'qt_section_navigation',
	'settings'    			=> 'qt_nav_bg_sidebar',
	'active_callback' 		=> array( $this, 'thelandscaper_show_settings_header_sidebar' ),
) ) );

$wp_customize->add_setting( 'qt_nav_active_line', array(
	'default' 				=> '#c7d990',
	'transport'				=> 'refresh',
    'sanitize_callback' 	=> 'sanitize_hex_color',
) );

$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'qt_nav_active_line', array(
	'label'         		=> esc_html__( 'Active & hover line', 'the-landscaper-wp' ),
	'description' 			=> esc_html__( 'Change the color of the active and hover line', 'the-landscaper-wp' ),
	'section'     			=> 'qt_section_navigation',
	'settings'    			=> 'qt_nav_active_line',
	'active_callback' 		=> array( $this, 'thelandscaper_show_settings_header_sidebar' ),
) ) );

$wp_customize->add_setting( 'qt_nav_textcolor_sidebar', array(
    'default'    			=> '#ffffff',
    'transport'				=> 'refresh',
    'sanitize_callback' 	=> 'sanitize_hex_color',
) );

$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'qt_nav_textcolor_sidebar', array(
	'label'      			=> esc_html__( 'Link color', 'the-landscaper-wp' ),
	'description' 			=> esc_html__( 'Change the color of the parent links', 'the-landscaper-wp' ),
	'section'     			=> 'qt_section_navigation',
	'settings'    			=> 'qt_nav_textcolor_sidebar',
	'active_callback' 		=> array( $this, 'thelandscaper_show_settings_header_sidebar' ),
) ) );

$wp_customize->add_setting( 'qt_nav_textcolor_hover_sidebar', array(
    'transport'				=> 'refresh',
    'sanitize_callback' 	=> 'sanitize_hex_color',
) );

$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'qt_nav_textcolor_hover_sidebar', array(
	'label'      			=> esc_html__( 'Link hover color', 'the-landscaper-wp' ),
	'description' 			=> esc_html__( 'Change the hover color of the parent links', 'the-landscaper-wp' ),
	'section'     			=> 'qt_section_navigation',
	'settings'    			=> 'qt_nav_textcolor_hover_sidebar',
	'active_callback' 		=> array( $this, 'thelandscaper_show_settings_header_sidebar' ),
) ) );

$wp_customize->add_setting( 'qt_nav_submenu_bg_sidebar', array(
	'default' 				=> '#a2c046',
	'transport'				=> 'refresh',
	'sanitize_callback' 	=> 'sanitize_hex_color',
) );

$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'qt_nav_submenu_bg_sidebar', array(
	'label'       			=> esc_html__( 'Submenu background color', 'the-landscaper-wp' ),
	'description' 			=> esc_html__( 'Change the background color of the submenu\'s', 'the-landscaper-wp' ),
	'section'     			=> 'qt_section_navigation',
	'settings'    			=> 'qt_nav_submenu_bg_sidebar',
	'active_callback' 		=> array( $this, 'thelandscaper_show_settings_header_sidebar' ),
) ) );

$wp_customize->add_setting( 'qt_nav_submenu_textcolor_sidebar', array(
	'default'     			=> '#ffffff',
	'transport'				=> 'refresh',
	'sanitize_callback' 	=> 'sanitize_hex_color',
) );

$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'qt_nav_submenu_textcolor_sidebar', array(
	'label'       			=> esc_html__( 'Submenu link color', 'the-landscaper-wp' ),
	'description' 			=> esc_html__( 'Change the link color of the submenu\'s', 'the-landscaper-wp' ),
	'section'     			=> 'qt_section_navigation',
	'settings'    			=> 'qt_nav_submenu_textcolor_sidebar',
	'active_callback' 		=> array( $this, 'thelandscaper_show_settings_header_sidebar' ),
) ) );

$wp_customize->add_setting( 'qt_nav_submenu_bg_hover_sidebar', array(
	'default' 				=> TheLandscaper_Customizer::thelandscaper_adjust_color( get_theme_mod( 'qt_nav_submenu_bg_sidebar', '#a2c046' ), -9 ),
	'transport'				=> 'refresh',
	'sanitize_callback' 	=> 'sanitize_hex_color',
) );

$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'qt_nav_submenu_bg_hover_sidebar', array(
	'label'       			=> esc_html__( 'Submenu background hover color', 'the-landscaper-wp' ),
	'description' 			=> esc_html__( 'Change the hover background color of the submenu\'s', 'the-landscaper-wp' ),
	'section'     			=> 'qt_section_navigation',
	'settings'    			=> 'qt_nav_submenu_bg_hover_sidebar',
	'active_callback' 		=> array( $this, 'thelandscaper_show_settings_header_sidebar' ),
) ) );

$wp_customize->add_setting( 'qt_nav_submenu_textcolor_hover_sidebar', array(
	'default'     			=> '#ffffff',
	'transport'				=> 'refresh',
	'sanitize_callback' 	=> 'sanitize_hex_color',
) );

$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'qt_nav_submenu_textcolor_hover_sidebar', array(
	'label'       			=> esc_html__( 'Submenu link color hover', 'the-landscaper-wp' ),
	'description' 			=> esc_html__( 'Change the link hover color of the submenu\'s', 'the-landscaper-wp' ),
	'section'     			=> 'qt_section_navigation',
	'settings'    			=> 'qt_nav_submenu_textcolor_hover_sidebar',
	'active_callback' 		=> array( $this, 'thelandscaper_show_settings_header_sidebar' ),
) ) );

$wp_customize->add_setting( 'qt_topbar_bg_sidebar', array(
	'default'				=> '#3a3a3a',
    'transport'				=> 'refresh',
	'sanitize_callback' 	=> 'sanitize_hex_color',
) );

$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'qt_topbar_bg_sidebar', array(
	'label'       			=> esc_html__( 'Background color', 'the-landscaper-wp' ),
	'description' 			=> esc_html__( 'Change the background color of the header', 'the-landscaper-wp' ),
	'section'     			=> 'qt_section_header',
	'settings'    			=> 'qt_topbar_bg_sidebar',
	'active_callback' 		=> array( $this, 'thelandscaper_show_settings_header_sidebar' ),
) ) );