<?php

/**
 * Topbar settings for the transparent header layout
 */

$wp_customize->add_setting( 'qt_topbar_bg_transparent', array(
	'default' 				=> '#3a3a3a',
    'transport'				=> 'refresh',
	'sanitize_callback' 	=> 'sanitize_hex_color',
) );
$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'qt_topbar_bg_transparent', array(
	'label'       			=> esc_html__( 'Mobile topbar background color', 'the-landscaper-wp' ),
	'description' 			=> esc_html__( 'Change the mobile topbar background color of the transparent header layout', 'the-landscaper-wp' ),
	'section'     			=> 'qt_section_header',
	'settings'    			=> 'qt_topbar_bg_transparent',
	'active_callback' 		=> array( $this, 'thelandscaper_show_settings_header_transparent' ),
) ) );

$wp_customize->add_setting( 'qt_topbar_textcolor_transparent', array(
    'default'     			=> '#b5b5b5',
    'transport'				=> 'refresh',
    'sanitize_callback' 	=> 'sanitize_hex_color'
) );
$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'qt_topbar_textcolor_transparent', array(
	'label' 				=> esc_html__( 'Topbar text color', 'the-landscaper-wp' ),
	'description' 			=> esc_html__( 'Change the text color of the topbar', 'the-landscaper-wp' ),
	'section' 				=> 'qt_section_header',
	'settings' 				=> 'qt_topbar_textcolor_transparent',
	'active_callback'		=> array( $this, 'thelandscaper_show_settings_header_transparent' ),
) ) );

$wp_customize->add_setting( 'qt_topbar_icon_color_transparent', array(
    'default'     			=> '#b5b5b5',
    'transport'				=> 'refresh',
    'sanitize_callback' 	=> 'sanitize_hex_color'
) );
$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'qt_topbar_icon_color_transparent', array(
	'label' 				=> esc_html__( 'Topbar icon color', 'the-landscaper-wp' ),
	'description' 			=> esc_html__( 'Change the icon color of the topbar', 'the-landscaper-wp' ),
	'section' 				=> 'qt_section_header',
	'settings' 				=> 'qt_topbar_icon_color_transparent',
	'active_callback'		=> array( $this, 'thelandscaper_show_settings_header_transparent' ),
) ) );

$wp_customize->add_setting( 'qt_topbar_icon_color_hover_transparent', array(
    'default'     			=> '#ffffff',
    'transport'				=> 'refresh',
    'sanitize_callback' 	=> 'sanitize_hex_color'
) );
$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'qt_topbar_icon_color_hover_transparent', array(
	'label' 				=> esc_html__( 'Topbar icon color hover', 'the-landscaper-wp' ),
	'description' 			=> esc_html__( 'Change the hover icon color of the topbar', 'the-landscaper-wp' ),
	'section' 				=> 'qt_section_header',
	'settings' 				=> 'qt_topbar_icon_color_hover_transparent',
	'active_callback'		=> array( $this, 'thelandscaper_show_settings_header_transparent' ),
) ) );

$wp_customize->add_setting( 'qt_topbar_link_color_transparent', array(
    'default'     			=> '#b5b5b5',
    'transport'				=> 'refresh',
    'sanitize_callback' 	=> 'sanitize_hex_color'
) );
$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'qt_topbar_link_color_transparent', array(
	'label' 				=> esc_html__( 'Topbar link color', 'the-landscaper-wp' ),
	'description' 			=> esc_html__( 'Change the link color of the topbar', 'the-landscaper-wp' ),
	'section' 				=> 'qt_section_header',
	'settings' 				=> 'qt_topbar_link_color_transparent',
	'active_callback'		=> array( $this, 'thelandscaper_show_settings_header_transparent' ),
) ) );

$wp_customize->add_setting( 'qt_topbar_link_hover_color_transparent', array(
    'default'     			=> '#ffffff',
    'transport'				=> 'refresh',
    'sanitize_callback' 	=> 'sanitize_hex_color'
) );
$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'qt_topbar_link_hover_color_transparent', array(
	'label' 				=> esc_html__( 'Topbar link hover color', 'the-landscaper-wp' ),
	'description' 			=> esc_html__( 'Change the link hover color of the topbar', 'the-landscaper-wp' ),
	'section' 				=> 'qt_section_header',
	'settings' 				=> 'qt_topbar_link_hover_color_transparent',
	'active_callback'		=> array( $this, 'thelandscaper_show_settings_header_transparent' ),
) ) );

/**
 * Header settings for the transparent header layout
 */

$wp_customize->add_setting( 'qt_gradient_bg_transparent', array(
	'default' 				=> '#3a3a3a',
    'transport'				=> 'refresh',
	'sanitize_callback' 	=> 'sanitize_hex_color',
) );
$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'qt_gradient_bg_transparent', array(
	'label'       			=> esc_html__( 'Header background color', 'the-landscaper-wp' ),
	'description' 			=> esc_html__( 'Change the background color of the transparent header layout', 'the-landscaper-wp' ),
	'section'     			=> 'qt_section_header',
	'settings'    			=> 'qt_gradient_bg_transparent',
	'active_callback' 		=> array( $this, 'thelandscaper_show_settings_header_transparent' ),
) ) );

$wp_customize->add_setting( 'qt_gradient_bg_transparent_opacity', array(
	'default' 				=> '0.5',
	'transport'				=> 'refresh',
	'sanitize_callback' 	=> 'thelandscaper_sanitize_number_absint',
) );
$wp_customize->add_control( 'qt_gradient_bg_transparent_opacity', array(
    'label' 				=> esc_html__( 'Header background opacity', 'the-landscaper-wp' ),
    'description' 			=> esc_html__( 'Change the background opacity of the transparent header. Range goes from 0 to 1', 'the-landscaper-wp' ),
	'type'              	=> 'range',
    'input_attrs'       	=> array(
        'min'           		=> 0,
        'max'           		=> 1,
        'step'          		=> 0.1,
    ),
    'section' 				=> 'qt_section_header',
    'settings' 				=> 'qt_gradient_bg_transparent_opacity',
	'active_callback' 		=> array( $this, 'thelandscaper_show_settings_header_transparent' ),
) );

/**
 * Navigation settings for the transparent header layout
 */
$wp_customize->add_setting( 'qt_nav_stickynav_bg_transparent', array(
    'default'    			=> '#000000',
    'transport'				=> 'refresh',
    'sanitize_callback' 	=> 'sanitize_hex_color',
) );
$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'qt_nav_stickynav_bg_transparent', array(
	'label'      			=> esc_html__( 'Sticky background color', 'the-landscaper-wp' ),
	'description'			=> esc_html__( 'Change the background color of the sticky navigation', 'the-landscaper-wp' ),
	'section'     			=> 'qt_section_navigation',
	'settings'    			=> 'qt_nav_stickynav_bg_transparent',
	'active_callback' 		=> array( $this, 'thelandscaper_show_setting_stickynav_background' ),
) ) );

$wp_customize->add_setting( 'qt_nav_stickynav_bg_transparent_opacity', 
	array(
	'default' 				=> '0.5',
	'transport'				=> 'refresh',
	'sanitize_callback' 	=> 'thelandscaper_sanitize_number_absint',
) );
$wp_customize->add_control( 'qt_nav_stickynav_bg_transparent_opacity', array(
    'label' 				=> esc_html__( 'Sticky background opacity', 'the-landscaper-wp' ),
    'description' 			=> esc_html__( 'Range goes from 0 to 1', 'the-landscaper-wp' ),
	'type'              	=> 'range',
    'input_attrs'       	=> array(
        'min'           		=> 0,
        'max'           		=> 1,
        'step'          		=> 0.1,
    ),
    'section' 				=> 'qt_section_navigation',
    'settings' 				=> 'qt_nav_stickynav_bg_transparent_opacity',
	'active_callback' 		=> array( $this, 'thelandscaper_show_setting_stickynav_background' ),
) );

$wp_customize->add_setting( 'qt_nav_textcolor_transparent', array(
    'default'    			=> '#ffffff',
    'transport'				=> 'refresh',
    'sanitize_callback' 	=> 'sanitize_hex_color',
) );
$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'qt_nav_textcolor_transparent', array(
	'label'      			=> esc_html__( 'Link color', 'the-landscaper-wp' ),
	'description'			=> esc_html__( 'Change the color of the parent links', 'the-landscaper-wp' ),
	'section'     			=> 'qt_section_navigation',
	'settings'    			=> 'qt_nav_textcolor_transparent',
	'active_callback' 		=> array( $this, 'thelandscaper_show_settings_header_transparent' ),
) ) );

$wp_customize->add_setting( 'qt_nav_textcolor_hover_transparent', array(
    'transport'				=> 'refresh',
    'sanitize_callback' 	=> 'sanitize_hex_color',
) );
$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'qt_nav_textcolor_hover_transparent', array(
	'label'      			=> esc_html__( 'Link hover color', 'the-landscaper-wp' ),
	'description'			=> esc_html__( 'Change the hover color of the parent links', 'the-landscaper-wp' ),
	'section'     			=> 'qt_section_navigation',
	'settings'    			=> 'qt_nav_textcolor_hover_transparent',
	'active_callback' 		=> array( $this, 'thelandscaper_show_settings_header_transparent' ),
) ) );

$wp_customize->add_setting( 'qt_nav_submenu_bg_transparent', array(
	'default' 				=> '#434343',
	'transport'				=> 'refresh',
	'sanitize_callback' 	=> 'sanitize_hex_color',
) );
$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'qt_nav_submenu_bg_transparent', array(
	'label'       			=> esc_html__( 'Submenu background color', 'the-landscaper-wp' ),
	'description'			=> esc_html__( 'Change the background color of the submenu\'s', 'the-landscaper-wp' ),
	'section'     			=> 'qt_section_navigation',
	'settings'    			=> 'qt_nav_submenu_bg_transparent',
	'active_callback' 		=> array( $this, 'thelandscaper_show_settings_header_transparent' ),
) ) );

$wp_customize->add_setting( 'qt_nav_submenu_textcolor_transparent', array(
	'default'     			=> '#999999',
	'transport'				=> 'refresh',
	'sanitize_callback' 	=> 'sanitize_hex_color',
) );
$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'qt_nav_submenu_textcolor_transparent', array(
	'label'       			=> esc_html__( 'Submenu link color', 'the-landscaper-wp' ),
	'description'			=> esc_html__( 'Change the link color of the submenu\'s', 'the-landscaper-wp' ),
	'section'     			=> 'qt_section_navigation',
	'settings'    			=> 'qt_nav_submenu_textcolor_transparent',
	'active_callback' 		=> array( $this, 'thelandscaper_show_settings_header_transparent' ),
) ) );

$wp_customize->add_setting( 'qt_nav_submenu_bg_hover_transparent', array(
	'default' 				=> TheLandscaper_Customizer::thelandscaper_adjust_color( get_theme_mod( 'qt_nav_submenu_bg_transparent', '#434343' ), -9 ),
	'transport'				=> 'refresh',
	'sanitize_callback' 	=> 'sanitize_hex_color',
) );

$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'qt_nav_submenu_bg_hover_transparent', array(
	'label'       			=> esc_html__( 'Submenu background color hover', 'the-landscaper-wp' ),
	'description'			=> esc_html__( 'Change the hover background color of the submenu\'s', 'the-landscaper-wp' ),
	'section'     			=> 'qt_section_navigation',
	'settings'    			=> 'qt_nav_submenu_bg_hover_transparent',
	'active_callback' 		=> array( $this, 'thelandscaper_show_settings_header_transparent' ),
) ) );

$wp_customize->add_setting( 'qt_nav_submenu_textcolor_hover_transparent', array(
	'default'     			=> '#ffffff',
	'transport'				=> 'refresh',
	'sanitize_callback' 	=> 'sanitize_hex_color',
) );

$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'qt_nav_submenu_textcolor_hover_transparent', array(
	'label'       			=> esc_html__( 'Submenu link color hover', 'the-landscaper-wp' ),
	'description'			=> esc_html__( 'Change the link hover color of the submenu\'s', 'the-landscaper-wp' ),
	'section'     			=> 'qt_section_navigation',
	'settings'    			=> 'qt_nav_submenu_textcolor_hover_transparent',
	'active_callback' 		=> array( $this, 'thelandscaper_show_settings_header_transparent' ),
) ) );

$wp_customize->add_setting( 'qt_nav_submenu_topline_transparent', array(
	'default'     			=> '#a2c046',
	'transport'				=> 'refresh',
	'sanitize_callback' 	=> 'sanitize_hex_color',
) );
$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'qt_nav_submenu_topline_transparent', array(
	'label'       			=> esc_html__( 'Submenu top border color', 'the-landscaper-wp' ),
	'description'			=> esc_html__( 'Change the top border color of the submenu\'s', 'the-landscaper-wp' ),
	'section'     			=> 'qt_section_navigation',
	'settings'    			=> 'qt_nav_submenu_topline_transparent',
	'active_callback' 		=> array( $this, 'thelandscaper_show_settings_header_transparent' ),
) ) );