<?php
/**
*
* Contains methods for customizing the theme customization screen.
* 
* @package The Landscaper
* @link http://codex.wordpress.org/Theme_Customization_API
*/
class TheLandscaper_Customizer {

	/**
	 * Holds the instance of this class.
	 *
	 * @access private
	 * @var    object
	 */
	private static $instance;

	public function __construct() {

		// Enqueue live preview javascript in Theme Customizer admin screen
		add_action( 'customize_preview_init', array( $this, 'thelandscaper_live_preview' ) );

		// Include custom files
		add_action( 'customize_register', array( $this, 'thelandscaper_customize_include_files' ) );

		// Add options to the theme customizer.
		add_action( 'customize_register', array( $this, 'thelandscaper_customize_register' ) );

		// Output Customizer CSS & Custom CSS to the header
		add_action( 'wp_head', array( $this, 'thelandscaper_head_callback' ) );

		// Output Customizer JS to the header
		add_action( 'wp_head', array( $this, 'thelandscaper_head_js' ) );

		// Output Customizer JS to the footer
		add_action( 'wp_footer', array( $this, 'thelandscaper_foot_js' ) );

		// Delete the cached data for this feature.
		add_action( 'customize_save_after' . get_stylesheet(), array( $this, 'thelandscaper_cache_delete' ) );

		// Flush the rewrite rules after saving the customizer
		add_action( 'customize_save_after', 'flush_rewrite_rules' );
	}

	/**
	 * Include custom files to the customizer
	 */
	public function thelandscaper_customize_include_files( $wp_customize ) {

		// Get custom customizer functions
		// require_once ( get_theme_file_path( '/inc/customizer/custom_functions.php' ) );

		// Get sanitize callback functions
		// require_once ( get_theme_file_path( '/inc/customizer/sanitize_callbacks.php' ) );

		// Get custom controls
		require_once( get_theme_file_path( '/inc/customizer-settings/google-font-settings.php' ) );
	}

	/**
	* This hooks into 'customize_register' (available as of WP 3.4) and allows
	* you to add new sections and controls to the Theme Customize screen.
	* 
	* Note: To enable instant preview, we have to actually write a bit of custom
	* javascript. See live_preview() for more.
	*  
	* @see add_action('customize_register',$func)
	*/
	public function thelandscaper_customize_register( $wp_customize ) {

		// Remove some default controls (can still be edited under the settings admin tab)
		$wp_customize->remove_section( 'static_front_page' );
		$wp_customize->remove_control( 'blogdescription' );
		$wp_customize->remove_control( 'blogname' );
		$wp_customize->remove_control( 'background_color' );

		/** 
		 * Add custom theme panel to the live customizer for our theme options
		 */
		$wp_customize->add_panel( 'qt_theme_panel', array(
			'title'       	=> esc_html__( 'Theme Options', 'the-landscaper-wp' ),
			'priority'    	=> 10,
		) );

		/** 
		 * Add custom sections to the custom theme panel
		 */
		$wp_customize->add_section( 'qt_section_logo', array(
			'title'       	=> esc_html__( 'Logo', 'the-landscaper-wp' ),
			'panel'       	=> 'qt_theme_panel',
		) );
		
		$wp_customize->add_section( 'qt_section_header', array(
			'title' 	  	=> esc_html__( 'Header', 'the-landscaper-wp' ),
			'panel'       	=> 'qt_theme_panel',
		) );
	    
	    $wp_customize->add_section( 'qt_section_navigation', array(
			'title' 	  	=> esc_html__( 'Navigation', 'the-landscaper-wp' ),
			'panel'       	=> 'qt_theme_panel',
		) );

		$wp_customize->add_section( 'qt_section_navigation_mobile', array(
			'title' 	  	=> esc_html__( 'Mobile Navigation', 'the-landscaper-wp' ),
			'panel'       	=> 'qt_theme_panel',
		) );
		
		$wp_customize->add_section( 'qt_section_slider', array(
			'title' 	  	=> esc_html__( 'Slider', 'the-landscaper-wp' ),
			'description' 	=> esc_html__( 'Color settings for the homepage slider', 'the-landscaper-wp' ),
			'panel'       	=> 'qt_theme_panel',
		) );
	    
	    $wp_customize->add_section( 'qt_section_main_title', array(
			'title' 	  	=> esc_html__( 'Page Header', 'the-landscaper-wp' ),
			'panel'       	=> 'qt_theme_panel',
		) );
	    
	    $wp_customize->add_section( 'qt_section_breadcrumbs', array(
			'title'		  	=> esc_html__( 'Breadcrumbs', 'the-landscaper-wp' ),
			'panel'       	=> 'qt_theme_panel',
		) );
		
		$wp_customize->add_section( 'qt_section_theme_colors', array(
			'title'		  	=> esc_html__( 'Layout &amp; Colors', 'the-landscaper-wp' ),
			'panel'       	=> 'qt_theme_panel',
		) );
		
		$wp_customize->add_section( 'qt_section_blog', array(
			'title'		  	=> esc_html__( 'Blog', 'the-landscaper-wp' ),
			'panel'       	=> 'qt_theme_panel',
		) );
	    
	    $wp_customize->add_section( 'qt_section_gallery', array(
			'title'		  	=> esc_html__( 'Single Gallery', 'the-landscaper-wp' ),
			'description' 	=> esc_html__( 'Gallery settings for the single gallery posts', 'the-landscaper-wp' ),
			'panel'       	=> 'qt_theme_panel',
		) );
	    
	    if ( thelandscaper_woocommerce_active() ) {
	        $wp_customize->add_section( 'qt_section_shop', array(
	            'title'		  	=> esc_html__( 'Shop', 'the-landscaper-wp' ),
	        
	            'panel'       	=> 'qt_theme_panel',
	        ) );
		}
	    
	    $wp_customize->add_section( 'qt_section_footer', array(
			'title'		  	=> esc_html__( 'Footer', 'the-landscaper-wp' ),
			'panel'       	=> 'qt_theme_panel',
		) );
		
		$wp_customize->add_section( 'qt_section_typography', array(
			'title'		  	=> esc_html__( 'Typography', 'the-landscaper-wp' ),
			'description' 	=> sprintf( esc_html__( 'If you\'re looking for more advanced typography controls please install the %s plugin or use the child theme to enqueue custom fonts.', 'the-landscaper-wp'  ), '<a href="'. esc_url( '//wordpress.org/plugins/easy-google-fonts/' ) .'" target="_blank">Easy Google Fonts</a>' ),
			'panel'       	=> 'qt_theme_panel',
		) );
		
		$wp_customize->add_section( 'qt_section_other', array(
			'title'		  	=> esc_html__( '404 Page', 'the-landscaper-wp' ),
			'panel'       	=> 'qt_theme_panel',
		) );
		
		$wp_customize->add_section( 'qt_section_opening_hours', array(
            'title'		  	=> esc_html__( 'Opening Hours & Translation', 'the-landscaper-wp' ),
            'description' 	=> esc_html__( 'Set global opening hours and translate the weekdays for the opening hour widget', 'the-landscaper-wp' ),
            'panel'       	=> 'qt_theme_panel',
	    ) );

	    $wp_customize->add_section( 'qt_section_fontawesome', array(
            'title'		  	=> esc_html__( 'Font Awesome', 'the-landscaper-wp' ),
            'description' 	=> esc_html__( 'Please do not use this to downgrade from Font Awesome version 5 to 4.', 'the-landscaper-wp' ),
            'panel'       	=> 'qt_theme_panel',
	    ) );
	    
	    $wp_customize->add_section( 'qt_section_custom', array(
            'title'		  	=> esc_html__( 'Custom', 'the-landscaper-wp' ),
            'description'	=> esc_html__( 'It is recommended to type code in a text editor and then paste it into the field below', 'the-landscaper-wp' ),
        
            'panel'       	=> 'qt_theme_panel',
	    ) );


		/** 
		 * Panel: Logo
		 */
		$wp_customize->add_setting( 'qt_logo', array( 
			'default' 			=> get_theme_file_uri( '/assets/images/logo.png' ),
			'transport'			=> 'refresh',
			'sanitize_callback' => 'esc_url',
		) );
		$wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'qt_logo', array(
            'label' 	 		=> esc_html__('Theme logo', 'the-landscaper-wp'),
            'description' 		=> esc_html__( 'Recommended logo height is 90 pixels', 'the-landscaper-wp' ),
            'section' 	 		=> 'qt_section_logo',
            'settings' 	 		=> 'qt_logo',
		) ) );

		$wp_customize->add_setting( 'qt_logo_retina', array( 
			'transport'			=> 'refresh',
			'sanitize_callback' => 'esc_url',
		) );
		$wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'qt_logo_retina', array(
        	'label' 	 		=> esc_html__( 'Theme logo retina (2x)', 'the-landscaper-wp' ),
            'description' 		=> esc_html__( 'Please do not upload the regular logo here. Only add a logo that is exact 2x the size of the regular logo', 'the-landscaper-wp' ),
            'section' 	 		=> 'qt_section_logo',
            'settings' 	 		=> 'qt_logo_retina',
		) ) );

		$wp_customize->add_setting( 'qt_logo_margin_top', array(
	    	'default' 			=> '0',
	    	'transport'			=> 'refresh',
	    	'sanitize_callback' => 'wp_kses_post',
		) );
		$wp_customize->add_control( 'qt_logo_margin_top', array(
		    'label' 			=> esc_html__( 'Logo top margin', 'the-landscaper-wp'),
		    'description' 		=> esc_html__( 'Change the logo top margin. Please don\'t include px', 'the-landscaper-wp' ),
	    	'type'		        => 'number',
		    'section' 			=> 'qt_section_logo',
		    'settings' 			=> 'qt_logo_margin_top',
		    'input_attrs' 		=> array(
				'min'  => 0,
				'max'  => 100,
				'step' => 5,
			),
		) );

		$wp_customize->add_setting( 'qt_logo_width', array(
	    	'transport' 			=> 'refresh',
	    	'sanitize_callback' 	=> 'wp_kses_post',
		) );
		$wp_customize->add_control( 'qt_logo_width', array(
		    'label' 				=> esc_html__( 'Logo width', 'the-landscaper-wp'),
		    'description' 			=> esc_html__( 'Change the logo width. Please don\'t include px', 'the-landscaper-wp' ),
	    	'type' 					=> 'number',
		    'section' 				=> 'qt_section_logo',
		    'settings' 				=> 'qt_logo_width',
		    'input_attrs'			=> array(
				'min'	=> 0,
				'max' 	=> 500,
				'step'	=> 10,
			),
		) );

		$wp_customize->add_setting( 'qt_logo_transparent', array( 
			'default' 			=> get_theme_file_uri( '/assets/images/logo_transparent.png' ),
			'transport'			=> 'refresh',
			'sanitize_callback' => 'esc_url',
		) );
		$wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'qt_logo_transparent', array(
            'label' 	 		=> esc_html__( 'Theme logo transparent', 'the-landscaper-wp' ),
            'description' 		=> esc_html__( 'Logo only for the transparent, sidebar and overlay header layouts', 'the-landscaper-wp' ),
            'section' 	 		=> 'qt_section_logo',
            'settings' 	 		=> 'qt_logo_transparent',
		) ) );

		$wp_customize->add_setting( 'qt_logo_retina_transparent', array( 
			'default' 			=> get_theme_file_uri( '/assets/images/logo_transparent_2x.png' ),
			'transport'			=> 'refresh',
			'sanitize_callback' => 'esc_url',
		) );
		$wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'qt_logo_retina_transparent', array(
        	'label' 	 		=> esc_html__( 'Theme logo transparent retina (2x)', 'the-landscaper-wp' ),
        	'description' 		=> esc_html__( 'Please do not upload the regular transparent logo here. Only add a logo that is exact 2x the size of the regular logo', 'the-landscaper-wp' ),
            'section' 	 		=> 'qt_section_logo',
            'settings' 	 		=> 'qt_logo_retina_transparent',
		) ) );

		$wp_customize->add_setting( 'qt_logo_header_overlay', array(
	    	'default'  				=> 'default',
	    	'transport'				=> 'refresh',
	    	'type'					=> 'theme_mod',
	    	'capability'			=> 'edit_theme_options',
	    	'sanitize_callback' 	=> 'sanitize_text_field',
		) );
		$wp_customize->add_control( 'qt_logo_header_overlay', array(
			'label'    				=> esc_html__( 'Header overlay logo', 'the-landscaper-wp' ),
			'description'    		=> esc_html__( 'Choose which logo to display for the header overlay layout', 'the-landscaper-wp' ),
			'section'  				=> 'qt_section_logo',
			'settings' 				=> 'qt_logo_header_overlay',
			'type'     				=> 'select',
			'choices'  				=> array(
				'default'  			=> esc_html__( 'Default logo', 'the-landscaper-wp' ),
				'transparent' 		=> esc_html__( 'Transparent logo', 'the-landscaper-wp' ),
			),
			'active_callback' 		=> array( $this, 'thelandscaper_show_settings_header_overlay' ),
		) );

		/** 
		 * Panel: Header
		 */
		$wp_customize->add_setting( 'qt_topbar', array(
	    	'default'  				=> 'show',
	    	'transport'				=> 'refresh',
	    	'type'					=> 'theme_mod',
	    	'capability'			=> 'edit_theme_options',
	    	'sanitize_callback' 	=> 'sanitize_text_field',
		) );
		$wp_customize->add_control( 'qt_topbar', array(
			'label'    				=> esc_html__( 'Topbar', 'the-landscaper-wp' ),
			'description'    		=> esc_html__( 'Show or hide the topbar', 'the-landscaper-wp' ),
			'section'  				=> 'qt_section_header',
			'settings' 				=> 'qt_topbar',
			'type'     				=> 'select',
			'choices'  				=> array(
				'show'  			=> esc_html__( 'Show', 'the-landscaper-wp' ),
				'hide' 				=> esc_html__( 'Hide', 'the-landscaper-wp' ),
				'hide_mobile' 		=> esc_html__( 'Hide on mobile only', 'the-landscaper-wp' ),
			),
		) );

		$wp_customize->add_setting( 'qt_nav_layout', array(
	    	'default'  				=> 'default',
	    	'transport'				=> 'refresh',
	    	'sanitize_callback' 	=> 'sanitize_text_field',
		) );
		$wp_customize->add_control( 'qt_nav_layout', array(
			'label'    				=> esc_html__( 'Header layout', 'the-landscaper-wp' ),
			'description' 			=> esc_html__( 'Change the global header layout', 'the-landscaper-wp' ),
			'section'  				=> 'qt_section_header',
			'settings' 				=> 'qt_nav_layout',
			'type'     				=> 'select',
			'choices'  				=> array(
				'default'  				=> esc_html__( 'Default', 'the-landscaper-wp' ),
				'wide' 					=> esc_html__( 'Wide', 'the-landscaper-wp'),
				'fullwidth' 			=> esc_html__( 'Full width', 'the-landscaper-wp'),
				'transparent' 			=> esc_html__( 'Transparent', 'the-landscaper-wp'),
				'sidebar' 				=> esc_html__( 'Sidebar', 'the-landscaper-wp' ),
				'overlay' 				=> esc_html__( 'Overlay', 'the-landscaper-wp' ),
			),
		) );

		$wp_customize->add_setting( 'qt_topbar_bg', array( 
			'default' 				=> '#3a3a3a',
			'transport'				=> 'refresh',
			'sanitize_callback' 	=> 'sanitize_hex_color',
		) );
		$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'qt_topbar_bg', array(
			'label'       			=> esc_html__( 'Topbar background color', 'the-landscaper-wp' ),
			'description' 			=> esc_html__( 'Change the background color of the topbar', 'the-landscaper-wp' ),
			'section'     			=> 'qt_section_header',
			'settings'    			=> 'qt_topbar_bg',
			'active_callback' 		=> array( $this, 'thelandscaper_show_settings_except_header_sidebar_and_transparent' ),
		) ) );

		/** 
		 * Panel: Navigation
		 */

		/* Settings for the header default & wide layout */
		require get_theme_file_path( '/inc/customizer-settings/header-default-settings.php' );

		/* Settings for the header transparent layout */
		require get_theme_file_path( '/inc/customizer-settings/header-transparent-settings.php' );

		/* Settings for the header sidebar layout */
		require get_theme_file_path( '/inc/customizer-settings/header-sidebar-settings.php' );

		/* Settings for the header overlay layout */
		require get_theme_file_path( '/inc/customizer-settings/header-overlay-settings.php' );

		$wp_customize->add_setting( 'qt_nav_submenu_textcolor_hover', array(
			'default'     			=> '#fff',
			'transport'				=> 'refresh',
			'sanitize_callback' 	=> 'sanitize_hex_color',
		) );

		$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'qt_nav_submenu_textcolor_hover', array(
			'label'       			=> esc_html__( 'Submenu link color hover', 'the-landscaper-wp' ),
			'description'			=> esc_html__( 'Change the link hover color of the submenu\'s', 'the-landscaper-wp' ),
			'section'     			=> 'qt_section_navigation',
			'settings'    			=> 'qt_nav_submenu_textcolor_hover',
			'active_callback' 		=> array( $this, 'thelandscaper_show_settings_header_default_and_overlay' ),
		) ) );

		$wp_customize->add_setting( 'qt_nav_submenu_bg_hover', array(
			'default' 				=> TheLandscaper_Customizer::thelandscaper_adjust_color( get_theme_mod( 'qt_nav_submenu_bg', '#434343' ), -9 ),
			'transport'				=> 'refresh',
			'sanitize_callback' 	=> 'sanitize_hex_color',
		) );

		$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'qt_nav_submenu_bg_hover', array(
			'label'       			=> esc_html__( 'Submenu background color hover', 'the-landscaper-wp' ),
			'description'			=> esc_html__( 'Change the hover background color of the submenu\'s', 'the-landscaper-wp' ),
			'section'     			=> 'qt_section_navigation',
			'settings'    			=> 'qt_nav_submenu_bg_hover',
			'active_callback' 		=> array( $this, 'thelandscaper_show_settings_header_default_and_overlay' ),
		) ) );

		$wp_customize->add_setting( 'qt_nav_double_tap', array(
        	'default'  				=> 'yes',
        	'transport'				=> 'refresh',
        	'sanitize_callback' 	=> 'sanitize_text_field',
	    ) );
		$wp_customize->add_control( 'qt_nav_double_tap', array(
			'label'       			=> esc_html__( 'Enable doubletap touch devices', 'the-landscaper-wp' ),
			'description' 			=> esc_html__( 'When using a touch device the main navigation parent links will open the submenu on the first tab, the second tab will go to the actual page', 'the-landscaper-wp' ),
			'section'  				=> 'qt_section_navigation',
			'settings' 				=> 'qt_nav_double_tap',
			'type'     				=> 'select',
			'choices'  				=> array(
				'yes'					=> esc_html__( 'Yes', 'the-landscaper-wp' ),
				'no' 					=> esc_html__( 'No', 'the-landscaper-wp' ),
			),
		) );

		/** 
		 * Panel: Mobile Navigation
		 */
		$wp_customize->add_setting( 'qt_nav_mobile_bg', array(
			'default' 			=> '#a2c046',
			'transport'			=> 'refresh',
		    'sanitize_callback' => 'sanitize_hex_color',
		) );

		$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'qt_nav_mobile_bg', array(
			'label'         	=> esc_html__( 'Background color', 'the-landscaper-wp' ),
			'description' 		=> esc_html__( 'Change the background color of the parent links', 'the-landscaper-wp' ),
			'section'     		=> 'qt_section_navigation_mobile',
			'settings'    		=> 'qt_nav_mobile_bg',
		) ) );

		$wp_customize->add_setting( 'qt_nav_mobile_textcolor', array(
		    'default'    		=> '#ffffff',
		    'transport'			=> 'refresh',
		    'sanitize_callback' => 'sanitize_hex_color',
		) );

		$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'qt_nav_mobile_textcolor', array(
			'label'      		=> esc_html__( 'Link color', 'the-landscaper-wp' ),
			'description'		=> esc_html__( 'Change the color of the parent links', 'the-landscaper-wp' ),
			'section'     		=> 'qt_section_navigation_mobile',
			'settings'    		=> 'qt_nav_mobile_textcolor',
		) ) );

		$wp_customize->add_setting( 'qt_nav_mobile_submenu_bg', array(
		    'default'    		=> '#9ab643',
		    'transport'			=> 'refresh',
		    'sanitize_callback' => 'sanitize_hex_color',
		) );

		$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'qt_nav_mobile_submenu_bg', array(
			'label'      		=> esc_html__( 'Submenu background color', 'the-landscaper-wp' ),
			'description'		=> esc_html__( 'Change the background color of the submenu links', 'the-landscaper-wp' ),
			'section'     		=> 'qt_section_navigation_mobile',
			'settings'    		=> 'qt_nav_mobile_submenu_bg',
		) ) );

		$wp_customize->add_setting( 'qt_nav_mobile_submenu_textcolor', array(
		    'default'    		=> '#ffffff',
		    'transport'			=> 'refresh',
		    'sanitize_callback' => 'sanitize_hex_color',
		) );

		$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'qt_nav_mobile_submenu_textcolor', array(
			'label'      		=> esc_html__( 'Submenu link color', 'the-landscaper-wp' ),
			'description'		=> esc_html__( 'Change the text color of the submenu links', 'the-landscaper-wp' ),
			'section'     		=> 'qt_section_navigation_mobile',
			'settings'    		=> 'qt_nav_mobile_submenu_textcolor',
		) ) );

		$wp_customize->add_setting( 'qt_mobile_nav_menu_bg', array(
		    'default'    		=> '#a2c046',
		    'transport'			=> 'refresh',
		    'sanitize_callback' => 'sanitize_hex_color',
		) );

		$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'qt_mobile_nav_menu_bg', array(
			'label'      		=> esc_html__( 'Menu toggle background', 'the-landscaper-wp' ),
			'description'		=> esc_html__( 'Change the background color of the mobile navigation toggle button', 'the-landscaper-wp' ),
			'section'     		=> 'qt_section_navigation_mobile',
			'settings'    		=> 'qt_mobile_nav_menu_bg',
		) ) );

		$wp_customize->add_setting( 'qt_mobile_nav_menu_text', array(
		    'default'    		=> '#ffffff',
		    'transport'			=> 'refresh',
		    'sanitize_callback' => 'sanitize_hex_color',
		) );

		$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'qt_mobile_nav_menu_text', array(
			'label'      		=> esc_html__( 'Menu toggle text', 'the-landscaper-wp' ),
			'description'		=> esc_html__( 'Change the text color of the mobile navigation toggle button', 'the-landscaper-wp' ),
			'section'     		=> 'qt_section_navigation_mobile',
			'settings'    		=> 'qt_mobile_nav_menu_text',
		) ) );

		$wp_customize->add_setting( 'qt_mobile_nav_submenu_toggle_bg', array(
		    'default'    		=> 'transparent',
		    'transport'			=> 'refresh',
		    'sanitize_callback' => 'sanitize_hex_color',
		) );

		$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'qt_mobile_nav_submenu_toggle_bg', array(
			'label'      		=> esc_html__( 'Submenu toggle button', 'the-landscaper-wp' ),
			'description'		=> esc_html__( 'Change the background color of the submenu toggle icon', 'the-landscaper-wp' ),
			'section'     		=> 'qt_section_navigation_mobile',
			'settings'    		=> 'qt_mobile_nav_submenu_toggle_bg',
		) ) );

		$wp_customize->add_setting( 'qt_mobile_nav_submenu_toggle_bg_active', array(
		    'default'    		=> '#9ab643',
		    'transport'			=> 'refresh',
		    'sanitize_callback' => 'sanitize_hex_color',
		) );

		$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'qt_mobile_nav_submenu_toggle_bg_active', array(
			'label'      		=> esc_html__( 'Submenu toggle button active', 'the-landscaper-wp' ),
			'description'		=> esc_html__( 'Change the background color of the active submenu toggle', 'the-landscaper-wp' ),
			'section'     		=> 'qt_section_navigation_mobile',
			'settings'    		=> 'qt_mobile_nav_submenu_toggle_bg_active',
		) ) );

		$wp_customize->add_setting( 'qt_mobile_nav_submenu_toggle_icon', array(
		    'default'    		=> '#ffffff',
		    'transport'			=> 'refresh',
		    'sanitize_callback' => 'sanitize_hex_color',
		) );

		$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'qt_mobile_nav_submenu_toggle_icon', array(
			'label'      		=> esc_html__( 'Submenu toggle icon', 'the-landscaper-wp' ),
			'description'		=> esc_html__( 'Change the color of the submenu toggle icon', 'the-landscaper-wp' ),
			'section'     		=> 'qt_section_navigation_mobile',
			'settings'    		=> 'qt_mobile_nav_submenu_toggle_icon',
		) ) );

		/** 
		 * Panel: Slider
		 */
		$wp_customize->add_setting( 'qt_slider_small_heading_color', array(
		    'transport'				=> 'refresh',
		    'sanitize_callback' 	=> 'sanitize_hex_color',
		) );
		$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'qt_slider_small_heading_color', array(
			'label'      			=> esc_html__( 'Top heading color', 'the-landscaper-wp' ),
			'description' 			=> esc_html__( 'Change the color of the small top heading', 'the-landscaper-wp' ),
			'section'     			=> 'qt_section_slider',
			'settings'    			=> 'qt_slider_small_heading_color',
			'priority'    			=> 10,
		) ) );

		$wp_customize->add_setting( 'qt_slider_heading_color', array(
		    'transport'				=> 'refresh',
		    'sanitize_callback' 	=> 'sanitize_hex_color',
		) );
		$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'qt_slider_heading_color', array(
			'label'      			=> esc_html__( 'Heading color', 'the-landscaper-wp' ),
			'description' 			=> esc_html__( 'Change the color of the heading', 'the-landscaper-wp' ),
			'section'     			=> 'qt_section_slider',
			'settings'    			=> 'qt_slider_heading_color',
			'priority'    			=> 15,
		) ) );

		$wp_customize->add_setting( 'qt_slider_content_color', array(
		    'transport'				=> 'refresh',
		    'sanitize_callback' 	=> 'sanitize_hex_color',
		) );
		$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'qt_slider_content_color', array(
			'label'      			=> esc_html__( 'Content color', 'the-landscaper-wp' ),
			'description' 			=> esc_html__( 'Change the color of the content texts', 'the-landscaper-wp' ),
			'section'     			=> 'qt_section_slider',
			'settings'    			=> 'qt_slider_content_color',
			'priority'    			=> 20,
		) ) );

		$wp_customize->add_setting( 'qt_slider_primary_button_background_color', array(
		    'transport'				=> 'refresh',
		    'sanitize_callback' 	=> 'sanitize_hex_color',
		) );
		$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'qt_slider_primary_button_background_color', array(
			'label'      			=> esc_html__( 'Primary button background color', 'the-landscaper-wp' ),
			'description' 			=> esc_html__( 'Change the background color of the primary button', 'the-landscaper-wp' ),
			'section'     			=> 'qt_section_slider',
			'settings'    			=> 'qt_slider_primary_button_background_color',
			'priority'    			=> 25,
		) ) );

		$wp_customize->add_setting( 'qt_slider_primary_button_color', array(
		    'transport'				=> 'refresh',
		    'sanitize_callback' 	=> 'sanitize_hex_color',
		) );
		$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'qt_slider_primary_button_color', array(
			'label'      			=> esc_html__( 'Primary button text color', 'the-landscaper-wp' ),
			'description' 			=> esc_html__( 'Change the text color of the primary button', 'the-landscaper-wp' ),
			'section'     			=> 'qt_section_slider',
			'settings'    			=> 'qt_slider_primary_button_color',
			'priority'    			=> 30,
		) ) );

		$wp_customize->add_setting( 'qt_slider_control_background_color', array(
		    'transport'				=> 'refresh',
		    'sanitize_callback' 	=> 'sanitize_hex_color',
		) );
		$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'qt_slider_control_background_color', array(
			'label'      			=> esc_html__( 'Controls background color', 'the-landscaper-wp' ),
			'description' 			=> esc_html__( 'Change the background color of the slider controls', 'the-landscaper-wp' ),
			'section'     			=> 'qt_section_slider',
			'settings'    			=> 'qt_slider_control_background_color',
			'priority'    			=> 35,
		) ) );

		$wp_customize->add_setting( 'qt_slider_control_color', array(
		    'transport'				=> 'refresh',
		    'sanitize_callback' 	=> 'sanitize_hex_color',
		) );
		$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'qt_slider_control_color', array(
			'label'      			=> esc_html__( 'Control arrow color', 'the-landscaper-wp' ),
			'description' 			=> esc_html__( 'Change the color of the slider controls icon', 'the-landscaper-wp' ),
			'section'     			=> 'qt_section_slider',
			'settings'    			=> 'qt_slider_control_color',
			'priority'    			=> 40,
		) ) );

		$wp_customize->add_setting( 'qt_slider_mobile_background_color', array(
		    'transport'				=> 'refresh',
		    'sanitize_callback' 	=> 'sanitize_hex_color',
		) );
		$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'qt_slider_mobile_background_color', array(
			'label'      			=> esc_html__( '(Mobile) Background color', 'the-landscaper-wp' ),
			'description' 			=> esc_html__( 'Change the background color of the slider captions on mobile', 'the-landscaper-wp' ),
			'section'     			=> 'qt_section_slider',
			'settings'    			=> 'qt_slider_mobile_background_color',
			'priority'    			=> 45,
		) ) );

		/** 
		 * Panel: Page Header
		 */
		$wp_customize->add_setting( 'qt_maintitle_layout', array(
        	'default'  			=> 'small',
        	'transport'			=> 'refresh',
        	'sanitize_callback' => 'sanitize_text_field',
	    ) );
		$wp_customize->add_control( 'qt_maintitle_layout', array(
			'label'    			=> esc_html__( 'Page header', 'the-landscaper-wp' ),
			'description' 		=> esc_html__( 'Show or hide the page header on all pages', 'the-landscaper-wp' ),
			'section'  			=> 'qt_section_main_title',
			'settings' 			=> 'qt_maintitle_layout',
			'type'    			=> 'select',
			'choices'  			=> array(
				'small'  		=> esc_html__( 'Small Height', 'the-landscaper-wp'),
				'large' 		=> esc_html__( 'Large Height', 'the-landscaper-wp'),
				'hide' 			=> esc_html__( 'Hide', 'the-landscaper-wp'),
			),
		) );

		$wp_customize->add_setting( 'qt_maintitle_align', array(
        	'default'  			=> 'left',
        	'transport'			=> 'refresh',
        	'sanitize_callback' => 'sanitize_text_field',
	    ) );
		$wp_customize->add_control( 'qt_maintitle_align', array(
			'label'    			=> esc_html__( 'Alignment', 'the-landscaper-wp' ),
			'description' 		=> esc_html__( 'Change the alignment of the page header titles', 'the-landscaper-wp' ),
			'section'  			=> 'qt_section_main_title',
			'settings' 			=> 'qt_maintitle_align',
			'type'    			=> 'select',
			'choices'  			=> array(
				'left'  		=> esc_html__( 'Left', 'the-landscaper-wp'),
				'center' 		=> esc_html__( 'Center', 'the-landscaper-wp'),
				'right' 	    => esc_html__( 'Right', 'the-landscaper-wp'),
			),
		) );

		$wp_customize->add_setting( 'qt_maintitle_color', array(
	    	'default'     		=> '#333333',
	    	'transport'			=> 'refresh',
	    	'sanitize_callback' => 'sanitize_hex_color',
		) );
		$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'qt_maintitle_color', array(
			'label'      		=> esc_html__( 'Page title color', 'the-landscaper-wp' ),
			'description' 		=> esc_html__( 'Change the color of the page title', 'the-landscaper-wp' ),
			'section'    		=> 'qt_section_main_title',
			'settings'   		=> 'qt_maintitle_color',
		) ) );

		$wp_customize->add_setting( 'qt_subtitle_color', array(
	    	'default'     		=> '#999999',
	    	'transport'			=> 'refresh',
	    	'sanitize_callback' => 'sanitize_hex_color',
		) );
		$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'qt_subtitle_color', array(
			'label'      		=> esc_html__( 'Subtitle color', 'the-landscaper-wp' ),
			'description' 		=> esc_html__( 'Change the color of the subtitle', 'the-landscaper-wp' ),
			'section'    		=> 'qt_section_main_title',
			'settings'   		=> 'qt_subtitle_color',
		) ) );

		$wp_customize->add_setting( 'qt_maintitle_bgcolor', array(
	    	'default'     		=> '#f2f2f2',
	    	'transport'			=> 'refresh',
	    	'sanitize_callback' => 'sanitize_hex_color',
		) );
		$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'qt_maintitle_bgcolor', array(
			'label'      		=> esc_html__( 'Background color', 'the-landscaper-wp' ),
			'description' 		=> esc_html__( 'Change the background color of the page header', 'the-landscaper-wp' ),
			'section'    		=> 'qt_section_main_title',
			'settings'   		=> 'qt_maintitle_bgcolor',
		) ) );

		$wp_customize->add_setting( 'qt_maintitle_bgimage', array(
			'default' 	 		=> get_theme_file_uri( '/assets/images/leafs.png' ),
			'transport'			=> 'refresh',
			'sanitize_callback' => 'esc_url_raw',
		) );
		$wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'qt_maintitle_bgimage', array(
            'label' 	 		=> esc_html__( 'Background pattern', 'the-landscaper-wp' ),
            'description' 		=> esc_html__( 'Add a background image to the page header', 'the-landscaper-wp' ),
            'section' 	 		=> 'qt_section_main_title',
            'settings' 	 		=> 'qt_maintitle_bgimage',
		) ) );

		$wp_customize->add_setting( 'qt_maintitle_bg_position', array(
			'default'  				=> 'left center',
			'transport'				=> 'refresh',
			'sanitize_callback' 	=> 'sanitize_text_field',
		) );

		$wp_customize->add_control( 'qt_maintitle_bg_position', array(
			'label'       			=> esc_html__( 'Background position', 'the-landscaper-wp' ),
			'section'				=> 'qt_section_main_title',
			'settings'				=> 'qt_maintitle_bg_position',
			'type'					=> 'select',
			'choices'				=> array(
				'left top' 				=> esc_html__( 'Left Top', 'the-landscaper-wp' ),
				'left center' 			=> esc_html__( 'Left Center', 'the-landscaper-wp' ),
				'left bottom' 			=> esc_html__( 'Left Bottom', 'the-landscaper-wp' ),
				'right top' 			=> esc_html__( 'Right Top', 'the-landscaper-wp' ),
				'right center' 			=> esc_html__( 'Right Center', 'the-landscaper-wp' ),
				'right bottom' 			=> esc_html__( 'Right Bottom', 'the-landscaper-wp' ),
				'center top' 			=> esc_html__( 'Center Top', 'the-landscaper-wp' ),
				'center center' 		=> esc_html__( 'Center Center', 'the-landscaper-wp' ),
				'center bottom' 		=> esc_html__( 'Center Bottom', 'the-landscaper-wp' ),
			),
		) );

		// Add page header setting: page header background image repeat
		$wp_customize->add_setting( 'qt_maintitle_bg_repeat', array(
			'default'  				=> 'repeat',
			'transport'				=> 'refresh',
			'sanitize_callback' 	=> 'sanitize_text_field',
		) );

		$wp_customize->add_control( 'qt_maintitle_bg_repeat', array(
			'label'      		 	=> esc_html__( 'Background repeat', 'the-landscaper-wp' ),
			'section'				=> 'qt_section_main_title',
			'settings'				=> 'qt_maintitle_bg_repeat',
			'type'					=> 'select',
			'choices'				=> array(
				'no-repeat'  			=> esc_html__( 'No repeat', 'the-landscaper-wp' ),
				'repeat' 	 			=> esc_html__( 'Repeat', 'the-landscaper-wp' ),
			),
		) );

		// Add page header setting: page header background image size
		$wp_customize->add_setting( 'qt_maintitle_bg_size', array(
			'default'  				=> 'auto',
			'transport'				=> 'refresh',
			'sanitize_callback' 	=> 'sanitize_text_field',
		) );

		$wp_customize->add_control( 'qt_maintitle_bg_size', array(
			'label'       			=> esc_html__( 'Background size', 'the-landscaper-wp' ),
			'section'				=> 'qt_section_main_title',
			'settings'				=> 'qt_maintitle_bg_size',
			'type'					=> 'select',
			'choices'				=> array(
				'auto' 					=> esc_html__( 'Default', 'the-landscaper-wp' ),
				'cover' 				=> esc_html__( 'Cover', 'the-landscaper-wp' ),
			),
		) );


		/** 
		 * Panel: Breadcrumbs
		 */
		$wp_customize->add_setting( 'qt_breadcrumbs', array(
        	'default'  			=> 'show',
        	'transport'			=> 'refresh',
        	'sanitize_callback' => 'sanitize_text_field',
	    ) );
		$wp_customize->add_control( 'qt_breadcrumbs', array(
			'label'    			=> esc_html__( 'Breadcrumbs', 'the-landscaper-wp' ),
			'description' 		=> esc_html__( 'Show or hide the breadcrumbs on all pages', 'the-landscaper-wp' ),
			'section'  			=> 'qt_section_breadcrumbs',
			'settings' 			=> 'qt_breadcrumbs',
			'type'    			=> 'select',
			'choices'  			=> array(
				'show'  		=> esc_html__( 'Show', 'the-landscaper-wp' ),
				'hide' 			=> esc_html__( 'Hide', 'the-landscaper-wp' ),
			),
		) );

		$wp_customize->add_setting( 'qt_breadcrumbs_align', array(
        	'default'  			=> 'left',
        	'transport'			=> 'refresh',
        	'sanitize_callback' => 'sanitize_text_field',
	    ) );
		$wp_customize->add_control( 'qt_breadcrumbs_align', array(
			'label'    			=> esc_html__( 'Alignment', 'the-landscaper-wp' ),
			'description' 		=> esc_html__( 'Change the alignment of the breadcrumbs', 'the-landscaper-wp' ),
			'section'  			=> 'qt_section_breadcrumbs',
			'settings' 			=> 'qt_breadcrumbs_align',
			'type'    			=> 'select',
			'choices'  			=> array(
				'left'  		=> esc_html__( 'Left', 'the-landscaper-wp' ),
				'center' 		=> esc_html__( 'Center', 'the-landscaper-wp' ),
				'right' 	    => esc_html__( 'Right', 'the-landscaper-wp' ),
			),
		) );

		$wp_customize->add_setting( 'qt_breadcrumbs_textcolor', array(
		    'default'    		=> '#999999',
		    'transport'	  		=> 'refresh',
		    'sanitize_callback' => 'sanitize_hex_color',
		) );
		$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'qt_breadcrumbs_textcolor', array(
			'label'      		=> esc_html__( 'Text color', 'the-landscaper-wp' ),
			'description' 		=> esc_html__( 'Change the color of the breadcrumb links', 'the-landscaper-wp' ),
			'section'    		=> 'qt_section_breadcrumbs',
			'settings'   		=> 'qt_breadcrumbs_textcolor',
		) ) );

		$wp_customize->add_setting( 'qt_breadcrumbs_activecolor', array(
		    'default'    		=> '#a2c046',
		    'transport'	  		=> 'refresh',
		    'sanitize_callback' => 'sanitize_hex_color',
		) );
		$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'qt_breadcrumbs_activecolor', array(
				'label'      	=> esc_html__( 'Active color', 'the-landscaper-wp' ),
				'description' 	=> esc_html__( 'Change the color of the active breadcrumb link', 'the-landscaper-wp' ),
				'section'    	=> 'qt_section_breadcrumbs',
				'settings'   	=> 'qt_breadcrumbs_activecolor',
			)
		) );

		$wp_customize->add_setting( 'qt_breadcrumbs_bg_color', array(
			'default' 			=> '#ffffff',
		    'transport'	  		=> 'refresh',
		    'sanitize_callback' => 'sanitize_hex_color',
		) );
		$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'qt_breadcrumbs_bg_color', array(
			'label'      		=> esc_html__( 'Background color', 'the-landscaper-wp' ),
			'description' 		=> esc_html__( 'Change the background color of the breadcrumbs', 'the-landscaper-wp' ),
			'section'    		=> 'qt_section_breadcrumbs',
			'settings'   		=> 'qt_breadcrumbs_bg_color',
		) ) );


		/** 
		 * Panel: Layout & Colors
		 */
		$wp_customize->add_setting( 'qt_boxed_bg', array(
			'default' 			=> '#ffffff',
			'transport'			=> 'refresh',
			'sanitize_callback' => 'sanitize_hex_color',
		) );
		$wp_customize->add_control( new WP_Customize_Color_Control( 
			$wp_customize, 'qt_boxed_bg', array(
				'label'       	=> esc_html__( 'Background color', 'the-landscaper-wp' ),
				'description'	=> esc_html__( 'Change the background color of the content area', 'the-landscaper-wp' ),
				'section'     	=> 'qt_section_theme_colors',
				'settings'	  	=> 'qt_boxed_bg',
			)
		) );

		$wp_customize->add_setting( 'qt_theme_textcolor', array(
		    'default'     		=> '#a5a5a5',
		    'transport'	  		=> 'refresh',
		    'sanitize_callback' => 'sanitize_hex_color',
		) );
		$wp_customize->add_control( new WP_Customize_Color_Control( 
			$wp_customize, 'qt_theme_textcolor', array(
				'label'       	=> esc_html__( 'Text color', 'the-landscaper-wp' ),
				'description'	=> esc_html__( 'Change the color of the content texts', 'the-landscaper-wp' ),
				'section'     	=> 'qt_section_theme_colors',
				'settings'    	=> 'qt_theme_textcolor',
			)
		) );

		$wp_customize->add_setting( 'qt_theme_primary_color', array(
	    	'default'     		=> '#a2c046',
	    	'transport'			=> 'refresh',
	    	'sanitize_callback' => 'sanitize_hex_color',
		) );
		$wp_customize->add_control( new WP_Customize_Color_Control( 
			$wp_customize, 'qt_theme_primary_color', array(
				'label'       	=> esc_html__( 'Primary color', 'the-landscaper-wp' ),
				'description'	=> esc_html__( 'Change the primary color scheme', 'the-landscaper-wp' ),
				'section'     	=> 'qt_section_theme_colors',
				'settings'    	=> 'qt_theme_primary_color',
			)
		) );

		$wp_customize->add_setting( 'qt_theme_primary_btncolor', array(
	     	'default'     		=> '#a2c046',
	     	'transport'			=> 'refresh',
		    'sanitize_callback' => 'sanitize_hex_color',
		) );
		$wp_customize->add_control( new WP_Customize_Color_Control( 
			$wp_customize, 'qt_theme_primary_btncolor', array(
				'label'       	=> esc_html__( 'Button background color', 'the-landscaper-wp' ),
				'description'	=> esc_html__( 'Change the background color of the button', 'the-landscaper-wp' ),
				'section'     	=> 'qt_section_theme_colors',
				'settings'    	=> 'qt_theme_primary_btncolor',
			)
		) );

		$wp_customize->add_setting( 'qt_theme_primary_btncolor_hover', array(
	     	'default'     		=> '#98b63c',
	     	'transport'			=> 'refresh',
		    'sanitize_callback' => 'sanitize_hex_color',
		) );
		$wp_customize->add_control( new WP_Customize_Color_Control( 
			$wp_customize, 'qt_theme_primary_btncolor_hover', array(
				'label'       	=> esc_html__( 'Button hover background color', 'the-landscaper-wp' ),
				'description'	=> esc_html__( 'Change the hover background color of the button', 'the-landscaper-wp' ),
				'section'     	=> 'qt_section_theme_colors',
				'settings'    	=> 'qt_theme_primary_btncolor_hover',
			)
		) );

		$wp_customize->add_setting( 'qt_theme_primary_btntext', array(
	     	'default'     		=> '#ffffff',
	     	'transport'			=> 'refresh',
		    'sanitize_callback' => 'sanitize_hex_color',
		) );
		$wp_customize->add_control( new WP_Customize_Color_Control( 
			$wp_customize, 'qt_theme_primary_btntext', array(
				'label'       	=> esc_html__( 'Button text color', 'the-landscaper-wp' ),
				'description'	=> esc_html__( 'Change the text color of the button', 'the-landscaper-wp' ),
				'section'     	=> 'qt_section_theme_colors',
				'settings'    	=> 'qt_theme_primary_btntext',
			)
		) );

		$wp_customize->add_setting( 'qt_theme_widgettitle', array(
	     	'default'     		=> '#9fc612',
	     	'transport'			=> 'refresh',
		    'sanitize_callback' => 'sanitize_hex_color',
		) );
		$wp_customize->add_control( new WP_Customize_Color_Control( 
			$wp_customize, 'qt_theme_widgettitle', array(
				'label'       	=> esc_html__( 'Widget title color', 'the-landscaper-wp' ),
				'description'	=> esc_html__( 'Change the color of the widget titles', 'the-landscaper-wp' ),
				'section'     	=> 'qt_section_theme_colors',
				'settings'    	=> 'qt_theme_widgettitle',
			)
		) );

		$wp_customize->add_setting( 'qt_theme_widgettitle_span', array(
	     	'default'     		=> '#464646',
	     	'transport'			=> 'refresh',
		    'sanitize_callback' => 'sanitize_hex_color',
		) );
		$wp_customize->add_control( new WP_Customize_Color_Control( 
			$wp_customize, 'qt_theme_widgettitle_span', array(
				'label'       	=> esc_html__( 'First word in widget title', 'the-landscaper-wp' ),
				'description'	=> esc_html__( 'Change the color of the first word in widget titles', 'the-landscaper-wp' ),
				'section'     	=> 'qt_section_theme_colors',
				'settings'    	=> 'qt_theme_widgettitle_span',
			)
		) );

		// Add colors section setting: button layout
		$wp_customize->add_setting( 'qt_button_layout', array(
			'default'  				=> '',
			'transport'				=> 'refresh',
			'sanitize_callback' 	=> 'sanitize_text_field',
		) );

		$wp_customize->add_control( 'qt_button_layout', array(
			'label'       			=> esc_html__( 'Button layout', 'the-landscaper-wp' ),
			'description' 			=> esc_html__( 'Change the layout of the button', 'the-landscaper-wp' ),
			'section'				=> 'qt_section_theme_colors',
			'settings'				=> 'qt_button_layout',
			'type'					=> 'select',
			'choices' 				=> array(
				'' 						=> esc_html__( 'Sqaure (default)', 'the-landscaper-wp' ),
				'btn-rounded' 			=> esc_html__( 'Rounded', 'the-landscaper-wp' ),
			),
		) );

		$wp_customize->add_setting( 'qt_theme_layout', array(
        	'default'  			=> 'wide',
        	'transport'			=> 'refresh',
        	'sanitize_callback' => 'sanitize_text_field',
	    ) );
		$wp_customize->add_control( 'qt_theme_layout', array(
			'label'    			=> esc_html__( 'Boxed layout', 'the-landscaper-wp' ),
			'description'		=> esc_html__( 'Enable the boxed layout', 'the-landscaper-wp' ),
			'section'  			=> 'qt_section_theme_colors',
			'settings' 			=> 'qt_theme_layout',
			'type'    			=> 'select',
			'choices'  			=> array(
				'wide'  		=> esc_html__( 'Disable', 'the-landscaper-wp' ),
				'boxed' 		=> esc_html__( 'Enable', 'the-landscaper-wp' ),
			)
		) );

		$wp_customize->add_setting( 'qt_theme_widgettitle_border', array(
        	'default'  			=> 'dashed',
        	'transport'			=> 'refresh',
        	'sanitize_callback' => 'sanitize_text_field',
	    ) );
		$wp_customize->add_control( 'qt_theme_widgettitle_border', array(
			'label'    			=> esc_html__( 'Theme border style', 'the-landscaper-wp' ),
			'description'		=> esc_html__( 'Change the border style of the widget titles', 'the-landscaper-wp' ),
			'section'  			=> 'qt_section_theme_colors',
			'settings' 			=> 'qt_theme_widgettitle_border',
			'type'    			=> 'select',
			'choices' 			=> array(
				'solid' 		=> esc_html__( 'Solid', 'the-landscaper-wp' ),
				'dashed' 	 	=> esc_html__( 'Dashed', 'the-landscaper-wp' ),
				'dotted'		=> esc_html__( 'Dotted', 'the-landscaper-wp' ),
			)
		) );

		$wp_customize->add_setting( 'qt_scroll_to_top_button', array(
	    	'default'  				=> 'show',
	    	'transport'				=> 'refresh',
	    	'sanitize_callback' 	=> 'sanitize_text_field',
		) );
		$wp_customize->add_control( 'qt_scroll_to_top_button', array(
			'label'    				=> esc_html__( 'Scroll to top button', 'the-landscaper-wp' ),
			'description'			=> esc_html__( 'Enable the scroll to top button', 'the-landscaper-wp' ),
			'section'  				=> 'qt_section_theme_colors',
			'settings' 				=> 'qt_scroll_to_top_button',
			'type'     				=> 'select',
			'choices'  				=> array(
				'show'  			=> esc_html__( 'Show', 'the-landscaper-wp' ),
				'hide' 				=> esc_html__( 'Hide', 'the-landscaper-wp' ),
			),
		) );

		if ( class_exists( 'Essential_Grid' ) ) {
			$wp_customize->add_setting( 'qt_default_esg_style', array(
		    	'default'  				=> 'enable',
		    	'transport'				=> 'refresh',
		    	'sanitize_callback' 	=> 'sanitize_text_field',
			) );
			$wp_customize->add_control( 'qt_default_esg_style', array(
				'label'    				=> esc_html__( 'Essential Grid color', 'the-landscaper-wp' ),
				'description'			=> esc_html__( 'Change the \'The Landscaper\' essential grid skin based on theme primary color setting', 'the-landscaper-wp' ),
				'section'  				=> 'qt_section_theme_colors',
				'settings' 				=> 'qt_default_esg_style',
				'type'     				=> 'select',
				'choices'  				=> array(
					'enable' 			=> esc_html__( 'Enable', 'the-landscaper-wp' ),
					'disable'  			=> esc_html__( 'Disable', 'the-landscaper-wp' ),
				),
			) );
		}

		/** 
		 * Panel: Blog
		 */
		$wp_customize->add_setting( 'qt_blog_metadata', array(
        	'default'  			=> 'show',
        	'transport'			=> 'refresh',
        	'sanitize_callback' => 'sanitize_text_field',
	    ) );
		$wp_customize->add_control( 'qt_blog_metadata', array(
			'label'    			=> esc_html__( 'Display post metadata', 'the-landscaper-wp' ),
			'description' 		=> esc_html__( 'Show or hide the blog post metadata', 'the-landscaper-wp' ),
			'section'  			=> 'qt_section_blog',
			'settings' 			=> 'qt_blog_metadata',
			'type'    			=> 'select',
			'choices' 			=> array(
				'show' 			=> esc_html__( 'Show', 'the-landscaper-wp'),
				'hide'  		=> esc_html__( 'Hide', 'the-landscaper-wp'),
			),
		) );
		
		$wp_customize->add_setting( 'qt_blog_bigdate', array(
        	'default'  			=> 'show',
        	'transport'			=> 'refresh',
        	'sanitize_callback' => 'sanitize_text_field',
	    ) );
		$wp_customize->add_control( 'qt_blog_bigdate', array(
			'label'    			=> esc_html__( 'Show large date', 'the-landscaper-wp' ),
			'description' 		=> esc_html__( 'Left of the posts on blog list layout', 'the-landscaper-wp' ),
			'section'  			=> 'qt_section_blog',
			'settings' 			=> 'qt_blog_bigdate',
			'type'    			=> 'select',
			'choices' 			=> array(
				'show' 			=> esc_html__( 'Show', 'the-landscaper-wp'),
				'hide'  		=> esc_html__( 'Hide', 'the-landscaper-wp'),
			),
		) );

		$wp_customize->add_setting( 'qt_blog_commments', array(
        	'default'  			=> 'show',
        	'transport'			=> 'refresh',
        	'sanitize_callback' => 'sanitize_text_field',
	    ) );
		$wp_customize->add_control( 'qt_blog_commments', array(
			'label'    			=> esc_html__( 'Display comment section', 'the-landscaper-wp' ),
			'description' 		=> esc_html__( 'Show or hide the comment section on all blog posts', 'the-landscaper-wp' ),
			'section'  			=> 'qt_section_blog',
			'settings' 			=> 'qt_blog_commments',
			'type'    			=> 'select',
			'choices' 			=> array(
				'show' 			=> esc_html__( 'Show', 'the-landscaper-wp'),
				'hide'  		=> esc_html__( 'Hide', 'the-landscaper-wp'),
			),
		) );

		$wp_customize->add_setting( 'qt_blog_read_more', array(
	    	'transport'			=> 'refresh',
	    	'sanitize_callback' => 'wp_kses_post',
		) );
		$wp_customize->add_control( 'qt_blog_read_more', array(
	    	'label' 			=> esc_html__( 'Read more text', 'the-landscaper-wp' ),
	    	'description' 		=> esc_html__( 'Change the read more link text', 'the-landscaper-wp' ),
	    	'section' 			=> 'qt_section_blog',
	    	'settings' 			=> 'qt_blog_read_more',
	    	'type' 				=> 'text',
		) );

		$wp_customize->add_setting( 'qt_blog_custom_excerpt_length', array(
	    	'transport'			=> 'refresh',
	    	'sanitize_callback' => 'wp_kses_post',
		) );
		$wp_customize->add_control( 'qt_blog_custom_excerpt_length', array(
	    	'label' 			=> esc_html__( 'Custom excerpt length', 'the-landscaper-wp' ),
	    	'description' 		=> esc_html__( 'Change the excerpt length for the blog page posts (e.g. 80)', 'the-landscaper-wp' ),
	    	'section' 			=> 'qt_section_blog',
	    	'settings' 			=> 'qt_blog_custom_excerpt_length',
	    	'type' 				=> 'text',
		) );

		$wp_customize->add_setting( 'qt_blog_share', array(
        	'default'  			=> 'blog',
        	'transport'			=> 'refresh',
        	'sanitize_callback' => 'sanitize_text_field',
	    ) );
		$wp_customize->add_control( 'qt_blog_share', array(
			'label'    			=> esc_html__( 'Share buttons', 'the-landscaper-wp' ),
			'description' 		=> esc_html__( 'Add share buttons at the bottom of the single post or page', 'the-landscaper-wp' ),
			'section'  			=> 'qt_section_blog',
			'settings' 			=> 'qt_blog_share',
			'type'    			=> 'select',
			'choices' 			=> array(
				'show' 			=> esc_html__( 'All pages &amp; posts', 'the-landscaper-wp'),
				'blog' 			=> esc_html__( 'Only on blog posts', 'the-landscaper-wp'),
				'pages' 		=> esc_html__( 'Only on pages', 'the-landscaper-wp'),
				'galleries' 	=> esc_html__( 'Only on single gallery pages', 'the-landscaper-wp'),
				'hide'  		=> esc_html__( 'Hide', 'the-landscaper-wp'),
			),
		) );

		$wp_customize->add_setting( 'qt_blog_tooltip', array(
			'default'			=> 'Share',
	    	'transport'			=> 'refresh',
	    	'sanitize_callback' => 'wp_kses_post',
		) );
		$wp_customize->add_control( 'qt_blog_tooltip', array(
		    'label' 			=> esc_html__( 'Tooltip text', 'the-landscaper-wp' ),
		    'section' 			=> 'qt_section_blog',
		    'settings' 			=> 'qt_blog_tooltip',
		    'type' 				=> 'text',
		    'active_callback'   => array( $this, 'thelandscaper_hide_social_input_fields' ),
		) );

		$wp_customize->add_setting( 'qt_blog_twitter', array(
			'default'			=> 'Twitter',
	    	'transport'			=> 'refresh',
	    	'sanitize_callback' => 'wp_kses_post',
		) );
		$wp_customize->add_control( 'qt_blog_twitter', array(
		    'label' 			=> esc_html__( 'Twitter text', 'the-landscaper-wp' ),
		    'section' 			=> 'qt_section_blog',
		    'settings' 			=> 'qt_blog_twitter',
		    'type' 				=> 'text',
		    'active_callback'   => array( $this, 'thelandscaper_hide_social_input_fields' ),
		) );

		$wp_customize->add_setting( 'qt_blog_facebook', array(
			'default'			=> 'Facebook',
	    	'transport'			=> 'refresh',
	    	'sanitize_callback' => 'wp_kses_post',
		) );
		$wp_customize->add_control( 'qt_blog_facebook', array(
		    'label' 			=> esc_html__( 'Facebook text', 'the-landscaper-wp' ),
		    'section' 			=> 'qt_section_blog',
		    'settings' 			=> 'qt_blog_facebook',
		    'type' 				=> 'text',
		    'active_callback'   => array( $this, 'thelandscaper_hide_social_input_fields' ),
		) );

		$wp_customize->add_setting( 'qt_blog_linkedin', array(
			'default'			=> 'LinkedIn',
	    	'transport'			=> 'refresh',
	    	'sanitize_callback' => 'wp_kses_post',
		) );
		$wp_customize->add_control( 'qt_blog_linkedin', array(
		    'label' 			=> esc_html__( 'LinkedIn Text', 'the-landscaper-wp' ),
		    'section' 			=> 'qt_section_blog',
		    'settings' 			=> 'qt_blog_linkedin',
		    'type' 				=> 'text',
		    'active_callback'   => array( $this, 'thelandscaper_hide_social_input_fields' ),
		) );

		/** 
		 * Panel: Gallery
		 */
		$wp_customize->add_setting( 'qt_gallery_title', array(
        	'default'  			=> 'actual_title',
        	'transport'			=> 'refresh',
        	'sanitize_callback' => 'sanitize_text_field',
	    ) );
		$wp_customize->add_control( 'qt_gallery_title', array(
			'label'    			=> esc_html__( 'Position of the page title', 'the-landscaper-wp' ),
			'section'  			=> 'qt_section_gallery',
			'settings' 			=> 'qt_gallery_title',
			'type'    			=> 'select',
			'choices' 			=> array(
				'actual_title' 	=> esc_html__( 'Show Actual Item Title', 'the-landscaper-wp' ),
				'custom_title'  => esc_html__( 'Show Custom Title', 'the-landscaper-wp' ),
			),
			'priority' 			=> 1,
		) );

		$wp_customize->add_setting( 'qt_gallery_maintitle', array(
	    	'default' 			=> 'Gallery',
	    	'transport'			=> 'refresh',
	    	'sanitize_callback' => 'wp_kses_post',
		) );
		$wp_customize->add_control( 'qt_gallery_maintitle', array(
		    'label' 			=> esc_html__( 'Gallery page title', 'the-landscaper-wp' ),
		    'description' 		=> esc_html__( 'Display if above option isset to custom title', 'the-landscaper-wp' ),
		    'section' 			=> 'qt_section_gallery',
		    'settings' 			=> 'qt_gallery_maintitle',
		    'priority' 			=> 5,
		) );

		$wp_customize->add_setting( 'qt_gallery_subtitle', array(
	    	'default' 			=> 'A selection of our best work',
	    	'transport'			=> 'refresh',
	    	'sanitize_callback' => 'wp_kses_post',
		) );
		$wp_customize->add_control( 'qt_gallery_subtitle', array(
		    'label' 			=> esc_html__( 'Gallery subtitle', 'the-landscaper-wp' ),
		    'description' 		=> esc_html__( 'Display if subtitle field on specific post is empty', 'the-landscaper-wp' ),
		    'section' 			=> 'qt_section_gallery',
		    'settings' 			=> 'qt_gallery_subtitle',
		    'priority' 			=> 10,
		) );

		$wp_customize->add_setting( 'qt_gallery_nav', array(
        	'default'  			=> 'show',
        	'transport'			=> 'refresh',
        	'sanitize_callback' => 'sanitize_text_field',
	    ) );
		$wp_customize->add_control( 'qt_gallery_nav', array(
			'label'    			=> esc_html__( 'Display gallery navigation', 'the-landscaper-wp' ),
			'description' 		=> esc_html__( 'Display the project navigation at the bottom of the page', 'the-landscaper-wp' ),
			'section'  			=> 'qt_section_gallery',
			'settings' 			=> 'qt_gallery_nav',
			'type'    			=> 'select',
			'choices' 			=> array(
				'show' 	=> esc_html__( 'Show', 'the-landscaper-wp'),
				'hide'  => esc_html__( 'Hide', 'the-landscaper-wp'),
			),
			'priority' 			=> 15,
		) );

		$wp_customize->add_setting( 'qt_gallery_prevtext', array(
	    	'default' 			=> 'Previous',
	    	'transport'			=> 'refresh',
	    	'sanitize_callback' => 'wp_kses_post',
		) );
		$wp_customize->add_control( 'qt_gallery_prevtext', array(
		    'label' 			=> esc_html__( 'Previous button text', 'the-landscaper-wp'),
		    'description' 		=> esc_html__( 'Text for the previous post link at the bottom of the page', 'the-landscaper-wp' ),
		    'section' 			=> 'qt_section_gallery',
		    'settings' 			=> 'qt_gallery_prevtext',
		    'active_callback'	=> array( $this, 'thelandscaper_show_setting_gallery_nav' ),
		    'priority' 			=> 20,
		) );

		$wp_customize->add_setting( 'qt_gallery_nexttext', array(
	    	'default' 			=> 'Next',
	    	'transport'			=> 'refresh',
	    	'sanitize_callback' => 'wp_kses_post',
		) );
		$wp_customize->add_control( 'qt_gallery_nexttext', array(
		    'label' 			=> esc_html__( 'Next button text', 'the-landscaper-wp'),
		    'description' 		=> esc_html__( 'Text for the next post link at the bottom of the page', 'the-landscaper-wp' ),
		    'section' 			=> 'qt_section_gallery',
		    'settings' 			=> 'qt_gallery_nexttext',
		    'active_callback'	=> array( $this, 'thelandscaper_show_setting_gallery_nav' ),
		    'priority' 			=> 25,
		) );

		$wp_customize->add_setting( 'qt_gallery_summarylink', array(
	    	'transport'			=> 'refresh',
	    	'sanitize_callback' => 'esc_url_raw',
		) );
		$wp_customize->add_control( 'qt_gallery_summarylink', array(
		    'label'				=> esc_html__( 'Gallery summary link', 'the-landscaper-wp' ),
		    'description' 		=> esc_html__( 'Single project navigation summary button text', 'the-landscaper-wp' ),
		    'section' 			=> 'qt_section_gallery',
		    'settings' 			=> 'qt_gallery_summarylink',
		    'active_callback'	=> array( $this, 'thelandscaper_show_setting_gallery_nav' ),
		    'priority' 			=> 30,
		) );

		$wp_customize->add_setting( 'qt_gallery_summarytext', array(
			'default'			=> 'View Summary',
			'transport'			=> 'refresh',
			'sanitize_callback' => 'wp_kses_post',
		) );
		$wp_customize->add_control( 'qt_gallery_summarytext', array(
			'label'				=> esc_html__( 'Gallery summary text', 'the-landscaper-wp' ),
			'section'			=> 'qt_section_gallery',
			'settings'			=> 'qt_gallery_summarytext',
			'active_callback'	=> array( $this, 'thelandscaper_show_setting_gallery_nav' ),
			'priority'			=> 35,
		) );

		$wp_customize->add_setting( 'qt_gallery_slug', array(
	    	'default' 			=> 'gallery',
	    	'transport'			=> 'refresh',
	    	'sanitize_callback' => 'thelandscaper_sanitize_gallery_slug',
		) );
		$wp_customize->add_control( 'qt_gallery_slug', array(
		    'label' 			=> esc_html__( 'Gallery URL slug', 'the-landscaper-wp' ),
		    'description'		=> esc_html__( 'After changing this setting please go to Settings > Permalinks and save the page', 'the-landscaper-wp' ),
		    'section' 			=> 'qt_section_gallery',
		    'settings' 			=> 'qt_gallery_slug',
		    'priority' 			=> 40,
		) );

		$wp_customize->add_setting( 'qt_gallery_cat_slug', array(
	    	'default' 			=> '',
	    	'transport'			=> 'refresh',
	    	'sanitize_callback' => 'thelandscaper_sanitize_gallery_slug',
		) );
		$wp_customize->add_control( 'qt_gallery_cat_slug', array(
		    'label' 			=> esc_html__( 'Gallery category URL slug', 'the-landscaper-wp' ),
		    'description'		=> esc_html__( 'After changing this setting please go to Settings > Permalinks and save the page', 'the-landscaper-wp' ),
		    'section' 			=> 'qt_section_gallery',
		    'settings' 			=> 'qt_gallery_cat_slug',
		    'priority' 			=> 45,
		) );

		$wp_customize->add_setting( 'qt_gallery_cat_title', array(
	    	'default' 			=> '',
	    	'transport'			=> 'refresh',
	    	'sanitize_callback' => 'wp_kses_post',
		) );
		$wp_customize->add_control( 'qt_gallery_cat_title', array(
		    'label' 			=> esc_html__( 'Gallery category title', 'the-landscaper-wp' ),
		    'description' 		=> esc_html__( 'Prefix for the gallery category page title', 'the-landscaper-wp' ),
		    'section' 			=> 'qt_section_gallery',
		    'settings' 			=> 'qt_gallery_cat_title',
		    'priority' 			=> 50,
		) );

		/** 
		 * Panel: Shop
		 */
		if( thelandscaper_woocommerce_active() ) {
			$wp_customize->add_setting( 'qt_shop_products_per_page', array(
		    	'default' 			=> '8',
		    	'transport'			=> 'refresh',
		    	'sanitize_callback' => 'wp_kses_post',
			) );
			$wp_customize->add_control( 'qt_shop_products_per_page', array(
			    'label' 			=> esc_html__( 'Products per page', 'the-landscaper-wp'),
			    'section' 			=> 'qt_section_shop',
			    'settings' 			=> 'qt_shop_products_per_page',
			    'priority' 			=> 5,
			) );

			$wp_customize->add_setting( 'qt_single_product_sidebar', array(
				'default'			=> 'Right',
	        	'transport'			=> 'refresh',
	        	'sanitize_callback' => 'wp_kses_post',
		    ) );
			$wp_customize->add_control( 'qt_single_product_sidebar', array(
				'label'    			=> esc_html__( 'Single product page sidebar', 'the-landscaper-wp' ),
				'section'  			=> 'qt_section_shop',
				'settings' 			=> 'qt_single_product_sidebar',
				'type'    			=> 'select',
				'choices' 			=> array(
					'Hide'  		=> esc_html__( 'No sidebar', 'the-landscaper-wp'),
					'Left'  		=> esc_html__( 'Left', 'the-landscaper-wp'),
					'Right' 		=> esc_html__( 'Right', 'the-landscaper-wp'),
				),
				'priority' 			=> 10,
			) );
			$wp_customize->add_setting( 'qt_shop_product_zoom', array(
				'default'  				=> 'enable',
				'transport'				=> 'refresh',
				'sanitize_callback' 	=> 'wp_kses_post',
			) );

			$wp_customize->add_control( 'qt_shop_product_zoom', array(
				'label'       			=> esc_html__( 'Single product image zoom', 'the-landscaper-wp' ),
				'description' 			=> esc_html__( 'Use the WooCommerce product image zoom. Changes are visible on the front-end', 'the-landscaper-wp' ),
				'section'				=> 'qt_section_shop',
				'settings'				=> 'qt_shop_product_zoom',
				'type'					=> 'select',
				'choices'	  			=> array(
					'enable'					=> esc_html__( 'Enable', 'the-landscaper-wp' ),
					'disable'					=> esc_html__( 'Disable', 'the-landscaper-wp' ),
				),
			) );
			$wp_customize->add_setting( 'qt_shop_product_lightbox', array(
				'default'  				=> 'enable',
				'transport'				=> 'refresh',
				'sanitize_callback' 	=> 'wp_kses_post',
			) );

			$wp_customize->add_control( 'qt_shop_product_lightbox', array(
				'label'       			=> esc_html__( 'Single product image lightbox', 'the-landscaper-wp' ),
				'description' 			=> esc_html__( 'Use the WooCommerce product image lightbox. Changes are visible on the front-end', 'the-landscaper-wp' ),
				'section'				=> 'qt_section_shop',
				'settings'				=> 'qt_shop_product_lightbox',
				'type'					=> 'select',
				'choices'	  			=> array(
					'enable'					=> esc_html__( 'Enable', 'the-landscaper-wp' ),
					'disable'					=> esc_html__( 'Disable', 'the-landscaper-wp' ),
				),
			) );
			$wp_customize->add_setting( 'qt_shop_product_slider', array(
				'default'  				=> 'enable',
				'transport'				=> 'refresh',
				'sanitize_callback' 	=> 'wp_kses_post',
			) );

			$wp_customize->add_control( 'qt_shop_product_slider', array(
				'label'       			=> esc_html__( 'Single product image gallery slider', 'the-landscaper-wp' ),
				'description' 			=> esc_html__( 'Use the WooCommerce product image gallery slider. Changes are visible on the front-end', 'the-landscaper-wp' ),
				'section'				=> 'qt_section_shop',
				'settings'				=> 'qt_shop_product_slider',
				'type'					=> 'select',
				'choices'	  			=> array(
					'enable'					=> esc_html__( 'Enable', 'the-landscaper-wp' ),
					'disable'					=> esc_html__( 'Disable', 'the-landscaper-wp' ),
				),
			) );
		}

		/** 
		 * Panel: Footer
		 */
		$wp_customize->add_setting( 'qt_footer_columns', array( 
			'default' 			=> 4,
			'transport'			=> 'refresh',
			'sanitize_callback' => 'sanitize_text_field',
		) );
		$wp_customize->add_control( 'qt_footer_columns', array(
			'type'        		=> 'select',
			'priority'    		=> 0,
			'label'       		=> esc_html__( 'Footer columns', 'the-landscaper-wp' ),
			'description' 		=> esc_html__( 'Select how many columns you want to use in the footer. Select 0 to hide the footer', 'the-landscaper-wp' ),
			'section'     		=> 'qt_section_footer',
			'settings'    		=> 'qt_footer_columns',
			'choices' 			=> array(
				'0'					=> esc_html__( 'Hide footer', 'the-landscaper-wp' ),
				'1'					=> esc_html__( '1', 'the-landscaper-wp' ),
				'2'					=> esc_html__( '2', 'the-landscaper-wp' ),
				'3'					=> esc_html__( '3', 'the-landscaper-wp' ),
				'4'					=> esc_html__( '4', 'the-landscaper-wp' ),
			),
		) );

		$wp_customize->add_setting( 'qt_footer_bgcolor', array(
			'default'			=> '#333333',
		    'transport'			=> 'refresh',
		    'sanitize_callback' => 'sanitize_hex_color',
		) );
		$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'qt_footer_bgcolor', array(
			'label'       		=> esc_html__( 'Background color', 'the-landscaper-wp' ),
			'description'		=> esc_html__( 'Change the background color of the footer', 'the-landscaper-wp' ),
			'section'     		=> 'qt_section_footer',
			'settings'    		=> 'qt_footer_bgcolor',
		) ) );

		$wp_customize->add_setting( 'qt_footer_widgettitle', array(
		    'default'     		=> '#ffffff',
		    'transport'	  		=> 'refresh',
		    'sanitize_callback' => 'sanitize_hex_color',
		) );
		$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'qt_footer_widgettitle', array(
			'label'       		=> esc_html__( 'Widget title color', 'the-landscaper-wp' ),
			'description'		=> esc_html__( 'Change the widget title color of the footer', 'the-landscaper-wp' ),
			'section'     		=> 'qt_section_footer',
			'settings'    		=> 'qt_footer_widgettitle',
		) ) );

		$wp_customize->add_setting( 'qt_footer_textcolor', array(
	    	'default'     		=> '#757575',
	    	'transport'	  		=> 'refresh',
	    	'sanitize_callback' => 'sanitize_hex_color',
		) );
		$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'qt_footer_textcolor', array(
			'label'       		=> esc_html__( 'Text color', 'the-landscaper-wp' ),
			'description'		=> esc_html__( 'Change the text color of the footer', 'the-landscaper-wp' ),
			'section'     		=> 'qt_section_footer',
			'settings'    		=> 'qt_footer_textcolor',
		) ) );

		$wp_customize->add_setting( 'qt_footer_link_color', array(
	    	'default'     		=> '#757575',
	    	'transport'	  		=> 'refresh',
	    	'sanitize_callback' => 'sanitize_hex_color',
		) );
		$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'qt_footer_link_color', array(
			'label'       		=> esc_html__( 'Link color', 'the-landscaper-wp' ),
			'description'		=> esc_html__( 'Change the link color of the footer', 'the-landscaper-wp' ),
			'section'     		=> 'qt_section_footer',
			'settings'    		=> 'qt_footer_link_color',
		) ) );

		$wp_customize->add_setting( 'qt_footer_link_hover_color', array(
	    	'default'     		=> '#ffffff',
	    	'transport'	  		=> 'refresh',
	    	'sanitize_callback' => 'sanitize_hex_color',
		) );
		$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'qt_footer_link_hover_color', array(
			'label'       		=> esc_html__( 'Link hover color', 'the-landscaper-wp' ),
			'description'		=> esc_html__( 'Change the link hover color of the footer', 'the-landscaper-wp' ),
			'section'     		=> 'qt_section_footer',
			'settings'    		=> 'qt_footer_link_hover_color',
		) ) );

		$wp_customize->add_setting( 'qt_footer_bgimage', array(
			'default' 	 		=> get_theme_file_uri( '/assets/images/leafs_dark.png' ),
			'transport'			=> 'refresh',
	    	'sanitize_callback' => 'esc_url_raw',
		) );
		$wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'qt_footer_bgimage', array(
            'label' 	 		=> esc_html__( 'Background pattern', 'the-landscaper-wp' ),
            'description'		=> esc_html__( 'Change the background image of the footer', 'the-landscaper-wp' ),
            'section' 	 		=> 'qt_section_footer',
            'settings' 			=> 'qt_footer_bgimage',
		) ) );

		$wp_customize->add_setting( 'qt_footerbottom_bgcolor', array(
			'default'			=> '#292929',
		    'transport'			=> 'refresh',
		    'sanitize_callback' => 'sanitize_hex_color',
		) );
		$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'qt_footerbottom_bgcolor', array(
			'label'       		=> esc_html__( 'Bottom footer background color', 'the-landscaper-wp' ),
			'description'		=> esc_html__( 'Change the background color of the bottom footer', 'the-landscaper-wp' ),
			'section'     		=> 'qt_section_footer',
			'settings'    		=> 'qt_footerbottom_bgcolor',
		) ) );

		$wp_customize->add_setting( 'qt_footerbottom_textcolor', array(
		    'default'     		=> '#656565',
		    'transport'	  		=> 'refresh',
		    'sanitize_callback' => 'sanitize_hex_color',
		) );
		$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'qt_footerbottom_textcolor', array(
			'label'       		=> esc_html__( 'Bottom footer text color', 'the-landscaper-wp' ),
			'description'		=> esc_html__( 'Change the text color of the bottom footer', 'the-landscaper-wp' ),
			'section'     		=> 'qt_section_footer',
			'settings'    		=> 'qt_footerbottom_textcolor',
		) ) );

		$wp_customize->add_setting( 'qt_footerbottom_linkcolor', array(
		    'default'     		=> '#e4e4e4',
		    'transport'	  		=> 'refresh',
		    'sanitize_callback' => 'sanitize_hex_color',
		) );
		$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'qt_footerbottom_linkcolor', array(
			'label'       		=> esc_html__( 'Bottom footer link color', 'the-landscaper-wp' ),
			'description'		=> esc_html__( 'Change the link color of the bottom footer', 'the-landscaper-wp' ),
			'section'     		=> 'qt_section_footer',
			'settings'    		=> 'qt_footerbottom_linkcolor',
		) ) );

		$wp_customize->add_setting( 'qt_footerbottom_textleft', array(
	    	'default' 			=> 'Copyright 2017 The Landscaper by Qreativethemes',
	    	'transport'			=> 'refresh',
	    	'sanitize_callback' => 'wp_kses_post',
		) );
		$wp_customize->add_control( 'qt_footerbottom_textleft', array(
		    'label' 			=> esc_html__( 'Bottom footer left text', 'the-landscaper-wp' ),
		    'description'		=> esc_html__( 'Add a text to the left side of the bottom footer', 'the-landscaper-wp' ),
		    'section' 			=> 'qt_section_footer',
		    'settings' 			=> 'qt_footerbottom_textleft',
		    'type' 				=> 'textarea',
		) );

		$wp_customize->add_setting( 'qt_footerbottom_textmiddle', array(
			'default'			=> 'Middle Text',
	    	'transport'			=> 'refresh',
	    	'sanitize_callback' => 'wp_kses_post',
		) );
		$wp_customize->add_control( 'qt_footerbottom_textmiddle', array(
		    'label' 			=> esc_html__( 'Bottom footer middle text', 'the-landscaper-wp' ),
		    'description'		=> esc_html__( 'Add a text to the middle of the bottom footer', 'the-landscaper-wp' ),
		    'section' 			=> 'qt_section_footer',
		    'settings' 			=> 'qt_footerbottom_textmiddle',
		    'type' 				=> 'textarea',
		) );

		$wp_customize->add_setting( 'qt_footerbottom_textright', array(
	    	'default' 			=> 'For emergency tree removal 123-777-456',
	    	'transport'			=> 'refresh',
	    	'sanitize_callback' => 'wp_kses_post',
		) );
		$wp_customize->add_control( 'qt_footerbottom_textright', array(
	    	'label' 			=> esc_html__( 'Bottom footer right text', 'the-landscaper-wp' ),
	    	'description'		=> esc_html__( 'Add a text to the right side of the bottom footer', 'the-landscaper-wp' ),
	    	'section' 			=> 'qt_section_footer',
	    	'settings' 			=> 'qt_footerbottom_textright',
	    	'type' 				=> 'textarea',
		) );

		/** 
		 * Panel: Typography
		 */
		$wp_customize->add_setting( 'qt_theme_primary_font', array(
			'default' 			=> 'Roboto',
	    	'transport'			=> 'refresh',
	    	'sanitize_callback' => 'esc_attr',
		) );
		$wp_customize->add_control( 'qt_theme_primary_font', array(
			'label'    			=> esc_html__( 'Primary font', 'the-landscaper-wp' ),
			'description'    	=> esc_html__( 'Font used for body text and navigation', 'the-landscaper-wp' ),
			'section'  			=> 'qt_section_typography',
			'settings' 			=> 'qt_theme_primary_font',
			'type'     			=> 'select',
			/* BY PTheme */
			'choices' 			=> array(
			'IranSans' => 'IRANSansWeb',
			'IRANSans-EN' => 'IRANSans-EN',
			'Aviny' => 'aviny',
			'IranYekan' => 'iryekan',
			'IranYekan-Bold' => 'iranyekanbold',
			'IranYekan-EN' => 'iranyekan-en',
			'Vazir-Bold' => 'Vazir-Bold',
			'Vazir-Light' => 'Vazir-Light',
			'Shabnam' => 'Shabnam',
			'Samim' => 'Samim',
			'Parastoo' => 'Parastoo',
			'Gandom' => 'Gandom',
			'Naskh' => 'Naskh',
			'Kufi' => 'Kufi',
			'Sahel' => 'Sahel',
			'ANic' => 'ANic',
			),
		) );

		$wp_customize->add_setting( 'qt_theme_primary_font_size', array(
			'default' 			=> '14',
	    	'transport'			=> 'refresh',
	    	'sanitize_callback' => 'absint',
		) );
		$wp_customize->add_control( 'qt_theme_primary_font_size', array(
		    'label' 			=> esc_html__( 'Primary font size', 'the-landscaper-wp'),
		    'description'    	=> esc_html__( 'Please don\'t include px in your string', 'the-landscaper-wp' ),
	    	'type'		        => 'number',
		    'section' 			=> 'qt_section_typography',
		    'settings' 			=> 'qt_theme_primary_font_size',
		    'input_attrs' 		=> array(
				'min' 		=> 0,
				'max'  		=> 100,
				'step' 		=> 2,
			),
		) );

		$wp_customize->add_setting( 'qt_theme_secondary_font', array(
			'default' 			=> 'Roboto Slab',
	    	'transport'			=> 'refresh',
	    	'sanitize_callback' => 'esc_attr',
		) );
		$wp_customize->add_control( 'qt_theme_secondary_font', array(
			'label'    			=> esc_html__( 'Secondary font', 'the-landscaper-wp' ),
			'description'    	=> esc_html__( 'Font used for the headings and titles', 'the-landscaper-wp' ),
			'section'  			=> 'qt_section_typography',
			'settings' 			=> 'qt_theme_secondary_font',
			'type'     			=> 'select',
			/* BY PTheme */
			'choices' 			=> array(
			'IranSans' => 'IRANSansWeb',
			'IRANSans-EN' => 'IRANSans-EN',
			'Aviny' => 'aviny',
			'IranYekan' => 'iryekan',
			'IranYekan-Bold' => 'iranyekanbold',
			'IranYekan-EN' => 'iranyekan-en',
			'Vazir-Bold' => 'Vazir-Bold',
			'Vazir-Light' => 'Vazir-Light',
			'Shabnam' => 'Shabnam',
			'Samim' => 'Samim',
			'Parastoo' => 'Parastoo',
			'Gandom' => 'Gandom',
			'Naskh' => 'Naskh',
			'Kufi' => 'Kufi',
			'Sahel' => 'Sahel',
			'ANic' => 'ANic',
			),
		) );

		$wp_customize->add_setting( 'qt_theme_widgettitle_span_weight', array(
			'default' 			=> 'normal',
	    	'transport'			=> 'refresh',
	    	'sanitize_callback' => 'esc_attr',
		) );
		$wp_customize->add_control( 'qt_theme_widgettitle_span_weight', array(
			'label'    			=> esc_html__( 'First word font weight', 'the-landscaper-wp' ),
			'description'    	=> esc_html__( 'First word in widget title font weight', 'the-landscaper-wp' ),
			'section'  			=> 'qt_section_typography',
			'settings' 			=> 'qt_theme_widgettitle_span_weight',
			'type'     			=> 'select',
			'choices' 			=> array(
				'bold' 			=> esc_html__( 'Bold', 'the-landscaper-wp' ),
				'normal' 		=> esc_html__( 'Normal', 'the-landscaper-wp' ),
			),
		) );

		$wp_customize->add_setting( 'qt_theme_navigation_link_size', array(
			'default' 			=> '',
	    	'transport'			=> 'refresh',
	    	'sanitize_callback' => 'absint',
		) );
		$wp_customize->add_control( 'qt_theme_navigation_link_size', array(
		    'label' 			=> esc_html__( 'Main navigation link size', 'the-landscaper-wp' ),
		    'description' 		=> esc_html__( 'Please don\'t include px in your string', 'the-landscaper-wp' ),
	    	'type'		        => 'number',
		    'section' 			=> 'qt_section_typography',
		    'settings' 			=> 'qt_theme_navigation_link_size',
		    'input_attrs' 		=> array(
				'min' 		=> 0,
				'max'  		=> 100,
				'step' 		=> 2,
			),
		) );

		$wp_customize->add_setting( 'qt_theme_navigation_submenu_link_size', array(
			'default' 			=> '',
	    	'transport'			=> 'refresh',
	    	'sanitize_callback' => 'absint',
		) );
		$wp_customize->add_control( 'qt_theme_navigation_submenu_link_size', array(
		    'label' 			=> esc_html__( 'Main navigation submenu link size', 'the-landscaper-wp' ),
		    'description' 		=> esc_html__( 'Please don\'t include px in your string', 'the-landscaper-wp' ),
	    	'type'		        => 'number',
		    'section' 			=> 'qt_section_typography',
		    'settings' 			=> 'qt_theme_navigation_submenu_link_size',
		    'input_attrs' 		=> array(
				'min' 		=> 0,
				'max'  		=> 100,
				'step' 		=> 2,
			),
		) );

		$wp_customize->add_setting( 'qt_theme_widget_title_size', array(
			'default' 			=> '',
	    	'transport'			=> 'refresh',
	    	'sanitize_callback' => 'absint',
		) );
		$wp_customize->add_control( 'qt_theme_widget_title_size', array(
		    'label' 			=> esc_html__( 'Widget title size', 'the-landscaper-wp' ),
		    'description' 		=> esc_html__( 'Please don\'t include px in your string', 'the-landscaper-wp' ),
	    	'type'		        => 'number',
		    'section' 			=> 'qt_section_typography',
		    'settings' 			=> 'qt_theme_widget_title_size',
		    'input_attrs' 		=> array(
				'min' 		=> 0,
				'max'  		=> 100,
				'step' 		=> 2,
			),
		) );

		$wp_customize->add_setting( 'qt_theme_page_heading_title_size', array(
			'default' 			=> '',
	    	'transport'			=> 'refresh',
	    	'sanitize_callback' => 'absint',
		) );
		$wp_customize->add_control( 'qt_theme_page_heading_title_size', array(
		    'label' 			=> esc_html__( 'Page header title size', 'the-landscaper-wp' ),
		    'description' 		=> esc_html__( 'Please don\'t include px in your string', 'the-landscaper-wp' ),
	    	'type'		        => 'number',
		    'section' 			=> 'qt_section_typography',
		    'settings' 			=> 'qt_theme_page_heading_title_size',
		    'input_attrs' 		=> array(
				'min' 		=> 0,
				'max'  		=> 100,
				'step' 		=> 2,
			),
		) );

		$wp_customize->add_setting( 'qt_theme_footer_widget_title_size', array(
			'default' 			=> '',
	    	'transport'			=> 'refresh',
	    	'sanitize_callback' => 'absint',
		) );
		$wp_customize->add_control( 'qt_theme_footer_widget_title_size', array(
		    'label' 			=> esc_html__( 'Footer widget title size', 'the-landscaper-wp' ),
		    'description' 		=> esc_html__( 'Please don\'t include px in your string', 'the-landscaper-wp' ),
	    	'type'		        => 'number',
		    'section' 			=> 'qt_section_typography',
		    'settings' 			=> 'qt_theme_footer_widget_title_size',
		    'input_attrs' 		=> array(
				'min' 		=> 0,
				'max'  		=> 100,
				'step' 		=> 2,
			),
		) );

		$wp_customize->add_setting( 'qt_theme_heading_one_size', array(
			'default' 			=> '',
	    	'transport'			=> 'refresh',
	    	'sanitize_callback' => 'absint',
		) );
		$wp_customize->add_control( 'qt_theme_heading_one_size', array(
		    'label' 			=> esc_html__( 'Header 1 (H1) size', 'the-landscaper-wp' ),
		    'description' 		=> esc_html__( 'Please don\'t include px in your string', 'the-landscaper-wp' ),
	    	'type'		        => 'number',
		    'section' 			=> 'qt_section_typography',
		    'settings' 			=> 'qt_theme_heading_one_size',
		    'input_attrs' 		=> array(
				'min' 		=> 0,
				'max'  		=> 100,
				'step' 		=> 2,
			),
		) );

		$wp_customize->add_setting( 'qt_theme_heading_two_size', array(
			'default' 			=> '',
	    	'transport'			=> 'refresh',
	    	'sanitize_callback' => 'absint',
		) );
		$wp_customize->add_control( 'qt_theme_heading_two_size', array(
		    'label' 			=> esc_html__( 'Header 2 (H2) size', 'the-landscaper-wp' ),
		    'description' 		=> esc_html__( 'Please don\'t include px in your string', 'the-landscaper-wp' ),
	    	'type'		        => 'number',
		    'section' 			=> 'qt_section_typography',
		    'settings' 			=> 'qt_theme_heading_two_size',
		    'input_attrs' 		=> array(
				'min' 		=> 0,
				'max'  		=> 100,
				'step' 		=> 2,
			),
		) );

		$wp_customize->add_setting( 'qt_theme_heading_three_size', array(
			'default' 			=> '',
	    	'transport'			=> 'refresh',
	    	'sanitize_callback' => 'absint',
		) );
		$wp_customize->add_control( 'qt_theme_heading_three_size', array(
		    'label' 			=> esc_html__( 'Header 3 (H3) size', 'the-landscaper-wp' ),
		    'description' 		=> esc_html__( 'Please don\'t include px in your string', 'the-landscaper-wp' ),
	    	'type'		        => 'number',
		    'section' 			=> 'qt_section_typography',
		    'settings' 			=> 'qt_theme_heading_three_size',
		    'input_attrs' 		=> array(
				'min' 		=> 0,
				'max'  		=> 100,
				'step' 		=> 2,
			),
		) );

		$wp_customize->add_setting( 'qt_theme_heading_four_size', array(
			'default' 			=> '',
	    	'transport'			=> 'refresh',
	    	'sanitize_callback' => 'absint',
		) );
		$wp_customize->add_control( 'qt_theme_heading_four_size', array(
		    'label' 			=> esc_html__( 'Header 4 (H4) size', 'the-landscaper-wp' ),
		    'description' 		=> esc_html__( 'Please don\'t include px in your string', 'the-landscaper-wp' ),
	    	'type'		        => 'number',
		    'section' 			=> 'qt_section_typography',
		    'settings' 			=> 'qt_theme_heading_four_size',
		    'input_attrs' 		=> array(
				'min' 		=> 0,
				'max'  		=> 100,
				'step' 		=> 2,
			),
		) );

		$wp_customize->add_setting( 'qt_theme_heading_five_size', array(
			'default' 			=> '',
	    	'transport'			=> 'refresh',
	    	'sanitize_callback' => 'absint',
		) );
		$wp_customize->add_control( 'qt_theme_heading_five_size', array(
		    'label' 			=> esc_html__( 'Header 5 (H5) size', 'the-landscaper-wp' ),
		    'description' 		=> esc_html__( 'Please don\'t include px in your string', 'the-landscaper-wp' ),
	    	'type'		        => 'number',
		    'section' 			=> 'qt_section_typography',
		    'settings' 			=> 'qt_theme_heading_five_size',
		    'input_attrs' 		=> array(
				'min' 		=> 0,
				'max'  		=> 100,
				'step' 		=> 2,
			),
		) );

		$wp_customize->add_setting( 'qt_theme_heading_six_size', array(
			'default' 			=> '',
	    	'transport'			=> 'refresh',
	    	'sanitize_callback' => 'absint',
		) );
		$wp_customize->add_control( 'qt_theme_heading_six_size', array(
		    'label' 			=> esc_html__( 'Header 6 (H6) size', 'the-landscaper-wp' ),
		    'description' 		=> esc_html__( 'Please don\'t include px in your string', 'the-landscaper-wp' ),
	    	'type'		        => 'number',
		    'section' 			=> 'qt_section_typography',
		    'settings' 			=> 'qt_theme_heading_six_size',
		    'input_attrs' 		=> array(
				'min' 		=> 0,
				'max'  		=> 100,
				'step' 		=> 2,
			),
		) );

		/** 
		 * Panel: 404 Page
		 */
		$wp_customize->add_setting( 'qt_404_page_image', array( 
			'transport'			=> 'refresh',
			'sanitize_callback' => 'esc_url',
		) );
		$wp_customize->add_control( new WP_Customize_Image_Control( 
			$wp_customize, 'qt_404_page_image', array(
	            'label' 	 	=> esc_html__( '404 page image', 'the-landscaper-wp'),
	            'description' 	=> esc_html__( 'To reach the 404 page navigate to a page that don\'t exisint via the browser domain bar', 'the-landscaper-wp' ),
	            'section' 	 	=> 'qt_section_other',
	            'settings' 	 	=> 'qt_404_page_image',
				'priority'   	=> 5,
			)
		) );

		$wp_customize->add_setting( 'qt_404_page_text_title', array(
	    	'default' 			=> 'Oops! That page can\'t be found',
	    	'transport'			=> 'refresh',
	    	'sanitize_callback' => 'wp_kses_post',
		) );
		$wp_customize->add_control( 'qt_404_page_text_title', array(
	    	'label' 			=> esc_html__( '404 page text heading', 'the-landscaper-wp' ),
	    	'section' 			=> 'qt_section_other',
	    	'settings' 			=> 'qt_404_page_text_title',
	    	'type' 				=> 'text',
	    	'priority' 			=> 10,
		) );

		$wp_customize->add_setting( 'qt_404_page_text', array(
	    	'default' 			=> 'Nothing was found here, try a search below',
	    	'transport'			=> 'refresh',
	    	'sanitize_callback' => 'wp_kses_post',
		) );
		$wp_customize->add_control( 'qt_404_page_text', array(
	    	'label' 			=> esc_html__( '404 page text', 'the-landscaper-wp' ),
	    	'section' 			=> 'qt_section_other',
	    	'settings' 			=> 'qt_404_page_text',
	    	'type' 				=> 'text',
	    	'priority' 			=> 15,
		) );

		$wp_customize->add_setting( 'qt_404_page_search', array(
	    	'default'  				=> 'show',
	    	'transport'				=> 'refresh',
	    	'sanitize_callback' 	=> 'sanitize_text_field',
		) );
		$wp_customize->add_control( 'qt_404_page_search', array(
			'label'    				=> esc_html__( '404 page search bar', 'the-landscaper-wp' ),
			'section'  				=> 'qt_section_other',
			'settings' 				=> 'qt_404_page_search',
			'type'     				=> 'select',
			'choices'  				=> array(
				'show'  			=> esc_html__( 'Show', 'the-landscaper-wp' ),
				'hide' 				=> esc_html__( 'Hide', 'the-landscaper-wp' ),
			),
			'priority' 				=> 20,
		) );

		/** 
		 * Panel: Opening Hour Translation
		 */

		$thelandscaper_qt_weekdays = array(
			'monday',
			'tuesday',
			'wednesday',
			'thursday',
			'friday',
			'saturday',
			'sunday'
		);

		foreach ( $thelandscaper_qt_weekdays as $day ) {

			// Captialize the weekday for the labels
			$day_name = ucfirst( $day );

			// Create the controls for all weekdays
			$wp_customize->add_setting( 'qt_weekday_' . $day, array(
				'transport'				=> 'refresh',
				'sanitize_callback' 	=> 'wp_kses_post',
			) );

			$wp_customize->add_control( 'qt_weekday_' . $day, array(
				'type' 					=> 'text',
				'section' 				=> 'qt_section_opening_hours',
			    'settings' 				=> 'qt_weekday_' . $day,
			    'label' 				=> $day_name . ' ' . esc_html__( '(Translate)', 'the-landscaper-wp' ),
			    'description' 			=> esc_html__( 'Translate the weekday', 'the-landscaper-wp' ),
			) );

			$wp_customize->add_setting( 'qt_weekday_' . $day . '_from', array(
				'transport'				=> 'refresh',
				'sanitize_callback' 	=> 'wp_kses_post',
			) );

			$wp_customize->add_control( 'qt_weekday_' . $day . '_from', array(
				'type' 					=> 'text',
				'section' 				=> 'qt_section_opening_hours',
			    'settings' 				=> 'qt_weekday_' . $day . '_from',
			    'label' 				=> $day_name . ' ' . esc_html__( '(From)', 'the-landscaper-wp' ),
			    'description' 			=> esc_html__( 'Example: 7:00 AM or 08:00', 'the-landscaper-wp' ),
			) );

			$wp_customize->add_setting( 'qt_weekday_' . $day . '_to', array(
				'transport'				=> 'refresh',
				'sanitize_callback' 	=> 'wp_kses_post',
			) );

			$wp_customize->add_control( 'qt_weekday_' . $day . '_to', array(
				'type' 					=> 'text',
				'section' 				=> 'qt_section_opening_hours',
			    'settings' 				=> 'qt_weekday_' . $day . '_to',
			    'label' 				=> $day_name . ' ' . esc_html__( '(To)', 'the-landscaper-wp' ),
			    'description' 			=> esc_html__( 'Example: 5:00 PM or 17:00', 'the-landscaper-wp' ),
			) );
		}

		$wp_customize->add_setting( 'qt_opening_closed_text', array(
			'transport'				=> 'refresh',
			'sanitize_callback' 	=> 'wp_kses_post',
		) );

		$wp_customize->add_control( 'qt_opening_closed_text', array(
			'type' 					=> 'text',
			'section' 				=> 'qt_section_opening_hours',
		    'settings' 				=> 'qt_opening_closed_text',
		    'label' 				=> esc_html__( 'Closed Text', 'the-landscaper-wp' ),
		    'description' 			=> esc_html__( 'Leave "From" and "To" fields empty to display the closed message', 'the-landscaper-wp' ),
		) );

		$wp_customize->add_setting( 'qt_opening_separator', array(
			'transport'				=> 'refresh',
			'sanitize_callback' 	=> 'wp_kses_post',
		) );

		$wp_customize->add_control( 'qt_opening_separator', array(
			'type' 					=> 'text',
			'section' 				=> 'qt_section_opening_hours',
		    'settings' 				=> 'qt_opening_separator',
		    'label' 				=> esc_html__( 'Separator', 'the-landscaper-wp' ),
		    'description' 			=> esc_html__( 'Separator symbol between opening hours', 'the-landscaper-wp' ),
		) );

		$wp_customize->add_setting( 'qt_opening_extra_info', array(
			'transport'				=> 'refresh',
			'sanitize_callback' 	=> 'wp_kses_post',
		) );

		$wp_customize->add_control( 'qt_opening_extra_info', array(
			'type' 					=> 'text',
			'section' 				=> 'qt_section_opening_hours',
		    'settings' 				=> 'qt_opening_extra_info',
		    'label' 				=> esc_html__( 'Extra info', 'the-landscaper-wp' ),
		    'description' 			=> esc_html__( 'Define lunchbreaks or vacations', 'the-landscaper-wp' ),
		) );

		/**
		 * Panel: Font Awesome
		 */
		$wp_customize->add_setting( 'qt_fontawesome_version', array(
	    	'default'  			=> '4',
	    	'transport'			=> 'refresh',
	    	'sanitize_callback' => 'sanitize_text_field',
		) );
		$wp_customize->add_control( 'qt_fontawesome_version', array(
			'label'    			=> esc_html__( 'Font Awesome version', 'the-landscaper-wp' ),
			'description'       => esc_html__( 'Use this setting to update from Font Awesome version 4 to version 5. Note that the icon prefix class has been changed in version 5 and some icons might display slightly different', 'the-landscaper-wp' ),
			'section'  			=> 'qt_section_fontawesome',
			'settings' 			=> 'qt_fontawesome_version',
			'type'     			=> 'select',
			'choices'  			=> array(
				'4'  				=> esc_html__( 'Version 4', 'the-landscaper-wp' ),
				'5' 				=> esc_html__( 'Version 5', 'the-landscaper-wp' ),
			),
		) );

		$wp_customize->add_setting( 'qt_fontawesome_fallback', array(
	    	'default'  			=> 'enable',
	    	'transport'			=> 'refresh',
	    	'sanitize_callback' => 'sanitize_text_field',
		) );
		$wp_customize->add_control( 'qt_fontawesome_fallback', array(
			'label'    			=> esc_html__( 'Icon fallback support', 'the-landscaper-wp' ),
			'description'       => esc_html__( 'You can enable this setting if you still using icons from Font Awesome version 4 on your website. It is recommend go through your website and update all icons manually to version 5 icons', 'the-landscaper-wp' ),
			'section'  			=> 'qt_section_fontawesome',
			'settings' 			=> 'qt_fontawesome_fallback',
			'type'     			=> 'select',
			'choices'  			=> array(
				'enable'  			=> esc_html__( 'Enable', 'the-landscaper-wp' ),
				'disable' 			=> esc_html__( 'Disable', 'the-landscaper-wp' ),
			),
			'active_callback' 	=> array( $this, 'thelandscaper_show_setting_fallback_support' ),
		) );

		/** 
		 * Panel: Custom
		 */
		$wp_customize->add_setting( 'qt_custom_head_js', array(
	    	'transport'			=> 'refresh',
	    	'sanitize_callback' => 'thelandscaper_sanitize_js',
		) );
		$wp_customize->add_control( 'qt_custom_head_js', array(
	    	'label' 			=> esc_html__( 'Custom header JS', 'the-landscaper-wp' ),
	    	'description' 		=> esc_html__( 'Please use the <script></script> tags', 'the-landscaper-wp' ),
	    	'section' 			=> 'qt_section_custom',
	    	'settings' 			=> 'qt_custom_head_js',
	    	'type' 				=> 'textarea',
		) );

		$wp_customize->add_setting( 'qt_custom_foot_js', array(
	    	'transport'			=> 'refresh',
	    	'sanitize_callback' => 'thelandscaper_sanitize_js',
		) );
		$wp_customize->add_control( 'qt_custom_foot_js', array(
	    	'label' 			=> esc_html__( 'Custom footer JS', 'the-landscaper-wp' ),
	    	'description' 		=> esc_html__( 'Please use the <script></script> tags', 'the-landscaper-wp' ),
	    	'section' 			=> 'qt_section_custom',
	    	'settings' 			=> 'qt_custom_foot_js',
	    	'type' 				=> 'textarea',
		) );

		$wp_customize->add_setting( 'qt_custom_google_api', array(
	    	'default' 			=> '',
	    	'transport'			=> 'refresh',
	    	'sanitize_callback' => 'wp_kses_post',
		) );
		$wp_customize->add_control( 'qt_custom_google_api', array(
	    	'label' 			=> esc_html__( 'Google Maps API key', 'the-landscaper-wp' ),
	    	'description' 		=> sprintf(
	    		esc_html__( 'You need to create a billing account and API key at Google to use the API embedded map on your website. See %1$s for more information. Enter your Google Maps API key. Create one %2$s', 'the-landscaper-wp'  ),
	    		'<a href="'. esc_url( 'https://cloud.google.com/maps-platform/pricing/ ') .'">this page</a>',
	    		'<a href="'. esc_url( 'https://console.developers.google.com/flows/enableapi?apiid=maps_backend,geocoding_backend,directions_backend,distance_matrix_backend,elevation_backend&keyType=CLIENT_SIDE&reusekey=true' ) .'" target="_blank">here</a>' ),
	    	'section' 			=> 'qt_section_custom',
	    	'settings' 			=> 'qt_custom_google_api',
	    	'type' 				=> 'text',
		) );

		$wp_customize->add_setting( 'qt_show_acf', array(
	    	'default'  			=> 'no',
	    	'transport'			=> 'refresh',
	    	'sanitize_callback' => 'sanitize_text_field',
		) );
		$wp_customize->add_control( 'qt_show_acf', array(
			'label'    			=> esc_html__( 'Show ACF admin tab', 'the-landscaper-wp' ),
			'description'       => esc_html__( 'If you want to use the ACF plugin and make the admin tab visible set this to "Yes". Please do not change if you don\'t know what you\'re doing.', 'the-landscaper-wp' ),
			'section'  			=> 'qt_section_custom',
			'settings' 			=> 'qt_show_acf',
			'type'     			=> 'select',
			'choices'  			=> array(
				'no'  				=> esc_html__( 'No', 'the-landscaper-wp' ),
				'yes' 				=> esc_html__( 'Yes', 'the-landscaper-wp' ),
			),
		) );
	}

	/**
	 * Formats the primary styles for output.
	 *
	 * @since  1.0.0
	 * @return string
	 */
	public function thelandscaper_get_primary_styles() {

		// Top Margin Logo
		$qt_logo_margin_top			  			  	= get_theme_mod( 'qt_logo_margin_top' );
		$qt_logo_width 							  	= get_theme_mod( 'qt_logo_width' );


		/**
		 * Header Layout Default, Wide & Overlay
		 */

		// Topbar
		$topbar_bg 								  	= get_theme_mod( 'qt_topbar_bg', '#3a3a3a' );
		$topbar_textcolor 						  	= get_theme_mod( 'qt_topbar_textcolor', '#7d7d7d' );
		$topbar_icon_color 						  	= get_theme_mod( 'qt_topbar_icon_color', '#7d7d7d' );
		$topbar_icon_color_hover 				  	= get_theme_mod( 'qt_topbar_icon_color_hover', '#7d7d7d' );
		$topbar_link_color 						  	= get_theme_mod( 'qt_topbar_link_color', '#7d7d7d' );
		$topbar_link_hover_color 				  	= get_theme_mod( 'qt_topbar_link_hover_color', '#ffffff' );

		// Navigation
		$nav_bg 								  	= get_theme_mod( 'qt_nav_bg', '#a2c046' );
		$nav_bg_full 							  	= get_theme_mod( 'qt_nav_bg_full', '#ffffff' );
		$nav_bg_adjust 							  	= TheLandscaper_Customizer::thelandscaper_adjust_color( $nav_bg, 25 );
		$nav_textcolor 							  	= get_theme_mod( 'qt_nav_textcolor', '#ffffff' );
		$nav_textcolor_hover 					  	= get_theme_mod( 'qt_nav_textcolor_hover', '#ffffff' );
		$nav_submenu_bgcolor 					  	= get_theme_mod( 'qt_nav_submenu_bg', '#434343' );
		$nav_submenu_textcolor 					  	= get_theme_mod( 'qt_nav_submenu_textcolor', '#999999' );

		$nav_submenu_bgcolor_adjust 			  	= TheLandscaper_Customizer::thelandscaper_adjust_color( $nav_submenu_bgcolor, -9 ); // only used for default value
		$nav_submenu_textcolor_adjust 			  	= TheLandscaper_Customizer::thelandscaper_adjust_color( $nav_submenu_textcolor, 100 ); // only used for default value
		$nav_submenu_bg_hover 					  	= get_theme_mod( 'qt_nav_submenu_bg_hover', $nav_submenu_bgcolor_adjust );
		$nav_submenu_textcolor_hover 			  	= get_theme_mod( 'qt_nav_submenu_textcolor_hover', $nav_submenu_textcolor_adjust );


		/**
		 * Header Layout Transparent
		 */

		// Topbar
		$header_transparent_topbar_background 		= get_theme_mod( 'qt_topbar_bg_transparent', '#3a3a3a' );
		$header_transparent_topbar_text_color		= get_theme_mod( 'qt_topbar_textcolor_transparent', '#b5b5b5' );
		$header_transparent_topbar_icon_color 		= get_theme_mod( 'qt_topbar_icon_color_transparent', '#b5b5b5' );
		$header_transparent_topbar_icon_color_hover = get_theme_mod( 'qt_topbar_icon_color_hover_transparent', '#ffffff' );
		$header_transparent_topbar_link_color 		= get_theme_mod( 'qt_topbar_link_color_transparent', '#b5b5b5' );
		$header_transparent_topbar_link_color_hover = get_theme_mod( 'qt_topbar_link_hover_color_transparent', '#ffffff' );

		// Header
		$gradient_bg_transparent 				  	= get_theme_mod( 'qt_gradient_bg_transparent', '#000000' );
		$gradient_bg_transparent_opacity 		  	= get_theme_mod( 'qt_gradient_bg_transparent_opacity', '0.5' );
		$gradient_bg_transparent_rgba 			  	= TheLandscaper_Customizer::thelandscaper_hex_to_rgba( $gradient_bg_transparent, $gradient_bg_transparent_opacity );

		// Navigation
		$nav_textcolor_transparent 				  	= get_theme_mod( 'qt_nav_textcolor_transparent', '#ffffff' );
		$nav_textcolor_hover_transparent 		  	= get_theme_mod( 'qt_nav_textcolor_hover_transparent' );

		$nav_submenu_topline_transparent 		  	= get_theme_mod( 'qt_nav_submenu_topline_transparent', '#a2c046' );
		$nav_submenu_bgcolor_transparent 		  	= get_theme_mod( 'qt_nav_submenu_bg_transparent', '#434343' );
		$nav_submenu_textcolor_transparent 		  	= get_theme_mod( 'qt_nav_submenu_textcolor_transparent', '#999999' );

		$nav_submenu_bgcolor_adjust_transparent	  	= TheLandscaper_Customizer::thelandscaper_adjust_color( $nav_submenu_bgcolor_transparent, -9 );
	    $nav_submenu_textcolor_adjust_transparent 	= TheLandscaper_Customizer::thelandscaper_adjust_color( $nav_submenu_textcolor_transparent, 100 );

	    $nav_submenu_bgcolor_hover_transparent 		= get_theme_mod( 'qt_nav_submenu_bg_hover_transparent', $nav_submenu_bgcolor_adjust_transparent );
		$nav_submenu_textcolor_hover_transparent	= get_theme_mod( 'qt_nav_submenu_textcolor_hover_transparent', $nav_submenu_textcolor_adjust_transparent );

	    // Sticky Navigation
	    $nav_stickynav_bg_transparent 			  	= get_theme_mod( 'qt_nav_stickynav_bg_transparent', '#000000' );
	    $nav_stickynav_bg_transparent_opacity 	 	= get_theme_mod( 'qt_nav_stickynav_bg_transparent_opacity', '0.5' );
	    $nav_stickynav_bg_rgba 					  	= TheLandscaper_Customizer::thelandscaper_hex_to_rgba( $nav_stickynav_bg_transparent, $nav_stickynav_bg_transparent_opacity );


		/**
		 * Header Layout Sidebar
		 */

		// Topbar
		$topbar_bg_sidebar 						  	= get_theme_mod( 'qt_topbar_bg_sidebar', '#3a3a3a' );
		$topbar_textcolor_sidebar 			      	= get_theme_mod( 'qt_topbar_textcolor_sidebar', '#7d7d7d' );
		$topbar_textcolor_adjust_sidebar          	= TheLandscaper_Customizer::thelandscaper_adjust_color( $topbar_textcolor_sidebar, -25 );
		$topbar_textcolor_hover_sidebar 	      	= TheLandscaper_Customizer::thelandscaper_adjust_color( $topbar_textcolor_sidebar, 150 );

		// Navigation
		$nav_bg_sidebar 					      	= get_theme_mod( 'qt_nav_bg_sidebar', '#3a3a3a' );
		$nav_active_line 						  	= get_theme_mod( 'qt_nav_active_line', '#a2c046' );
		$nav_bg_adjust_sidebar 				  	  	= TheLandscaper_Customizer::thelandscaper_adjust_color( $nav_bg_sidebar, 25 );
		$nav_textcolor_sidebar 				  	  	= get_theme_mod( 'qt_nav_textcolor_sidebar', '#ffffff' );
		$nav_textcolor_hover_sidebar 			  	= get_theme_mod( 'qt_nav_textcolor_hover_sidebar' );
		$nav_submenu_bgcolor_sidebar 		  	  	= get_theme_mod( 'qt_nav_submenu_bg_sidebar', '#a2c046' );
		$nav_submenu_textcolor_sidebar 		 	  	= get_theme_mod( 'qt_nav_submenu_textcolor_sidebar', '#ffffff' );


		$nav_submenu_bgcolor_adjust_sidebar	  	  	= TheLandscaper_Customizer::thelandscaper_adjust_color( $nav_submenu_bgcolor_sidebar, -9 ); // only used for default value
		$nav_submenu_textcolor_adjust_sidebar  	  	= TheLandscaper_Customizer::thelandscaper_adjust_color( $nav_submenu_textcolor_sidebar, 100 ); // only used for default value
		$nav_submenu_bg_hover_sidebar 			  	= get_theme_mod( 'qt_nav_submenu_bg_hover_sidebar', $nav_submenu_bgcolor_adjust_sidebar );
		$nav_submenu_textcolor_hover_sidebar 	  	= get_theme_mod( 'qt_nav_submenu_textcolor_hover_sidebar', $nav_submenu_textcolor_adjust_sidebar );


		/**
		 * Header Layout Overlay
		 */

		// Header
		$header_background 							= get_theme_mod( 'qt_header_background', '#ffffff' );
		$header_title_color 						= get_theme_mod( 'qt_header_title_color', '#080808' );
		$header_text_color 						  	= get_theme_mod( 'qt_header_text_color', '#7d7d7d' );
		$header_icon_color 							= get_theme_mod( 'qt_header_icon_color', '#7d7d7d' );
		$header_icon_color_hover 				  	= get_theme_mod( 'qt_header_icon_color_hover', '#7d7d7d' );

		/**
		 * Different header controls end here
		 */


		// Mobile Navigation
		$nav_mobile_bg 				  				= get_theme_mod( 'qt_nav_mobile_bg' , '#a2c046' );
		$nav_mobile_bg_adjust 		  				= TheLandscaper_Customizer::thelandscaper_adjust_color( $nav_mobile_bg, 10 );
		$nav_mobile_textcolor 		  				= get_theme_mod( 'qt_nav_mobile_textcolor', '#ffffff' );
		$nav_mobile_submenu_bg 		  				= get_theme_mod( 'qt_nav_mobile_submenu_bg', '#9ab643' );
		$nav_mobile_submenu_textcolor 				= get_theme_mod( 'qt_nav_mobile_submenu_textcolor', '#ffffff' );

		$nav_mobile_nav_menu_bg 					= get_theme_mod( 'qt_mobile_nav_menu_bg', $nav_mobile_submenu_bg );
		$nav_mobile_nav_menu_text 					= get_theme_mod( 'qt_mobile_nav_menu_text', '#ffffff' );

		$nav_mobile_nav_submenu_toggle_bg 			= get_theme_mod( 'qt_mobile_nav_submenu_toggle_bg', 'transparent' );
		$nav_mobile_nav_submenu_toggle_bg_active	= get_theme_mod( 'qt_mobile_nav_submenu_toggle_bg_active', '#9ab643' );
		$nav_mobile_nav_submenu_toggle_icon 		= get_theme_mod( 'qt_mobile_nav_submenu_toggle_icon', '#ffffff' );

		// Slider
		$slider_small_heading_color 				= get_theme_mod( 'qt_slider_small_heading_color' );
		$slider_heading_color 						= get_theme_mod( 'qt_slider_heading_color' );
		$slider_content_color 						= get_theme_mod( 'qt_slider_content_color' );
		$slider_primary_button_background_color 	= get_theme_mod( 'qt_slider_primary_button_background_color' );
		$slider_primary_button_color 				= get_theme_mod( 'qt_slider_primary_button_color' );
		$slider_control_background_color 			= get_theme_mod( 'qt_slider_control_background_color' );
		$slider_control_color 						= get_theme_mod( 'qt_slider_control_color' );
		$slider_mobile_background_color 			= get_theme_mod( 'qt_slider_mobile_background_color' );

		// Page Header
		$maintitle_align 							= get_theme_mod( 'qt_maintitle_align' , 'left' );
		$maintitle_bgcolor 							= get_theme_mod( 'qt_maintitle_bgcolor', '#f2f2f2' );
		$maintitle_color 							= get_theme_mod( 'qt_maintitle_color', '#333333' );
		$subtitle_color 							= get_theme_mod( 'qt_subtitle_color', '#999999' );
		$maintitle_bg_image 						= get_theme_mod( 'qt_maintitle_bgimage', get_theme_file_uri( '/assets/images/leafs.png' ) );
		$maintitle_bg_position 						= get_theme_mod( 'qt_maintitle_bg_position', 'left center' );
		$maintitle_bg_repeat 						= get_theme_mod( 'qt_maintitle_bg_repeat', 'repeat' );
		$maintitle_bg_size 							= get_theme_mod( 'qt_maintitle_bg_size', 'auto' );

		// Breadcrumbs
		$breadcrumbs_align 			  				= get_theme_mod( 'qt_breadcrumbs_align' , 'left' );
		$breadcrumbs_textcolor 		  				= get_theme_mod( 'qt_breadcrumbs_textcolor', '#a5a5a5' );
		$breadcrumbs_text_hover		  				= TheLandscaper_Customizer::thelandscaper_adjust_color( $breadcrumbs_textcolor, -10 );
		$breadcrumbs_activecolor 	  				= get_theme_mod( 'qt_breadcrumbs_activecolor', '#a2c046' );
		$breadcrumbs_bg_color 		  				= get_theme_mod( 'qt_breadcrumbs_bg_color', '#ffffff' );

		// Theme Colors -- Primary 
		$theme_primary_color 		  				= get_theme_mod( 'qt_theme_primary_color', '#a2c046' );
		$theme_primary_color_adjust   				= TheLandscaper_Customizer::thelandscaper_adjust_color( $theme_primary_color, -10 );
		$theme_primary_color_adjust_light 			= TheLandscaper_Customizer::thelandscaper_adjust_color( $theme_primary_color, 52 );

		// Theme Colors -- Button Background
		$theme_btn_color 			  				= get_theme_mod( 'qt_theme_primary_btncolor', '#a2c046' );
		$theme_btn_color_hover 		  				= get_theme_mod( 'qt_theme_primary_btncolor_hover', '#98b63c' );
		$theme_btn_color_adjust 	  				= TheLandscaper_Customizer::thelandscaper_adjust_color( $theme_btn_color, -10 );
		$theme_btn_layout 							= get_theme_mod( 'qt_button_layout', '' );

		// Theme Colors -- Button Text Color
		$theme_btn_textcolor		  				= get_theme_mod( 'qt_theme_primary_btntext', '#ffffff' );

		// Theme Colors -- Text Color
		$theme_textcolor 			  				= get_theme_mod( 'qt_theme_textcolor', '#a5a5a5' );

		// Theme Colors -- Widget Title Color
		$widget_title_color 		  				= get_theme_mod( 'qt_theme_widgettitle', '#9fc612' );

		// Theme Colors -- First Span Widget Title Color
		$widget_title_span_color 	  				= get_theme_mod( 'qt_theme_widgettitle_span', '#464646' );

		// Theme Colors -- Theme Border Style
		$widget_border_style 		  				= get_theme_mod( 'qt_theme_widgettitle_border', 'dashed' );

		// Footer
		$footer_bg 					  				= get_theme_mod( 'qt_footer_bgcolor' );
		$footer_bgimage 			  				= get_theme_mod( 'qt_footer_bgimage', get_theme_file_uri( '/assets/images/leafs_dark.png' ) );
		$footer_textcolor 			  				= get_theme_mod( 'qt_footer_textcolor', '#757575' );
		$footer_link_color 			  				= get_theme_mod( 'qt_footer_link_color', '#757575' );
		$footer_link_hover_color 	  				= get_theme_mod( 'qt_footer_link_hover_color', '#ffffff' );
		$footer_widget_title 		  				= get_theme_mod( 'qt_footer_widgettitle', '#ffffff' );
		$footer_bottom_bg 			  				= get_theme_mod( 'qt_footerbottom_bgcolor', '#292929' );
		$footer_bottom_textcolor 	  				= get_theme_mod( 'qt_footerbottom_textcolor', '#777777' );
		$footer_bottom_linkcolor 	  				= get_theme_mod( 'qt_footerbottom_linkcolor', '#e4e4e4' );
		$footer_bottom_linkcolor_adjust 			= TheLandscaper_Customizer::thelandscaper_adjust_color( $footer_bottom_linkcolor, 50 );

		// Boxed Layout
		$boxed_bg 					  				= get_theme_mod( 'qt_boxed_bg', '#ffffff' );

		// Font Settings
		$theme_primary_font 		  				= get_theme_mod( 'qt_theme_primary_font', 'Roboto' );
		$theme_secondary_font 		  				= get_theme_mod( 'qt_theme_secondary_font', 'Roboto Slab' );
		$theme_first_word_font_weight 				= get_theme_mod( 'qt_theme_widgettitle_span_weight', 'normal' );
		$theme_primary_font_size 	  				= get_theme_mod( 'qt_theme_primary_font_size' );

		$theme_custom_heading_sizes   				= get_theme_mod( 'qt_theme_custom_heading_sizes', 'no' );
		$theme_widget_title_size 	  				= get_theme_mod( 'qt_theme_widget_title_size' );
		$theme_heading_one_size 	  				= get_theme_mod( 'qt_theme_heading_one_size' );
		$theme_heading_two_size 	  				= get_theme_mod( 'qt_theme_heading_two_size' );
		$theme_heading_three_size 	  				= get_theme_mod( 'qt_theme_heading_three_size' );
		$theme_heading_four_size 	  				= get_theme_mod( 'qt_theme_heading_four_size' );
		$theme_heading_five_size 	  				= get_theme_mod( 'qt_theme_heading_fice_size' );
		$theme_heading_six_size 	  				= get_theme_mod( 'qt_theme_heading_six_size' );

		$theme_navigation_link_size 				= get_theme_mod( 'qt_theme_navigation_link_size' );
		$theme_navigation_submenu_link_size 		= get_theme_mod( 'qt_theme_navigation_submenu_link_size' );
		$theme_page_heading_title_size 				= get_theme_mod( 'qt_theme_page_heading_title_size' );
		$theme_footer_widget_title_size 			= get_theme_mod( 'qt_theme_footer_widget_title_size' );

		/**  
		 * Build Up the Styles
		 *
		 **/
		$thelandscaper_style = "";


		// Primary font
		if ( $theme_primary_font ) {

			// Primary font type
			$thelandscaper_style .= "
				body,
				button,
				input,
				select,
				textarea,
				.btn,
				.topbar,
				.topbar a,
				.topbar .tagline,
				.topbar .widget-icon-box .title,
				.topbar .widget-icon-box .subtitle,
				.main-navigation li a,
				.page-header .sub-title,
				.panel-group .accordion-toggle,
				.block-posts .widget-title a,
				.testimonials .testimonial-quote {
					font-family: '{$theme_primary_font}';
				}
			";

			// Primary font size
			if ( $theme_primary_font_size != '' ) {
				
				$thelandscaper_style .= "
					body {
						font-size: {$theme_primary_font_size}px;
					}
				";
			}
		}

		// Secondary font
		if ( $theme_secondary_font ) {

			$thelandscaper_style .= "
				h1,
				h2,
				h3,
				h4,
				h5,
				h6,
				.jumbotron.carousel .carousel-text h1,
				.jumbotron.carousel .carousel-text p.carousel-heading-tag,
				.testimonials .testimonial-person .testimonial-author,
				.dropcap-wrap .dropcap-title,
				.counter .count-number,
				.counter .count-before,
				.counter .count-after {
					font-family: '{$theme_secondary_font}';
				}
			";
		}

		// First word widget title font weight
		$thelandscaper_style .= "

			.content .custom-title span.light,
			.content .widget-title span.light {
				font-weight: {$theme_first_word_font_weight};
			}
		";

		// Navigation link size
		if ( $theme_navigation_link_size != '' ) {

			$thelandscaper_style .= "
				@media (min-width: 992px) {
					.main-navigation > li > a {
						font-size: {$theme_navigation_link_size}px;
					}
				}
			";
		}

		// Navigation submneu link size
		if ( $theme_navigation_submenu_link_size != '' ) {

			$thelandscaper_style .= "
				.main-navigation .sub-menu > li > a {
					font-size: {$theme_navigation_submenu_link_size}px;
				}
			";
		}

		// Page heading title size
		if ( $theme_page_heading_title_size != '' ) {

			$thelandscaper_style .= "
				.page-header .main-title {
					font-size: {$theme_page_heading_title_size}px;
				}
			";
		}

		// Footer widget title size
		if ( $theme_footer_widget_title_size != '' ) {

			$thelandscaper_style .= "
				.footer .widget-title {
					font-size: {$theme_footer_widget_title_size}px;
				}
			";
		}

		// Widget title size
		if ( $theme_widget_title_size != '' ) {
			
			$thelandscaper_style .= "
				.widget-title {
					font-size: {$theme_widget_title_size}px;
				}
			";
		}

		// Heading 1
		if ( $theme_heading_one_size != '' ) {
			
			$thelandscaper_style .= "
				.content h1 {
					font-size: {$theme_heading_one_size}px;
				}
			";
		}

		// Heading 2
		if ( $theme_heading_two_size != '' ) {
			
			$thelandscaper_style .= "
				.content h2 {
					font-size: {$theme_heading_two_size}px;
				}
			";
		}

		// Heading 3
		if ( $theme_heading_three_size != '' ) {
			
			$thelandscaper_style .= "
				.content h3 {
					font-size: {$theme_heading_three_size}px;
				}
			";
		}

		// Heading 4
		if ( $theme_heading_four_size != '' ) {
			
			$thelandscaper_style .= "
				.content h4 {
					font-size: {$theme_heading_four_size}px;
				}
			";
		}

		// Heading 5
		if ( $theme_heading_five_size != '' ) {
			
			$thelandscaper_style .= "
				.content h5 {
					font-size: {$theme_heading_five_size}px;
				}
			";
		}

		// Heading 6
		if ( $theme_heading_six_size != '' ) {
			
			$thelandscaper_style .= "
				.content h6 {
					font-size: {$theme_heading_six_size}px;
				}
			";
		}

		if ( $qt_logo_margin_top != '' || $qt_logo_width != '' )  {

			$thelandscaper_style .= "
				.header .navbar-brand img {
			";

				if ( $qt_logo_margin_top != '' ) {

					$thelandscaper_style .= "
						margin-top: {$qt_logo_margin_top}px;
					";
				}

				if ( $qt_logo_width != '' ) {

					$thelandscaper_style .= "
						width: {$qt_logo_width}px;
					";
				}
			
			$thelandscaper_style .= "
				}
			";
		}

		$thelandscaper_style .= "

			@media (max-width: 992px) {

				.navbar-toggle,
				.navbar-toggle:hover {
					background-color: {$nav_mobile_nav_menu_bg};
				}

				.navbar-toggle .navbar-toggle-text {
					color: {$nav_mobile_nav_menu_text};
				}

				.navbar-toggle .icon-bar {
					background-color: {$nav_mobile_nav_menu_text};
				}

				.main-navigation .nav-toggle-mobile-submenu {
					color: {$nav_mobile_nav_submenu_toggle_icon};
					background-color: {$nav_mobile_nav_submenu_toggle_bg};
				}

				.main-navigation > li.nav-toggle-dropdown .nav-toggle-mobile-submenu {
					background-color: {$nav_mobile_nav_submenu_toggle_bg_active};
				}

				.main-navigation li a {
					color: {$nav_mobile_textcolor};
					border-color: {$nav_mobile_bg_adjust};
					background-color: {$nav_mobile_bg};
				}

				.main-navigation li .sub-menu li a {
					color: {$nav_mobile_submenu_textcolor};
					background-color: {$nav_mobile_submenu_bg};
				}

				.header { 
					background-color: {$nav_bg_full};
				}
			}
		";

		// Topbar
		$thelandscaper_style .= "

			.topbar { 
				background-color: {$topbar_bg};
			}

			.topbar,
			.topbar .tagline,
			.topbar .widget-icon-box .title,
			.topbar .widget-icon-box .subtitle { 
				color: {$topbar_textcolor};
			}

			.topbar a,
			.topbar .menu > li > a {
				color: {$topbar_link_color};	
			}

			.topbar a:hover,
			.topbar .menu > li > a:hover {
				color: {$topbar_link_hover_color};
			}

			.topbar .fa,
			.topbar .widget-icon-box .fa,
			.topbar .widget-social-icons a {
				color: {$topbar_icon_color};
			}

			.topbar .widget-icon-box:hover .fa,
			.topbar .widget-social-icons a:hover .fa,
			.topbar .menu > li.menu-item-has-children:hover > a {
				color: {$topbar_icon_color_hover};
			}
		";

		// Header Default, Wide & Overlay Layout
		if ( 'default' === get_theme_mod( 'qt_nav_layout', 'default' ) || 
			 'default' === get_field( 'header_layout', get_the_ID() ) || 
			 'default' === get_field( 'home_header_layout', get_the_ID() ) ||
			 'wide' === get_theme_mod( 'qt_nav_layout', 'default' ) || 
			 'wide' === get_field( 'header_layout', get_the_ID() ) || 
			 'wide' === get_field( 'home_header_layout', get_the_ID() ) ||
			 'overlay' === get_theme_mod( 'qt_nav_layout', 'default' ) ||
			 'overlay' === get_field( 'header_layout', get_the_ID() ) ||
			 'overlay' === get_field( 'home_header_layout', get_the_ID() ) ||
			 'fullwidth' === get_theme_mod( 'qt_nav_layout', 'default' ) ) {

			// Navigation
			$thelandscaper_style .= "

				.navigation {
					background-color: {$nav_bg_full};
				}
				
				.main-navigation,
				.header.header-wide .main-navigation::after {
					background-color: {$nav_bg};
				}
				
				.main-navigation li a {
					color: {$nav_textcolor};
				}

				.main-navigation li:hover a,
				.main-navigation li.menu-item-has-children:hover::after {
					color: {$nav_textcolor_hover};
				}
				
				.main-navigation li .sub-menu li a {
					color: {$nav_submenu_textcolor};
					background-color: {$nav_submenu_bgcolor};
				}

				.main-navigation li .sub-menu li:hover > a {
					color: {$nav_submenu_textcolor_hover};
					background-color: {$nav_submenu_bg_hover};
					border-bottom-color: {$nav_submenu_bg_hover};
				}

				.main-navigation > li:hover > a::after,
				.main-navigation > li.current-menu-item > a::after,
				.main-navigation > li.current_page_parent > a::after, 
				.main-navigation > li.current-menu-ancestor > a::after {
					background-color: {$nav_bg_adjust};
				}
			";
		}


		// Header Layout Default & Wide CSS
		if ( 'default' === get_theme_mod( 'qt_nav_layout', 'default' ) || 
			 'default' === get_field( 'header_layout', get_the_ID() ) || 
			 'default' === get_field( 'home_header_layout', get_the_ID() ) || 
			 'wide' === get_theme_mod( 'qt_nav_layout', 'default' ) || 
			 'wide' === get_field( 'header_layout', get_the_ID() ) || 
			 'wide' === get_field( 'home_header_layout', get_the_ID() ) ) {

			// Topbar
			$thelandscaper_style .= "

				@media (min-width: 992px) {
					.header { 
						background-color: {$topbar_bg};
					}

					.main-navigation::before { 
						border-color: transparent transparent transparent {$nav_bg_full};
					}
				}
			";
		}

		// Header Layout Overlay
		if ( 'overlay' === get_theme_mod( 'qt_nav_layout', 'default' ) || 
			 'overlay' === get_field( 'header_layout', get_the_ID() ) || 
			 'overlay' === get_field( 'home_header_layout', get_the_ID() ) ) {

			// Topbar
			$thelandscaper_style .= "

				.header { 
					background-color: {$header_background};
				}

				.header-overlay-middle .widget-icon-box .title {
					color: {$header_title_color};
				}

				.header-overlay-middle,
				.header-overlay-middle .widget-icon-box .subtitle {
					color: {$header_text_color};
				}

				body.header-overlay .header .header-overlay-middle .widgets .widget-icon-box i,
				body.header-overlay .header .header-overlay-middle .widgets .social-icons a {
					color: {$header_icon_color};
				}

				body.header-overlay .header .header-overlay-middle .widgets .widget-icon-box:hover i,
				body.header-overlay .header .header-overlay-middle .widgets .social-icons a:hover {
					color: {$header_icon_color_hover};
				}
			";
		}


		// Header Layout Transparent CSS
		if ( 'transparent' === get_theme_mod( 'qt_nav_layout', 'default' ) || 
			 'transparent' === get_field( 'header_layout', get_the_ID() ) || 
			 'transparent' === get_field( 'home_header_layout', get_the_ID() ) ) {

			// Topbar
			$thelandscaper_style .= "

				@media (max-width: 992px) {

					body.header-transparent .topbar {
						background-color: {$header_transparent_topbar_background};
					}
				}

				@media (min-width: 992px) {

					body.header-transparent .topbar {
						background: transparent;
					}

					body.header-transparent .topbar,
					body.header-transparent .topbar .tagline,
					body.header-transparent .topbar .widget-icon-box .title,
					body.header-transparent .topbar .widget-icon-box .subtitle {
						color: {$header_transparent_topbar_text_color};
					}

					body.header-transparent .topbar .fa,
					body.header-transparent .topbar .widget-icon-box .fa,
					body.header-transparent .topbar .widget-social-icons a {
						color: {$header_transparent_topbar_icon_color};
					}

					body.header-transparent .topbar .fa:hover,
					body.header-transparent .topbar .widget-icon-box:hover .fa,
					body.header-transparent .topbar .widget-social-icons a:hover {
						color: {$header_transparent_topbar_icon_color_hover};
					}

					body.header-transparent .topbar a,
					body.header-transparent .topbar .menu > li > a {
						color: {$header_transparent_topbar_link_color};
					}

					body.header-transparent .topbar a:hover,
					body.header-transparent .topbar .menu > li > a:hover {
						color: {$header_transparent_topbar_link_color_hover};
					}

					body.header-transparent .header-transparent {
						background: linear-gradient(to bottom, {$gradient_bg_transparent_rgba} 0%, transparent 100%);
					}

					body.header-transparent.is-sticky-nav .navigation-wrapper {
						background: {$nav_stickynav_bg_rgba};
					}
					
					.header-transparent .main-navigation>li>a {
						color: {$nav_textcolor_transparent};
					}

					.header-transparent .main-navigation>li:hover>a,
					.header-transparent .main-navigation>li.menu-item-has-children:hover::after {
						color: {$nav_textcolor_hover_transparent};
					}

					.header-transparent .main-navigation>li>.sub-menu {
						border-top-color: {$nav_submenu_topline_transparent};
					}
					
					.header-transparent .main-navigation>li>.sub-menu li a {
						color: {$nav_submenu_textcolor_transparent};
						background-color: {$nav_submenu_bgcolor_transparent};
					}

					.header-transparent .main-navigation>li>.sub-menu li:hover > a {
						color: {$nav_submenu_textcolor_hover_transparent};
						background-color: {$nav_submenu_bgcolor_hover_transparent};
						border-bottom-color: {$nav_submenu_bgcolor_hover_transparent};
					}
				}
			";
		}


		// Header Layout Sidebar CSS
		if ( 'sidebar' === get_theme_mod( 'qt_nav_layout', 'default' ) || 
			 'sidebar' === get_field( 'header_layout', get_the_ID() ) || 
			 'sidebar' === get_field( 'home_header_layout', get_the_ID() ) ) {

			// Topbar
			$thelandscaper_style .= "

				@media (max-width: 992px) {
					.header-sidebar .topbar {
						background-color: {$topbar_bg_sidebar};
					}
				}
		
				@media (min-width: 992px) {

					.header-sidebar .header-sidebar,
					.header-sidebar .topbar {
						background-color: {$topbar_bg_sidebar};
					}
					
					.header-sidebar .main-navigation>li>a {
						color: {$nav_textcolor_sidebar};
						background-color: {$nav_bg_sidebar};
					}

					.header-sidebar .main-navigation>li:hover a {
						color: {$nav_textcolor_hover_sidebar};
					}

					.header-sidebar .main-navigation>li:hover>a::after,
					.header-sidebar .main-navigation>li:focus>a::after,
					.header-sidebar .main-navigation>li.current-menu-item>a::after,
					.header-sidebar .main-navigation>li.current-menu-item>a:hover::after,
					.header-sidebar .main-navigation>li.current-menu-parent>a::after,
					.header-sidebar .main-navigation>li.current-menu-parent>a:hover::after {
						background-color: {$nav_active_line};
					}
					
					.header-sidebar .header-sidebar .main-navigation .sub-menu li a {
						color: {$nav_submenu_textcolor_sidebar};
						background-color: {$nav_submenu_bgcolor_sidebar};
					}

					.header-sidebar .header-sidebar .main-navigation .sub-menu li:hover > a {
						color: {$nav_submenu_textcolor_hover_sidebar};
						background-color: {$nav_submenu_bg_hover_sidebar};
					}
				}
			";
		}


		// Page Header
		$thelandscaper_style .= "

			.page-header {
				text-align: {$maintitle_align};
				background-color: {$maintitle_bgcolor};
				background-image: url('{$maintitle_bg_image}');
				background-position: {$maintitle_bg_position};
				background-repeat: {$maintitle_bg_repeat};
				background-size: {$maintitle_bg_size};
			}

			.page-header .main-title {
				color: {$maintitle_color};
			}

			.page-header .sub-title {
				color: {$subtitle_color};
			}
		";


		// Breadcrumbs
		$thelandscaper_style .= "

			.breadcrumbs {
				text-align: {$breadcrumbs_align};
				background-color: {$breadcrumbs_bg_color};
			}

			.breadcrumbs a {
				color: {$breadcrumbs_textcolor};
			}

			.breadcrumbs a:hover {
				color: {$breadcrumbs_text_hover};
			}
			
			.breadcrumbs span>span,
			.breadcrumbs .last {
				color: {$breadcrumbs_activecolor};
			}
		";


		// Theme Colors -- Primary 
		$thelandscaper_style .= "
			a,
			.dropcap,
			.post-item .title > a:hover,
			.testimonials .testimonial .author-location,
			.post .post-left-meta .box.date .day,
			.post .post-title a:hover,
			.post-inner .post-meta-data a:hover,
			.w-footer .icon-box .fa,
			.content .icon-box .fa,
			.opening-times ul li.today,
			.wpcf7 span,
			.testimonials .testimonial-person .testimonial-location,
			.panel-group .accordion-toggle::before,
			.wp-block-quote cite,
			.wp-block-quote footer,
			.wp-block-quote__citation,
			.has-theme-green-color { 
				color: {$theme_primary_color};
			}

			.jumbotron.carousel .carousel-topheading { 
				color: {$theme_primary_color_adjust_light};
			}
		";

		$thelandscaper_style .= "
			.w-footer .icon-box:hover .fa,
			.content .icon-box:hover .fa,
			a:hover,
			a:focus,
			a:active { 
				color: {$theme_primary_color_adjust};
			}
		";

		$thelandscaper_style .= "
			.topbar .menu .sub-menu > li > a,
			.counter.count-box .count-icon,
			.carousel-indicators li.active,
			table thead th,
			.qt-table thead td,
			.opening-times ul span.right.label,
			.social-icons a,
			.post-item .label-wrap .label,
			.has-theme-green-background-color,
			.team-member-social .overlay-center a:hover {
				background-color: {$theme_primary_color};
			}
		";

		$thelandscaper_style .= "
			.client-logos img:hover,
			.cta-button:hover,
			.brochure-box:hover,
			.wpcf7-text:focus,
			.wpcf7-textarea:focus,
			.brand-border:hover,
			.comment-form .comment-form-author input:focus,
			.comment-form .comment-form-email input:focus,
			.comment-form .comment-form-url input:focus,
			.comment-form .comment-form-comment textarea:focus {
				border-color: {$theme_primary_color};
			}
		";

		$thelandscaper_style .= "

			.post-item .label-wrap .label::after,
			.counter.count-box .count-icon::after { 
				border-top-color: {$theme_primary_color};
			}

			.post-item .label-wrap .label:hover,
			.counter.count-box:hover .count-icon { 
				background-color: {$theme_primary_color_adjust};
			}

			.post-item .label-wrap .label:hover::after,
			.counter.count-box:hover .count-icon::after { 
				border-top-color: {$theme_primary_color_adjust};
			}
		";


		// Theme Colors -- Button Background
		$thelandscaper_style .= "
			.btn-primary,
			.btn-primary:active,
			.btn-primary:focus,
			.btn-primary:active:focus,
			.btn-primary:hover,
			.wpcf7-submit,
			.wpcf7-checkbox .wpcf7-list-item,
			button,
			input[type='button'],
			input[type='reset'],
			input[type='submit'],
			.jumbotron .carousel-indicators li.active,
			.post-item .vertical-center span,
			.testimonials .testimonial-control,
			.testimonials .testimonial-control:first-of-type::before,
			.testimonials .testimonial-control:last-of-type::before,
			.cta-button,
			.brochure-box,
			.project-navigation a,
			.pagination a.current,
			.pagination span.current,
			body.page .pagination > span:not(.page-links-title),
			.sidebar .widget.widget_nav_menu .menu li.current-menu-item a,
			.sidebar .widget.widget_nav_menu .menu li a:hover,
			.content .widget.widget_nav_menu .menu li.current-menu-item a,
			.content .widget.widget_nav_menu .menu li a:hover,
			.panel-group .panel .panel-heading .accordion-toggle[aria-expanded=".'"true"'."],
			.wp-block-button:not(.is-style-outline) .wp-block-button__link:not(.has-background) { 
				background-color: {$theme_btn_color};
				color: {$theme_btn_textcolor};
			}

			.has-theme-button-green-background-color {
				background-color: {$theme_btn_color};
			}

			.has-theme-button-green-color {
				color: {$theme_btn_color};
			}
		";


		// Button Background Hover
		$thelandscaper_style .= "
			.btn-primary:hover,
			.wpcf7-submit:hover,
			.wpcf7-checkbox .wpcf7-list-item:hover,
			button:hover,
			input[type='button']:hover,
			input[type='reset']:hover,
			input[type='submit']:hover,
			.post-item .vertical-center span:hover,
			.testimonials .testimonial-control:hover,
			.testimonials .testimonial-control:first-of-type:hover::before,
			.testimonials .testimonial-control:last-of-type:hover::before,
			.project-navigation a:hover,
			.pagination a:hover,
			.project-navigation a:focus,
			.wp-block-button:not(.is-style-outline) .wp-block-button__link:not(.has-background):hover {
				background-color: {$theme_btn_color_hover};
				color: {$theme_btn_textcolor};
			}
		";


		$thelandscaper_style .= "

			.pagination a:hover,
			.wpcf7-checkbox .wpcf7-list-item {
				border-color: {$theme_btn_color_adjust};
			}
		";


		// Theme Colors -- Text Color
		$thelandscaper_style .= "
			body,
			.content a.icon-box .subtitle,
			.has-theme-text-color-color {
				color: {$theme_textcolor};
			}

			.has-theme-text-color-background-color {
				background-color: {$theme_textcolor};
			}
		";


		// Theme Colors -- Widget Title Color
		$thelandscaper_style .= "
			.widget-title {
				color: {$widget_title_color};
			}
		";


		// Theme Colors -- First Span Widget Title Color
		$thelandscaper_style .= "
			.content .widget-title span.light {
				color: {$widget_title_span_color};
			}
		";


		// Theme Colors -- Theme Borders
		$thelandscaper_style .= "
			.content .widget-title, .custom-title, 
			.project-navigation, 
			.post-meta-data {
				border-style: {$widget_border_style};
			}
		";


		// Slider
		if ( $slider_small_heading_color != '' ) {
			$thelandscaper_style .= "
				.jumbotron.carousel .carousel-topheading {
					color: {$slider_small_heading_color};
				}
			";
		}

		if ( $slider_heading_color != '' ) {
			$thelandscaper_style .= "
				.jumbotron.carousel .carousel-text .carousel-heading-tag {
					color: {$slider_heading_color};
				}
			";
		}

		if ( $slider_content_color != '' ) {
			$thelandscaper_style .= "
				.jumbotron.carousel .carousel-text p {
					color: {$slider_content_color};
				}
			";
		}

		if ( $slider_primary_button_color != '' || $slider_primary_button_background_color != '' ) {
			$thelandscaper_style .= "
				.jumbotron.carousel .carousel-text .btn.btn-primary {
					color: {$slider_primary_button_color};
					background-color: {$slider_primary_button_background_color};
				}
			";
		}

		if ( $slider_control_color != '' || $slider_control_background_color != '' ) {
			$thelandscaper_style .= "
				.jumbotron .carousel-control {
					color: {$slider_control_color};
					background-color: {$slider_control_background_color};
				}
				.jumbotron .carousel-control:hover {
					background-color: {$slider_control_background_color};
				}
			";
		}

		if ( $slider_mobile_background_color != '' ) {
			$thelandscaper_style .= "
				@media(max-width: 992px) {
					.jumbotron .item {
						background-color: {$slider_mobile_background_color};
					}
				}
			";
		}


		// Essential Grid
		if ( class_exists( 'Essential_Grid' ) && 'enable' === get_theme_mod( 'qt_default_esg_style', 'enable' ) ) {

			// gallery homepage grid
			$thelandscaper_style .= "
				body .the-landscaper-home .eg-the-landscaper-home-element-2,
				body .the-landscaper-home .eg-the-landscaper-home-element-4,
				body .the-landscaper .esg-filterbutton,
				body .the-landscaper .esg-sortbutton,
				body .the-landscaper .esg-cartbutton {
					font-family: {$theme_primary_font};
				}
				body .the-landscaper-home .eg-the-landscaper-home-element-0 {
					font-family: {$theme_secondary_font};
				}
				body .the-landscaper-home .eg-the-landscaper-home-element-2 {
					background-color: {$theme_primary_color};
				}
				body .the-landscaper-home .eg-the-landscaper-home-element-2:hover {
					background-color: {$theme_primary_color_adjust};
				}
				body .the-landscaper-home .eg-the-landscaper-home-element-4 {
					color: {$theme_primary_color};
				}
				body .the-landscaper-home .esg-navigationbutton {
					background-color: {$theme_primary_color};
				}
				body .the-landscaper-home .esg-navigationbutton:hover {
					background-color: {$theme_primary_color_adjust};
				}
				body .the-landscaper-home .esg-navigationbutton.esg-left::before {
					border-color: {$theme_primary_color} transparent transparent transparent;
				}
				body .the-landscaper-home .esg-navigationbutton.esg-right:before {
					border-color: transparent transparent {$theme_primary_color} transparent;
				}
				body .the-landscaper-home .esg-navigationbutton:hover.esg-left::before {
					border-color: {$theme_primary_color_adjust} transparent transparent transparent;
				}
				body .the-landscaper-home .esg-navigationbutton:hover.esg-right:before {
					border-color: transparent transparent {$theme_primary_color_adjust} transparent;
				}
			";

			// gallery pages grid
			$thelandscaper_style .= "				
				body .the-landscaper .eg-the-landscaper-element-30 {
					background-color: {$theme_primary_color};
				}
				body .the-landscaper .eg-the-landscaper-element-30:hover {
					background-color: {$theme_primary_color_adjust};
				}
			";

			// gallery lightbox grid
			$thelandscaper_style .= "
				body .the-landscaper .eg-the-landscaper-lightbox-element-31 {
					background-color: {$theme_primary_color};
				}
				body .the-landscaper .eg-the-landscaper-lightbox-element-31:hover {
					background-color: {$theme_primary_color_adjust};
				}
			";

			// overall styles grid
			$thelandscaper_style .= "
				body .the-landscaper .esg-filterbutton.selected,
				body .the-landscaper .esg-filterbutton:hover {
					border-color: {$theme_primary_color};
					background-color: {$theme_primary_color};
				}
				body .the-landscaper .eg-the-landscaper-element-24 {
					font-family: {$theme_secondary_font};
				}
			";
		}


		// Footer
		$thelandscaper_style .= "
			
			.main-footer {
				background-color: {$footer_bg };
				background-image: url('{$footer_bgimage}');
			}

			.main-footer,
			.main-footer p {
				color: {$footer_textcolor};
			}

			.main-footer a:not(.btn),
			.main-footer .widget_nav_menu ul > li > a {
				color: {$footer_link_color};
			}

			.main-footer a:hover,
			.main-footer .widget_nav_menu ul > li > a:hover {
				color: {$footer_link_hover_color};
			}

			.footer .widget-title {
				color: {$footer_widget_title};
			}

			.bottom-footer {
				background-color: {$footer_bottom_bg};
			}

			.bottom-footer p {
				color: {$footer_bottom_textcolor};
			}

			.bottom-footer a {
				color: {$footer_bottom_linkcolor};
			}

			.bottom-footer a:hover {
				color: {$footer_bottom_linkcolor_adjust};
			}
		";


		// Boxed Layout
		$thelandscaper_style .= "
			.layout-boxed { 
				background-color: {$boxed_bg};
			}
		";

		// WooCommerce
		if ( thelandscaper_woocommerce_active() ) {

			// Get the button layout setting for WooCommerce buttons
			if ( $theme_btn_layout == 'btn-rounded' ) {
				$btn_border_radius = '30';
			} else {
				$btn_border_radius = '0';
			}

			$thelandscaper_style .= "
				.woocommerce-page div.product p.price,
				.woocommerce div.product .star-rating span::before,
				ul.product_list_widget li .star-rating span::before,
				.woocommerce ul.products li.product .woocommerce-loop-category__title:hover,
				.woocommerce ul.products li.product .woocommerce-loop-product__title:hover,
				.woocommerce ul.products li.product.product h3:hover,
				body.woocommerce-page .woocommerce-error:before,
				body.woocommerce-page .woocommerce-info:before,
				body.woocommerce-page .woocommerce-message:before {
					color: {$theme_primary_color};
				}

				.woocommerce form .form-row input.input-text:active,
				.woocommerce form .form-row input.input-text:focus,
				.woocommerce form .form-row textarea:active,
				.woocommerce form .form-row textarea:focus {
					border-color: {$theme_primary_color};
				}
			
				.woocommerce div.product div.images img:hover,
				.woocommerce ul.products li.product a:hover img { 
					outline-color: {$theme_primary_color};
				}

				.woocommerce nav.woocommerce-pagination ul li span.current {
					border-color: {$theme_btn_color};
				}

				.woocommerce .widget_product_categories .product-categories li a { 
					border-color: {$theme_primary_color_adjust};
				}

				.woocommerce-MyAccount-navigation ul li.is-active a,
				.woocommerce-MyAccount-navigation ul li a:hover {
					background-color: {$theme_primary_color};
				}

				.woocommerce a.button,
				.woocommerce input.button,
				.woocommerce input.button.alt,
				.woocommerce button.button,
				.woocommerce button.button.alt,
				.woocommerce #respond input#submit,
				.woocommerce span.onsale,
				.woocommerce ul.products li.product .onsale,
				.woocommerce nav.woocommerce-pagination ul li span.current,
				.woocommerce-page div.product form.cart .button.single_add_to_cart_button,
				.woocommerce-cart .wc-proceed-to-checkout a.checkout-button,
				.woocommerce .widget_price_filter .ui-slider .ui-slider-handle {
					color: {$theme_btn_textcolor};
					border-radius: {$btn_border_radius}px;
					background-color: {$theme_btn_color};
				}

				.woocommerce a.button:hover,
				.woocommerce input.button:hover,
				.woocommerce input.button.alt:hover,
				.woocommerce button.button:hover,
				.woocommerce button.button.alt:hover,
				.woocommerce span.onsale:hover,
				.woocommerce ul.products li.product .onsale:hover, 
				.woocommerce-page div.product form.cart .button.single_add_to_cart_button:hover,
				.woocommerce-cart .wc-proceed-to-checkout a.checkout-button:hover,
				.woocommerce nav.woocommerce-pagination ul li a:hover,
				.woocommerce nav.woocommerce-pagination ul li a:focus,
				body.woocommerce-page .woocommerce-error a.button:hover,
				body.woocommerce-page .woocommerce-info a.button:hover,
				body.woocommerce-page .woocommerce-message a.button:hover { 
					color: {$theme_btn_textcolor};
					background-color: {$theme_btn_color_adjust};
				}

				.woocommerce div.product .woocommerce-tabs ul.tabs li.active,
				.woocommerce .widget_product_categories .product-categories li a {
					color: {$theme_btn_textcolor};
					background-color: {$theme_btn_color};
				}

				.woocommerce div.product .woocommerce-tabs ul.tabs li.active,
				.woocommerce .widget_product_categories .product-categories li a:hover {
					color: {$theme_btn_textcolor};
					background-color: {$theme_btn_color_adjust};
				}
			
				.woocommerce nav.woocommerce-pagination ul li a:hover,
				.woocommerce nav.woocommerce-pagination ul li a:focus,
				.woocommerce div.product .woocommerce-tabs ul.tabs li.active,
				.woocommerce div.product .woocommerce-tabs ul.tabs li:hover,
				.woocommerce .widget_product_categories .product-categories li a { 
					border-color: {$theme_btn_color_adjust};
				}

				.woocommerce-page .product .summary.entry-summary p.price,
				.pagination, .woocommerce-pagination { 
					border-style: {$widget_border_style};
				}

				.woocommerce div.product #reviews .comment-reply-title {
					font-family: {$theme_secondary_font};
				}
			";
		}

		$thelandscaper_style .= thelandscaper_inline_styles();

		return str_replace( array( "\r", "\n", "\t" ), '', $thelandscaper_style );
	}

	/**
	 * Callback for 'wp_head' that outputs the CSS for this feature.
	 *
	 * @since  1.0.0
	 * @return void
	 */
	public function thelandscaper_head_callback() {

		// Get all the inline styles from the customizer settings
		$thelandscaper_style = '<style id="customizer-css">';
		$thelandscaper_style .= $this->thelandscaper_get_primary_styles();
		$thelandscaper_style .= '</style>';

		// Output the customizer styles 
		// Already sanitzed from the customizer settings callback
		echo trim( $thelandscaper_style );

		// Add wp inline style
		wp_add_inline_style( 'custom-css', 'thelandscaper_customizer_css', 30 );
	}

	/**
	 * Callback for 'wp_head' that outputs the JavaScript for this feature.
	 *
	 * @since  1.3
	 * @return void
	 */
	public function thelandscaper_head_js() {

		$header_js = get_theme_mod( 'qt_custom_head_js', '' );

		if ( $header_js !== '' ) { echo trim( $header_js ); }
	}

	/**
	 * Callback for 'wp_foot' that outputs the JavaScript for this feature.
	 *
	 * @since  1.3
	 * @return void
	 */
	public function thelandscaper_foot_js() {

		$footer_js = get_theme_mod( 'qt_custom_foot_js', '' );

		if ( $footer_js !== '' ) { echo trim( $footer_js ); }
	}

	/**
	 * Deletes the cached style CSS that's output into the header.
	 *
	 * @since  1.0.0
	 * @return void
	 */
	public function thelandscaper_cache_delete() {
		wp_cache_delete( get_stylesheet() . '_custom_colors' );
	}

	/**
	* This outputs the javascript needed to automate the live settings preview.
	* Also keep in mind that this function isn't necessary unless your settings 
	* are using 'transport'=>'refresh' instead of the default 'transport'
	* => 'refresh'
	* 
	* Used by hook: 'customize_preview_init'
	* 
	* @see add_action('customize_preview_init',$func)
	* @since Version 1.0
	*/
	public function thelandscaper_live_preview() {
		wp_enqueue_script( 'thelandscaper-customizer', get_theme_file_uri( '/assets/js/customizer.js' ), array( 'customize-preview' ), '', true );
	}

	/**
	 * Active Callbacks for customizer settings
	 */

	// Returns if blog share buttons are set to display
	public function thelandscaper_hide_social_input_fields() {

		$blog_share = get_theme_mod( 'qt_blog_share', 'hide' );

		if ( 'hide' == $blog_share ) {
			return false;
		} else {
			return true;
		}
	}

	// Returns if header layout isset to default or wide
	public function thelandscaper_show_settings_header_default() {

		$header_default 	= get_theme_mod( 'qt_nav_layout', 'default' );
		$header_wide 		= get_theme_mod( 'qt_nav_layout', 'wide' );
		$header_fullwidth	= get_theme_mod( 'qt_nav_layout', 'fullwidth' );

		if ( 'default' == $header_default || 'wide' == $header_wide || 'fullwidth' == $header_fullwidth ) {
			return true;
		} else {
			return false;
		}
	}

	// Returns if header layout isset to sidebar
	public function thelandscaper_show_settings_header_sidebar() {

		$header_sidebar = get_theme_mod( 'qt_nav_layout', 'sidebar' );

		if ( 'sidebar' == $header_sidebar ) {
			return true;
		} else {
			return false;
		}
	}

	// Returns if header layout isset to transparent
	public function thelandscaper_show_settings_header_transparent() {

		$header_transparent = get_theme_mod( 'qt_nav_layout', 'transparent' );

		if ( 'transparent' == $header_transparent ) {
			return true;
		} else {
			return false;
		}
	}

	// Returns if header layout isset to overlay
	public function thelandscaper_show_settings_header_overlay() {

		$header_overlay = get_theme_mod( 'qt_nav_layout', 'overlay' );

		if ( 'overlay' == $header_overlay ) {
			return true;
		} else {
			return false;
		}
	}

	// Returns if header layout isset to default, wide or overlay
	public function thelandscaper_show_settings_header_default_and_overlay() {

		$header_default 	= get_theme_mod( 'qt_nav_layout', 'default' );
		$header_wide 		= get_theme_mod( 'qt_nav_layout', 'wide' );
		$header_fullwidth	= get_theme_mod( 'qt_nav_layout', 'fullwidth' );
		$header_overlay		= get_theme_mod( 'qt_nav_layout', 'overlay' );

		if ( 'default' == $header_default || 'wide' == $header_wide || 'fullwidth' == $header_fullwidth || 'overlay' == $header_overlay ) {
			return true;
		} else {
			return false;
		}
	}
	
	// Retun for each header layout except the transparent header
	public function thelandscaper_show_settings_except_header_transparent() {

		$header_transparent = get_theme_mod( 'qt_nav_layout', 'transparent' );

		if ( 'transparent' == $header_transparent ) {
			return false;
		} else {
			return true;
		}
	}

	// Display setting for all if sidebar layout is not chosen
	public function thelandscaper_show_settings_except_header_sidebar() {

		$header_sidebar = get_theme_mod( 'qt_nav_layout', 'sidebar' );

		if ( 'sidebar' == $header_sidebar ) {
			return false;
		} else {
			return true;
		}
	}

	// Hide setting for sidebar and transparent header layout
	public function thelandscaper_show_settings_except_header_sidebar_and_transparent() {

		$header_sidebar = get_theme_mod( 'qt_nav_layout', 'sidebar' );
		$header_transparent = get_theme_mod( 'qt_nav_layout', 'transparent' );

		if ( 'sidebar' == $header_sidebar || 'transparent' == $header_transparent ) {
			return false;
		} else {
			return true;
		}
	}

	// Return the sticky nav option for default, wide and transparent header layout
	public function thelandscaper_show_setting_sticky_nav() {

		$header_sidebar = get_theme_mod( 'qt_nav_layout', 'sidebar' );

		if ( 'sidebar' == $header_sidebar ) {
			return false;
		} else {
			return true;
		}
	}

	// Return the background color option for sticky nav on transparent header layout if nav isset to sticky
	public function thelandscaper_show_setting_stickynav_background() {

		$header_transparent	= get_theme_mod( 'qt_nav_layout', 'transparent' );
		$header_sticky		= get_theme_mod( 'qt_nav_position', 'static' );

		if ( 'transparent' == $header_transparent && 'sticky' == $header_sticky ) {
			return true;
		} else {
			return false;
		}
	}

	// Return options if gallery navigation isset to show
	public function thelandscaper_show_setting_gallery_nav() {

		$gallery_nav = get_theme_mod( 'qt_gallery_nav', 'hide' );

		if ( 'hide' == $gallery_nav ) {
			return false;
		} else {
			return true;
		}
	}

	// Return option if custom heading sizes isset to yes
	public function thelandscaper_show_custom_heading_sizes() {

		$custom_heading_sizes = get_theme_mod( 'qt_theme_custom_heading_sizes', 'yes' );

		if ( 'yes' == $custom_heading_sizes ) {
			return true;
		} else {
			return false;
		}
	}

	// Return option if icon fallback support isset to enable
	public function thelandscaper_show_setting_fallback_support() {

		$fontawesome_version = get_theme_mod( 'qt_fontawesome_version' );

		if ( '5' == $fontawesome_version ) {
			return true;
		} else {
			return false;
		}
	}

	/**
	 * Generare a ligter/darker color based on a #hex color input
	 */
	public function thelandscaper_adjust_color( $hex, $steps ) {
	    // Steps should be between -255 and 255. Negative = darker, positive = lighter
	    $steps = max(-255, min(255, $steps));

	    // Normalize into a six character long hex string
	    $hex = str_replace('#', '', $hex);
	    if (strlen($hex) == 3) {
	        $hex = str_repeat(substr($hex,0,1), 2).str_repeat(substr($hex,1,1), 2).str_repeat(substr($hex,2,1), 2);
	    }

	    // Split into three parts: R, G and B
	    $color_parts = str_split($hex, 2);
	    $return = '#';

	    foreach ($color_parts as $color) {
	        $color   = hexdec($color); // Convert to decimal
	        $color   = max(0,min(255,$color + $steps)); // Adjust color
	        $return .= str_pad(dechex($color), 2, '0', STR_PAD_LEFT); // Make two char hex code
	    }

	    return $return;
	}

	/**
	 * Convert hexdec color string to rgb(a) string
	 */
	public function thelandscaper_hex_to_rgba( $color, $opacity ) {
		 
        $color = substr( $color, 1 );
 
        // Check if color has 6 or 3 characters and get values
        $hex = array( $color[0] . $color[1], $color[2] . $color[3], $color[4] . $color[5] );
 
        // Convert hexadec to rgb
        $rgb =  array_map( 'hexdec', $hex );
 
        // Check if opacity is set(rgba or rgb)
        if ( $opacity ) {
        	if ( abs( $opacity ) > 1 ) {
        		$opacity = 1.0;
        	}
        	$output = 'rgba( '. implode( ",", $rgb ) .','. $opacity .')';
        }
 
        // Return rgb(a) color string
        return $output;
	}
}

/**
 * Adds sanitization callback function: js code
 */
if ( ! function_exists( 'thelandscaper_sanitize_js' ) ) {
	function thelandscaper_sanitize_js( $input ) {
		return trim( $input );
	}
}

/**
 * Adds sanitization callback function: gallery slug
 */
if ( ! function_exists( 'thelandscaper_sanitize_gallery_slug' ) ) {
	function thelandscaper_sanitize_gallery_slug( $slug ) {
		$slug = trim( $slug );
		return sanitize_title( $slug, 'gallery' );
	}
}

new TheLandscaper_Customizer();