<?php
/**
 * This file represents an example of the code that themes would use to register
 * the required plugins.
 *
 * It is expected that theme authors would copy and paste this code into their
 * functions.php file, and amend to suit.
 *
 * @package    TGM-Plugin-Activation
 * @subpackage Example
 * @version    2.6.1.
 * @author     Thomas Griffin, Gary Jones, Juliette Reinders Folmer
 * @copyright  Copyright (c) 2011, Thomas Griffin
 * @license    http://opensource.org/licenses/gpl-2.0.php GPL v2 or later
 * @link       https://github.com/TGMPA/TGM-Plugin-Activation
 */

/**
 * Register the required plugins for this theme.
 */
function thelandscaper_register_required_plugins() {

    /**
     * Array of plugin arrays. Required keys are name and slug.
     * If the source is NOT from the .org repo, then source is also required.
     */
    $plugins = array(

        array(
            'name'               => 'Advanced Custom Fields Pro',
            'slug'               => 'advanced-custom-fields-pro',
            'source'             => get_theme_file_path( '/bundled-plugins/advanced-custom-fields-pro.zip' ),
            'required'           => true,
            'version'            => '5.9.9',
            'external_url'       => 'https://www.advancedcustomfields.com/pro'
        ),
        array(
            'name'               => 'Page Builder by SiteOrigin',
            'slug'               => 'siteorigin-panels',
            'required'           => true,
        ),
        array(
            'name'               => 'The Landscaper Toolkit',
            'slug'               => 'the-landscaper-toolkit',
            'source'             => get_theme_file_path( '/bundled-plugins/the-landscaper-toolkit.zip' ),
            'required'           => true,
            'version'            => '1.7.3',
            'external_url'       => 'https://www.qreativethemes.com'
        ),
        array(
            'name'               => 'One Click Demo Import',
            'slug'               => 'one-click-demo-import',
            'required'           => true,
        ),
        array(
            'name'               => 'Portfolio Post Type',
            'slug'               => 'portfolio-post-type',
            'required'           => true,
        ),
        array(
            'name'               => 'Breadcrumb NavXT',
            'slug'               => 'breadcrumb-navxt',
            'required'           => false,
        ),
        array(
            'name'               => 'Essential Grid',
            'slug'               => 'essential-grid',
            'source'             => get_theme_file_path( '/bundled-plugins/essential-grid.zip' ),
            'required'           => false,
            'version'            => '3.0.12',
            'external_url'       => 'https://codecanyon.net/item/essential-grid-wordpress-plugin/7563340'
        ),
        array(
            'name'               => 'Simple Page Sidebars',
            'slug'               => 'simple-page-sidebars',
            'required'           => false,
        ),
        array(
            'name'               => 'Black Studio TinyMCE Widget',
            'slug'               => 'black-studio-tinymce-widget',
            'required'           => false,
        ),
        array(
            'name'               => 'TwentyTwenty',
            'slug'               => 'twentytwenty',
            'required'           => false,
        ),
        array(
            'name'               => 'Contact Form 7',
            'slug'               => 'contact-form-7',
            'required'           => false,
        ),
        array(
            'name'               => 'Easy Fancybox',
            'slug'               => 'easy-fancybox',
            'required'           => false,
        ),
        array(
            'name'               => 'WooCommerce',
            'slug'               => 'woocommerce',
            'required'           => false
        ),

    );

    $config = array(
        'id'           => 'tgmpa',                 // Unique ID for hashing notices for multiple instances of TGMPA.
        'default_path' => '',                      // Default absolute path to bundled plugins.
        'menu'         => 'tgmpa-install-plugins', // Menu slug.
        'parent_slug'  => 'themes.php',            // Parent menu slug.
        'capability'   => 'edit_theme_options',    // Capability needed to view plugin install page, should be a capability associated with the parent menu used.
        'has_notices'  => true,                    // Show admin notices or not.
        'dismissable'  => true,                    // If false, a user cannot dismiss the nag message.
        'dismiss_msg'  => '',                      // If 'dismissable' is false, this message will be output at top of nag.
        'is_automatic' => false,                   // Automatically activate plugins after installation or not.
        'message'      => '',                      // Message to output right before the plugins table.
    );
    
    tgmpa( $plugins, $config );
}
add_action( 'tgmpa_register', 'thelandscaper_register_required_plugins' );