<?php
/**
 * All theme add_actions & functions
 *
 * @package The Landscaper
 */

/**
 * Remove emoji scripts and styles
 */
remove_action( 'wp_head', 'print_emoji_detection_script', 7 ); 
remove_action( 'admin_print_scripts', 'print_emoji_detection_script' ); 
remove_action( 'wp_print_styles', 'print_emoji_styles' ); 
remove_action( 'admin_print_styles', 'print_emoji_styles' );

/**
 * Add admin area notice to install our plugin that contain the theme widgets
 *
 * Updated WordPress requirements from Envato forced us to move the widgets from the theme folder in to a plugin
 *
 * @since 1.8
 *
 */
if ( ! function_exists( 'thelandscaper_custom_admin_notice' ) ) {
    function thelandscaper_custom_admin_notice() {

        if ( ! class_exists( 'TheLandscaperToolkit' ) ) { ?>
	        <div class="notice notice-error notice-qt">
	        	<h1><?php esc_html_e( 'Required: Install "The Landscaper Toolkit" plugin', 'the-landscaper-wp' ); ?></h1>
	            <p>
	            	<?php echo sprintf( 
						esc_html__( 'Due to new WordPress requirements from Envato we are required to move some theme files (widgets and custom fields) to a plugin. %s Installing this plugin is necessary for the theme. The benefit of this plugin is that you won\'t lose any content when switching themes.', 'the-landscaper-wp' ),
						'<br>'
					); ?>
	            </p>
	            <p>
	            	<?php echo sprintf( 
						esc_html__( 'Please navigate to %s → %s to install and activate the %s plugin', 'the-landscaper-wp' ),
						'Appearance',
						'<strong><a href="'. esc_url( admin_url( 'themes.php?page=tgmpa-install-plugins' ) ) .'">Install Plugins</a></strong>',
						'<strong>"The Landscaper Toolkit"</strong>'
					); ?>
				</p>
	        </div>
		<?php
		}
    }
    add_action( 'admin_notices', 'thelandscaper_custom_admin_notice' );
}

/**
 * Check if WooCommerce is active
 */
if ( ! function_exists( 'thelandscaper_woocommerce_active' ) ) {
	function thelandscaper_woocommerce_active() {
		return class_exists( 'Woocommerce' );
	}
}

/**
 * Essential Grid integration
 * No custom prefix because it is a Essential Grid function
 */
if ( function_exists( 'set_ess_grid_as_theme' ) ) {
	define( 'ESS_GRID_AS_THEME', true );
	set_ess_grid_as_theme();
}

/**
 * Return the Google Font URL
 */
if ( ! function_exists( 'thelandscaper_fonts_slug' ) ) {
	function thelandscaper_fonts_slug() {

		$fonts_url = '';
		$fonts = array();

		$fonts = apply_filters( 'pre_google_web_fonts', $fonts );

		foreach ( $fonts as $key => $value ) {
			$fonts[$key] = $key . ':' . implode( ',', $value );
		}

		if ( $fonts ) {
			$query_args = array(
				'family' => urlencode( implode( '|', $fonts ) ),
				'subset' => urlencode( 'latin,latin-ext' ),
			);

			$fonts_url = add_query_arg( $query_args, '//fonts.googleapis.com/css' );
		}
		 
		return esc_url( $fonts_url );
	}
}

/*
 * Return the correct header layout
 */
if ( ! function_exists( 'thelandscaper_get_header_layout' ) ) {
	function thelandscaper_get_header_layout() {

		// Get the page ID
		$get_id = thelandscaper_get_correct_page_id();

		// Get the header options
		$customizer_header_layout = get_theme_mod( 'qt_nav_layout', 'default' );
		$page_header_layout = get_field( 'header_layout', $get_id );
		$page_home_header_layout = get_field( 'home_header_layout', $get_id );

		// Set default header
		$header = $customizer_header_layout;

        // If header customizer option isset to default
        if ( 'default' === $customizer_header_layout ) {
			$header = 'default';
		}

		// If header customizer option isset to wide
		if ( 'wide' === $customizer_header_layout ) {
			$header = 'wide';
		}

		// If header customizer option isset to full width
		if ( 'fullwidth' === $customizer_header_layout ) {
			$header = 'fullwidth';
		}

		// If header customizer option isset to transparent
		if ( 'transparent' === $customizer_header_layout ) {
			$header = 'transparent';
		}

		// If header customizer option isset to sidebar
		if ( 'sidebar' === $customizer_header_layout ) {
			$header = 'sidebar';
		}

		// If header customizer option isset to overlay
		if ( 'overlay' === $customizer_header_layout ) {
			$header = 'overlay';
		}

		if ( 'null' != $page_header_layout && $page_header_layout ) {
			$header = $page_header_layout;
		}

		if ( 'null' != $page_home_header_layout && $page_home_header_layout ) {
			$header = $page_home_header_layout;
		}

		return $header;
	}
}

/**
 *  Get the correct page id based on post/page
 */
if ( ! function_exists( 'thelandscaper_get_correct_page_id' ) ) {
    function thelandscaper_get_correct_page_id() {

        $get_id = get_the_ID();

        if ( is_home() || is_singular( 'post' ) ) {
            $page_id = absint( get_option( 'page_for_posts' ) );
            $get_id  = $page_id;
        }

        if ( thelandscaper_woocommerce_active() && is_woocommerce() ) {
            $shop_id = absint( get_option( 'woocommerce_shop_page_id' ) );
            $get_id  = $shop_id;
        }

        return $get_id;
    }
}

/**
 * Add all inline styles from the ACF page settings
 */
if ( ! function_exists( 'thelandscaper_inline_styles' ) ) {
    function thelandscaper_inline_styles() {

		// Get the page ID
		$get_the_id = thelandscaper_get_correct_page_id();

		// Create array for the settings
		$inline_css = '';

		// Create array for page heading settings
        $page_header_settings = array();

        if ( 'header-custom' === get_field( 'page_title_area', $get_the_id ) ) {
			$page_header_settings['padding-top'] = get_field( 'page_area_padding_top', $get_the_id ) . 'px';
			$page_header_settings['padding-bottom'] = get_field( 'page_area_padding_bottom', $get_the_id ) . 'px';
		}

        // Check if page heading align isset
        if ( get_field( 'header_text_align', $get_the_id )  ) {
            $page_header_settings['text-align'] = get_field( 'header_text_align', $get_the_id );
        }

        // Check if page heading background image isset
        if ( get_field( 'header_bgimage', $get_the_id ) ) {
            $page_header_settings['background-image'] = get_field( 'header_bgimage', $get_the_id );
            $page_header_settings['background-position-x'] = get_field( 'header_bg_horizontal', $get_the_id );
            $page_header_settings['background-position-y'] = get_field( 'header_bg_vertical', $get_the_id );
            $page_header_settings['background-size'] = get_field( 'header_bgsize', $get_the_id );
            $page_header_settings['background-attachment'] = get_field( 'header_bgattachment', $get_the_id );
        }

        // Check if page heading backgroud color isset
        if ( get_field( 'header_bgcolor', $get_the_id ) ) {
            $page_header_settings['background-color'] = get_field( 'header_bgcolor', $get_the_id );
        }

        if ( $page_header_settings ) {
            $inline_css .= '.page-header{';
            foreach ( $page_header_settings as $key => $value ) {
                if ( $value ) {
                    if ( $key != 'background-image' ) {
                        $inline_css .= $key . ': '. esc_attr( $value ) .';';
                    } else {
                        $inline_css .= $key . ': url('. esc_url( $value ) .');';
                    }
                }
            }
            $inline_css .= '}';
        }

        // Check if page title color isset
        $title_settings = array();

        if ( get_field( 'page_title_color', $get_the_id ) ) {
            $title_settings['color'] = get_field( 'page_title_color', $get_the_id );
        }

        if ( $title_settings ) {
            $inline_css .= '.page-header .main-title{';
            foreach ( $title_settings as $key => $value ) {
                if ( $value ) {
                    $inline_css .= $key . ':'.esc_attr( $value ).';';
                }
            }
            $inline_css .= '}';
        }

        // Check if subtitle color isset
        $subtitle_settings = array();

        if ( get_field( 'sub_title_color', $get_the_id ) ) {
            $subtitle_settings['color'] = get_field( 'sub_title_color', $get_the_id );
        }

        if ( $subtitle_settings ) {
            $inline_css .= '.page-header .sub-title{';
            foreach ( $subtitle_settings as $key => $value ) {
                if ( $value ) {
                    $inline_css .= $key . ':'.esc_attr( $value ).';';
                }
            }
            $inline_css .= '}';
        }

        // Check if fixed height isset for the homepage slider
        if ( true == get_field( 'slide_fixed_height', $get_the_id ) ) {

            if ( get_field( 'slide_height_mobile', $get_the_id ) ) {
                $inline_css .= '
                    @media (max-width:580px) { 
                        .jumbotron .slide-image img {
                        	height:'. absint( get_field( 'slide_height_mobile', $get_the_id ) ) .'px;
                        }
                    }
                ';
            }

            if ( get_field( 'slide_height_tablet', $get_the_id ) ) {
                $inline_css .= '
                    @media (min-width:581px) {
                        .jumbotron .slide-image img {
                        	height:'. absint( get_field( 'slide_height_tablet', $get_the_id ) ) .'px;
                        }
                    }
                ';
            }

            if ( get_field( 'slide_height_desktop_small', $get_the_id ) ) {
                $inline_css .= '
                    @media (min-width:992px) {
                        .jumbotron .slide-image img {
                        	height:'. absint( get_field( 'slide_height_desktop_small', $get_the_id ) ) .'px;
                        }
                    }
                ';
            }

            if ( get_field( 'slide_height_desktop_large', $get_the_id ) ) {
                $inline_css .= '
                    @media (min-width:1200px) {
                        .jumbotron .slide-image img {
                        	height:'. absint( get_field( 'slide_height_desktop_large', $get_the_id ) ) .'px;
                        }
                    }
                ';
            }
        }

        if ( have_rows( 'slide', $get_the_id ) ) {

            while ( have_rows( 'slide', $get_the_id ) ) {
                the_row();
                $index = get_row_index();

                // Texts
                $slide_subheading               = get_sub_field( 'slide_subheading_color', $get_the_id );
                $slide_heading                  = get_sub_field( 'slide_heading_color', $get_the_id );
                $slide_content                  = get_sub_field( 'slide_content_color', $get_the_id );
                $slide_buttons                  = get_sub_field( 'button_colors', $get_the_id );

                // Button default
                $slide_btn_color                = $slide_buttons['slide_button_color'];
                $slide_btn_background           = $slide_buttons['slide_button_background'];
                $slide_btn_background_hover     = $slide_buttons['slide_button_background_hover'];

                // Button outline
                $slide_btn_outline_color        = $slide_buttons['slide_button_outline_color'];
                $slide_btn_outline_border       = $slide_buttons['slide_button_outline_border'];
                $slide_btn_outline_border_hover = $slide_buttons['slide_button_outline_border_hover'];

                // Overlay
                $slide_overlay_background       = get_sub_field( 'slide_overlay_color', $get_the_id );
                $slide_overlay_opacity          = get_sub_field( 'slide_overlay_opacity', $get_the_id );

                if ( $slide_subheading ) {

                    $inline_css .= '

                    	.jumbotron.carousel .slide-id-'.$index.' .carousel-topheading {
                            color: '. esc_attr( $slide_subheading ) .';
                        }
                    ';
                }

                if ( $slide_heading ) {

                    $inline_css .= '

                        .jumbotron.carousel .slide-id-'.$index.' .carousel-text .carousel-heading-tag {
                            color: '. esc_attr( $slide_heading ) .';
                        }
                    ';
                }

                if ( $slide_content ) {

                    $inline_css .= '

                        .jumbotron.carousel .slide-id-'.$index.' .carousel-text p {
                            color: '. esc_attr( $slide_content ) .';
                        }
                    ';
                }

                if ( $slide_btn_color || $slide_btn_background ) {

                    $inline_css .= '

                    	.jumbotron.carousel .slide-id-'.$index.' .carousel-text .btn.btn-primary {
                            ';

                            if ( $slide_btn_color ) {

                                $inline_css .= '
                                    color: '. esc_attr( $slide_btn_color ) .';
                                ';
                            }

                            if ( $slide_btn_background ) {
                                
                                $inline_css .= '
                                    background-color: '. esc_attr( $slide_btn_background ) .';
                                ';
                            }

                            $inline_css .= '
                        }
                    ';
                }

                if ( $slide_btn_background_hover ) {

                    $inline_css .= '
                        
                        .jumbotron.carousel .slide-id-'.$index.' .carousel-text .btn.btn-primary:hover {
                            background-color: '. esc_attr( $slide_btn_background_hover ) .';
                        }
                    ';
                }

                if ( $slide_btn_outline_color || $slide_btn_outline_border ) {

                    $inline_css .= '

                        .jumbotron.carousel .slide-id-'.$index.' .carousel-text .btn.btn-outline {
                            ';

                            if ( $slide_btn_outline_color ) {
                                
                                $inline_css .= '
                                    color: '. esc_attr( $slide_btn_outline_color ) .';
                                ';
                            }

                            if ( $slide_btn_outline_border ) {
                                
                                $inline_css .= '
                                    border-color: '. esc_attr( $slide_btn_outline_border ) .';
                                ';
                            }

                            $inline_css .= '
                        }
                    ';
                }

                if ( $slide_btn_outline_border_hover ) {

                    $inline_css .= '
                        
                        .jumbotron.carousel .slide-id-'.$index.' .carousel-text .btn.btn-outline:hover {
                            border-color: '. esc_attr( $slide_btn_outline_border_hover ) .';
                        }
                    ';
                }

                if ( $slide_overlay_background || $slide_overlay_opacity ) {

                    $inline_css .= '
                    
                        .jumbotron .slide-id-'.$index.' .slide-image::before {
                            opacity: '. esc_attr( $slide_overlay_opacity ) .';
                            background-color: '. esc_attr( $slide_overlay_background ) .';
                        }
                    ';
                }
            }
        }

        return preg_replace( '/\s+/S', " ", $inline_css );
	}
}

/**
 *  Custom excerpt length option for the blog posts page
 */
if ( ! function_exists( 'thelandscaper_blog_grid_display_excerpt' ) ) {
    function thelandscaper_blog_grid_display_excerpt() {

        $custom_length = get_theme_mod( 'qt_blog_custom_excerpt_length' );

        // Check if custom excerpt length has been added
        if ( $custom_length ) {
            $excerpt = get_the_excerpt();
            $excerpt = wp_trim_words( $excerpt, absint( $custom_length ), '&hellip;' );
            echo '<p>'. wp_kses_post( do_shortcode( $excerpt ) ) .'</p>';
            echo thelandscaper_read_more_link();
        } elseif ( has_excerpt() ) {
            the_excerpt();
        } else {
            the_content();
        }
    }
}

/**
 * Slider Image Sizes for Fullwidth Slider Page Template
 */
if ( ! function_exists( 'thelandscaper_srcset_sizes' ) ) {
	function thelandscaper_srcset_sizes( $img_id, $sizes ) {
		$srcset = array();
        $sizes = array();

		foreach ( $sizes as $size ) {
			$img = wp_get_attachment_image_src( $img_id, $size );
			$srcset[] = sprintf( '%s %sw', $img[0], $img[1] ); //
		}

		return implode( ', ' , $srcset );
	}
}

/**
 * Add a pingback url auto-discovery header for single posts, pages, or attachments.
 */
if ( ! function_exists( 'thelandscaper_pingback_header' ) ) {
    function thelandscaper_pingback_header() {
        if ( is_singular() && pings_open() ) {
            printf( '<link rel="pingback" href="%s">', esc_url( get_bloginfo( 'pingback_url' ) ) );
        }
    }
    add_action( 'wp_head', 'thelandscaper_pingback_header' );
}

/**
 * Validate HTML tag
 */
if ( ! function_exists( 'thelandscaper_validate_html_tag' ) ) {
    function thelandscaper_validate_html_tag( $tag ) {
        
        $allowed_html = array(
            'div',
            'h1',
            'h2',
            'h3',
            'h4',
            'h5',
            'h6',
            'p',
            'span',
        );
        
        return in_array( strtolower( $tag ), $allowed_html ) ? $tag : 'div';
    }
}

/**
 * Fire the wp_body_open action.
 *
 * No theme prefix here because this is a backwards compatibility function to support WordPress versions prior to 5.2.0.
 */
if ( ! function_exists( 'wp_body_open' ) ) {
    function wp_body_open() {
        do_action( 'wp_body_open' );
    }
}