<?php
/**
 * Main Title Template Part
 *
 * @package The Landscaper
 */

// $header_attr = '';
$headtag = is_single() ? 'h2' : 'h1';
$get_id = thelandscaper_get_correct_page_id();

// If main title isset in page setting to large, or in theme customizer add 'header-large' class
if ( 'large' === get_theme_mod( 'qt_maintitle_layout', 'small' ) ) {

	$title_layout = ' header-large';
	
	if ( 'header-small' === get_field( 'page_title_area', $get_id ) ) {
		$title_layout = '';
	}

} elseif ( 'small' === get_theme_mod( 'qt_maintitle_layout', 'small' ) ) {

	$title_layout = '';
	
	if ( 'header-large' === get_field( 'page_title_area', $get_id ) ) { 
		$title_layout = ' header-large';
	}
} ?>

<?php if ( 'hide' !== get_theme_mod( 'qt_maintitle_layout' ) && 'header-hide' !== get_field( 'page_title_area', $get_id ) ) { ?>
	<div class="page-header<?php echo esc_attr( $title_layout ); ?>">
		<div class="container">

			<?php
				$subtitle = '';

				if ( is_home() || ( is_single() && 'post' === get_post_type() ) ) {
					
					$title = get_the_title( $get_id );
					$subtitle = get_field( 'subtitle', $get_id );

					// Set title if page_for_post option is not set for frontpage and blog 
					if ( ! $get_id ) {
						$title = esc_html__( 'Blog', 'the-landscaper-wp' );
					}

				} elseif ( thelandscaper_woocommerce_active() && is_woocommerce() ) {
					
					ob_start();
				 	woocommerce_page_title();
				 	$title = ob_get_clean();
				 	$subtitle = get_field( 'subtitle', (int) $get_id );

				} elseif ( is_category() || is_tag() || is_author() || is_year() || is_month() || is_day() || is_tax() ) {
					
					$title = get_the_archive_title();

				} elseif ( 'portfolio' == get_post_type() ) {
					
					// Page Title for gallery post
					if ( 'custom_title' === get_theme_mod( 'qt_gallery_title', 'custom_title' ) ) {

						$title = get_theme_mod( 'qt_gallery_maintitle', 'Gallery' );
						$headtag = 'h2';

					} else {

						$title = get_the_title();
						$headtag = 'h1';
					}

					// Subtitle for gallery post
					if ( get_field( 'subtitle', $get_id ) != '' ) {

						$subtitle = get_field( 'subtitle', $get_id );

					} else {

						$subtitle = get_theme_mod( 'qt_gallery_subtitle', 'A selection of our best work' );
					}

				} elseif ( is_search() ) {
					
					$title = esc_html__( 'Search Results For', 'the-landscaper-wp' ) . ' &quot;' . get_search_query() . '&quot;';

				} elseif ( is_404() ) {
					
					$title = esc_html__( 'Error 404', 'the-landscaper-wp' );

				} else {
					
					$title = get_the_title();
					$subtitle = get_field( 'subtitle' );
				}
			?>

			<?php if ( 'hide' !== get_field( 'display_page_title', $get_id ) ) { ?>
				<<?php echo esc_html( $headtag ); ?> class="main-title"><?php echo wp_kses_post( $title ); ?></<?php echo esc_html( $headtag ); ?>>
			<?php } ?>

			<?php if ( $subtitle ) { ?>
				<h3 class="sub-title"><?php echo wp_kses_post( $subtitle ); ?></h3>
			<?php } ?>

		</div>
	</div>

<?php } ?>

<?php if ( 'hide' !== get_theme_mod( 'qt_breadcrumbs', 'show' ) && 'hide' !== get_field( 'display_breadcrumbs', $get_id ) ) {
	get_template_part( 'parts/breadcrumbs' );
} ?>

<?php if ( 'header-hide' === get_field( 'page_title_area', $get_id ) && 'hide' === get_field( 'display_breadcrumbs', $get_id ) ) { ?>
	<div class="content-spacer"></div>
<?php } ?>