<?php
/**
 * Custom template tags for this theme.
 *
 * @package The Landscaper
 */

if ( ! function_exists( 'thelandscaper_comment' ) ) :
    function thelandscaper_comment( $comment, $args, $depth ) {
        
        switch ( $comment->comment_type ) :
            case 'pingback' :
            case 'trackback' :
            // Display trackbacks differently than normal comments. ?>
        <li class="post pingback">
            <p><?php esc_html_e( 'Pingback:', 'the-landscaper-wp' ); ?> <?php comment_author_link(); ?><?php edit_comment_link( esc_html__( '(Edit)', 'the-landscaper-wp' ), ' ' ); ?></p>
        
        <?php
                break;
            default :
        ?>
        
        <li <?php comment_class(); ?> id="li-comment-<?php comment_ID(); ?>">
    		<div class="comment-avatar vcard">
                <?php echo get_avatar( $comment, 70 ); ?>
            </div>
    	 
    		<div class="comment-inner">
                <div class="comment-header">
                    <div class="author-link">
                        <?php comment_author_link(); ?>
                    </div>
                    <div class="comment-time">
                        <?php
                            printf( 
                                '<a href="%1$s"><time datetime="%2$s">%3$s</time></a>',
                                esc_url( get_comment_link( $comment->comment_ID ) ),
                                get_comment_time( 'c' ),
                                get_comment_date()
                        ); ?> <?php esc_html_e( 'at', 'the-landscaper-wp' ); ?> <?php comment_time(); ?>
                    </div>
                    <?php edit_comment_link( esc_html__( '(Edit)', 'the-landscaper-wp' ), ' ' ); ?>
                </div>
                <div class="comment-content clearfix">
                    <?php comment_text(); ?>
                </div>
                <div class="comment-actions">
                    <?php comment_reply_link( array_merge( $args, array(
                        'reply_text' => esc_html__( 'Reply', 'the-landscaper-wp' ),
                        'depth'      => $depth,
                        'max_depth'  => $args['max_depth'] )
                    ) ); ?>
                </div>

                <?php if ( $comment->comment_approved == '0' ) : ?>
                    <p class="comment-awaiting-moderation"><?php esc_html__( 'Your comment is awaiting moderation.', 'the-landscaper-wp' ); ?></p>
                <?php endif; ?>
    		</div>
    	</li>

        <?php
                break;
        endswitch;
    }
endif;