<?php 
/**
 * Register widget area.
 *
 * @link http://codex.wordpress.org/Function_Reference/register_sidebar
 * @package The Landscaper
 */

function thelandscaper_sidebars() {

	// Set id back to sidebar-1 for new theme installations
	$sidebar_name = ( is_active_sidebar( 'sidebar' ) ) ? 'sidebar' : 'sidebar-1';

	// Blog Page Sidebar
	register_sidebar( array(
		'name'          => esc_html__( 'Blog Sidebar', 'the-landscaper-wp' ),
		'id'            => $sidebar_name,
		'description'   => esc_html__( 'Widgets for the blog sidebar', 'the-landscaper-wp' ),
		'before_widget' => '<div class="widget %2$s">',
		'after_widget' 	=> '</div>',
		'before_title'  => '<h6 class="widget-title">',
		'after_title'   => '</h6>',
	) );

	// Topbar - Left
	register_sidebar( array(
		'name'          => esc_html__( 'Topbar - Left Side', 'physio-qt' ),
		'description'   => esc_html__( 'Widgets for the left topbar side. Icon box, social, menu or text widget only is recommended. If no widgets are added the site tagline under Settings > Reading will be displayed', 'physio-qt' ),
		'id'            => 'topbar-widgets-left',
		'before_widget' => '<div class="widget %2$s">',
		'after_widget'  => '</div>',
	) );

	// Topbar - Right
	register_sidebar( array(
		'name' 			=> esc_html__( 'Topbar - Right Side', 'the-landscaper-wp' ),
		'id' 			=> 'topbar-widgets',
		'description' 	=>  esc_html__( 'Widgets for the right topbar side. Icon box, social, menu or text widget only is recommended.', 'the-landscaper-wp'),
		'before_widget' => '<div class="widget %2$s">',
		'after_widget' 	=> '</div>',
	) );

	// Header Overlay Sidebar
	register_sidebar( array(
		'name' 			=> esc_html__( 'Header Overlay Layout', 'the-landscaper-wp' ),
		'id' 			=> 'header-widgets',
		'description' 	=>  esc_html__( 'This area is for the header overlay layout only. For all other header layouts use the "Topbar" panel ', 'the-landscaper-wp'),
		'before_widget' => '<div class="widget %2$s">',
		'after_widget' 	=> '</div>',
	) );

	// Default Sidebar
	register_sidebar( array(
		'name' 			=> esc_html__( 'Page Sidebar', 'the-landscaper-wp' ),
		'id' 			=> 'page-sidebar',
		'description' 	=> esc_html__( 'Widgets for the default page(s) sidebar', 'the-landscaper-wp'),
		'before_widget' => '<div class="widget %2$s">',
		'after_widget' 	=> '</div>',
		'before_title'  => '<h6 class="widget-title">',
		'after_title'   => '</h6>',
	) );

	// WooCommerce Sidebar
	if ( thelandscaper_woocommerce_active() ) {
		register_sidebar( array(
			'name'          => esc_html__( 'Shop Sidebar', 'the-landscaper-wp'),
			'id'            => 'shop-sidebar',
			'description'   => esc_html__( 'Widgets for the shop (WooCommerce) sidebar', 'the-landscaper-wp'),
			'class'         => 'sidebar',
			'before_widget' => '<div class="widget %2$s">',
			'after_widget'  => '</div>',
			'before_title'  => '<h6 class="widget-title">',
			'after_title'   => '</h6>'
		) );
	}

	// Footer Sidebar
	$main_footer_columns = (int)get_theme_mod( 'qt_footer_columns', 4 );

	if ( $main_footer_columns > 0 ) {
		register_sidebar(
			array(
				'name'          => esc_html__( 'Footer', 'the-landscaper-wp' ),
				'id'            => 'main-footer',
				'description'   => esc_html__( 'Widgets for the theme footer. Change columns at: Appearance &gt; Customize &gt; Theme Options &gt; Footer.', 'the-landscaper-wp' ),
				'before_widget' => sprintf( '<div class="col-xs-12 col-md-%d"><div class="widget w-footer %%2$s">', round( 12 / $main_footer_columns ) ),
				'after_widget'  => '</div></div>',
				'before_title'  => '<h6 class="widget-title">',
				'after_title'   => '</h6>'
			)
		);
	}
}
add_action( 'widgets_init', 'thelandscaper_sidebars' );